/*
 * Decompiled with CFR 0.152.
 */
package com.android.settings;

import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.ApplicationInfo;
import android.content.pm.PackageManager;
import android.content.pm.ServiceInfo;
import android.net.Uri;
import android.os.Bundle;
import android.os.SystemProperties;
import android.preference.CheckBoxPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceCategory;
import android.preference.PreferenceGroup;
import android.preference.PreferenceScreen;
import android.provider.Settings;
import android.text.TextUtils;
import android.view.KeyCharacterMap;
import android.view.accessibility.AccessibilityManager;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;

public class AccessibilitySettings
extends PreferenceActivity {
    private static final String DEFAULT_SCREENREADER_MARKET_LINK = "market://search?q=pname:com.google.android.marvin.talkback";
    private final String TOGGLE_ACCESSIBILITY_SERVICE_CHECKBOX = "toggle_accessibility_service_checkbox";
    private static final String ACCESSIBILITY_SERVICES_CATEGORY = "accessibility_services_category";
    private static final String POWER_BUTTON_CATEGORY = "power_button_category";
    private final String POWER_BUTTON_ENDS_CALL_CHECKBOX = "power_button_ends_call";
    private CheckBoxPreference mToggleCheckBox;
    private PreferenceCategory mPowerButtonCategory;
    private CheckBoxPreference mPowerButtonEndsCallCheckBox;
    private Map<String, ServiceInfo> mAccessibilityServices = new LinkedHashMap<String, ServiceInfo>();
    private TextUtils.SimpleStringSplitter mStringColonSplitter = new TextUtils.SimpleStringSplitter(':');
    private PreferenceGroup mAccessibilityServicesCategory;

    protected void onCreate(Bundle icicle) {
        super.onCreate(icicle);
        this.addPreferencesFromResource(2130968576);
        this.mToggleCheckBox = (CheckBoxPreference)this.findPreference("toggle_accessibility_service_checkbox");
        this.mPowerButtonCategory = (PreferenceCategory)this.findPreference(POWER_BUTTON_CATEGORY);
        this.mPowerButtonEndsCallCheckBox = (CheckBoxPreference)this.findPreference("power_button_ends_call");
        this.addAccessibilitServicePreferences();
    }

    protected void onResume() {
        super.onResume();
        HashSet<String> enabled = new HashSet<String>();
        String settingValue = Settings.Secure.getString((ContentResolver)this.getContentResolver(), (String)"enabled_accessibility_services");
        if (settingValue != null) {
            TextUtils.SimpleStringSplitter splitter = this.mStringColonSplitter;
            splitter.setString(settingValue);
            while (splitter.hasNext()) {
                enabled.add(splitter.next());
            }
        }
        Map<String, ServiceInfo> accessibilityServices = this.mAccessibilityServices;
        for (String key : accessibilityServices.keySet()) {
            CheckBoxPreference preference = (CheckBoxPreference)this.findPreference(key);
            if (preference == null) continue;
            preference.setChecked(enabled.contains(key));
        }
        int serviceState = Settings.Secure.getInt((ContentResolver)this.getContentResolver(), (String)"accessibility_enabled", (int)0);
        if (!accessibilityServices.isEmpty()) {
            if (serviceState == 1) {
                this.mToggleCheckBox.setChecked(true);
            } else {
                this.setAccessibilityServicePreferencesState(false);
            }
            this.mToggleCheckBox.setEnabled(true);
        } else {
            if (serviceState == 1) {
                Settings.Secure.putInt((ContentResolver)this.getContentResolver(), (String)"accessibility_enabled", (int)0);
            }
            this.mToggleCheckBox.setEnabled(false);
            this.displayNoAppsAlert();
        }
        if (KeyCharacterMap.deviceHasKey((int)26)) {
            int incallPowerBehavior = Settings.Secure.getInt((ContentResolver)this.getContentResolver(), (String)"incall_power_button_behavior", (int)1);
            boolean powerButtonCheckboxEnabled = incallPowerBehavior == 2;
            this.mPowerButtonEndsCallCheckBox.setChecked(powerButtonCheckboxEnabled);
            this.mPowerButtonEndsCallCheckBox.setEnabled(true);
        } else {
            this.getPreferenceScreen().removePreference((Preference)this.mPowerButtonCategory);
        }
    }

    protected void onPause() {
        super.onPause();
        this.persistEnabledAccessibilityServices();
    }

    private void setAccessibilityServicePreferencesState(boolean isEnabled) {
        if (this.mAccessibilityServicesCategory == null) {
            return;
        }
        int count = this.mAccessibilityServicesCategory.getPreferenceCount();
        for (int i = 0; i < count; ++i) {
            Preference pref = this.mAccessibilityServicesCategory.getPreference(i);
            pref.setEnabled(isEnabled);
        }
    }

    public boolean onPreferenceTreeClick(PreferenceScreen preferenceScreen, Preference preference) {
        String key = preference.getKey();
        if ("toggle_accessibility_service_checkbox".equals(key)) {
            boolean isChecked = ((CheckBoxPreference)preference).isChecked();
            this.handleEnableAccessibilityStateChange((CheckBoxPreference)preference);
        } else if ("power_button_ends_call".equals(key)) {
            boolean isChecked = ((CheckBoxPreference)preference).isChecked();
            Settings.Secure.putInt((ContentResolver)this.getContentResolver(), (String)"incall_power_button_behavior", (int)(isChecked ? 2 : 1));
        } else if (preference instanceof CheckBoxPreference) {
            this.handleEnableAccessibilityServiceStateChange((CheckBoxPreference)preference);
        }
        return super.onPreferenceTreeClick(preferenceScreen, preference);
    }

    private void handleEnableAccessibilityStateChange(CheckBoxPreference preference) {
        if (preference.isChecked()) {
            Settings.Secure.putInt((ContentResolver)this.getContentResolver(), (String)"accessibility_enabled", (int)1);
            this.setAccessibilityServicePreferencesState(true);
        } else {
            final CheckBoxPreference checkBoxPreference = preference;
            AlertDialog dialog = new AlertDialog.Builder((Context)this).setTitle(0x1040014).setIcon(17301543).setMessage((CharSequence)this.getString(2131231619)).setCancelable(true).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    Settings.Secure.putInt((ContentResolver)AccessibilitySettings.this.getContentResolver(), (String)"accessibility_enabled", (int)0);
                    AccessibilitySettings.this.setAccessibilityServicePreferencesState(false);
                }
            }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    checkBoxPreference.setChecked(true);
                }
            }).create();
            dialog.show();
        }
    }

    private void handleEnableAccessibilityServiceStateChange(CheckBoxPreference preference) {
        if (preference.isChecked()) {
            final CheckBoxPreference checkBoxPreference = preference;
            AlertDialog dialog = new AlertDialog.Builder((Context)this).setTitle(0x1040014).setIcon(17301543).setMessage((CharSequence)this.getString(2131231618, new Object[]{this.mAccessibilityServices.get((Object)preference.getKey()).applicationInfo.loadLabel(this.getPackageManager())})).setCancelable(true).setPositiveButton(17039370, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    checkBoxPreference.setChecked(true);
                    AccessibilitySettings.this.persistEnabledAccessibilityServices();
                }
            }).setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                public void onClick(DialogInterface dialog, int which) {
                    checkBoxPreference.setChecked(false);
                }
            }).create();
            dialog.show();
        } else {
            this.persistEnabledAccessibilityServices();
        }
    }

    private void persistEnabledAccessibilityServices() {
        StringBuilder builder = new StringBuilder(256);
        int firstEnabled = -1;
        for (String key : this.mAccessibilityServices.keySet()) {
            CheckBoxPreference preference = (CheckBoxPreference)this.findPreference(key);
            if (!preference.isChecked()) continue;
            builder.append(key);
            builder.append(':');
        }
        Settings.Secure.putString((ContentResolver)this.getContentResolver(), (String)"enabled_accessibility_services", (String)builder.toString());
    }

    private void addAccessibilitServicePreferences() {
        AccessibilityManager accessibilityManager = (AccessibilityManager)this.getSystemService("accessibility");
        List installedServices = accessibilityManager.getAccessibilityServiceList();
        this.mAccessibilityServicesCategory = (PreferenceGroup)this.findPreference(ACCESSIBILITY_SERVICES_CATEGORY);
        if (installedServices.isEmpty()) {
            this.getPreferenceScreen().removePreference((Preference)this.mAccessibilityServicesCategory);
            this.mAccessibilityServicesCategory = null;
            return;
        }
        int count = installedServices.size();
        for (int i = 0; i < count; ++i) {
            ServiceInfo serviceInfo = (ServiceInfo)installedServices.get(i);
            String key = serviceInfo.packageName + "/" + serviceInfo.name;
            this.mAccessibilityServices.put(key, serviceInfo);
            CheckBoxPreference preference = new CheckBoxPreference((Context)this);
            preference.setKey(key);
            preference.setTitle(serviceInfo.loadLabel(this.getPackageManager()));
            this.mAccessibilityServicesCategory.addPreference((Preference)preference);
        }
    }

    private void displayNoAppsAlert() {
        try {
            PackageManager pm = this.getPackageManager();
            ApplicationInfo applicationInfo = pm.getApplicationInfo("com.android.vending", 0);
        }
        catch (PackageManager.NameNotFoundException e) {
            return;
        }
        AlertDialog.Builder noAppsAlert = new AlertDialog.Builder((Context)this);
        noAppsAlert.setTitle(2131231620);
        noAppsAlert.setMessage(2131231621);
        noAppsAlert.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                String screenreaderMarketLink = SystemProperties.get((String)"ro.screenreader.market", (String)AccessibilitySettings.DEFAULT_SCREENREADER_MARKET_LINK);
                Uri marketUri = Uri.parse((String)screenreaderMarketLink);
                Intent marketIntent = new Intent("android.intent.action.VIEW", marketUri);
                AccessibilitySettings.this.startActivity(marketIntent);
                AccessibilitySettings.this.finish();
            }
        });
        noAppsAlert.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
            }
        });
        noAppsAlert.show();
    }
}

