/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.settings;

import android.app.backup.BackupManager;
import android.content.ContentProvider;
import android.content.ContentUris;
import android.content.ContentValues;
import android.content.Context;
import android.content.res.AssetFileDescriptor;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteException;
import android.database.sqlite.SQLiteQueryBuilder;
import android.media.RingtoneManager;
import android.net.Uri;
import android.os.Bundle;
import android.os.FileObserver;
import android.os.ParcelFileDescriptor;
import android.os.SystemProperties;
import android.provider.DrmStore;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import com.android.providers.settings.DatabaseHelper;
import java.io.FileNotFoundException;
import java.security.SecureRandom;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class SettingsProvider
extends ContentProvider {
    private static final String TAG = "SettingsProvider";
    private static final boolean LOCAL_LOGV = false;
    private static final String TABLE_FAVORITES = "favorites";
    private static final String TABLE_OLD_FAVORITES = "old_favorites";
    private static final String[] COLUMN_VALUE = new String[]{"value"};
    private static final int MAX_CACHE_ENTRIES = 200;
    private static final SettingsCache sSystemCache = new SettingsCache("system");
    private static final SettingsCache sSecureCache = new SettingsCache("secure");
    private static final AtomicInteger sKnownMutationsInFlight = new AtomicInteger(0);
    private static final int MAX_CACHE_ENTRY_SIZE = 500;
    private static final Bundle NULL_SETTING = Bundle.forPair((String)"value", null);
    private static final Bundle TOO_LARGE_TO_CACHE_MARKER = Bundle.forPair((String)"_dummy", null);
    protected DatabaseHelper mOpenHelper;
    private BackupManager mBackupManager;
    private static SettingsFileObserver sObserverInstance;

    private Uri getUriFor(Uri tableUri, ContentValues values, long rowId) {
        if (tableUri.getPathSegments().size() != 1) {
            throw new IllegalArgumentException("Invalid URI: " + tableUri);
        }
        String table = (String)tableUri.getPathSegments().get(0);
        if ("system".equals(table) || "secure".equals(table)) {
            String name = values.getAsString("name");
            return Uri.withAppendedPath((Uri)tableUri, (String)name);
        }
        return ContentUris.withAppendedId((Uri)tableUri, (long)rowId);
    }

    private void sendNotify(Uri uri) {
        String notify;
        boolean backedUpDataChanged = false;
        String property = null;
        String table = (String)uri.getPathSegments().get(0);
        if (table.equals("system")) {
            property = "sys.settings_system_version";
            backedUpDataChanged = true;
        } else if (table.equals("secure")) {
            property = "sys.settings_secure_version";
            backedUpDataChanged = true;
        }
        if (property != null) {
            long version = SystemProperties.getLong((String)property, (long)0L) + 1L;
            SystemProperties.set((String)property, (String)Long.toString(version));
        }
        if (backedUpDataChanged) {
            this.mBackupManager.dataChanged();
        }
        if ((notify = uri.getQueryParameter("notify")) == null || "true".equals(notify)) {
            this.getContext().getContentResolver().notifyChange(uri, null);
        }
    }

    private void checkWritePermissions(SqlArguments args) {
        if ("secure".equals(args.table) && this.getContext().checkCallingOrSelfPermission("android.permission.WRITE_SECURE_SETTINGS") != 0) {
            throw new SecurityException(String.format("Permission denial: writing to secure settings requires %1$s", "android.permission.WRITE_SECURE_SETTINGS"));
        }
    }

    public boolean onCreate() {
        this.mOpenHelper = new DatabaseHelper(this.getContext());
        this.mBackupManager = new BackupManager(this.getContext());
        if (!this.ensureAndroidIdIsSet()) {
            return false;
        }
        SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
        sObserverInstance = new SettingsFileObserver(db.getPath());
        sObserverInstance.startWatching();
        this.startAsyncCachePopulation();
        return true;
    }

    private void startAsyncCachePopulation() {
        new Thread("populate-settings-caches"){

            public void run() {
                SettingsProvider.this.fullyPopulateCaches();
            }
        }.start();
    }

    private void fullyPopulateCaches() {
        this.fullyPopulateCache("secure", sSecureCache);
        this.fullyPopulateCache("system", sSystemCache);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void fullyPopulateCache(String table, SettingsCache cache) {
        SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
        Cursor c = db.query(table, new String[]{"name", "value"}, null, null, null, null, null, "201");
        try {
            SettingsCache settingsCache = cache;
            synchronized (settingsCache) {
                cache.clear();
                cache.setFullyMatchesDisk(true);
                int rows = 0;
                while (c.moveToNext()) {
                    ++rows;
                    String name = c.getString(0);
                    String value = c.getString(1);
                    cache.populate(name, value);
                }
                if (rows > 200) {
                    cache.setFullyMatchesDisk(false);
                    Log.d((String)TAG, (String)("row count exceeds max cache entries for table " + table));
                }
                Log.d((String)TAG, (String)("cache for settings table '" + table + "' rows=" + rows + "; fullycached=" + cache.fullyMatchesDisk()));
            }
        }
        finally {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean ensureAndroidIdIsSet() {
        Cursor c = this.query(Settings.Secure.CONTENT_URI, new String[]{"value"}, "name=?", new String[]{"android_id"}, null);
        try {
            String value;
            String string2 = value = c.moveToNext() ? c.getString(0) : null;
            if (value == null) {
                SecureRandom random = new SecureRandom();
                String newAndroidIdValue = Long.toHexString(random.nextLong());
                Log.d((String)TAG, (String)("Generated and saved new ANDROID_ID [" + newAndroidIdValue + "]"));
                ContentValues values = new ContentValues();
                values.put("name", "android_id");
                values.put("value", newAndroidIdValue);
                Uri uri = this.insert(Settings.Secure.CONTENT_URI, values);
                if (uri == null) {
                    boolean bl = false;
                    return bl;
                }
            }
            boolean bl = true;
            return bl;
        }
        finally {
            c.close();
        }
    }

    public Bundle call(String method, String request, Bundle args) {
        if ("GET_system".equals(method)) {
            return this.lookupValue("system", sSystemCache, request);
        }
        if ("GET_secure".equals(method)) {
            return this.lookupValue("secure", sSecureCache, request);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private Bundle lookupValue(String table, SettingsCache cache, String key) {
        SettingsCache settingsCache = cache;
        synchronized (settingsCache) {
            if (cache.containsKey(key)) {
                Bundle value = (Bundle)cache.get(key);
                if (value != TOO_LARGE_TO_CACHE_MARKER) {
                    return value;
                }
            } else if (cache.fullyMatchesDisk()) {
                return NULL_SETTING;
            }
        }
        SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
        Cursor cursor = null;
        try {
            cursor = db.query(table, COLUMN_VALUE, "name=?", new String[]{key}, null, null, null, null);
            if (cursor != null && cursor.getCount() == 1) {
                cursor.moveToFirst();
                Bundle bundle = cache.putIfAbsent(key, cursor.getString(0));
                return bundle;
            }
        }
        catch (SQLiteException e) {
            Log.w((String)TAG, (String)"settings lookup error", (Throwable)e);
            Bundle bundle = null;
            return bundle;
        }
        finally {
            if (cursor != null) {
                cursor.close();
            }
        }
        cache.putIfAbsent(key, null);
        return NULL_SETTING;
    }

    public Cursor query(Uri url, String[] select, String where, String[] whereArgs, String sort) {
        SqlArguments args = new SqlArguments(url, where, whereArgs);
        SQLiteDatabase db = this.mOpenHelper.getReadableDatabase();
        if (TABLE_FAVORITES.equals(args.table)) {
            return null;
        }
        if (TABLE_OLD_FAVORITES.equals(args.table)) {
            args.table = TABLE_FAVORITES;
            Cursor cursor = db.rawQuery("PRAGMA table_info(favorites);", null);
            if (cursor != null) {
                boolean exists = cursor.getCount() > 0;
                cursor.close();
                if (!exists) {
                    return null;
                }
            } else {
                return null;
            }
        }
        SQLiteQueryBuilder qb = new SQLiteQueryBuilder();
        qb.setTables(args.table);
        Cursor ret = qb.query(db, select, args.where, args.args, null, null, sort);
        ret.setNotificationUri(this.getContext().getContentResolver(), url);
        return ret;
    }

    public String getType(Uri url) {
        SqlArguments args = new SqlArguments(url, null, null);
        if (TextUtils.isEmpty((CharSequence)args.where)) {
            return "vnd.android.cursor.dir/" + args.table;
        }
        return "vnd.android.cursor.item/" + args.table;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int bulkInsert(Uri uri, ContentValues[] values) {
        SqlArguments args = new SqlArguments(uri);
        if (TABLE_FAVORITES.equals(args.table)) {
            return 0;
        }
        this.checkWritePermissions(args);
        SettingsCache cache = SettingsCache.forTable(args.table);
        sKnownMutationsInFlight.incrementAndGet();
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        db.beginTransaction();
        try {
            int numValues = values.length;
            for (int i = 0; i < numValues; ++i) {
                if (db.insert(args.table, null, values[i]) < 0L) {
                    int n = 0;
                    return n;
                }
                SettingsCache.populate(cache, values[i]);
            }
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
            sKnownMutationsInFlight.decrementAndGet();
        }
        this.sendNotify(uri);
        return values.length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean parseProviderList(Uri url, ContentValues initialValues) {
        char prefix;
        String value = initialValues.getAsString("value");
        String newProviders = null;
        if (value != null && value.length() > 1 && ((prefix = value.charAt(0)) == '+' || prefix == '-')) {
            value = value.substring(1);
            String providers = "";
            String[] columns = new String[]{"value"};
            String where = "name='location_providers_allowed'";
            Cursor cursor = this.query(url, columns, where, null, null);
            if (cursor != null && cursor.getCount() == 1) {
                try {
                    cursor.moveToFirst();
                    providers = cursor.getString(0);
                }
                finally {
                    cursor.close();
                }
            }
            int index = providers.indexOf(value);
            int end = index + value.length();
            if (index > 0 && providers.charAt(index - 1) != ',') {
                index = -1;
            }
            if (end < providers.length() && providers.charAt(end) != ',') {
                index = -1;
            }
            if (prefix == '+' && index < 0) {
                newProviders = providers.length() == 0 ? value : providers + ',' + value;
            } else if (prefix == '-' && index >= 0) {
                if (index > 0) {
                    --index;
                } else if (end < providers.length()) {
                    ++end;
                }
                newProviders = providers.substring(0, index);
                if (end < providers.length()) {
                    newProviders = newProviders + providers.substring(end);
                }
            } else {
                return false;
            }
            if (newProviders != null) {
                initialValues.put("value", newProviders);
            }
        }
        return true;
    }

    public Uri insert(Uri url, ContentValues initialValues) {
        String value;
        SqlArguments args = new SqlArguments(url);
        if (TABLE_FAVORITES.equals(args.table)) {
            return null;
        }
        this.checkWritePermissions(args);
        String name = initialValues.getAsString("name");
        if ("location_providers_allowed".equals(name) && !this.parseProviderList(url, initialValues)) {
            return null;
        }
        SettingsCache cache = SettingsCache.forTable(args.table);
        if (SettingsCache.isRedundantSetValue(cache, name, value = initialValues.getAsString("value"))) {
            return Uri.withAppendedPath((Uri)url, (String)name);
        }
        sKnownMutationsInFlight.incrementAndGet();
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        long rowId = db.insert(args.table, null, initialValues);
        sKnownMutationsInFlight.decrementAndGet();
        if (rowId <= 0L) {
            return null;
        }
        SettingsCache.populate(cache, initialValues);
        url = this.getUriFor(url, initialValues, rowId);
        this.sendNotify(url);
        return url;
    }

    public int delete(Uri url, String where, String[] whereArgs) {
        SqlArguments args = new SqlArguments(url, where, whereArgs);
        if (TABLE_FAVORITES.equals(args.table)) {
            return 0;
        }
        if (TABLE_OLD_FAVORITES.equals(args.table)) {
            args.table = TABLE_FAVORITES;
        }
        this.checkWritePermissions(args);
        sKnownMutationsInFlight.incrementAndGet();
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        int count = db.delete(args.table, args.where, args.args);
        sKnownMutationsInFlight.decrementAndGet();
        if (count > 0) {
            SettingsCache.invalidate(args.table);
            this.sendNotify(url);
        }
        this.startAsyncCachePopulation();
        return count;
    }

    public int update(Uri url, ContentValues initialValues, String where, String[] whereArgs) {
        SqlArguments args = new SqlArguments(url, where, whereArgs);
        if (TABLE_FAVORITES.equals(args.table)) {
            return 0;
        }
        this.checkWritePermissions(args);
        sKnownMutationsInFlight.incrementAndGet();
        SQLiteDatabase db = this.mOpenHelper.getWritableDatabase();
        int count = db.update(args.table, initialValues, args.where, args.args);
        sKnownMutationsInFlight.decrementAndGet();
        if (count > 0) {
            SettingsCache.invalidate(args.table);
            this.sendNotify(url);
        }
        this.startAsyncCachePopulation();
        return count;
    }

    public ParcelFileDescriptor openFile(Uri uri, String mode) throws FileNotFoundException {
        String authority;
        boolean isDrmAuthority;
        Context context;
        Uri soundUri;
        int ringtoneType = RingtoneManager.getDefaultType((Uri)uri);
        if (ringtoneType != -1 && (soundUri = RingtoneManager.getActualDefaultRingtoneUri((Context)(context = this.getContext()), (int)ringtoneType)) != null && ((isDrmAuthority = (authority = soundUri.getAuthority()).equals("drm")) || authority.equals("media"))) {
            if (isDrmAuthority) {
                try {
                    DrmStore.enforceAccessDrmPermission((Context)context);
                }
                catch (SecurityException e) {
                    throw new FileNotFoundException(e.getMessage());
                }
            }
            return context.getContentResolver().openFileDescriptor(soundUri, mode);
        }
        return super.openFile(uri, mode);
    }

    public AssetFileDescriptor openAssetFile(Uri uri, String mode) throws FileNotFoundException {
        int ringtoneType = RingtoneManager.getDefaultType((Uri)uri);
        if (ringtoneType != -1) {
            Context context = this.getContext();
            Uri soundUri = RingtoneManager.getActualDefaultRingtoneUri((Context)context, (int)ringtoneType);
            if (soundUri != null) {
                String authority = soundUri.getAuthority();
                boolean isDrmAuthority = authority.equals("drm");
                if (isDrmAuthority || authority.equals("media")) {
                    if (isDrmAuthority) {
                        try {
                            DrmStore.enforceAccessDrmPermission((Context)context);
                        }
                        catch (SecurityException e) {
                            throw new FileNotFoundException(e.getMessage());
                        }
                    }
                    ParcelFileDescriptor pfd = null;
                    try {
                        pfd = context.getContentResolver().openFileDescriptor(soundUri, mode);
                        return new AssetFileDescriptor(pfd, 0L, -1L);
                    }
                    catch (FileNotFoundException ex) {
                        // empty catch block
                    }
                }
                try {
                    return super.openAssetFile(soundUri, mode);
                }
                catch (FileNotFoundException ex) {
                    return context.getResources().openRawResourceFd(0x10C0000);
                }
            }
            throw new FileNotFoundException();
        }
        return super.openAssetFile(uri, mode);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private static final class SettingsCache
    extends LinkedHashMap<String, Bundle> {
        private final String mCacheName;
        private boolean mCacheFullyMatchesDisk = false;

        public SettingsCache(String name) {
            super(200, 0.75f, true);
            this.mCacheName = name;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public boolean fullyMatchesDisk() {
            SettingsCache settingsCache = this;
            synchronized (settingsCache) {
                return this.mCacheFullyMatchesDisk;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void setFullyMatchesDisk(boolean value) {
            SettingsCache settingsCache = this;
            synchronized (settingsCache) {
                this.mCacheFullyMatchesDisk = value;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected boolean removeEldestEntry(Map.Entry eldest) {
            if (this.size() <= 200) {
                return false;
            }
            SettingsCache settingsCache = this;
            synchronized (settingsCache) {
                this.mCacheFullyMatchesDisk = false;
            }
            return true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Bundle putIfAbsent(String key, String value) {
            Bundle bundle;
            Bundle bundle2 = bundle = value == null ? NULL_SETTING : Bundle.forPair((String)"value", (String)value);
            if (value == null || value.length() <= 500) {
                SettingsCache settingsCache = this;
                synchronized (settingsCache) {
                    if (!this.containsKey(key)) {
                        this.put(key, bundle);
                    }
                }
            }
            return bundle;
        }

        public static SettingsCache forTable(String tableName) {
            if ("system".equals(tableName)) {
                return sSystemCache;
            }
            if ("secure".equals(tableName)) {
                return sSecureCache;
            }
            return null;
        }

        public static void populate(SettingsCache cache, ContentValues contentValues) {
            if (cache == null) {
                return;
            }
            String name = contentValues.getAsString("name");
            if (name == null) {
                Log.w((String)SettingsProvider.TAG, (String)"null name populating settings cache.");
                return;
            }
            String value = contentValues.getAsString("value");
            cache.populate(name, value);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void populate(String name, String value) {
            SettingsCache settingsCache = this;
            synchronized (settingsCache) {
                if (value == null || value.length() <= 500) {
                    this.put(name, Bundle.forPair((String)"value", (String)value));
                } else {
                    this.put(name, TOO_LARGE_TO_CACHE_MARKER);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static void invalidate(String tableName) {
            SettingsCache cache = SettingsCache.forTable(tableName);
            if (cache == null) {
                return;
            }
            SettingsCache settingsCache = cache;
            synchronized (settingsCache) {
                cache.clear();
                cache.mCacheFullyMatchesDisk = false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public static boolean isRedundantSetValue(SettingsCache cache, String name, String value) {
            if (cache == null) {
                return false;
            }
            SettingsCache settingsCache = cache;
            synchronized (settingsCache) {
                Bundle bundle = (Bundle)cache.get(name);
                if (bundle == null) {
                    return false;
                }
                String oldValue = bundle.getPairValue();
                if (oldValue == null && value == null) {
                    return true;
                }
                if (oldValue == null != (value == null)) {
                    return false;
                }
                return oldValue.equals(value);
            }
        }
    }

    private class SettingsFileObserver
    extends FileObserver {
        private final AtomicBoolean mIsDirty;
        private final String mPath;

        public SettingsFileObserver(String path) {
            super(path, 906);
            this.mIsDirty = new AtomicBoolean(false);
            this.mPath = path;
        }

        public void onEvent(int event, String path) {
            int modsInFlight = sKnownMutationsInFlight.get();
            if (modsInFlight > 0) {
                return;
            }
            Log.d((String)SettingsProvider.TAG, (String)("external modification to " + this.mPath + "; event=" + event));
            if (!this.mIsDirty.compareAndSet(false, true)) {
                return;
            }
            Log.d((String)SettingsProvider.TAG, (String)("updating our caches for " + this.mPath));
            SettingsProvider.this.fullyPopulateCaches();
            this.mIsDirty.set(false);
        }
    }

    private static class SqlArguments {
        public String table;
        public final String where;
        public final String[] args;

        SqlArguments(Uri url, String where, String[] args) {
            if (url.getPathSegments().size() == 1) {
                this.table = (String)url.getPathSegments().get(0);
                if (!DatabaseHelper.isValidTable(this.table)) {
                    throw new IllegalArgumentException("Bad root path: " + this.table);
                }
                this.where = where;
                this.args = args;
            } else {
                if (url.getPathSegments().size() != 2) {
                    throw new IllegalArgumentException("Invalid URI: " + url);
                }
                if (!TextUtils.isEmpty((CharSequence)where)) {
                    throw new UnsupportedOperationException("WHERE clause not supported: " + url);
                }
                this.table = (String)url.getPathSegments().get(0);
                if (!DatabaseHelper.isValidTable(this.table)) {
                    throw new IllegalArgumentException("Bad root path: " + this.table);
                }
                if ("system".equals(this.table) || "secure".equals(this.table)) {
                    this.where = "name=?";
                    this.args = new String[]{(String)url.getPathSegments().get(1)};
                } else {
                    this.where = "_id=" + ContentUris.parseId((Uri)url);
                    this.args = null;
                }
            }
        }

        SqlArguments(Uri url) {
            if (url.getPathSegments().size() == 1) {
                this.table = (String)url.getPathSegments().get(0);
                if (!DatabaseHelper.isValidTable(this.table)) {
                    throw new IllegalArgumentException("Bad root path: " + this.table);
                }
            } else {
                throw new IllegalArgumentException("Invalid URI: " + url);
            }
            this.where = null;
            this.args = null;
        }
    }
}

