/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.settings;

import android.app.ActivityManagerNative;
import android.app.IActivityManager;
import android.app.backup.IBackupManager;
import android.content.ContentResolver;
import android.content.Context;
import android.content.IContentService;
import android.content.res.Configuration;
import android.media.AudioManager;
import android.os.IBinder;
import android.os.IPowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.provider.Settings;
import android.text.TextUtils;
import java.util.Locale;

public class SettingsHelper {
    private static final String TAG = "SettingsHelper";
    private Context mContext;
    private AudioManager mAudioManager;
    private IContentService mContentService;
    private IPowerManager mPowerManager;
    private boolean mSilent;
    private boolean mVibrate;

    public SettingsHelper(Context context) {
        this.mContext = context;
        this.mAudioManager = (AudioManager)context.getSystemService("audio");
        this.mContentService = ContentResolver.getContentService();
        this.mPowerManager = IPowerManager.Stub.asInterface((IBinder)ServiceManager.getService((String)"power"));
    }

    public boolean restoreValue(String name, String value) {
        if ("screen_brightness".equals(name)) {
            this.setBrightness(Integer.parseInt(value));
        } else if ("sound_effects_enabled".equals(name)) {
            this.setSoundEffects(Integer.parseInt(value) == 1);
        } else {
            if ("location_providers_allowed".equals(name)) {
                this.setGpsLocation(value);
                return false;
            }
            if ("backup_auto_restore".equals(name)) {
                this.setAutoRestore(Integer.parseInt(value) == 1);
            }
        }
        return true;
    }

    private void setAutoRestore(boolean enabled) {
        try {
            IBackupManager bm = IBackupManager.Stub.asInterface((IBinder)ServiceManager.getService((String)"backup"));
            if (bm != null) {
                bm.setAutoRestore(enabled);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void setGpsLocation(String value) {
        String GPS = "gps";
        boolean enabled = "gps".equals(value) || value.startsWith("gps,") || value.endsWith(",gps") || value.contains(",gps,");
        Settings.Secure.setLocationProviderEnabled((ContentResolver)this.mContext.getContentResolver(), (String)"gps", (boolean)enabled);
    }

    private void setSoundEffects(boolean enable) {
        if (enable) {
            this.mAudioManager.loadSoundEffects();
        } else {
            this.mAudioManager.unloadSoundEffects();
        }
    }

    private void setBrightness(int brightness) {
        try {
            IPowerManager power = IPowerManager.Stub.asInterface((IBinder)ServiceManager.getService((String)"power"));
            if (power != null) {
                power.setBacklightBrightness(brightness);
            }
        }
        catch (RemoteException remoteException) {
            // empty catch block
        }
    }

    private void setRingerMode() {
        if (this.mSilent) {
            this.mAudioManager.setRingerMode(this.mVibrate ? 1 : 0);
        } else {
            this.mAudioManager.setRingerMode(2);
            this.mAudioManager.setVibrateSetting(0, this.mVibrate ? 1 : 0);
        }
    }

    byte[] getLocaleData() {
        Configuration conf = this.mContext.getResources().getConfiguration();
        Locale loc = conf.locale;
        String localeString = loc.getLanguage();
        String country = loc.getCountry();
        if (!TextUtils.isEmpty((CharSequence)country)) {
            localeString = localeString + "_" + country;
        }
        return localeString.getBytes();
    }

    void setLocaleData(byte[] data) {
        Configuration conf = this.mContext.getResources().getConfiguration();
        Locale loc = conf.locale;
        if (conf.userSetLocale) {
            return;
        }
        String[] availableLocales = this.mContext.getAssets().getLocales();
        String localeCode = new String(data);
        String language = new String(data, 0, 2);
        String country = data.length > 4 ? new String(data, 3, 2) : "";
        loc = null;
        for (int i = 0; i < availableLocales.length; ++i) {
            if (!availableLocales[i].equals(localeCode)) continue;
            loc = new Locale(language, country);
            break;
        }
        if (loc == null) {
            return;
        }
        try {
            IActivityManager am = ActivityManagerNative.getDefault();
            Configuration config = am.getConfiguration();
            config.locale = loc;
            config.userSetLocale = true;
            am.updateConfiguration(config);
        }
        catch (RemoteException e) {
            // empty catch block
        }
    }

    void applyAudioSettings() {
        AudioManager am = new AudioManager(this.mContext);
        am.reloadAudioSettings();
    }
}

