/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.settings;

import android.app.backup.BackupAgentHelper;
import android.app.backup.BackupDataInput;
import android.app.backup.BackupDataOutput;
import android.content.ContentValues;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.net.wifi.WifiManager;
import android.os.FileUtils;
import android.os.ParcelFileDescriptor;
import android.os.Process;
import android.provider.Settings;
import android.text.TextUtils;
import android.util.Log;
import com.android.providers.settings.SettingsHelper;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.EOFException;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Arrays;
import java.util.zip.CRC32;

public class SettingsBackupAgent
extends BackupAgentHelper {
    private static final boolean DEBUG = false;
    private static final String KEY_SYSTEM = "system";
    private static final String KEY_SECURE = "secure";
    private static final String KEY_LOCALE = "locale";
    private static final int STATE_VERSION = 1;
    private static final int STATE_SYSTEM = 0;
    private static final int STATE_SECURE = 1;
    private static final int STATE_LOCALE = 2;
    private static final int STATE_WIFI = 3;
    private static final int STATE_SIZE = 4;
    private static String[] sortedSystemKeys = null;
    private static String[] sortedSecureKeys = null;
    private static final byte[] EMPTY_DATA = new byte[0];
    private static final String TAG = "SettingsBackupAgent";
    private static final int COLUMN_NAME = 1;
    private static final int COLUMN_VALUE = 2;
    private static final String[] PROJECTION = new String[]{"_id", "name", "value"};
    private static final String FILE_WIFI_SUPPLICANT = "/data/misc/wifi/wpa_supplicant.conf";
    private static final String FILE_WIFI_SUPPLICANT_TEMPLATE = "/system/etc/wifi/wpa_supplicant.conf";
    private static final String KEY_WIFI_SUPPLICANT = "\uffedWIFI";
    private SettingsHelper mSettingsHelper;

    public void onCreate() {
        this.mSettingsHelper = new SettingsHelper((Context)this);
        super.onCreate();
    }

    public void onBackup(ParcelFileDescriptor oldState, BackupDataOutput data, ParcelFileDescriptor newState) throws IOException {
        byte[] systemSettingsData = this.getSystemSettings();
        byte[] secureSettingsData = this.getSecureSettings();
        byte[] locale = this.mSettingsHelper.getLocaleData();
        byte[] wifiData = this.getWifiSupplicant(FILE_WIFI_SUPPLICANT);
        long[] stateChecksums = this.readOldChecksums(oldState);
        stateChecksums[0] = this.writeIfChanged(stateChecksums[0], KEY_SYSTEM, systemSettingsData, data);
        stateChecksums[1] = this.writeIfChanged(stateChecksums[1], KEY_SECURE, secureSettingsData, data);
        stateChecksums[2] = this.writeIfChanged(stateChecksums[2], KEY_LOCALE, locale, data);
        stateChecksums[3] = this.writeIfChanged(stateChecksums[3], KEY_WIFI_SUPPLICANT, wifiData, data);
        this.writeNewChecksums(stateChecksums, newState);
    }

    public void onRestore(BackupDataInput data, int appVersionCode, ParcelFileDescriptor newState) throws IOException {
        while (data.readNextHeader()) {
            String key = data.getKey();
            int size = data.getDataSize();
            if (KEY_SYSTEM.equals(key)) {
                this.restoreSettings(data, Settings.System.CONTENT_URI);
                this.mSettingsHelper.applyAudioSettings();
                continue;
            }
            if (KEY_SECURE.equals(key)) {
                this.restoreSettings(data, Settings.Secure.CONTENT_URI);
                continue;
            }
            if (KEY_WIFI_SUPPLICANT.equals(key)) {
                int retainedWifiState = this.enableWifi(false);
                this.restoreWifiSupplicant(FILE_WIFI_SUPPLICANT, data);
                FileUtils.setPermissions((String)FILE_WIFI_SUPPLICANT, (int)432, (int)Process.myUid(), (int)1010);
                this.enableWifi(retainedWifiState == 3 || retainedWifiState == 2);
                continue;
            }
            if (KEY_LOCALE.equals(key)) {
                byte[] localeData = new byte[size];
                data.readEntityData(localeData, 0, size);
                this.mSettingsHelper.setLocaleData(localeData);
                continue;
            }
            data.skipEntityData();
        }
    }

    private long[] readOldChecksums(ParcelFileDescriptor oldState) throws IOException {
        long[] stateChecksums = new long[4];
        DataInputStream dataInput = new DataInputStream(new FileInputStream(oldState.getFileDescriptor()));
        try {
            int stateVersion = dataInput.readInt();
            if (stateVersion == 1) {
                for (int i = 0; i < 4; ++i) {
                    stateChecksums[i] = dataInput.readLong();
                }
            }
        }
        catch (EOFException eof) {
            // empty catch block
        }
        dataInput.close();
        return stateChecksums;
    }

    private void writeNewChecksums(long[] checksums, ParcelFileDescriptor newState) throws IOException {
        DataOutputStream dataOutput = new DataOutputStream(new FileOutputStream(newState.getFileDescriptor()));
        dataOutput.writeInt(1);
        for (int i = 0; i < 4; ++i) {
            dataOutput.writeLong(checksums[i]);
        }
        dataOutput.close();
    }

    private long writeIfChanged(long oldChecksum, String key, byte[] data, BackupDataOutput output) {
        CRC32 checkSummer = new CRC32();
        checkSummer.update(data);
        long newChecksum = checkSummer.getValue();
        if (oldChecksum == newChecksum) {
            return oldChecksum;
        }
        try {
            output.writeEntityHeader(key, data.length);
            output.writeEntityData(data, data.length);
        }
        catch (IOException ioe) {
            // empty catch block
        }
        return newChecksum;
    }

    private byte[] getSystemSettings() {
        Cursor sortedCursor = this.getContentResolver().query(Settings.System.CONTENT_URI, PROJECTION, null, null, "name");
        if (sortedSystemKeys == null) {
            sortedSystemKeys = this.copyAndSort(Settings.System.SETTINGS_TO_BACKUP);
        }
        byte[] result = this.extractRelevantValues(sortedCursor, sortedSystemKeys);
        sortedCursor.close();
        return result;
    }

    private byte[] getSecureSettings() {
        Cursor sortedCursor = this.getContentResolver().query(Settings.Secure.CONTENT_URI, PROJECTION, null, null, "name");
        if (sortedSecureKeys == null) {
            sortedSecureKeys = this.copyAndSort(Settings.Secure.SETTINGS_TO_BACKUP);
        }
        byte[] result = this.extractRelevantValues(sortedCursor, sortedSecureKeys);
        sortedCursor.close();
        return result;
    }

    private void restoreSettings(BackupDataInput data, Uri contentUri) {
        int length;
        String[] whitelist = null;
        if (contentUri.equals((Object)Settings.Secure.CONTENT_URI)) {
            whitelist = Settings.Secure.SETTINGS_TO_BACKUP;
        } else if (contentUri.equals((Object)Settings.System.CONTENT_URI)) {
            whitelist = Settings.System.SETTINGS_TO_BACKUP;
        }
        ContentValues cv = new ContentValues(2);
        byte[] settings = new byte[data.getDataSize()];
        try {
            data.readEntityData(settings, 0, settings.length);
        }
        catch (IOException ioe) {
            Log.e((String)TAG, (String)"Couldn't read entity data");
            return;
        }
        for (int pos = 0; pos < settings.length; pos += length) {
            length = this.readInt(settings, pos);
            String settingName = length > 0 ? new String(settings, pos += 4, length) : null;
            pos += length;
            length = this.readInt(settings, pos);
            String settingValue = length > 0 ? new String(settings, pos += 4, length) : null;
            if (TextUtils.isEmpty((CharSequence)settingName) || TextUtils.isEmpty((CharSequence)settingValue) || this.invalidSavedSetting(whitelist, settingName) || !this.mSettingsHelper.restoreValue(settingName, settingValue)) continue;
            cv.clear();
            cv.put("name", settingName);
            cv.put("value", settingValue);
            this.getContentResolver().insert(contentUri, cv);
        }
    }

    private boolean invalidSavedSetting(String[] knownNames, String candidate) {
        if (knownNames == null) {
            return false;
        }
        for (String name : knownNames) {
            if (!name.equals(candidate)) continue;
            return false;
        }
        return true;
    }

    private String[] copyAndSort(String[] keys) {
        Object[] sortedKeys = new String[keys.length];
        System.arraycopy(keys, 0, sortedKeys, 0, keys.length);
        Arrays.sort(sortedKeys);
        return sortedKeys;
    }

    byte[] extractRelevantValues(Cursor sortedCursor, String[] sortedKeys) {
        byte[][] values = new byte[sortedKeys.length * 2][];
        if (!sortedCursor.moveToFirst()) {
            Log.e((String)TAG, (String)"Couldn't read from the cursor");
            return new byte[0];
        }
        int keyIndex = 0;
        int totalSize = 0;
        while (!sortedCursor.isAfterLast()) {
            String name = sortedCursor.getString(1);
            while (sortedKeys[keyIndex].compareTo(name.toString()) < 0 && ++keyIndex != sortedKeys.length) {
            }
            if (keyIndex < sortedKeys.length && name.equals(sortedKeys[keyIndex])) {
                byte[] valueBytes;
                String value = sortedCursor.getString(2);
                byte[] nameBytes = name.toString().getBytes();
                totalSize += 4 + nameBytes.length;
                values[keyIndex * 2] = nameBytes;
                if (TextUtils.isEmpty((CharSequence)value)) {
                    valueBytes = null;
                    totalSize += 4;
                } else {
                    valueBytes = value.toString().getBytes();
                    totalSize += 4 + valueBytes.length;
                }
                values[keyIndex * 2 + 1] = valueBytes;
                ++keyIndex;
            }
            if (keyIndex != sortedKeys.length && sortedCursor.moveToNext()) continue;
            break;
        }
        byte[] result = new byte[totalSize];
        int pos = 0;
        for (int i = 0; i < sortedKeys.length * 2; ++i) {
            if (values[i] == null) continue;
            pos = this.writeInt(result, pos, values[i].length);
            pos = this.writeBytes(result, pos, values[i]);
        }
        return result;
    }

    private byte[] getWifiSupplicant(String filename) {
        try {
            File file = new File(filename);
            if (file.exists()) {
                String line;
                BufferedReader br = new BufferedReader(new FileReader(file));
                StringBuffer relevantLines = new StringBuffer();
                boolean started = false;
                while ((line = br.readLine()) != null) {
                    if (!started && line.startsWith("network")) {
                        started = true;
                    }
                    if (!started) continue;
                    relevantLines.append(line).append("\n");
                }
                if (relevantLines.length() > 0) {
                    return relevantLines.toString().getBytes();
                }
                return EMPTY_DATA;
            }
            return EMPTY_DATA;
        }
        catch (IOException ioe) {
            Log.w((String)TAG, (String)("Couldn't backup " + filename));
            return EMPTY_DATA;
        }
    }

    private void restoreWifiSupplicant(String filename, BackupDataInput data) {
        byte[] bytes = new byte[data.getDataSize()];
        if (bytes.length <= 0) {
            return;
        }
        try {
            data.readEntityData(bytes, 0, bytes.length);
            File supplicantFile = new File(FILE_WIFI_SUPPLICANT);
            if (supplicantFile.exists()) {
                supplicantFile.delete();
            }
            this.copyWifiSupplicantTemplate();
            FileOutputStream fos = new FileOutputStream(filename, true);
            fos.write("\n".getBytes());
            fos.write(bytes);
        }
        catch (IOException ioe) {
            Log.w((String)TAG, (String)("Couldn't restore " + filename));
        }
    }

    private void copyWifiSupplicantTemplate() {
        try {
            int size;
            BufferedReader br = new BufferedReader(new FileReader(FILE_WIFI_SUPPLICANT_TEMPLATE));
            BufferedWriter bw = new BufferedWriter(new FileWriter(FILE_WIFI_SUPPLICANT));
            char[] temp = new char[1024];
            while ((size = br.read(temp)) > 0) {
                bw.write(temp, 0, size);
            }
            bw.close();
            br.close();
        }
        catch (IOException ioe) {
            Log.w((String)TAG, (String)"Couldn't copy wpa_supplicant file");
        }
    }

    private int writeInt(byte[] out, int pos, int value) {
        out[pos + 0] = (byte)(value >> 24 & 0xFF);
        out[pos + 1] = (byte)(value >> 16 & 0xFF);
        out[pos + 2] = (byte)(value >> 8 & 0xFF);
        out[pos + 3] = (byte)(value >> 0 & 0xFF);
        return pos + 4;
    }

    private int writeBytes(byte[] out, int pos, byte[] value) {
        System.arraycopy(value, 0, out, pos, value.length);
        return pos + value.length;
    }

    private int readInt(byte[] in, int pos) {
        int result = (in[pos] & 0xFF) << 24 | (in[pos + 1] & 0xFF) << 16 | (in[pos + 2] & 0xFF) << 8 | (in[pos + 3] & 0xFF) << 0;
        return result;
    }

    private int enableWifi(boolean enable) {
        WifiManager wfm = (WifiManager)this.getSystemService("wifi");
        if (wfm != null) {
            int state = wfm.getWifiState();
            wfm.setWifiEnabled(enable);
            return state;
        }
        return 4;
    }
}

