/*
 * Decompiled with CFR 0.152.
 */
package com.android.providers.settings;

import android.content.ComponentName;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.res.XmlResourceParser;
import android.database.Cursor;
import android.database.sqlite.SQLiteDatabase;
import android.database.sqlite.SQLiteOpenHelper;
import android.database.sqlite.SQLiteStatement;
import android.media.AudioManager;
import android.media.AudioService;
import android.os.SystemProperties;
import android.text.TextUtils;
import android.util.Log;
import com.android.internal.util.XmlUtils;
import com.android.internal.widget.LockPatternUtils;
import java.io.IOException;
import java.util.HashSet;
import java.util.List;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

public class DatabaseHelper
extends SQLiteOpenHelper {
    private static final String TAG = "SettingsProvider";
    private static final String DATABASE_NAME = "settings.db";
    private static final int DATABASE_VERSION = 57;
    private Context mContext;
    private static final HashSet<String> mValidTables = new HashSet();

    public DatabaseHelper(Context context) {
        super(context, DATABASE_NAME, null, 57);
        this.mContext = context;
    }

    public static boolean isValidTable(String name) {
        return mValidTables.contains(name);
    }

    private void createSecureTable(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE secure (_id INTEGER PRIMARY KEY AUTOINCREMENT,name TEXT UNIQUE ON CONFLICT REPLACE,value TEXT);");
        db.execSQL("CREATE INDEX secureIndex1 ON secure (name);");
    }

    public void onCreate(SQLiteDatabase db) {
        db.execSQL("CREATE TABLE system (_id INTEGER PRIMARY KEY AUTOINCREMENT,name TEXT UNIQUE ON CONFLICT REPLACE,value TEXT);");
        db.execSQL("CREATE INDEX systemIndex1 ON system (name);");
        this.createSecureTable(db);
        db.execSQL("CREATE TABLE bluetooth_devices (_id INTEGER PRIMARY KEY,name TEXT,addr TEXT,channel INTEGER,type INTEGER);");
        db.execSQL("CREATE TABLE bookmarks (_id INTEGER PRIMARY KEY,title TEXT,folder TEXT,intent TEXT,shortcut INTEGER,ordering INTEGER);");
        db.execSQL("CREATE INDEX bookmarksIndex1 ON bookmarks (folder);");
        db.execSQL("CREATE INDEX bookmarksIndex2 ON bookmarks (shortcut);");
        this.loadBookmarks(db);
        this.loadVolumeLevels(db);
        this.loadSettings(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onUpgrade(SQLiteDatabase db, int oldVersion, int currentVersion) {
        Log.w((String)TAG, (String)("Upgrading settings database from version " + oldVersion + " to " + currentVersion));
        int upgradeVersion = oldVersion;
        if (upgradeVersion == 20) {
            this.loadVibrateSetting(db, true);
            upgradeVersion = 21;
        }
        if (upgradeVersion < 22) {
            upgradeVersion = 22;
            this.upgradeLockPatternLocation(db);
        }
        if (upgradeVersion < 23) {
            db.execSQL("UPDATE favorites SET iconResource=0 WHERE iconType=0");
            upgradeVersion = 23;
        }
        if (upgradeVersion == 23) {
            db.beginTransaction();
            try {
                db.execSQL("ALTER TABLE favorites ADD spanX INTEGER");
                db.execSQL("ALTER TABLE favorites ADD spanY INTEGER");
                db.execSQL("UPDATE favorites SET spanX=1, spanY=1 WHERE itemType<=0");
                db.execSQL("UPDATE favorites SET spanX=2, spanY=2 WHERE itemType=1000 or itemType=1002");
                db.execSQL("UPDATE favorites SET spanX=4, spanY=1 WHERE itemType=1001");
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
            upgradeVersion = 24;
        }
        if (upgradeVersion == 24) {
            db.beginTransaction();
            try {
                db.execSQL("DELETE FROM system WHERE name='network_preference'");
                db.execSQL("INSERT INTO system ('name', 'value') values ('network_preference', '1')");
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
            upgradeVersion = 25;
        }
        if (upgradeVersion == 25) {
            db.beginTransaction();
            try {
                db.execSQL("ALTER TABLE favorites ADD uri TEXT");
                db.execSQL("ALTER TABLE favorites ADD displayMode INTEGER");
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
            upgradeVersion = 26;
        }
        if (upgradeVersion == 26) {
            db.beginTransaction();
            try {
                this.createSecureTable(db);
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
            upgradeVersion = 27;
        }
        if (upgradeVersion == 27) {
            String[] settingsToMove = new String[]{"adb_enabled", "android_id", "bluetooth_on", "data_roaming", "device_provisioned", "http_proxy", "install_non_market_apps", "location_providers_allowed", "logging_id", "network_preference", "parental_control_enabled", "parental_control_last_update", "parental_control_redirect_url", "settings_classname", "usb_mass_storage_enabled", "use_google_mail", "wifi_networks_available_notification_on", "wifi_networks_available_repeat_delay", "wifi_num_open_networks_kept", "wifi_on", "wifi_watchdog_acceptable_packet_loss_percentage", "wifi_watchdog_ap_count", "wifi_watchdog_background_check_delay_ms", "wifi_watchdog_background_check_enabled", "wifi_watchdog_background_check_timeout_ms", "wifi_watchdog_initial_ignored_ping_count", "wifi_watchdog_max_ap_checks", "wifi_watchdog_on", "wifi_watchdog_ping_count", "wifi_watchdog_ping_delay_ms", "wifi_watchdog_ping_timeout_ms"};
            this.moveFromSystemToSecure(db, settingsToMove);
            upgradeVersion = 28;
        }
        if (upgradeVersion == 28 || upgradeVersion == 29) {
            db.beginTransaction();
            try {
                db.execSQL("DELETE FROM system WHERE name='mode_ringer_streams_affected'");
                int newValue = 38;
                db.execSQL("INSERT INTO system ('name', 'value') values ('mode_ringer_streams_affected', '" + String.valueOf(newValue) + "')");
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
            upgradeVersion = 30;
        }
        if (upgradeVersion == 30) {
            db.beginTransaction();
            try {
                db.execSQL("UPDATE bookmarks SET folder = '@quicklaunch'");
                db.execSQL("UPDATE bookmarks SET title = ''");
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
            upgradeVersion = 31;
        }
        if (upgradeVersion == 31) {
            db.beginTransaction();
            SQLiteStatement stmt = null;
            try {
                db.execSQL("DELETE FROM system WHERE name='window_animation_scale'");
                db.execSQL("DELETE FROM system WHERE name='transition_animation_scale'");
                stmt = db.compileStatement("INSERT INTO system(name,value) VALUES(?,?);");
                this.loadDefaultAnimationSettings(stmt);
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
                if (stmt != null) {
                    stmt.close();
                }
            }
            upgradeVersion = 32;
        }
        if (upgradeVersion == 32) {
            String wifiWatchList = SystemProperties.get((String)"ro.com.android.wifi-watchlist");
            if (!TextUtils.isEmpty((CharSequence)wifiWatchList)) {
                db.beginTransaction();
                try {
                    db.execSQL("INSERT OR IGNORE INTO secure(name,value) values('wifi_watchdog_watch_list','" + wifiWatchList + "');");
                    db.setTransactionSuccessful();
                }
                finally {
                    db.endTransaction();
                }
            }
            upgradeVersion = 33;
        }
        if (upgradeVersion == 33) {
            db.beginTransaction();
            try {
                db.execSQL("INSERT INTO system(name,value) values('zoom','2');");
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
            upgradeVersion = 34;
        }
        if (upgradeVersion == 34) {
            db.beginTransaction();
            SQLiteStatement stmt = null;
            try {
                stmt = db.compileStatement("INSERT OR IGNORE INTO secure(name,value) VALUES(?,?);");
                this.loadSecure35Settings(stmt);
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
                if (stmt != null) {
                    stmt.close();
                }
            }
            upgradeVersion = 35;
        }
        if (upgradeVersion == 35) {
            upgradeVersion = 36;
        }
        if (upgradeVersion == 36) {
            db.beginTransaction();
            try {
                db.execSQL("DELETE FROM system WHERE name='mode_ringer_streams_affected'");
                int newValue = 166;
                db.execSQL("INSERT INTO system ('name', 'value') values ('mode_ringer_streams_affected', '" + String.valueOf(newValue) + "')");
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
            upgradeVersion = 37;
        }
        if (upgradeVersion == 37) {
            db.beginTransaction();
            SQLiteStatement stmt = null;
            try {
                stmt = db.compileStatement("INSERT OR IGNORE INTO system(name,value) VALUES(?,?);");
                this.loadStringSetting(stmt, "airplane_mode_toggleable_radios", 2131099649);
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
                if (stmt != null) {
                    stmt.close();
                }
            }
            upgradeVersion = 38;
        }
        if (upgradeVersion == 38) {
            db.beginTransaction();
            try {
                String value = this.mContext.getResources().getBoolean(2130968584) ? "1" : "0";
                db.execSQL("INSERT OR IGNORE INTO secure(name,value) values('assisted_gps_enabled','" + value + "');");
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
            upgradeVersion = 39;
        }
        if (upgradeVersion == 39) {
            db.beginTransaction();
            try {
                String value = this.mContext.getResources().getBoolean(2130968580) ? "1" : "0";
                db.execSQL("INSERT OR IGNORE INTO system(name,value) values('screen_brightness_mode','" + value + "');");
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
            upgradeVersion = 40;
        }
        if (upgradeVersion == 40) {
            db.beginTransaction();
            SQLiteStatement stmt = null;
            try {
                db.execSQL("DELETE FROM system WHERE name='window_animation_scale'");
                db.execSQL("DELETE FROM system WHERE name='transition_animation_scale'");
                stmt = db.compileStatement("INSERT INTO system(name,value) VALUES(?,?);");
                this.loadDefaultAnimationSettings(stmt);
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
                if (stmt != null) {
                    stmt.close();
                }
            }
            upgradeVersion = 41;
        }
        if (upgradeVersion == 41) {
            db.beginTransaction();
            SQLiteStatement stmt = null;
            try {
                db.execSQL("DELETE FROM system WHERE name='haptic_feedback_enabled'");
                stmt = db.compileStatement("INSERT INTO system(name,value) VALUES(?,?);");
                this.loadDefaultHapticSettings(stmt);
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
                if (stmt != null) {
                    stmt.close();
                }
            }
            upgradeVersion = 42;
        }
        if (upgradeVersion == 42) {
            db.beginTransaction();
            SQLiteStatement stmt = null;
            try {
                stmt = db.compileStatement("INSERT INTO system(name,value) VALUES(?,?);");
                this.loadBooleanSetting(stmt, "notification_light_pulse", 2130968589);
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
                if (stmt != null) {
                    stmt.close();
                }
            }
            upgradeVersion = 43;
        }
        if (upgradeVersion == 43) {
            db.beginTransaction();
            SQLiteStatement stmt = null;
            try {
                stmt = db.compileStatement("INSERT OR IGNORE INTO system(name,value) VALUES(?,?);");
                this.loadSetting(stmt, "volume_bluetooth_sco", AudioManager.DEFAULT_STREAM_VOLUME[6]);
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
                if (stmt != null) {
                    stmt.close();
                }
            }
            upgradeVersion = 44;
        }
        if (upgradeVersion == 44) {
            db.execSQL("DROP TABLE IF EXISTS gservices");
            db.execSQL("DROP INDEX IF EXISTS gservicesIndex1");
            upgradeVersion = 45;
        }
        if (upgradeVersion == 45) {
            db.beginTransaction();
            try {
                db.execSQL("INSERT INTO secure(name,value) values('mount_play_not_snd','1');");
                db.execSQL("INSERT INTO secure(name,value) values('mount_ums_autostart','0');");
                db.execSQL("INSERT INTO secure(name,value) values('mount_ums_prompt','1');");
                db.execSQL("INSERT INTO secure(name,value) values('mount_ums_notify_enabled','1');");
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
            upgradeVersion = 46;
        }
        if (upgradeVersion == 46) {
            db.beginTransaction();
            try {
                db.execSQL("DELETE FROM system WHERE name='lockscreen.password_type';");
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
            upgradeVersion = 47;
        }
        if (upgradeVersion == 47) {
            db.beginTransaction();
            try {
                db.execSQL("DELETE FROM system WHERE name='lockscreen.password_type';");
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
            upgradeVersion = 48;
        }
        if (upgradeVersion == 48) {
            upgradeVersion = 49;
        }
        if (upgradeVersion == 49) {
            db.beginTransaction();
            SQLiteStatement stmt = null;
            try {
                stmt = db.compileStatement("INSERT INTO system(name,value) VALUES(?,?);");
                this.loadUISoundEffectsSettings(stmt);
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
                if (stmt != null) {
                    stmt.close();
                }
            }
            upgradeVersion = 50;
        }
        if (upgradeVersion == 50) {
            upgradeVersion = 51;
        }
        if (upgradeVersion == 51) {
            String[] settingsToMove = new String[]{"lock_pattern_autolock", "lock_pattern_visible_pattern", "lock_pattern_tactile_feedback_enabled", "lockscreen.password_type", "lockscreen.lockoutattemptdeadline", "lockscreen.patterneverchosen", "lock_pattern_autolock", "lockscreen.lockedoutpermanently", "lockscreen.password_salt"};
            this.moveFromSystemToSecure(db, settingsToMove);
            upgradeVersion = 52;
        }
        if (upgradeVersion == 52) {
            db.beginTransaction();
            SQLiteStatement stmt = null;
            try {
                stmt = db.compileStatement("INSERT INTO system(name,value) VALUES(?,?);");
                this.loadBooleanSetting(stmt, "vibrate_in_silent", 2130968595);
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
                if (stmt != null) {
                    stmt.close();
                }
            }
            upgradeVersion = 53;
        }
        if (upgradeVersion == 53) {
            upgradeVersion = 54;
        }
        if (upgradeVersion == 54) {
            db.beginTransaction();
            try {
                this.upgradeScreenTimeoutFromNever(db);
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
            }
            upgradeVersion = 55;
        }
        if (upgradeVersion == 55) {
            String[] settingsToMove = new String[]{"set_install_location", "default_install_location"};
            this.moveFromSystemToSecure(db, settingsToMove);
            db.beginTransaction();
            SQLiteStatement stmt = null;
            try {
                stmt = db.compileStatement("INSERT INTO system(name,value) VALUES(?,?);");
                this.loadSetting(stmt, "set_install_location", 0);
                this.loadSetting(stmt, "default_install_location", 0);
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
                if (stmt != null) {
                    stmt.close();
                }
            }
            upgradeVersion = 56;
        }
        if (upgradeVersion == 56) {
            db.beginTransaction();
            SQLiteStatement stmt = null;
            try {
                db.execSQL("DELETE FROM system WHERE name='airplane_mode_toggleable_radios'");
                stmt = db.compileStatement("INSERT OR IGNORE INTO system(name,value) VALUES(?,?);");
                this.loadStringSetting(stmt, "airplane_mode_toggleable_radios", 2131099649);
                db.setTransactionSuccessful();
            }
            finally {
                db.endTransaction();
                if (stmt != null) {
                    stmt.close();
                }
            }
            upgradeVersion = 57;
        }
        if (upgradeVersion != currentVersion) {
            Log.w((String)TAG, (String)("Got stuck trying to upgrade from version " + upgradeVersion + ", must wipe the settings provider"));
            db.execSQL("DROP TABLE IF EXISTS system");
            db.execSQL("DROP INDEX IF EXISTS systemIndex1");
            db.execSQL("DROP TABLE IF EXISTS secure");
            db.execSQL("DROP INDEX IF EXISTS secureIndex1");
            db.execSQL("DROP TABLE IF EXISTS gservices");
            db.execSQL("DROP INDEX IF EXISTS gservicesIndex1");
            db.execSQL("DROP TABLE IF EXISTS bluetooth_devices");
            db.execSQL("DROP TABLE IF EXISTS bookmarks");
            db.execSQL("DROP INDEX IF EXISTS bookmarksIndex1");
            db.execSQL("DROP INDEX IF EXISTS bookmarksIndex2");
            db.execSQL("DROP TABLE IF EXISTS favorites");
            this.onCreate(db);
            String wipeReason = oldVersion + "/" + upgradeVersion + "/" + currentVersion;
            db.execSQL("INSERT INTO secure(name,value) values('wiped_db_reason','" + wipeReason + "');");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void moveFromSystemToSecure(SQLiteDatabase db, String[] settingsToMove) {
        SQLiteStatement insertStmt = null;
        SQLiteStatement deleteStmt = null;
        db.beginTransaction();
        try {
            insertStmt = db.compileStatement("INSERT INTO secure (name,value) SELECT name,value FROM system WHERE name=?");
            deleteStmt = db.compileStatement("DELETE FROM system WHERE name=?");
            for (String setting : settingsToMove) {
                insertStmt.bindString(1, setting);
                insertStmt.execute();
                deleteStmt.bindString(1, setting);
                deleteStmt.execute();
            }
            db.setTransactionSuccessful();
        }
        finally {
            db.endTransaction();
            if (insertStmt != null) {
                insertStmt.close();
            }
            if (deleteStmt != null) {
                deleteStmt.close();
            }
        }
    }

    private void upgradeLockPatternLocation(SQLiteDatabase db) {
        Cursor c = db.query("system", new String[]{"_id", "value"}, "name='lock_pattern'", null, null, null, null);
        if (c.getCount() > 0) {
            c.moveToFirst();
            String lockPattern = c.getString(1);
            if (!TextUtils.isEmpty((CharSequence)lockPattern)) {
                try {
                    LockPatternUtils lpu = new LockPatternUtils(this.mContext);
                    List cellPattern = LockPatternUtils.stringToPattern((String)lockPattern);
                    lpu.saveLockPattern(cellPattern);
                }
                catch (IllegalArgumentException e) {
                    // empty catch block
                }
            }
            c.close();
            db.delete("system", "name='lock_pattern'", null);
        } else {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void upgradeScreenTimeoutFromNever(SQLiteDatabase db) {
        Cursor c = db.query("system", new String[]{"_id", "value"}, "name=? AND value=?", new String[]{"screen_off_timeout", "-1"}, null, null, null);
        SQLiteStatement stmt = null;
        if (c.getCount() > 0) {
            c.close();
            try {
                stmt = db.compileStatement("INSERT OR REPLACE INTO system(name,value) VALUES(?,?);");
                this.loadSetting(stmt, "screen_off_timeout", Integer.toString(1800000));
            }
            finally {
                if (stmt != null) {
                    stmt.close();
                }
            }
        } else {
            c.close();
        }
    }

    private int loadBookmarks(SQLiteDatabase db, int startingIndex) {
        Intent intent = new Intent("android.intent.action.MAIN", null);
        intent.addCategory("android.intent.category.LAUNCHER");
        ContentValues values = new ContentValues();
        PackageManager packageManager = this.mContext.getPackageManager();
        int i = startingIndex;
        try {
            int type;
            XmlResourceParser parser = this.mContext.getResources().getXml(2130903040);
            XmlUtils.beginDocument((XmlPullParser)parser, (String)"bookmarks");
            int depth = parser.getDepth();
            while (((type = parser.next()) != 3 || parser.getDepth() > depth) && type != 1) {
                if (type != 2) continue;
                String name = parser.getName();
                if (!"bookmark".equals(name)) break;
                String pkg = parser.getAttributeValue(null, "package");
                String cls = parser.getAttributeValue(null, "class");
                String shortcutStr = parser.getAttributeValue(null, "shortcut");
                char shortcutValue = shortcutStr.charAt(0);
                if (TextUtils.isEmpty((CharSequence)shortcutStr)) {
                    Log.w((String)TAG, (String)("Unable to get shortcut for: " + pkg + "/" + cls));
                }
                ActivityInfo info = null;
                ComponentName cn = new ComponentName(pkg, cls);
                try {
                    info = packageManager.getActivityInfo(cn, 0);
                }
                catch (PackageManager.NameNotFoundException e) {
                    String[] packages = packageManager.canonicalToCurrentPackageNames(new String[]{pkg});
                    cn = new ComponentName(packages[0], cls);
                    try {
                        info = packageManager.getActivityInfo(cn, 0);
                    }
                    catch (PackageManager.NameNotFoundException e1) {
                        Log.w((String)TAG, (String)("Unable to add bookmark: " + pkg + "/" + cls), (Throwable)e);
                    }
                }
                if (info == null) continue;
                intent.setComponent(cn);
                intent.setFlags(0x10000000);
                values.put("intent", intent.toUri(0));
                values.put("title", ((Object)info.loadLabel(packageManager)).toString());
                values.put("shortcut", Integer.valueOf(shortcutValue));
                db.insert("bookmarks", null, values);
                ++i;
            }
        }
        catch (XmlPullParserException e) {
            Log.w((String)TAG, (String)"Got execption parsing bookmarks.", (Throwable)e);
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"Got execption parsing bookmarks.", (Throwable)e);
        }
        return i;
    }

    private void loadBookmarks(SQLiteDatabase db) {
        this.loadBookmarks(db, 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadVolumeLevels(SQLiteDatabase db) {
        SQLiteStatement stmt = null;
        try {
            stmt = db.compileStatement("INSERT OR IGNORE INTO system(name,value) VALUES(?,?);");
            this.loadSetting(stmt, "volume_music", AudioManager.DEFAULT_STREAM_VOLUME[3]);
            this.loadSetting(stmt, "volume_ring", AudioManager.DEFAULT_STREAM_VOLUME[2]);
            this.loadSetting(stmt, "volume_system", AudioManager.DEFAULT_STREAM_VOLUME[1]);
            this.loadSetting(stmt, "volume_voice", AudioManager.DEFAULT_STREAM_VOLUME[0]);
            this.loadSetting(stmt, "volume_alarm", AudioManager.DEFAULT_STREAM_VOLUME[4]);
            this.loadSetting(stmt, "volume_notification", AudioManager.DEFAULT_STREAM_VOLUME[5]);
            this.loadSetting(stmt, "volume_bluetooth_sco", AudioManager.DEFAULT_STREAM_VOLUME[6]);
            this.loadSetting(stmt, "mode_ringer", 2);
            this.loadVibrateSetting(db, false);
            this.loadSetting(stmt, "mode_ringer_streams_affected", 166);
            this.loadSetting(stmt, "mute_streams_affected", 46);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadVibrateSetting(SQLiteDatabase db, boolean deleteOld) {
        if (deleteOld) {
            db.execSQL("DELETE FROM system WHERE name='vibrate_on'");
        }
        SQLiteStatement stmt = null;
        try {
            stmt = db.compileStatement("INSERT OR IGNORE INTO system(name,value) VALUES(?,?);");
            int vibrate = 0;
            vibrate = AudioService.getValueForVibrateSetting((int)vibrate, (int)1, (int)1);
            vibrate |= AudioService.getValueForVibrateSetting((int)vibrate, (int)0, (int)0);
            this.loadSetting(stmt, "vibrate_on", vibrate);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private void loadSettings(SQLiteDatabase db) {
        this.loadSystemSettings(db);
        this.loadSecureSettings(db);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSystemSettings(SQLiteDatabase db) {
        SQLiteStatement stmt = null;
        try {
            stmt = db.compileStatement("INSERT OR IGNORE INTO system(name,value) VALUES(?,?);");
            this.loadBooleanSetting(stmt, "dim_screen", 2130968576);
            this.loadSetting(stmt, "stay_on_while_plugged_in", "1".equals(SystemProperties.get((String)"ro.kernel.qemu")) ? 1 : 0);
            this.loadIntegerSetting(stmt, "screen_off_timeout", 2131034112);
            this.loadSetting(stmt, "emergency_tone", 0);
            this.loadSetting(stmt, "call_auto_retry", 0);
            this.loadSetting(stmt, "dtmf_tone_type", 0);
            this.loadSetting(stmt, "hearing_aid", 0);
            this.loadSetting(stmt, "tty_mode", 0);
            this.loadBooleanSetting(stmt, "airplane_mode_on", 2130968577);
            this.loadStringSetting(stmt, "airplane_mode_radios", 2131099648);
            this.loadStringSetting(stmt, "airplane_mode_toggleable_radios", 2131099649);
            this.loadBooleanSetting(stmt, "auto_time", 2130968578);
            this.loadIntegerSetting(stmt, "screen_brightness", 2131034113);
            this.loadBooleanSetting(stmt, "screen_brightness_mode", 2130968580);
            this.loadDefaultAnimationSettings(stmt);
            this.loadBooleanSetting(stmt, "accelerometer_rotation", 2130968579);
            this.loadDefaultHapticSettings(stmt);
            this.loadBooleanSetting(stmt, "notification_light_pulse", 2130968589);
            this.loadSetting(stmt, "set_install_location", 0);
            this.loadSetting(stmt, "default_install_location", 0);
            this.loadUISoundEffectsSettings(stmt);
            this.loadBooleanSetting(stmt, "vibrate_in_silent", 2130968595);
            this.loadBooleanSetting(stmt, "notifications_use_ring_volume", 2130968594);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private void loadUISoundEffectsSettings(SQLiteStatement stmt) {
        this.loadIntegerSetting(stmt, "power_sounds_enabled", 2131034115);
        this.loadStringSetting(stmt, "low_battery_sound", 2131099652);
        this.loadIntegerSetting(stmt, "dock_sounds_enabled", 2131034116);
        this.loadStringSetting(stmt, "desk_dock_sound", 2131099653);
        this.loadStringSetting(stmt, "desk_undock_sound", 2131099654);
        this.loadStringSetting(stmt, "car_dock_sound", 2131099655);
        this.loadStringSetting(stmt, "car_undock_sound", 2131099656);
        this.loadIntegerSetting(stmt, "lockscreen_sounds_enabled", 2131034117);
        this.loadStringSetting(stmt, "lock_sound", 2131099657);
        this.loadStringSetting(stmt, "unlock_sound", 2131099658);
    }

    private void loadDefaultAnimationSettings(SQLiteStatement stmt) {
        this.loadFractionSetting(stmt, "window_animation_scale", 0x7F070000, 1);
        this.loadFractionSetting(stmt, "transition_animation_scale", 2131165185, 1);
    }

    private void loadDefaultHapticSettings(SQLiteStatement stmt) {
        this.loadBooleanSetting(stmt, "haptic_feedback_enabled", 2130968581);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadSecureSettings(SQLiteDatabase db) {
        SQLiteStatement stmt = null;
        try {
            stmt = db.compileStatement("INSERT OR IGNORE INTO secure(name,value) VALUES(?,?);");
            this.loadBooleanSetting(stmt, "bluetooth_on", 2130968582);
            this.loadSetting(stmt, "data_roaming", "true".equalsIgnoreCase(SystemProperties.get((String)"ro.com.android.dataroaming", (String)"false")) ? 1 : 0);
            this.loadBooleanSetting(stmt, "install_non_market_apps", 2130968583);
            this.loadStringSetting(stmt, "location_providers_allowed", 2131099650);
            this.loadBooleanSetting(stmt, "assisted_gps_enabled", 2130968584);
            this.loadIntegerSetting(stmt, "network_preference", 2131034114);
            this.loadBooleanSetting(stmt, "usb_mass_storage_enabled", 2130968585);
            this.loadBooleanSetting(stmt, "wifi_on", 2130968586);
            this.loadBooleanSetting(stmt, "wifi_networks_available_notification_on", 2130968587);
            String wifiWatchList = SystemProperties.get((String)"ro.com.android.wifi-watchlist");
            if (!TextUtils.isEmpty((CharSequence)wifiWatchList)) {
                this.loadSetting(stmt, "wifi_watchdog_watch_list", wifiWatchList);
            }
            int type = SystemProperties.getInt((String)"ro.telephony.default_network", (int)0);
            this.loadSetting(stmt, "preferred_network_mode", type);
            this.loadSetting(stmt, "cdma_cell_broadcast_sms", 1);
            this.loadSetting(stmt, "preferred_cdma_subscription", 1);
            this.loadSetting(stmt, "mock_location", "1".equals(SystemProperties.get((String)"ro.allow.mock.location")) ? 1 : 0);
            this.loadSecure35Settings(stmt);
            this.loadBooleanSetting(stmt, "mount_play_not_snd", 2130968590);
            this.loadBooleanSetting(stmt, "mount_ums_autostart", 2130968591);
            this.loadBooleanSetting(stmt, "mount_ums_prompt", 2130968592);
            this.loadBooleanSetting(stmt, "mount_ums_notify_enabled", 2130968593);
        }
        finally {
            if (stmt != null) {
                stmt.close();
            }
        }
    }

    private void loadSecure35Settings(SQLiteStatement stmt) {
        this.loadBooleanSetting(stmt, "backup_enabled", 2130968588);
        this.loadStringSetting(stmt, "backup_transport", 2131099651);
    }

    private void loadSetting(SQLiteStatement stmt, String key, Object value) {
        stmt.bindString(1, key);
        stmt.bindString(2, value.toString());
        stmt.execute();
    }

    private void loadStringSetting(SQLiteStatement stmt, String key, int resid) {
        this.loadSetting(stmt, key, this.mContext.getResources().getString(resid));
    }

    private void loadBooleanSetting(SQLiteStatement stmt, String key, int resid) {
        this.loadSetting(stmt, key, this.mContext.getResources().getBoolean(resid) ? "1" : "0");
    }

    private void loadIntegerSetting(SQLiteStatement stmt, String key, int resid) {
        this.loadSetting(stmt, key, Integer.toString(this.mContext.getResources().getInteger(resid)));
    }

    private void loadFractionSetting(SQLiteStatement stmt, String key, int resid, int base) {
        this.loadSetting(stmt, key, Float.toString(this.mContext.getResources().getFraction(resid, base, base)));
    }

    static {
        mValidTables.add("system");
        mValidTables.add("secure");
        mValidTables.add("bluetooth_devices");
        mValidTables.add("bookmarks");
        mValidTables.add("favorites");
        mValidTables.add("gservices");
        mValidTables.add("old_favorites");
    }
}

