/*
 * Decompiled with CFR 0.152.
 */
package com.android.inputmethod.pinyin;

import android.content.Context;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.graphics.drawable.Drawable;
import com.android.inputmethod.pinyin.SkbPool;
import com.android.inputmethod.pinyin.SkbTemplate;
import com.android.inputmethod.pinyin.SoftKey;
import com.android.inputmethod.pinyin.SoftKeyToggle;
import com.android.inputmethod.pinyin.SoftKeyType;
import com.android.inputmethod.pinyin.SoftKeyboard;
import java.io.IOException;
import java.util.regex.Pattern;
import org.xmlpull.v1.XmlPullParserException;

public class XmlKeyboardLoader {
    private static final String XMLTAG_SKB_TEMPLATE = "skb_template";
    private static final String XMLTAG_KEYTYPE = "key_type";
    private static final String XMLTAG_KEYICON = "key_icon";
    private static final String XMLATTR_KEY_XMARGIN = "key_xmargin";
    private static final String XMLATTR_KEY_YMARGIN = "key_ymargin";
    private static final String XMLATTR_SKB_BG = "skb_bg";
    private static final String XMLATTR_BALLOON_BG = "balloon_bg";
    private static final String XMLATTR_POPUP_BG = "popup_bg";
    private static final String XMLATTR_COLOR = "color";
    private static final String XMLATTR_COLOR_HIGHLIGHT = "color_highlight";
    private static final String XMLATTR_COLOR_BALLOON = "color_balloon";
    private static final String XMLATTR_ID = "id";
    private static final String XMLATTR_KEYTYPE_BG = "bg";
    private static final String XMLATTR_KEYTYPE_HLBG = "hlbg";
    private static final String XMLATTR_START_POS_X = "start_pos_x";
    private static final String XMLATTR_START_POS_Y = "start_pos_y";
    private static final String XMLATTR_ROW_ID = "row_id";
    private static final String XMLTAG_KEYBOARD = "keyboard";
    private static final String XMLTAG_ROW = "row";
    private static final String XMLTAG_KEYS = "keys";
    private static final String XMLTAG_KEY = "key";
    private static final String XMLTAG_TOGGLE_STATE = "toggle_state";
    private static final String XMLATTR_TOGGLE_STATE_ID = "state_id";
    private static final String XMLATTR_SKB_TEMPLATE = "skb_template";
    private static final String XMLATTR_SKB_CACHE_FLAG = "skb_cache_flag";
    private static final String XMLATTR_SKB_STICKY_FLAG = "skb_sticky_flag";
    private static final String XMLATTR_QWERTY = "qwerty";
    private static final String XMLATTR_QWERTY_UPPERCASE = "qwerty_uppercase";
    private static final String XMLATTR_KEY_TYPE = "key_type";
    private static final String XMLATTR_KEY_WIDTH = "width";
    private static final String XMLATTR_KEY_HEIGHT = "height";
    private static final String XMLATTR_KEY_REPEAT = "repeat";
    private static final String XMLATTR_KEY_BALLOON = "balloon";
    private static final String XMLATTR_KEY_SPLITTER = "splitter";
    private static final String XMLATTR_KEY_LABELS = "labels";
    private static final String XMLATTR_KEY_CODES = "codes";
    private static final String XMLATTR_KEY_LABEL = "label";
    private static final String XMLATTR_KEY_CODE = "code";
    private static final String XMLATTR_KEY_ICON = "icon";
    private static final String XMLATTR_KEY_ICON_POPUP = "icon_popup";
    private static final String XMLATTR_KEY_POPUP_SKBID = "popup_skb";
    private static boolean DEFAULT_SKB_CACHE_FLAG = true;
    private static boolean DEFAULT_SKB_STICKY_FLAG = true;
    private static final int KEYTYPE_ID_LAST = -1;
    private Context mContext;
    private Resources mResources;
    private int mXmlEventType;
    private SkbTemplate mSkbTemplate;
    float mKeyXPos;
    float mKeyYPos;
    int mSkbWidth;
    int mSkbHeight;
    float mKeyXMargin = 0.0f;
    float mKeyYMargin = 0.0f;
    boolean mNextEventFetched = false;
    String mAttrTmp;

    public XmlKeyboardLoader(Context context) {
        this.mContext = context;
        this.mResources = this.mContext.getResources();
    }

    public SkbTemplate loadSkbTemplate(int resourceId) {
        if (null == this.mContext || 0 == resourceId) {
            return null;
        }
        Resources r = this.mResources;
        XmlResourceParser xrp = r.getXml(resourceId);
        KeyCommonAttributes attrDef = new KeyCommonAttributes(xrp);
        KeyCommonAttributes attrKey = new KeyCommonAttributes(xrp);
        this.mSkbTemplate = new SkbTemplate(resourceId);
        int lastKeyTypeId = -1;
        int globalColor = 0;
        int globalColorHl = 0;
        int globalColorBalloon = 0;
        try {
            this.mXmlEventType = xrp.next();
            while (this.mXmlEventType != 1) {
                this.mNextEventFetched = false;
                if (this.mXmlEventType == 2) {
                    String attribute = xrp.getName();
                    if ("skb_template".compareTo(attribute) == 0) {
                        Drawable skbBg = this.getDrawable(xrp, XMLATTR_SKB_BG, null);
                        Drawable balloonBg = this.getDrawable(xrp, XMLATTR_BALLOON_BG, null);
                        Drawable popupBg = this.getDrawable(xrp, XMLATTR_POPUP_BG, null);
                        if (null == skbBg || null == balloonBg || null == popupBg) {
                            return null;
                        }
                        this.mSkbTemplate.setBackgrounds(skbBg, balloonBg, popupBg);
                        float xMargin = this.getFloat(xrp, XMLATTR_KEY_XMARGIN, 0.0f);
                        float yMargin = this.getFloat(xrp, XMLATTR_KEY_YMARGIN, 0.0f);
                        this.mSkbTemplate.setMargins(xMargin, yMargin);
                        globalColor = this.getColor(xrp, XMLATTR_COLOR, 0);
                        globalColorHl = this.getColor(xrp, XMLATTR_COLOR_HIGHLIGHT, -1);
                        globalColorBalloon = this.getColor(xrp, XMLATTR_COLOR_BALLOON, -1);
                    } else if ("key_type".compareTo(attribute) == 0) {
                        int id2 = this.getInteger(xrp, XMLATTR_ID, -1);
                        Drawable bg = this.getDrawable(xrp, XMLATTR_KEYTYPE_BG, null);
                        Drawable hlBg = this.getDrawable(xrp, XMLATTR_KEYTYPE_HLBG, null);
                        int color2 = this.getColor(xrp, XMLATTR_COLOR, globalColor);
                        int colorHl = this.getColor(xrp, XMLATTR_COLOR_HIGHLIGHT, globalColorHl);
                        int colorBalloon = this.getColor(xrp, XMLATTR_COLOR_BALLOON, globalColorBalloon);
                        if (id2 != lastKeyTypeId + 1) {
                            return null;
                        }
                        SoftKeyType keyType = this.mSkbTemplate.createKeyType(id2, bg, hlBg);
                        keyType.setColors(color2, colorHl, colorBalloon);
                        if (!this.mSkbTemplate.addKeyType(keyType)) {
                            return null;
                        }
                        lastKeyTypeId = id2;
                    } else if (XMLTAG_KEYICON.compareTo(attribute) == 0) {
                        int keyCode = this.getInteger(xrp, XMLATTR_KEY_CODE, 0);
                        Drawable icon = this.getDrawable(xrp, XMLATTR_KEY_ICON, null);
                        Drawable iconPopup = this.getDrawable(xrp, XMLATTR_KEY_ICON_POPUP, null);
                        if (null != icon && null != iconPopup) {
                            this.mSkbTemplate.addDefaultKeyIcons(keyCode, icon, iconPopup);
                        }
                    } else if (XMLTAG_KEY.compareTo(attribute) == 0) {
                        int keyId = this.getInteger(xrp, XMLATTR_ID, -1);
                        if (-1 == keyId) {
                            return null;
                        }
                        if (!attrKey.getAttributes(attrDef)) {
                            return null;
                        }
                        this.mKeyXPos = this.getFloat(xrp, XMLATTR_START_POS_X, 0.0f);
                        this.mKeyYPos = this.getFloat(xrp, XMLATTR_START_POS_Y, 0.0f);
                        SoftKey softKey = this.getSoftKey(xrp, attrKey);
                        if (null == softKey) {
                            return null;
                        }
                        this.mSkbTemplate.addDefaultKey(keyId, softKey);
                    }
                }
                if (this.mNextEventFetched) continue;
                this.mXmlEventType = xrp.next();
            }
            xrp.close();
            return this.mSkbTemplate;
        }
        catch (XmlPullParserException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    public SoftKeyboard loadKeyboard(int resourceId, int skbWidth, int skbHeight) {
        if (null == this.mContext) {
            return null;
        }
        Resources r = this.mResources;
        SkbPool skbPool = SkbPool.getInstance();
        XmlResourceParser xrp = this.mContext.getResources().getXml(resourceId);
        this.mSkbTemplate = null;
        SoftKeyboard softKeyboard = null;
        SoftKey softKey = null;
        KeyCommonAttributes attrDef = new KeyCommonAttributes(xrp);
        KeyCommonAttributes attrSkb = new KeyCommonAttributes(xrp);
        KeyCommonAttributes attrRow = new KeyCommonAttributes(xrp);
        KeyCommonAttributes attrKeys = new KeyCommonAttributes(xrp);
        KeyCommonAttributes attrKey = new KeyCommonAttributes(xrp);
        this.mKeyXPos = 0.0f;
        this.mKeyYPos = 0.0f;
        this.mSkbWidth = skbWidth;
        this.mSkbHeight = skbHeight;
        try {
            this.mKeyXMargin = 0.0f;
            this.mKeyYMargin = 0.0f;
            this.mXmlEventType = xrp.next();
            while (this.mXmlEventType != 1) {
                String attr2;
                this.mNextEventFetched = false;
                if (this.mXmlEventType == 2) {
                    attr2 = xrp.getName();
                    if (XMLTAG_KEYBOARD.compareTo(attr2) == 0) {
                        int skbTemplateId = xrp.getAttributeResourceValue(null, "skb_template", 0);
                        this.mSkbTemplate = skbPool.getSkbTemplate(skbTemplateId, this.mContext);
                        if (null == this.mSkbTemplate || !attrSkb.getAttributes(attrDef)) {
                            return null;
                        }
                        boolean cacheFlag = this.getBoolean(xrp, XMLATTR_SKB_CACHE_FLAG, DEFAULT_SKB_CACHE_FLAG);
                        boolean stickyFlag = this.getBoolean(xrp, XMLATTR_SKB_STICKY_FLAG, DEFAULT_SKB_STICKY_FLAG);
                        boolean isQwerty = this.getBoolean(xrp, XMLATTR_QWERTY, false);
                        boolean isQwertyUpperCase = this.getBoolean(xrp, XMLATTR_QWERTY_UPPERCASE, false);
                        softKeyboard = new SoftKeyboard(resourceId, this.mSkbTemplate, this.mSkbWidth, this.mSkbHeight);
                        softKeyboard.setFlags(cacheFlag, stickyFlag, isQwerty, isQwertyUpperCase);
                        this.mKeyXMargin = this.getFloat(xrp, XMLATTR_KEY_XMARGIN, this.mSkbTemplate.getXMargin());
                        this.mKeyYMargin = this.getFloat(xrp, XMLATTR_KEY_YMARGIN, this.mSkbTemplate.getYMargin());
                        Drawable skbBg = this.getDrawable(xrp, XMLATTR_SKB_BG, null);
                        Drawable popupBg = this.getDrawable(xrp, XMLATTR_POPUP_BG, null);
                        Drawable balloonBg = this.getDrawable(xrp, XMLATTR_BALLOON_BG, null);
                        if (null != skbBg) {
                            softKeyboard.setSkbBackground(skbBg);
                        }
                        if (null != popupBg) {
                            softKeyboard.setPopupBackground(popupBg);
                        }
                        if (null != balloonBg) {
                            softKeyboard.setKeyBalloonBackground(balloonBg);
                        }
                        softKeyboard.setKeyMargins(this.mKeyXMargin, this.mKeyYMargin);
                    } else if (XMLTAG_ROW.compareTo(attr2) == 0) {
                        if (!attrRow.getAttributes(attrSkb)) {
                            return null;
                        }
                        this.mKeyXPos = this.getFloat(xrp, XMLATTR_START_POS_X, 0.0f);
                        this.mKeyYPos = this.getFloat(xrp, XMLATTR_START_POS_Y, this.mKeyYPos);
                        int rowId = this.getInteger(xrp, XMLATTR_ROW_ID, -1);
                        softKeyboard.beginNewRow(rowId, this.mKeyYPos);
                    } else if (XMLTAG_KEYS.compareTo(attr2) == 0) {
                        if (null == softKeyboard) {
                            return null;
                        }
                        if (!attrKeys.getAttributes(attrRow)) {
                            return null;
                        }
                        String splitter = xrp.getAttributeValue(null, XMLATTR_KEY_SPLITTER);
                        splitter = Pattern.quote(splitter);
                        String labels = xrp.getAttributeValue(null, XMLATTR_KEY_LABELS);
                        String codes = xrp.getAttributeValue(null, XMLATTR_KEY_CODES);
                        if (null == splitter || null == labels) {
                            return null;
                        }
                        String[] labelArr = labels.split(splitter);
                        String[] codeArr = null;
                        if (null != codes && labelArr.length != (codeArr = codes.split(splitter)).length) {
                            return null;
                        }
                        for (int i = 0; i < labelArr.length; ++i) {
                            softKey = new SoftKey();
                            int keyCode = 0;
                            if (null != codeArr) {
                                keyCode = Integer.valueOf(codeArr[i]);
                            }
                            softKey.setKeyAttribute(keyCode, labelArr[i], attrKeys.repeat, attrKeys.balloon);
                            softKey.setKeyType(this.mSkbTemplate.getKeyType(attrKeys.keyType), null, null);
                            float left = this.mKeyXPos;
                            float right = left + attrKeys.keyWidth;
                            float top = this.mKeyYPos;
                            float bottom = top + attrKeys.keyHeight;
                            if (right - left < 2.0f * this.mKeyXMargin) {
                                return null;
                            }
                            if (bottom - top < 2.0f * this.mKeyYMargin) {
                                return null;
                            }
                            softKey.setKeyDimensions(left, top, right, bottom);
                            softKeyboard.addSoftKey(softKey);
                            this.mKeyXPos = right;
                            if ((int)this.mKeyXPos * this.mSkbWidth <= this.mSkbWidth) continue;
                            return null;
                        }
                    } else if (XMLTAG_KEY.compareTo(attr2) == 0) {
                        if (null == softKeyboard) {
                            return null;
                        }
                        if (!attrKey.getAttributes(attrRow)) {
                            return null;
                        }
                        int keyId = this.getInteger(xrp, XMLATTR_ID, -1);
                        softKey = keyId >= 0 ? this.mSkbTemplate.getDefaultKey(keyId) : this.getSoftKey(xrp, attrKey);
                        if (null == softKey) {
                            return null;
                        }
                        this.mKeyXPos = softKey.mRightF;
                        if ((int)this.mKeyXPos * this.mSkbWidth > this.mSkbWidth) {
                            return null;
                        }
                        if (this.mXmlEventType == 2 && XMLTAG_ROW.compareTo(attr2 = xrp.getName()) == 0) {
                            this.mKeyYPos += attrRow.keyHeight;
                            if ((int)this.mKeyYPos * this.mSkbHeight > this.mSkbHeight) {
                                return null;
                            }
                        }
                        softKeyboard.addSoftKey(softKey);
                    }
                } else if (this.mXmlEventType == 3 && XMLTAG_ROW.compareTo(attr2 = xrp.getName()) == 0) {
                    this.mKeyYPos += attrRow.keyHeight;
                    if ((int)this.mKeyYPos * this.mSkbHeight > this.mSkbHeight) {
                        return null;
                    }
                }
                if (this.mNextEventFetched) continue;
                this.mXmlEventType = xrp.next();
            }
            xrp.close();
            softKeyboard.setSkbCoreSize(this.mSkbWidth, this.mSkbHeight);
            return softKeyboard;
        }
        catch (XmlPullParserException e) {
        }
        catch (IOException e) {
            // empty catch block
        }
        return null;
    }

    private SoftKey getSoftKey(XmlResourceParser xrp, KeyCommonAttributes attrKey) throws XmlPullParserException, IOException {
        SoftKey softKey;
        int keyCode = this.getInteger(xrp, XMLATTR_KEY_CODE, 0);
        String keyLabel = this.getString(xrp, XMLATTR_KEY_LABEL, null);
        Drawable keyIcon = this.getDrawable(xrp, XMLATTR_KEY_ICON, null);
        Drawable keyIconPopup = this.getDrawable(xrp, XMLATTR_KEY_ICON_POPUP, null);
        int popupSkbId = xrp.getAttributeResourceValue(null, XMLATTR_KEY_POPUP_SKBID, 0);
        if (null == keyLabel && null == keyIcon) {
            keyIcon = this.mSkbTemplate.getDefaultKeyIcon(keyCode);
            keyIconPopup = this.mSkbTemplate.getDefaultKeyIconPopup(keyCode);
            if (null == keyIcon || null == keyIconPopup) {
                return null;
            }
        }
        float left = this.mKeyXPos;
        float right = left + attrKey.keyWidth;
        float top = this.mKeyYPos;
        float bottom = top + attrKey.keyHeight;
        if (right - left < 2.0f * this.mKeyXMargin) {
            return null;
        }
        if (bottom - top < 2.0f * this.mKeyYMargin) {
            return null;
        }
        boolean toggleKey = false;
        this.mXmlEventType = xrp.next();
        this.mNextEventFetched = true;
        if (this.mXmlEventType == 2) {
            this.mAttrTmp = xrp.getName();
            if (this.mAttrTmp.compareTo(XMLTAG_TOGGLE_STATE) == 0) {
                toggleKey = true;
            }
        }
        if (toggleKey) {
            softKey = new SoftKeyToggle();
            if (!((SoftKeyToggle)softKey).setToggleStates(this.getToggleStates(attrKey, (SoftKeyToggle)softKey, keyCode))) {
                return null;
            }
        } else {
            softKey = new SoftKey();
        }
        softKey.setKeyAttribute(keyCode, keyLabel, attrKey.repeat, attrKey.balloon);
        softKey.setPopupSkbId(popupSkbId);
        softKey.setKeyType(this.mSkbTemplate.getKeyType(attrKey.keyType), keyIcon, keyIconPopup);
        softKey.setKeyDimensions(left, top, right, bottom);
        return softKey;
    }

    private SoftKeyToggle.ToggleState getToggleStates(KeyCommonAttributes attrKey, SoftKeyToggle softKey, int defKeyCode) throws XmlPullParserException, IOException {
        String attr2;
        XmlResourceParser xrp = attrKey.mXrp;
        int stateId = this.getInteger(xrp, XMLATTR_TOGGLE_STATE_ID, 0);
        if (0 == stateId) {
            return null;
        }
        String keyLabel = this.getString(xrp, XMLATTR_KEY_LABEL, null);
        int keyTypeId = this.getInteger(xrp, "key_type", -1);
        int keyCode = null == keyLabel ? this.getInteger(xrp, XMLATTR_KEY_CODE, defKeyCode) : this.getInteger(xrp, XMLATTR_KEY_CODE, 0);
        Drawable icon = this.getDrawable(xrp, XMLATTR_KEY_ICON, null);
        Drawable iconPopup = this.getDrawable(xrp, XMLATTR_KEY_ICON_POPUP, null);
        if (null == icon && null == keyLabel) {
            return null;
        }
        SoftKeyToggle.ToggleState rootState = softKey.createToggleState();
        rootState.setStateId(stateId);
        rootState.mKeyType = null;
        if (-1 != keyTypeId) {
            rootState.mKeyType = this.mSkbTemplate.getKeyType(keyTypeId);
        }
        rootState.mKeyCode = keyCode;
        rootState.mKeyIcon = icon;
        rootState.mKeyIconPopup = iconPopup;
        rootState.mKeyLabel = keyLabel;
        boolean repeat = this.getBoolean(xrp, XMLATTR_KEY_REPEAT, attrKey.repeat);
        boolean balloon = this.getBoolean(xrp, XMLATTR_KEY_BALLOON, attrKey.balloon);
        rootState.setStateFlags(repeat, balloon);
        rootState.mNextState = null;
        this.mXmlEventType = xrp.next();
        while (this.mXmlEventType != 2 && this.mXmlEventType != 1) {
            this.mXmlEventType = xrp.next();
        }
        if (this.mXmlEventType == 2 && (attr2 = xrp.getName()).compareTo(XMLTAG_TOGGLE_STATE) == 0) {
            SoftKeyToggle.ToggleState nextState = this.getToggleStates(attrKey, softKey, defKeyCode);
            if (null == nextState) {
                return null;
            }
            rootState.mNextState = nextState;
        }
        return rootState;
    }

    private int getInteger(XmlResourceParser xrp, String name, int defValue) {
        int resId = xrp.getAttributeResourceValue(null, name, 0);
        if (resId == 0) {
            String s = xrp.getAttributeValue(null, name);
            if (null == s) {
                return defValue;
            }
            try {
                int ret = Integer.valueOf(s);
                return ret;
            }
            catch (NumberFormatException e) {
                return defValue;
            }
        }
        return Integer.parseInt(this.mContext.getResources().getString(resId));
    }

    private int getColor(XmlResourceParser xrp, String name, int defValue) {
        int resId = xrp.getAttributeResourceValue(null, name, 0);
        if (resId == 0) {
            String s = xrp.getAttributeValue(null, name);
            if (null == s) {
                return defValue;
            }
            try {
                int ret = Integer.valueOf(s);
                return ret;
            }
            catch (NumberFormatException e) {
                return defValue;
            }
        }
        return this.mContext.getResources().getColor(resId);
    }

    private String getString(XmlResourceParser xrp, String name, String defValue) {
        int resId = xrp.getAttributeResourceValue(null, name, 0);
        if (resId == 0) {
            return xrp.getAttributeValue(null, name);
        }
        return this.mContext.getResources().getString(resId);
    }

    private float getFloat(XmlResourceParser xrp, String name, float defValue) {
        int resId = xrp.getAttributeResourceValue(null, name, 0);
        if (resId == 0) {
            String s = xrp.getAttributeValue(null, name);
            if (null == s) {
                return defValue;
            }
            try {
                float ret = s.endsWith("%p") ? Float.parseFloat(s.substring(0, s.length() - 2)) / 100.0f : Float.parseFloat(s);
                return ret;
            }
            catch (NumberFormatException e) {
                return defValue;
            }
        }
        return this.mContext.getResources().getDimension(resId);
    }

    private boolean getBoolean(XmlResourceParser xrp, String name, boolean defValue) {
        String s = xrp.getAttributeValue(null, name);
        if (null == s) {
            return defValue;
        }
        try {
            boolean ret = Boolean.parseBoolean(s);
            return ret;
        }
        catch (NumberFormatException e) {
            return defValue;
        }
    }

    private Drawable getDrawable(XmlResourceParser xrp, String name, Drawable defValue) {
        int resId = xrp.getAttributeResourceValue(null, name, 0);
        if (0 == resId) {
            return defValue;
        }
        return this.mResources.getDrawable(resId);
    }

    class KeyCommonAttributes {
        XmlResourceParser mXrp;
        int keyType;
        float keyWidth;
        float keyHeight;
        boolean repeat;
        boolean balloon;

        KeyCommonAttributes(XmlResourceParser xrp) {
            this.mXrp = xrp;
            this.balloon = true;
        }

        boolean getAttributes(KeyCommonAttributes defAttr) {
            this.keyType = XmlKeyboardLoader.this.getInteger(this.mXrp, "key_type", defAttr.keyType);
            this.keyWidth = XmlKeyboardLoader.this.getFloat(this.mXrp, XmlKeyboardLoader.XMLATTR_KEY_WIDTH, defAttr.keyWidth);
            this.keyHeight = XmlKeyboardLoader.this.getFloat(this.mXrp, XmlKeyboardLoader.XMLATTR_KEY_HEIGHT, defAttr.keyHeight);
            this.repeat = XmlKeyboardLoader.this.getBoolean(this.mXrp, XmlKeyboardLoader.XMLATTR_KEY_REPEAT, defAttr.repeat);
            this.balloon = XmlKeyboardLoader.this.getBoolean(this.mXrp, XmlKeyboardLoader.XMLATTR_KEY_BALLOON, defAttr.balloon);
            return this.keyType >= 0 && !(this.keyWidth <= 0.0f) && !(this.keyHeight <= 0.0f);
        }
    }
}

