/*
 * Decompiled with CFR 0.152.
 */
package com.android.inputmethod.pinyin;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import android.os.Vibrator;
import android.util.AttributeSet;
import android.view.View;
import com.android.inputmethod.pinyin.BalloonHint;
import com.android.inputmethod.pinyin.Environment;
import com.android.inputmethod.pinyin.Settings;
import com.android.inputmethod.pinyin.SkbContainer;
import com.android.inputmethod.pinyin.SoftKey;
import com.android.inputmethod.pinyin.SoftKeyboard;
import com.android.inputmethod.pinyin.SoundManager;
import java.util.List;

public class SoftKeyboardView
extends View {
    private SoftKeyboard mSoftKeyboard;
    private BalloonHint mBalloonPopup;
    private BalloonHint mBalloonOnKey;
    private SoundManager mSoundManager;
    private SoftKey mSoftKeyDown;
    private boolean mKeyPressed = false;
    private int[] mOffsetToSkbContainer = new int[2];
    private int[] mHintLocationToSkbContainer = new int[2];
    private int mNormalKeyTextSize;
    private int mFunctionKeyTextSize;
    private SkbContainer.LongPressTimer mLongPressTimer;
    private boolean mRepeatForLongPress = false;
    private boolean mMovingNeverHidePopupBalloon = false;
    private Vibrator mVibrator;
    protected long[] mVibratePattern = new long[]{1L, 20L};
    private Rect mDirtyRect = new Rect();
    private Paint mPaint;
    private Paint.FontMetricsInt mFmi;
    private boolean mDimSkb;

    public SoftKeyboardView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mSoundManager = SoundManager.getInstance(this.mContext);
        this.mPaint = new Paint();
        this.mPaint.setAntiAlias(true);
        this.mFmi = this.mPaint.getFontMetricsInt();
    }

    public boolean setSoftKeyboard(SoftKeyboard softSkb) {
        if (null == softSkb) {
            return false;
        }
        this.mSoftKeyboard = softSkb;
        Drawable bg = softSkb.getSkbBackground();
        if (null != bg) {
            this.setBackgroundDrawable(bg);
        }
        return true;
    }

    public SoftKeyboard getSoftKeyboard() {
        return this.mSoftKeyboard;
    }

    public void resizeKeyboard(int skbWidth, int skbHeight) {
        this.mSoftKeyboard.setSkbCoreSize(skbWidth, skbHeight);
    }

    public void setBalloonHint(BalloonHint balloonOnKey, BalloonHint balloonPopup, boolean movingNeverHidePopup) {
        this.mBalloonOnKey = balloonOnKey;
        this.mBalloonPopup = balloonPopup;
        this.mMovingNeverHidePopupBalloon = movingNeverHidePopup;
    }

    public void setOffsetToSkbContainer(int[] offsetToSkbContainer) {
        this.mOffsetToSkbContainer[0] = offsetToSkbContainer[0];
        this.mOffsetToSkbContainer[1] = offsetToSkbContainer[1];
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int measuredWidth = 0;
        int measuredHeight = 0;
        if (null != this.mSoftKeyboard) {
            measuredWidth = this.mSoftKeyboard.getSkbCoreWidth();
            measuredHeight = this.mSoftKeyboard.getSkbCoreHeight();
            measuredWidth += this.mPaddingLeft + this.mPaddingRight;
            measuredHeight += this.mPaddingTop + this.mPaddingBottom;
        }
        this.setMeasuredDimension(measuredWidth, measuredHeight);
    }

    private void showBalloon(BalloonHint balloon, int[] balloonLocationToSkb, boolean movePress) {
        long delay = 0L;
        if (movePress) {
            delay = 0L;
        }
        if (balloon.needForceDismiss()) {
            balloon.delayedDismiss(0L);
        }
        if (!balloon.isShowing()) {
            balloon.delayedShow(delay, balloonLocationToSkb);
        } else {
            balloon.delayedUpdate(delay, balloonLocationToSkb, balloon.getWidth(), balloon.getHeight());
        }
        long b = System.currentTimeMillis();
    }

    public void resetKeyPress(long balloonDelay) {
        if (!this.mKeyPressed) {
            return;
        }
        this.mKeyPressed = false;
        if (null != this.mBalloonOnKey) {
            this.mBalloonOnKey.delayedDismiss(balloonDelay);
        } else if (null != this.mSoftKeyDown) {
            if (this.mDirtyRect.isEmpty()) {
                this.mDirtyRect.set(this.mSoftKeyDown.mLeft, this.mSoftKeyDown.mTop, this.mSoftKeyDown.mRight, this.mSoftKeyDown.mBottom);
            }
            this.invalidate(this.mDirtyRect);
        } else {
            this.invalidate();
        }
        this.mBalloonPopup.delayedDismiss(balloonDelay);
    }

    public SoftKey onKeyPress(int x, int y, SkbContainer.LongPressTimer longPressTimer, boolean movePress) {
        float textSize;
        int desired_height;
        this.mKeyPressed = false;
        boolean moveWithinPreviousKey = false;
        if (movePress) {
            SoftKey newKey = this.mSoftKeyboard.mapToKey(x, y);
            if (newKey == this.mSoftKeyDown) {
                moveWithinPreviousKey = true;
            }
            this.mSoftKeyDown = newKey;
        } else {
            this.mSoftKeyDown = this.mSoftKeyboard.mapToKey(x, y);
        }
        if (moveWithinPreviousKey || null == this.mSoftKeyDown) {
            return this.mSoftKeyDown;
        }
        this.mKeyPressed = true;
        if (!movePress) {
            this.tryPlayKeyDown();
            this.tryVibrate();
        }
        this.mLongPressTimer = longPressTimer;
        if (!movePress) {
            if (this.mSoftKeyDown.getPopupResId() > 0 || this.mSoftKeyDown.repeatable()) {
                this.mLongPressTimer.startTimer();
            }
        } else {
            this.mLongPressTimer.removeTimer();
        }
        Environment env = Environment.getInstance();
        if (null != this.mBalloonOnKey) {
            Drawable keyHlBg = this.mSoftKeyDown.getKeyHlBg();
            this.mBalloonOnKey.setBalloonBackground(keyHlBg);
            int keyXMargin = this.mSoftKeyboard.getKeyXMargin();
            int keyYMargin = this.mSoftKeyboard.getKeyYMargin();
            int desired_width = this.mSoftKeyDown.width() - 2 * keyXMargin;
            desired_height = this.mSoftKeyDown.height() - 2 * keyYMargin;
            textSize = env.getKeyTextSize(0 != this.mSoftKeyDown.mKeyType.mKeyTypeId);
            Drawable icon = this.mSoftKeyDown.getKeyIcon();
            if (null != icon) {
                this.mBalloonOnKey.setBalloonConfig(icon, desired_width, desired_height);
            } else {
                this.mBalloonOnKey.setBalloonConfig(this.mSoftKeyDown.getKeyLabel(), textSize, true, this.mSoftKeyDown.getColorHl(), desired_width, desired_height);
            }
            this.mHintLocationToSkbContainer[0] = this.mPaddingLeft + this.mSoftKeyDown.mLeft - (this.mBalloonOnKey.getWidth() - this.mSoftKeyDown.width()) / 2;
            this.mHintLocationToSkbContainer[0] = this.mHintLocationToSkbContainer[0] + this.mOffsetToSkbContainer[0];
            this.mHintLocationToSkbContainer[1] = this.mPaddingTop + (this.mSoftKeyDown.mBottom - keyYMargin) - this.mBalloonOnKey.getHeight();
            this.mHintLocationToSkbContainer[1] = this.mHintLocationToSkbContainer[1] + this.mOffsetToSkbContainer[1];
            this.showBalloon(this.mBalloonOnKey, this.mHintLocationToSkbContainer, movePress);
        } else {
            this.mDirtyRect.union(this.mSoftKeyDown.mLeft, this.mSoftKeyDown.mTop, this.mSoftKeyDown.mRight, this.mSoftKeyDown.mBottom);
            this.invalidate(this.mDirtyRect);
        }
        if (this.mSoftKeyDown.needBalloon()) {
            Drawable balloonBg = this.mSoftKeyboard.getBalloonBackground();
            this.mBalloonPopup.setBalloonBackground(balloonBg);
            int desired_width = this.mSoftKeyDown.width() + env.getKeyBalloonWidthPlus();
            desired_height = this.mSoftKeyDown.height() + env.getKeyBalloonHeightPlus();
            textSize = env.getBalloonTextSize(0 != this.mSoftKeyDown.mKeyType.mKeyTypeId);
            Drawable iconPopup = this.mSoftKeyDown.getKeyIconPopup();
            if (null != iconPopup) {
                this.mBalloonPopup.setBalloonConfig(iconPopup, desired_width, desired_height);
            } else {
                this.mBalloonPopup.setBalloonConfig(this.mSoftKeyDown.getKeyLabel(), textSize, this.mSoftKeyDown.needBalloon(), this.mSoftKeyDown.getColorBalloon(), desired_width, desired_height);
            }
            this.mHintLocationToSkbContainer[0] = this.mPaddingLeft + this.mSoftKeyDown.mLeft + -(this.mBalloonPopup.getWidth() - this.mSoftKeyDown.width()) / 2;
            this.mHintLocationToSkbContainer[0] = this.mHintLocationToSkbContainer[0] + this.mOffsetToSkbContainer[0];
            this.mHintLocationToSkbContainer[1] = this.mPaddingTop + this.mSoftKeyDown.mTop - this.mBalloonPopup.getHeight();
            this.mHintLocationToSkbContainer[1] = this.mHintLocationToSkbContainer[1] + this.mOffsetToSkbContainer[1];
            this.showBalloon(this.mBalloonPopup, this.mHintLocationToSkbContainer, movePress);
        } else {
            this.mBalloonPopup.delayedDismiss(0L);
        }
        if (this.mRepeatForLongPress) {
            longPressTimer.startTimer();
        }
        return this.mSoftKeyDown;
    }

    public SoftKey onKeyRelease(int x, int y) {
        this.mKeyPressed = false;
        if (null == this.mSoftKeyDown) {
            return null;
        }
        this.mLongPressTimer.removeTimer();
        if (null != this.mBalloonOnKey) {
            this.mBalloonOnKey.delayedDismiss(200L);
        } else {
            this.mDirtyRect.union(this.mSoftKeyDown.mLeft, this.mSoftKeyDown.mTop, this.mSoftKeyDown.mRight, this.mSoftKeyDown.mBottom);
            this.invalidate(this.mDirtyRect);
        }
        if (this.mSoftKeyDown.needBalloon()) {
            this.mBalloonPopup.delayedDismiss(200L);
        }
        if (this.mSoftKeyDown.moveWithinKey(x - this.mPaddingLeft, y - this.mPaddingTop)) {
            return this.mSoftKeyDown;
        }
        return null;
    }

    public SoftKey onKeyMove(int x, int y) {
        if (null == this.mSoftKeyDown) {
            return null;
        }
        if (this.mSoftKeyDown.moveWithinKey(x - this.mPaddingLeft, y - this.mPaddingTop)) {
            return this.mSoftKeyDown;
        }
        this.mDirtyRect.union(this.mSoftKeyDown.mLeft, this.mSoftKeyDown.mTop, this.mSoftKeyDown.mRight, this.mSoftKeyDown.mBottom);
        if (this.mRepeatForLongPress) {
            if (this.mMovingNeverHidePopupBalloon) {
                return this.onKeyPress(x, y, this.mLongPressTimer, true);
            }
            if (null != this.mBalloonOnKey) {
                this.mBalloonOnKey.delayedDismiss(0L);
            } else {
                this.invalidate(this.mDirtyRect);
            }
            if (this.mSoftKeyDown.needBalloon()) {
                this.mBalloonPopup.delayedDismiss(0L);
            }
            if (null != this.mLongPressTimer) {
                this.mLongPressTimer.removeTimer();
            }
            return this.onKeyPress(x, y, this.mLongPressTimer, true);
        }
        return this.onKeyPress(x, y, this.mLongPressTimer, true);
    }

    private void tryVibrate() {
        if (!Settings.getVibrate()) {
            return;
        }
        if (this.mVibrator == null) {
            this.mVibrator = new Vibrator();
        }
        this.mVibrator.vibrate(this.mVibratePattern, -1);
    }

    private void tryPlayKeyDown() {
        if (Settings.getKeySound()) {
            this.mSoundManager.playKeyDown();
        }
    }

    public void dimSoftKeyboard(boolean dimSkb) {
        this.mDimSkb = dimSkb;
        this.invalidate();
    }

    protected void onDraw(Canvas canvas) {
        if (null == this.mSoftKeyboard) {
            return;
        }
        canvas.translate((float)this.mPaddingLeft, (float)this.mPaddingTop);
        Environment env = Environment.getInstance();
        this.mNormalKeyTextSize = env.getKeyTextSize(false);
        this.mFunctionKeyTextSize = env.getKeyTextSize(true);
        int rowNum = this.mSoftKeyboard.getRowNum();
        int keyXMargin = this.mSoftKeyboard.getKeyXMargin();
        int keyYMargin = this.mSoftKeyboard.getKeyYMargin();
        for (int row = 0; row < rowNum; ++row) {
            SoftKeyboard.KeyRow keyRow = this.mSoftKeyboard.getKeyRowForDisplay(row);
            if (null == keyRow) continue;
            List<SoftKey> softKeys = keyRow.mSoftKeys;
            int keyNum = softKeys.size();
            for (int i = 0; i < keyNum; ++i) {
                SoftKey softKey = softKeys.get(i);
                if (0 == softKey.mKeyType.mKeyTypeId) {
                    this.mPaint.setTextSize((float)this.mNormalKeyTextSize);
                } else {
                    this.mPaint.setTextSize((float)this.mFunctionKeyTextSize);
                }
                this.drawSoftKey(canvas, softKey, keyXMargin, keyYMargin);
            }
        }
        if (this.mDimSkb) {
            this.mPaint.setColor(-1610612736);
            canvas.drawRect(0.0f, 0.0f, (float)this.getWidth(), (float)this.getHeight(), this.mPaint);
        }
        this.mDirtyRect.setEmpty();
    }

    private void drawSoftKey(Canvas canvas, SoftKey softKey, int keyXMargin, int keyYMargin) {
        int textColor;
        Drawable bg;
        if (this.mKeyPressed && softKey == this.mSoftKeyDown) {
            bg = softKey.getKeyHlBg();
            textColor = softKey.getColorHl();
        } else {
            bg = softKey.getKeyBg();
            textColor = softKey.getColor();
        }
        if (null != bg) {
            bg.setBounds(softKey.mLeft + keyXMargin, softKey.mTop + keyYMargin, softKey.mRight - keyXMargin, softKey.mBottom - keyYMargin);
            bg.draw(canvas);
        }
        String keyLabel = softKey.getKeyLabel();
        Drawable keyIcon = softKey.getKeyIcon();
        if (null != keyIcon) {
            Drawable icon = keyIcon;
            int marginLeft = (softKey.width() - icon.getIntrinsicWidth()) / 2;
            int marginRight = softKey.width() - icon.getIntrinsicWidth() - marginLeft;
            int marginTop = (softKey.height() - icon.getIntrinsicHeight()) / 2;
            int marginBottom = softKey.height() - icon.getIntrinsicHeight() - marginTop;
            icon.setBounds(softKey.mLeft + marginLeft, softKey.mTop + marginTop, softKey.mRight - marginRight, softKey.mBottom - marginBottom);
            icon.draw(canvas);
        } else if (null != keyLabel) {
            this.mPaint.setColor(textColor);
            float x = (float)softKey.mLeft + ((float)softKey.width() - this.mPaint.measureText(keyLabel)) / 2.0f;
            int fontHeight = this.mFmi.bottom - this.mFmi.top;
            float marginY = (float)(softKey.height() - fontHeight) / 2.0f;
            float y = (float)softKey.mTop + marginY - (float)this.mFmi.top + (float)this.mFmi.bottom / 1.5f;
            canvas.drawText(keyLabel, x, y + 1.0f, this.mPaint);
        }
    }
}

