/*
 * Decompiled with CFR 0.152.
 */
package com.android.inputmethod.pinyin;

import android.graphics.drawable.Drawable;
import com.android.inputmethod.pinyin.SoftKey;
import com.android.inputmethod.pinyin.SoftKeyType;

public class SoftKeyToggle
extends SoftKey {
    private static final int KEYMASK_TOGGLE_STATE = 255;
    private ToggleState mToggleState;

    public int getToggleStateId() {
        return this.mKeyMask & 0xFF;
    }

    public boolean enableToggleState(int stateId, boolean resetIfNotFound) {
        int oldStateId = this.mKeyMask & 0xFF;
        if (oldStateId == stateId) {
            return false;
        }
        this.mKeyMask &= 0xFFFFFF00;
        if (stateId > 0) {
            this.mKeyMask |= 0xFF & stateId;
            if (this.getToggleState() == null) {
                this.mKeyMask &= 0xFFFFFF00;
                if (!resetIfNotFound && oldStateId > 0) {
                    this.mKeyMask |= 0xFF & oldStateId;
                }
                return resetIfNotFound;
            }
            return true;
        }
        return true;
    }

    public boolean disableToggleState(int stateId, boolean resetIfNotFound) {
        int oldStateId = this.mKeyMask & 0xFF;
        if (oldStateId == stateId) {
            this.mKeyMask &= 0xFFFFFF00;
            return stateId != 0;
        }
        if (resetIfNotFound) {
            this.mKeyMask &= 0xFFFFFF00;
            return oldStateId != 0;
        }
        return false;
    }

    public boolean disableAllToggleStates() {
        int oldStateId = this.mKeyMask & 0xFF;
        this.mKeyMask &= 0xFFFFFF00;
        return oldStateId != 0;
    }

    public Drawable getKeyIcon() {
        ToggleState state = this.getToggleState();
        if (null != state) {
            return state.mKeyIcon;
        }
        return super.getKeyIcon();
    }

    public Drawable getKeyIconPopup() {
        ToggleState state = this.getToggleState();
        if (null != state) {
            if (null != state.mKeyIconPopup) {
                return state.mKeyIconPopup;
            }
            return state.mKeyIcon;
        }
        return super.getKeyIconPopup();
    }

    public int getKeyCode() {
        ToggleState state = this.getToggleState();
        if (null != state) {
            return state.mKeyCode;
        }
        return this.mKeyCode;
    }

    public String getKeyLabel() {
        ToggleState state = this.getToggleState();
        if (null != state) {
            return state.mKeyLabel;
        }
        return this.mKeyLabel;
    }

    public Drawable getKeyBg() {
        ToggleState state = this.getToggleState();
        if (null != state && null != state.mKeyType) {
            return state.mKeyType.mKeyBg;
        }
        return this.mKeyType.mKeyBg;
    }

    public Drawable getKeyHlBg() {
        ToggleState state = this.getToggleState();
        if (null != state && null != state.mKeyType) {
            return state.mKeyType.mKeyHlBg;
        }
        return this.mKeyType.mKeyHlBg;
    }

    public int getColor() {
        ToggleState state = this.getToggleState();
        if (null != state && null != state.mKeyType) {
            return state.mKeyType.mColor;
        }
        return this.mKeyType.mColor;
    }

    public int getColorHl() {
        ToggleState state = this.getToggleState();
        if (null != state && null != state.mKeyType) {
            return state.mKeyType.mColorHl;
        }
        return this.mKeyType.mColorHl;
    }

    public int getColorBalloon() {
        ToggleState state = this.getToggleState();
        if (null != state && null != state.mKeyType) {
            return state.mKeyType.mColorBalloon;
        }
        return this.mKeyType.mColorBalloon;
    }

    public boolean isKeyCodeKey() {
        ToggleState state = this.getToggleState();
        if (null != state) {
            return state.mKeyCode > 0;
        }
        return super.isKeyCodeKey();
    }

    public boolean isUserDefKey() {
        ToggleState state = this.getToggleState();
        if (null != state) {
            return state.mKeyCode < 0;
        }
        return super.isUserDefKey();
    }

    public boolean isUniStrKey() {
        ToggleState state = this.getToggleState();
        if (null != state) {
            return null != state.mKeyLabel && state.mKeyCode == 0;
        }
        return super.isUniStrKey();
    }

    public boolean needBalloon() {
        ToggleState state = this.getToggleState();
        if (null != state) {
            return (state.mIdAndFlags & 0x20000000) != 0;
        }
        return super.needBalloon();
    }

    public boolean repeatable() {
        ToggleState state = this.getToggleState();
        if (null != state) {
            return (state.mIdAndFlags & 0x10000000) != 0;
        }
        return super.repeatable();
    }

    public void changeCase(boolean lowerCase) {
        ToggleState state = this.getToggleState();
        if (null != state && null != state.mKeyLabel) {
            state.mKeyLabel = lowerCase ? state.mKeyLabel.toLowerCase() : state.mKeyLabel.toUpperCase();
        }
    }

    public ToggleState createToggleState() {
        return new ToggleState();
    }

    public boolean setToggleStates(ToggleState rootState) {
        if (null == rootState) {
            return false;
        }
        this.mToggleState = rootState;
        return true;
    }

    private ToggleState getToggleState() {
        int stateId = this.mKeyMask & 0xFF;
        if (0 == stateId) {
            return null;
        }
        ToggleState state = this.mToggleState;
        while (null != state && (state.mIdAndFlags & 0xFF) != stateId) {
            state = state.mNextState;
        }
        return state;
    }

    public class ToggleState {
        private int mIdAndFlags;
        public SoftKeyType mKeyType;
        public int mKeyCode;
        public Drawable mKeyIcon;
        public Drawable mKeyIconPopup;
        public String mKeyLabel;
        public ToggleState mNextState;

        public void setStateId(int stateId) {
            this.mIdAndFlags |= stateId & 0xFF;
        }

        public void setStateFlags(boolean repeat, boolean balloon) {
            this.mIdAndFlags = repeat ? (this.mIdAndFlags |= 0x10000000) : (this.mIdAndFlags &= 0xEFFFFFFF);
            this.mIdAndFlags = balloon ? (this.mIdAndFlags |= 0x20000000) : (this.mIdAndFlags &= 0xDFFFFFFF);
        }
    }
}

