/*
 * Decompiled with CFR 0.152.
 */
package com.android.inputmethod.pinyin;

import android.content.Context;
import com.android.inputmethod.pinyin.SkbTemplate;
import com.android.inputmethod.pinyin.SoftKeyboard;
import com.android.inputmethod.pinyin.XmlKeyboardLoader;
import java.util.Vector;

public class SkbPool {
    private static SkbPool mInstance = null;
    private Vector<SkbTemplate> mSkbTemplates = new Vector();
    private Vector<SoftKeyboard> mSoftKeyboards = new Vector();

    private SkbPool() {
    }

    public static SkbPool getInstance() {
        if (null == mInstance) {
            mInstance = new SkbPool();
        }
        return mInstance;
    }

    public void resetCachedSkb() {
        this.mSoftKeyboards.clear();
    }

    public SkbTemplate getSkbTemplate(int skbTemplateId, Context context) {
        XmlKeyboardLoader xkbl;
        SkbTemplate t;
        for (int i = 0; i < this.mSkbTemplates.size(); ++i) {
            t = this.mSkbTemplates.elementAt(i);
            if (t.getSkbTemplateId() != skbTemplateId) continue;
            return t;
        }
        if (null != context && null != (t = (xkbl = new XmlKeyboardLoader(context)).loadSkbTemplate(skbTemplateId))) {
            this.mSkbTemplates.add(t);
            return t;
        }
        return null;
    }

    public SoftKeyboard getSoftKeyboard(int skbCacheId, int skbXmlId, int skbWidth, int skbHeight, Context context) {
        SoftKeyboard skb;
        for (int i = 0; i < this.mSoftKeyboards.size(); ++i) {
            skb = this.mSoftKeyboards.elementAt(i);
            if (skb.getCacheId() != skbCacheId || skb.getSkbXmlId() != skbXmlId) continue;
            skb.setSkbCoreSize(skbWidth, skbHeight);
            skb.setNewlyLoadedFlag(false);
            return skb;
        }
        if (null != context) {
            XmlKeyboardLoader xkbl = new XmlKeyboardLoader(context);
            skb = xkbl.loadKeyboard(skbXmlId, skbWidth, skbHeight);
            if (skb != null && skb.getCacheFlag()) {
                skb.setCacheId(skbCacheId);
                this.mSoftKeyboards.add(skb);
            }
            return skb;
        }
        return null;
    }
}

