/*
 * Decompiled with CFR 0.152.
 */
package com.android.inputmethod.pinyin;

import android.content.Context;
import android.content.res.Resources;
import android.inputmethodservice.InputMethodService;
import android.os.Handler;
import android.os.SystemClock;
import android.os.SystemProperties;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.widget.PopupWindow;
import android.widget.RelativeLayout;
import android.widget.ViewFlipper;
import com.android.inputmethod.pinyin.BalloonHint;
import com.android.inputmethod.pinyin.Environment;
import com.android.inputmethod.pinyin.InputModeSwitcher;
import com.android.inputmethod.pinyin.PinyinIME;
import com.android.inputmethod.pinyin.SkbPool;
import com.android.inputmethod.pinyin.SoftKey;
import com.android.inputmethod.pinyin.SoftKeyboard;
import com.android.inputmethod.pinyin.SoftKeyboardView;

public class SkbContainer
extends RelativeLayout
implements View.OnTouchListener {
    private static final int Y_BIAS_CORRECTION = -10;
    private static final int MOVE_TOLERANCE = 6;
    private static boolean POPUPWINDOW_FOR_PRESSED_UI = false;
    private int mSkbLayout = 0;
    private InputMethodService mService;
    private InputModeSwitcher mInputModeSwitcher;
    private GestureDetector mGestureDetector;
    private Environment mEnvironment;
    private ViewFlipper mSkbFlipper;
    private BalloonHint mBalloonPopup;
    private BalloonHint mBalloonOnKey = null;
    private SoftKeyboardView mMajorView;
    private boolean mLastCandidatesShowing;
    private boolean mPopupSkbShow = false;
    private boolean mPopupSkbNoResponse = false;
    private PopupWindow mPopupSkb;
    private SoftKeyboardView mPopupSkbView;
    private int mPopupX;
    private int mPopupY;
    private volatile boolean mWaitForTouchUp = false;
    private volatile boolean mDiscardEvent = false;
    private int mYBiasCorrection = 0;
    private int mXLast;
    private int mYLast;
    private SoftKeyboardView mSkv;
    private int[] mSkvPosInContainer = new int[2];
    private SoftKey mSoftKeyDown = null;
    private LongPressTimer mLongPressTimer;
    private int[] mXyPosTmp = new int[2];

    public SkbContainer(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mEnvironment = Environment.getInstance();
        this.mLongPressTimer = new LongPressTimer(this);
        this.mYBiasCorrection = "1".equals(SystemProperties.get((String)"ro.kernel.qemu")) ? 0 : -10;
        this.mBalloonPopup = new BalloonHint(context, (View)this, Integer.MIN_VALUE);
        if (POPUPWINDOW_FOR_PRESSED_UI) {
            this.mBalloonOnKey = new BalloonHint(context, (View)this, Integer.MIN_VALUE);
        }
        this.mPopupSkb = new PopupWindow(this.mContext);
        this.mPopupSkb.setBackgroundDrawable(null);
        this.mPopupSkb.setClippingEnabled(false);
    }

    public void setService(InputMethodService service) {
        this.mService = service;
    }

    public void setInputModeSwitcher(InputModeSwitcher inputModeSwitcher) {
        this.mInputModeSwitcher = inputModeSwitcher;
    }

    public void setGestureDetector(GestureDetector gestureDetector) {
        this.mGestureDetector = gestureDetector;
    }

    public boolean isCurrentSkbSticky() {
        if (null == this.mMajorView) {
            return true;
        }
        SoftKeyboard skb = this.mMajorView.getSoftKeyboard();
        if (null != skb) {
            return skb.getStickyFlag();
        }
        return true;
    }

    public void toggleCandidateMode(boolean candidatesShowing) {
        if (null == this.mMajorView || !this.mInputModeSwitcher.isChineseText() || this.mLastCandidatesShowing == candidatesShowing) {
            return;
        }
        this.mLastCandidatesShowing = candidatesShowing;
        SoftKeyboard skb = this.mMajorView.getSoftKeyboard();
        if (null == skb) {
            return;
        }
        int state = this.mInputModeSwitcher.getTooggleStateForCnCand();
        if (!candidatesShowing) {
            skb.disableToggleState(state, false);
            skb.enableToggleStates(this.mInputModeSwitcher.getToggleStates());
        } else {
            skb.enableToggleState(state, false);
        }
        this.mMajorView.invalidate();
    }

    public void updateInputMode() {
        int skbLayout = this.mInputModeSwitcher.getSkbLayout();
        if (this.mSkbLayout != skbLayout) {
            this.mSkbLayout = skbLayout;
            this.updateSkbLayout();
        }
        this.mLastCandidatesShowing = false;
        if (null == this.mMajorView) {
            return;
        }
        SoftKeyboard skb = this.mMajorView.getSoftKeyboard();
        if (null == skb) {
            return;
        }
        skb.enableToggleStates(this.mInputModeSwitcher.getToggleStates());
        this.invalidate();
    }

    private void updateSkbLayout() {
        int screenWidth = this.mEnvironment.getScreenWidth();
        int keyHeight = this.mEnvironment.getKeyHeight();
        int skbHeight = this.mEnvironment.getSkbHeight();
        Resources r = this.mContext.getResources();
        if (null == this.mSkbFlipper) {
            this.mSkbFlipper = (ViewFlipper)this.findViewById(2131361800);
        }
        this.mMajorView = (SoftKeyboardView)this.mSkbFlipper.getChildAt(0);
        SoftKeyboard majorSkb = null;
        SkbPool skbPool = SkbPool.getInstance();
        switch (this.mSkbLayout) {
            case 2130968579: {
                majorSkb = skbPool.getSoftKeyboard(2130968579, 2130968579, screenWidth, skbHeight, this.mContext);
                break;
            }
            case 2130968581: {
                majorSkb = skbPool.getSoftKeyboard(2130968581, 2130968581, screenWidth, skbHeight, this.mContext);
                break;
            }
            case 2130968582: {
                majorSkb = skbPool.getSoftKeyboard(2130968582, 2130968582, screenWidth, skbHeight, this.mContext);
                break;
            }
            case 2130968580: {
                majorSkb = skbPool.getSoftKeyboard(2130968580, 2130968580, screenWidth, skbHeight, this.mContext);
                break;
            }
            case 2130968578: {
                majorSkb = skbPool.getSoftKeyboard(2130968578, 2130968578, screenWidth, skbHeight, this.mContext);
                break;
            }
        }
        if (null == majorSkb || !this.mMajorView.setSoftKeyboard(majorSkb)) {
            return;
        }
        this.mMajorView.setBalloonHint(this.mBalloonOnKey, this.mBalloonPopup, false);
        this.mMajorView.invalidate();
    }

    private void responseKeyEvent(SoftKey sKey) {
        if (null == sKey) {
            return;
        }
        ((PinyinIME)this.mService).responseSoftKeyEvent(sKey);
    }

    private SoftKeyboardView inKeyboardView(int x, int y, int[] positionInParent) {
        if (this.mPopupSkbShow) {
            if (this.mPopupX <= x && this.mPopupX + this.mPopupSkb.getWidth() > x && this.mPopupY <= y && this.mPopupY + this.mPopupSkb.getHeight() > y) {
                positionInParent[0] = this.mPopupX;
                positionInParent[1] = this.mPopupY;
                this.mPopupSkbView.setOffsetToSkbContainer(positionInParent);
                return this.mPopupSkbView;
            }
            return null;
        }
        return this.mMajorView;
    }

    private void popupSymbols() {
        int popupResId = this.mSoftKeyDown.getPopupResId();
        if (popupResId > 0) {
            int skbContainerWidth = this.getWidth();
            int skbContainerHeight = this.getHeight();
            int miniSkbWidth = (int)((double)skbContainerWidth * 0.8);
            int miniSkbHeight = (int)((double)skbContainerHeight * 0.23);
            SkbPool skbPool = SkbPool.getInstance();
            SoftKeyboard skb = skbPool.getSoftKeyboard(popupResId, popupResId, miniSkbWidth, miniSkbHeight, this.mContext);
            if (null == skb) {
                return;
            }
            this.mPopupX = (skbContainerWidth - skb.getSkbTotalWidth()) / 2;
            this.mPopupY = (skbContainerHeight - skb.getSkbTotalHeight()) / 2;
            if (null == this.mPopupSkbView) {
                this.mPopupSkbView = new SoftKeyboardView(this.mContext, null);
                this.mPopupSkbView.onMeasure(-2, -2);
            }
            this.mPopupSkbView.setOnTouchListener(this);
            this.mPopupSkbView.setSoftKeyboard(skb);
            this.mPopupSkbView.setBalloonHint(this.mBalloonOnKey, this.mBalloonPopup, true);
            this.mPopupSkb.setContentView((View)this.mPopupSkbView);
            this.mPopupSkb.setWidth(skb.getSkbCoreWidth() + this.mPopupSkbView.getPaddingLeft() + this.mPopupSkbView.getPaddingRight());
            this.mPopupSkb.setHeight(skb.getSkbCoreHeight() + this.mPopupSkbView.getPaddingTop() + this.mPopupSkbView.getPaddingBottom());
            this.getLocationInWindow(this.mXyPosTmp);
            this.mPopupSkb.showAtLocation((View)this, 0, this.mPopupX, this.mPopupY + this.mXyPosTmp[1]);
            this.mPopupSkbShow = true;
            this.mPopupSkbNoResponse = true;
            this.dimSoftKeyboard(true);
            this.resetKeyPress(0L);
        }
    }

    private void dimSoftKeyboard(boolean dimSkb) {
        this.mMajorView.dimSoftKeyboard(dimSkb);
    }

    private void dismissPopupSkb() {
        this.mPopupSkb.dismiss();
        this.mPopupSkbShow = false;
        this.dimSoftKeyboard(false);
        this.resetKeyPress(0L);
    }

    private void resetKeyPress(long delay) {
        this.mLongPressTimer.removeTimer();
        if (null != this.mSkv) {
            this.mSkv.resetKeyPress(delay);
        }
    }

    public boolean handleBack(boolean realAction) {
        if (this.mPopupSkbShow) {
            if (!realAction) {
                return true;
            }
            this.dismissPopupSkb();
            this.mDiscardEvent = true;
            return true;
        }
        return false;
    }

    public void dismissPopups() {
        this.handleBack(true);
        this.resetKeyPress(0L);
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Environment env = Environment.getInstance();
        int measuredWidth = env.getScreenWidth();
        int measuredHeight = this.getPaddingTop();
        widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)measuredWidth, (int)0x40000000);
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(measuredHeight += env.getSkbHeight()), (int)0x40000000);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
    }

    public boolean onTouchEvent(MotionEvent event) {
        super.onTouchEvent(event);
        if (this.mSkbFlipper.isFlipping()) {
            this.resetKeyPress(0L);
            return true;
        }
        int x = (int)event.getX();
        int y = (int)event.getY();
        if (event.getAction() == 2 && Math.abs(x - this.mXLast) <= 6 && Math.abs((y += this.mYBiasCorrection) - this.mYLast) <= 6) {
            return true;
        }
        this.mXLast = x;
        this.mYLast = y;
        if (!this.mPopupSkbShow && this.mGestureDetector.onTouchEvent(event)) {
            this.resetKeyPress(0L);
            this.mDiscardEvent = true;
            return true;
        }
        switch (event.getAction()) {
            case 0: {
                this.resetKeyPress(0L);
                this.mWaitForTouchUp = true;
                this.mDiscardEvent = false;
                this.mSkv = null;
                this.mSoftKeyDown = null;
                this.mSkv = this.inKeyboardView(x, y, this.mSkvPosInContainer);
                if (null == this.mSkv) break;
                this.mSoftKeyDown = this.mSkv.onKeyPress(x - this.mSkvPosInContainer[0], y - this.mSkvPosInContainer[1], this.mLongPressTimer, false);
                break;
            }
            case 2: {
                SoftKeyboardView skv;
                if (x < 0 || x >= this.getWidth() || y < 0 || y >= this.getHeight()) break;
                if (this.mDiscardEvent) {
                    this.resetKeyPress(0L);
                    break;
                }
                if (this.mPopupSkbShow && this.mPopupSkbNoResponse || null == (skv = this.inKeyboardView(x, y, this.mSkvPosInContainer))) break;
                if (skv != this.mSkv) {
                    this.mSkv = skv;
                    this.mSoftKeyDown = this.mSkv.onKeyPress(x - this.mSkvPosInContainer[0], y - this.mSkvPosInContainer[1], this.mLongPressTimer, true);
                    break;
                }
                if (null == skv || null == this.mSkv) break;
                this.mSoftKeyDown = this.mSkv.onKeyMove(x - this.mSkvPosInContainer[0], y - this.mSkvPosInContainer[1]);
                if (null != this.mSoftKeyDown) break;
                this.mDiscardEvent = true;
                break;
            }
            case 1: {
                if (this.mDiscardEvent) {
                    this.resetKeyPress(0L);
                    break;
                }
                this.mWaitForTouchUp = false;
                if (null != this.mSkv) {
                    this.mSkv.onKeyRelease(x - this.mSkvPosInContainer[0], y - this.mSkvPosInContainer[1]);
                }
                if (!this.mPopupSkbShow || !this.mPopupSkbNoResponse) {
                    this.responseKeyEvent(this.mSoftKeyDown);
                }
                if (this.mSkv == this.mPopupSkbView && !this.mPopupSkbNoResponse) {
                    this.dismissPopupSkb();
                }
                this.mPopupSkbNoResponse = false;
                break;
            }
        }
        return null != this.mSkv;
    }

    public boolean onTouch(View v, MotionEvent event) {
        MotionEvent newEv = MotionEvent.obtain((long)event.getDownTime(), (long)event.getEventTime(), (int)event.getAction(), (float)(event.getX() + (float)this.mPopupX), (float)(event.getY() + (float)this.mPopupY), (float)event.getPressure(), (float)event.getSize(), (int)event.getMetaState(), (float)event.getXPrecision(), (float)event.getYPrecision(), (int)event.getDeviceId(), (int)event.getEdgeFlags());
        boolean ret = this.onTouchEvent(newEv);
        return ret;
    }

    class LongPressTimer
    extends Handler
    implements Runnable {
        public static final int LONG_PRESS_TIMEOUT1 = 500;
        private static final int LONG_PRESS_TIMEOUT2 = 100;
        private static final int LONG_PRESS_TIMEOUT3 = 100;
        public static final int LONG_PRESS_KEYNUM1 = 1;
        public static final int LONG_PRESS_KEYNUM2 = 3;
        SkbContainer mSkbContainer;
        private int mResponseTimes = 0;

        public LongPressTimer(SkbContainer skbContainer2) {
            this.mSkbContainer = skbContainer2;
        }

        public void startTimer() {
            this.postAtTime(this, SystemClock.uptimeMillis() + 500L);
            this.mResponseTimes = 0;
        }

        public boolean removeTimer() {
            this.removeCallbacks(this);
            return true;
        }

        public void run() {
            if (SkbContainer.this.mWaitForTouchUp) {
                ++this.mResponseTimes;
                if (SkbContainer.this.mSoftKeyDown.repeatable()) {
                    if (SkbContainer.this.mSoftKeyDown.isUserDefKey()) {
                        if (1 == this.mResponseTimes && SkbContainer.this.mInputModeSwitcher.tryHandleLongPressSwitch(((SkbContainer)SkbContainer.this).mSoftKeyDown.mKeyCode)) {
                            SkbContainer.this.mDiscardEvent = true;
                            SkbContainer.this.resetKeyPress(0L);
                        }
                    } else {
                        SkbContainer.this.responseKeyEvent(SkbContainer.this.mSoftKeyDown);
                        long timeout = this.mResponseTimes < 1 ? 500L : (this.mResponseTimes < 3 ? 100L : 100L);
                        this.postAtTime(this, SystemClock.uptimeMillis() + timeout);
                    }
                } else if (1 == this.mResponseTimes) {
                    SkbContainer.this.popupSymbols();
                }
            }
        }
    }
}

