/*
 * Decompiled with CFR 0.152.
 */
package com.android.inputmethod.pinyin;

import android.app.AlertDialog;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.ServiceConnection;
import android.content.res.Configuration;
import android.inputmethodservice.InputMethodService;
import android.os.Handler;
import android.os.IBinder;
import android.os.RemoteException;
import android.preference.PreferenceManager;
import android.util.Log;
import android.view.GestureDetector;
import android.view.KeyEvent;
import android.view.LayoutInflater;
import android.view.MotionEvent;
import android.view.View;
import android.view.Window;
import android.view.WindowManager;
import android.view.inputmethod.CompletionInfo;
import android.view.inputmethod.EditorInfo;
import android.view.inputmethod.InputConnection;
import android.view.inputmethod.InputMethodManager;
import android.widget.LinearLayout;
import android.widget.PopupWindow;
import com.android.inputmethod.pinyin.BalloonHint;
import com.android.inputmethod.pinyin.CandidateViewListener;
import com.android.inputmethod.pinyin.CandidatesContainer;
import com.android.inputmethod.pinyin.ComposingView;
import com.android.inputmethod.pinyin.EnglishInputProcessor;
import com.android.inputmethod.pinyin.Environment;
import com.android.inputmethod.pinyin.IPinyinDecoderService;
import com.android.inputmethod.pinyin.InputModeSwitcher;
import com.android.inputmethod.pinyin.KeyMapDream;
import com.android.inputmethod.pinyin.PinyinDecoderService;
import com.android.inputmethod.pinyin.Settings;
import com.android.inputmethod.pinyin.SettingsActivity;
import com.android.inputmethod.pinyin.SkbContainer;
import com.android.inputmethod.pinyin.SoftKey;
import com.android.inputmethod.pinyin.SoundManager;
import java.util.ArrayList;
import java.util.List;
import java.util.Vector;

public class PinyinIME
extends InputMethodService {
    static final String TAG = "PinyinIME";
    private static final boolean SIMULATE_KEY_DELETE = true;
    private Environment mEnvironment;
    private InputModeSwitcher mInputModeSwitcher;
    private SkbContainer mSkbContainer;
    private LinearLayout mFloatingContainer;
    private ComposingView mComposingView;
    private PopupWindow mFloatingWindow;
    private PopupTimer mFloatingWindowTimer = new PopupTimer();
    private CandidatesContainer mCandidatesContainer;
    private BalloonHint mCandidatesBalloon;
    private ChoiceNotifier mChoiceNotifier;
    private OnGestureListener mGestureListenerSkb;
    private OnGestureListener mGestureListenerCandidates;
    private GestureDetector mGestureDetectorSkb;
    private GestureDetector mGestureDetectorCandidates;
    private AlertDialog mOptionsDialog;
    private PinyinDecoderServiceConnection mPinyinDecoderServiceConnection;
    private ImeState mImeState = ImeState.STATE_IDLE;
    private DecodingInfo mDecInfo = new DecodingInfo();
    private EnglishInputProcessor mImEn;
    private BroadcastReceiver mReceiver = new BroadcastReceiver(){

        public void onReceive(Context context, Intent intent) {
            SoundManager.getInstance(context).updateRingerMode();
        }
    };

    public void onCreate() {
        this.mEnvironment = Environment.getInstance();
        if (this.mEnvironment.needDebug()) {
            Log.d((String)TAG, (String)"onCreate.");
        }
        super.onCreate();
        this.startPinyinDecoderService();
        this.mImEn = new EnglishInputProcessor();
        Settings.getInstance(PreferenceManager.getDefaultSharedPreferences((Context)this.getApplicationContext()));
        this.mInputModeSwitcher = new InputModeSwitcher(this);
        this.mChoiceNotifier = new ChoiceNotifier(this);
        this.mGestureListenerSkb = new OnGestureListener(false);
        this.mGestureListenerCandidates = new OnGestureListener(true);
        this.mGestureDetectorSkb = new GestureDetector((Context)this, (GestureDetector.OnGestureListener)this.mGestureListenerSkb);
        this.mGestureDetectorCandidates = new GestureDetector((Context)this, (GestureDetector.OnGestureListener)this.mGestureListenerCandidates);
        this.mEnvironment.onConfigurationChanged(this.getResources().getConfiguration(), (Context)this);
    }

    public void onDestroy() {
        if (this.mEnvironment.needDebug()) {
            Log.d((String)TAG, (String)"onDestroy.");
        }
        this.unbindService(this.mPinyinDecoderServiceConnection);
        Settings.releaseInstance();
        super.onDestroy();
    }

    public void onConfigurationChanged(Configuration newConfig) {
        Environment env = Environment.getInstance();
        if (this.mEnvironment.needDebug()) {
            Log.d((String)TAG, (String)"onConfigurationChanged");
            Log.d((String)TAG, (String)("--last config: " + env.getConfiguration().toString()));
            Log.d((String)TAG, (String)("---new config: " + newConfig.toString()));
        }
        env.onConfigurationChanged(newConfig, (Context)this);
        if (null != this.mSkbContainer) {
            this.mSkbContainer.dismissPopups();
        }
        if (null != this.mCandidatesBalloon) {
            this.mCandidatesBalloon.dismiss();
        }
        super.onConfigurationChanged(newConfig);
        this.resetToIdleState(false);
    }

    public boolean onKeyDown(int keyCode, KeyEvent event) {
        if (this.processKey(event, 0 != event.getRepeatCount())) {
            return true;
        }
        return super.onKeyDown(keyCode, event);
    }

    public boolean onKeyUp(int keyCode, KeyEvent event) {
        if (this.processKey(event, true)) {
            return true;
        }
        return super.onKeyUp(keyCode, event);
    }

    private boolean processKey(KeyEvent event, boolean realAction) {
        if (ImeState.STATE_BYPASS == this.mImeState) {
            return false;
        }
        int keyCode = event.getKeyCode();
        if (62 == keyCode && event.isShiftPressed()) {
            if (!realAction) {
                return true;
            }
            this.updateIcon(this.mInputModeSwitcher.switchLanguageWithHkb());
            this.resetToIdleState(false);
            int allMetaState = 247;
            this.getCurrentInputConnection().clearMetaKeyStates(allMetaState);
            return true;
        }
        if (this.mInputModeSwitcher.isEnglishWithHkb()) {
            return false;
        }
        if (this.processFunctionKeys(keyCode, realAction)) {
            return true;
        }
        int keyChar = 0;
        if (keyCode >= 29 && keyCode <= 54) {
            keyChar = keyCode - 29 + 97;
        } else if (keyCode >= 7 && keyCode <= 16) {
            keyChar = keyCode - 7 + 48;
        } else if (keyCode == 55) {
            keyChar = 44;
        } else if (keyCode == 56) {
            keyChar = 46;
        } else if (keyCode == 62) {
            keyChar = 32;
        } else if (keyCode == 75) {
            keyChar = 39;
        }
        if (this.mInputModeSwitcher.isEnglishWithSkb()) {
            return this.mImEn.processKey(this.getCurrentInputConnection(), event, this.mInputModeSwitcher.isEnglishUpperCaseWithSkb(), realAction);
        }
        if (this.mInputModeSwitcher.isChineseText()) {
            if (this.mImeState == ImeState.STATE_IDLE || this.mImeState == ImeState.STATE_APP_COMPLETION) {
                this.mImeState = ImeState.STATE_IDLE;
                return this.processStateIdle(keyChar, keyCode, event, realAction);
            }
            if (this.mImeState == ImeState.STATE_INPUT) {
                return this.processStateInput(keyChar, keyCode, event, realAction);
            }
            if (this.mImeState == ImeState.STATE_PREDICT) {
                return this.processStatePredict(keyChar, keyCode, event, realAction);
            }
            if (this.mImeState == ImeState.STATE_COMPOSING) {
                return this.processStateEditComposing(keyChar, keyCode, event, realAction);
            }
        } else if (0 != keyChar && realAction) {
            this.commitResultText(String.valueOf((char)keyChar));
        }
        return false;
    }

    private boolean processFunctionKeys(int keyCode, boolean realAction) {
        if (keyCode == 4 && this.isInputViewShown() && this.mSkbContainer.handleBack(realAction)) {
            return true;
        }
        if (this.mInputModeSwitcher.isChineseText()) {
            return false;
        }
        if (null != this.mCandidatesContainer && this.mCandidatesContainer.isShown() && !this.mDecInfo.isCandidatesListEmpty()) {
            if (keyCode == 23) {
                if (!realAction) {
                    return true;
                }
                this.chooseCandidate(-1);
                return true;
            }
            if (keyCode == 21) {
                if (!realAction) {
                    return true;
                }
                this.mCandidatesContainer.activeCurseBackward();
                return true;
            }
            if (keyCode == 22) {
                if (!realAction) {
                    return true;
                }
                this.mCandidatesContainer.activeCurseForward();
                return true;
            }
            if (keyCode == 19) {
                if (!realAction) {
                    return true;
                }
                this.mCandidatesContainer.pageBackward(false, true);
                return true;
            }
            if (keyCode == 20) {
                if (!realAction) {
                    return true;
                }
                this.mCandidatesContainer.pageForward(false, true);
                return true;
            }
            if (keyCode == 67 && ImeState.STATE_PREDICT == this.mImeState) {
                if (!realAction) {
                    return true;
                }
                this.resetToIdleState(false);
                return true;
            }
        } else {
            if (keyCode == 67) {
                if (!realAction) {
                    return true;
                }
                this.simulateKeyEventDownUp(keyCode);
                return true;
            }
            if (keyCode == 66) {
                if (!realAction) {
                    return true;
                }
                this.sendKeyChar('\n');
                return true;
            }
            if (keyCode == 62) {
                if (!realAction) {
                    return true;
                }
                this.sendKeyChar(' ');
                return true;
            }
        }
        return false;
    }

    private boolean processStateIdle(int keyChar, int keyCode, KeyEvent event, boolean realAction) {
        if (keyChar >= 97 && keyChar <= 122 && !event.isAltPressed()) {
            if (!realAction) {
                return true;
            }
            this.mDecInfo.addSplChar((char)keyChar, true);
            this.chooseAndUpdate(-1);
            return true;
        }
        if (keyCode == 67) {
            if (!realAction) {
                return true;
            }
            this.simulateKeyEventDownUp(keyCode);
            return true;
        }
        if (keyCode == 66) {
            if (!realAction) {
                return true;
            }
            this.sendKeyChar('\n');
            return true;
        }
        if (keyCode == 57 || keyCode == 58 || keyCode == 59 || keyCode == 60) {
            return true;
        }
        if (event.isAltPressed()) {
            char fullwidth_char = KeyMapDream.getChineseLabel(keyCode);
            if ('\u0000' != fullwidth_char) {
                if (realAction) {
                    String result = String.valueOf(fullwidth_char);
                    this.commitResultText(result);
                }
                return true;
            }
            if (keyCode >= 29 && keyCode <= 54) {
                return true;
            }
        } else if (keyChar != 0 && keyChar != 9) {
            if (realAction) {
                if (keyChar == 44 || keyChar == 46) {
                    this.inputCommaPeriod("", keyChar, false, ImeState.STATE_IDLE);
                } else if (0 != keyChar) {
                    String result = String.valueOf((char)keyChar);
                    this.commitResultText(result);
                }
            }
            return true;
        }
        return false;
    }

    private boolean processStateInput(int keyChar, int keyCode, KeyEvent event, boolean realAction) {
        if (event.isAltPressed()) {
            if (39 != event.getUnicodeChar(event.getMetaState())) {
                char fullwidth_char;
                if (realAction && '\u0000' != (fullwidth_char = KeyMapDream.getChineseLabel(keyCode))) {
                    this.commitResultText(this.mDecInfo.getCurrentFullSent(this.mCandidatesContainer.getActiveCandiatePos()) + String.valueOf(fullwidth_char));
                    this.resetToIdleState(false);
                }
                return true;
            }
            keyChar = 39;
        }
        if (keyChar >= 97 && keyChar <= 122 || keyChar == 39 && !this.mDecInfo.charBeforeCursorIsSeparator() || keyCode == 67) {
            if (!realAction) {
                return true;
            }
            return this.processSurfaceChange(keyChar, keyCode);
        }
        if (keyChar == 44 || keyChar == 46) {
            if (!realAction) {
                return true;
            }
            this.inputCommaPeriod(this.mDecInfo.getCurrentFullSent(this.mCandidatesContainer.getActiveCandiatePos()), keyChar, true, ImeState.STATE_IDLE);
            return true;
        }
        if (keyCode == 19 || keyCode == 20 || keyCode == 21 || keyCode == 22) {
            if (!realAction) {
                return true;
            }
            if (keyCode == 21) {
                this.mCandidatesContainer.activeCurseBackward();
            } else if (keyCode == 22) {
                this.mCandidatesContainer.activeCurseForward();
            } else if (keyCode == 19) {
                if (!this.mCandidatesContainer.pageBackward(false, true)) {
                    this.mCandidatesContainer.enableActiveHighlight(false);
                    this.changeToStateComposing(true);
                    this.updateComposingText(true);
                }
            } else if (keyCode == 20) {
                this.mCandidatesContainer.pageForward(false, true);
            }
            return true;
        }
        if (keyCode >= 8 && keyCode <= 16) {
            if (!realAction) {
                return true;
            }
            int activePos = keyCode - 8;
            int currentPage = this.mCandidatesContainer.getCurrentPage();
            if (activePos < this.mDecInfo.getCurrentPageSize(currentPage) && (activePos += this.mDecInfo.getCurrentPageStart(currentPage)) >= 0) {
                this.chooseAndUpdate(activePos);
            }
            return true;
        }
        if (keyCode == 66) {
            if (!realAction) {
                return true;
            }
            if (this.mInputModeSwitcher.isEnterNoramlState()) {
                this.commitResultText(this.mDecInfo.getOrigianlSplStr().toString());
                this.resetToIdleState(false);
            } else {
                this.commitResultText(this.mDecInfo.getCurrentFullSent(this.mCandidatesContainer.getActiveCandiatePos()));
                this.sendKeyChar('\n');
                this.resetToIdleState(false);
            }
            return true;
        }
        if (keyCode == 23 || keyCode == 62) {
            if (!realAction) {
                return true;
            }
            this.chooseCandidate(-1);
            return true;
        }
        if (keyCode == 4) {
            if (!realAction) {
                return true;
            }
            this.resetToIdleState(false);
            this.requestHideSelf(0);
            return true;
        }
        return false;
    }

    private boolean processStatePredict(int keyChar, int keyCode, KeyEvent event, boolean realAction) {
        if (!realAction) {
            return true;
        }
        if (event.isAltPressed()) {
            char fullwidth_char = KeyMapDream.getChineseLabel(keyCode);
            if ('\u0000' != fullwidth_char) {
                this.commitResultText(this.mDecInfo.getCandidate(this.mCandidatesContainer.getActiveCandiatePos()) + String.valueOf(fullwidth_char));
                this.resetToIdleState(false);
            }
            return true;
        }
        if (keyChar >= 97 && keyChar <= 122) {
            this.changeToStateInput(true);
            this.mDecInfo.addSplChar((char)keyChar, true);
            this.chooseAndUpdate(-1);
        } else if (keyChar == 44 || keyChar == 46) {
            this.inputCommaPeriod("", keyChar, true, ImeState.STATE_IDLE);
        } else if (keyCode == 19 || keyCode == 20 || keyCode == 21 || keyCode == 22) {
            if (keyCode == 21) {
                this.mCandidatesContainer.activeCurseBackward();
            }
            if (keyCode == 22) {
                this.mCandidatesContainer.activeCurseForward();
            }
            if (keyCode == 19) {
                this.mCandidatesContainer.pageBackward(false, true);
            }
            if (keyCode == 20) {
                this.mCandidatesContainer.pageForward(false, true);
            }
        } else if (keyCode == 67) {
            this.resetToIdleState(false);
        } else if (keyCode == 4) {
            this.resetToIdleState(false);
            this.requestHideSelf(0);
        } else if (keyCode >= 8 && keyCode <= 16) {
            int activePos = keyCode - 8;
            int currentPage = this.mCandidatesContainer.getCurrentPage();
            if (activePos < this.mDecInfo.getCurrentPageSize(currentPage) && (activePos += this.mDecInfo.getCurrentPageStart(currentPage)) >= 0) {
                this.chooseAndUpdate(activePos);
            }
        } else if (keyCode == 66) {
            this.sendKeyChar('\n');
            this.resetToIdleState(false);
        } else if (keyCode == 23 || keyCode == 62) {
            this.chooseCandidate(-1);
        }
        return true;
    }

    private boolean processStateEditComposing(int keyChar, int keyCode, KeyEvent event, boolean realAction) {
        if (!realAction) {
            return true;
        }
        ComposingView.ComposingStatus cmpsvStatus = this.mComposingView.getComposingStatus();
        if (event.isAltPressed()) {
            if (39 != event.getUnicodeChar(event.getMetaState())) {
                char fullwidth_char = KeyMapDream.getChineseLabel(keyCode);
                if ('\u0000' != fullwidth_char) {
                    String retStr = ComposingView.ComposingStatus.SHOW_STRING_LOWERCASE == cmpsvStatus ? this.mDecInfo.getOrigianlSplStr().toString() : this.mDecInfo.getComposingStr();
                    this.commitResultText(retStr + String.valueOf(fullwidth_char));
                    this.resetToIdleState(false);
                }
                return true;
            }
            keyChar = 39;
        }
        if (keyCode == 20) {
            if (!this.mDecInfo.selectionFinished()) {
                this.changeToStateInput(true);
            }
        } else if (keyCode == 21 || keyCode == 22) {
            this.mComposingView.moveCursor(keyCode);
        } else if (keyCode == 66 && this.mInputModeSwitcher.isEnterNoramlState() || keyCode == 23 || keyCode == 62) {
            if (ComposingView.ComposingStatus.SHOW_STRING_LOWERCASE == cmpsvStatus) {
                String str = this.mDecInfo.getOrigianlSplStr().toString();
                if (!this.tryInputRawUnicode(str)) {
                    this.commitResultText(str);
                }
            } else if (ComposingView.ComposingStatus.EDIT_PINYIN == cmpsvStatus) {
                String str = this.mDecInfo.getComposingStr();
                if (!this.tryInputRawUnicode(str)) {
                    this.commitResultText(str);
                }
            } else {
                this.commitResultText(this.mDecInfo.getComposingStr());
            }
            this.resetToIdleState(false);
        } else if (keyCode == 66 && !this.mInputModeSwitcher.isEnterNoramlState()) {
            String retStr = !this.mDecInfo.isCandidatesListEmpty() ? this.mDecInfo.getCurrentFullSent(this.mCandidatesContainer.getActiveCandiatePos()) : this.mDecInfo.getComposingStr();
            this.commitResultText(retStr);
            this.sendKeyChar('\n');
            this.resetToIdleState(false);
        } else {
            if (keyCode == 4) {
                this.resetToIdleState(false);
                this.requestHideSelf(0);
                return true;
            }
            return this.processSurfaceChange(keyChar, keyCode);
        }
        return true;
    }

    private boolean tryInputRawUnicode(String str) {
        if (str.length() > 7) {
            if (str.substring(0, 7).compareTo("unicode") == 0) {
                try {
                    int unicode;
                    String digitStr = str.substring(7);
                    int startPos = 0;
                    int radix = 10;
                    if (digitStr.length() > 2 && digitStr.charAt(0) == '0' && digitStr.charAt(1) == 'x') {
                        startPos = 2;
                        radix = 16;
                    }
                    if ((unicode = Integer.parseInt(digitStr = digitStr.substring(startPos), radix)) > 0) {
                        char low = (char)(unicode & 0xFFFF);
                        char high = (char)((unicode & 0xFFFF0000) >> 16);
                        this.commitResultText(String.valueOf(low));
                        if ('\u0000' != high) {
                            this.commitResultText(String.valueOf(high));
                        }
                    }
                    return true;
                }
                catch (NumberFormatException e) {
                    return false;
                }
            }
            if (str.substring(str.length() - 7, str.length()).compareTo("unicode") == 0) {
                String resultStr = "";
                for (int pos = 0; pos < str.length() - 7; ++pos) {
                    if (pos > 0) {
                        resultStr = resultStr + " ";
                    }
                    resultStr = resultStr + "0x" + Integer.toHexString(str.charAt(pos));
                }
                this.commitResultText(String.valueOf(resultStr));
                return true;
            }
        }
        return false;
    }

    private boolean processSurfaceChange(int keyChar, int keyCode) {
        if (this.mDecInfo.isSplStrFull() && 67 != keyCode) {
            return true;
        }
        if (keyChar >= 97 && keyChar <= 122 || keyChar == 39 && !this.mDecInfo.charBeforeCursorIsSeparator() || (keyChar >= 48 && keyChar <= 57 || keyChar == 32) && ImeState.STATE_COMPOSING == this.mImeState) {
            this.mDecInfo.addSplChar((char)keyChar, false);
            this.chooseAndUpdate(-1);
        } else if (keyCode == 67) {
            this.mDecInfo.prepareDeleteBeforeCursor();
            this.chooseAndUpdate(-1);
        }
        return true;
    }

    private void changeToStateComposing(boolean updateUi) {
        this.mImeState = ImeState.STATE_COMPOSING;
        if (!updateUi) {
            return;
        }
        if (null != this.mSkbContainer && this.mSkbContainer.isShown()) {
            this.mSkbContainer.toggleCandidateMode(true);
        }
    }

    private void changeToStateInput(boolean updateUi) {
        this.mImeState = ImeState.STATE_INPUT;
        if (!updateUi) {
            return;
        }
        if (null != this.mSkbContainer && this.mSkbContainer.isShown()) {
            this.mSkbContainer.toggleCandidateMode(true);
        }
        this.showCandidateWindow(true);
    }

    private void simulateKeyEventDownUp(int keyCode) {
        InputConnection ic = this.getCurrentInputConnection();
        if (null == ic) {
            return;
        }
        ic.sendKeyEvent(new KeyEvent(0, keyCode));
        ic.sendKeyEvent(new KeyEvent(1, keyCode));
    }

    private void commitResultText(String resultText) {
        InputConnection ic = this.getCurrentInputConnection();
        if (null != ic) {
            ic.commitText((CharSequence)resultText, 1);
        }
        if (null != this.mComposingView) {
            this.mComposingView.setVisibility(4);
            this.mComposingView.invalidate();
        }
    }

    private void updateComposingText(boolean visible) {
        if (!visible) {
            this.mComposingView.setVisibility(4);
        } else {
            this.mComposingView.setDecodingInfo(this.mDecInfo, this.mImeState);
            this.mComposingView.setVisibility(0);
        }
        this.mComposingView.invalidate();
    }

    private void inputCommaPeriod(String preEdit, int keyChar, boolean dismissCandWindow, ImeState nextState) {
        if (keyChar == 44) {
            preEdit = preEdit + '\uff0c';
        } else if (keyChar == 46) {
            preEdit = preEdit + '\u3002';
        } else {
            return;
        }
        this.commitResultText(preEdit);
        if (dismissCandWindow) {
            this.resetCandidateWindow();
        }
        this.mImeState = nextState;
    }

    private void resetToIdleState(boolean resetInlineText) {
        if (ImeState.STATE_IDLE == this.mImeState) {
            return;
        }
        this.mImeState = ImeState.STATE_IDLE;
        this.mDecInfo.reset();
        if (null != this.mComposingView) {
            this.mComposingView.reset();
        }
        if (resetInlineText) {
            this.commitResultText("");
        }
        this.resetCandidateWindow();
    }

    private void chooseAndUpdate(int candId) {
        if (!this.mInputModeSwitcher.isChineseText()) {
            String choice = this.mDecInfo.getCandidate(candId);
            if (null != choice) {
                this.commitResultText(choice);
            }
            this.resetToIdleState(false);
            return;
        }
        if (ImeState.STATE_PREDICT != this.mImeState) {
            this.mDecInfo.chooseDecodingCandidate(candId);
        } else {
            this.mDecInfo.choosePredictChoice(candId);
        }
        if (this.mDecInfo.getComposingStr().length() > 0) {
            String resultStr = this.mDecInfo.getComposingStrActivePart();
            if (candId >= 0 && this.mDecInfo.canDoPrediction()) {
                this.commitResultText(resultStr);
                this.mImeState = ImeState.STATE_PREDICT;
                if (null != this.mSkbContainer && this.mSkbContainer.isShown()) {
                    this.mSkbContainer.toggleCandidateMode(false);
                }
                if (Settings.getPrediction()) {
                    CharSequence cs;
                    InputConnection ic = this.getCurrentInputConnection();
                    if (null != ic && null != (cs = ic.getTextBeforeCursor(3, 0))) {
                        this.mDecInfo.preparePredicts(cs);
                    }
                } else {
                    this.mDecInfo.resetCandidates();
                }
                if (this.mDecInfo.mCandidatesList.size() > 0) {
                    this.showCandidateWindow(false);
                } else {
                    this.resetToIdleState(false);
                }
            } else {
                if (ImeState.STATE_IDLE == this.mImeState) {
                    if (this.mDecInfo.getSplStrDecodedLen() == 0) {
                        this.changeToStateComposing(true);
                    } else {
                        this.changeToStateInput(true);
                    }
                } else if (this.mDecInfo.selectionFinished()) {
                    this.changeToStateComposing(true);
                }
                this.showCandidateWindow(true);
            }
        } else {
            this.resetToIdleState(false);
        }
    }

    private void chooseCandidate(int activeCandNo) {
        if (activeCandNo < 0) {
            activeCandNo = this.mCandidatesContainer.getActiveCandiatePos();
        }
        if (activeCandNo >= 0) {
            this.chooseAndUpdate(activeCandNo);
        }
    }

    private boolean startPinyinDecoderService() {
        if (null == this.mDecInfo.mIPinyinDecoderService) {
            Intent serviceIntent = new Intent();
            serviceIntent.setClass((Context)this, PinyinDecoderService.class);
            if (null == this.mPinyinDecoderServiceConnection) {
                this.mPinyinDecoderServiceConnection = new PinyinDecoderServiceConnection();
            }
            return this.bindService(serviceIntent, this.mPinyinDecoderServiceConnection, 1);
        }
        return true;
    }

    public View onCreateCandidatesView() {
        if (this.mEnvironment.needDebug()) {
            Log.d((String)TAG, (String)"onCreateCandidatesView.");
        }
        LayoutInflater inflater = this.getLayoutInflater();
        this.mFloatingContainer = (LinearLayout)inflater.inflate(2130903041, null);
        this.mComposingView = (ComposingView)this.mFloatingContainer.getChildAt(0);
        this.mCandidatesContainer = (CandidatesContainer)inflater.inflate(2130903040, null);
        this.mCandidatesBalloon = new BalloonHint((Context)this, (View)this.mCandidatesContainer, 0);
        this.mCandidatesBalloon.setBalloonBackground(this.getResources().getDrawable(2130837508));
        this.mCandidatesContainer.initialize(this.mChoiceNotifier, this.mCandidatesBalloon, this.mGestureDetectorCandidates);
        if (null != this.mFloatingWindow && this.mFloatingWindow.isShowing()) {
            this.mFloatingWindowTimer.cancelShowing();
            this.mFloatingWindow.dismiss();
        }
        this.mFloatingWindow = new PopupWindow((Context)this);
        this.mFloatingWindow.setClippingEnabled(false);
        this.mFloatingWindow.setBackgroundDrawable(null);
        this.mFloatingWindow.setInputMethodMode(2);
        this.mFloatingWindow.setContentView((View)this.mFloatingContainer);
        this.setCandidatesViewShown(true);
        return this.mCandidatesContainer;
    }

    public void responseSoftKeyEvent(SoftKey sKey) {
        if (null == sKey) {
            return;
        }
        InputConnection ic = this.getCurrentInputConnection();
        if (ic == null) {
            return;
        }
        int keyCode = sKey.getKeyCode();
        if (sKey.isKeyCodeKey() && this.processFunctionKeys(keyCode, true)) {
            return;
        }
        if (sKey.isUserDefKey()) {
            this.updateIcon(this.mInputModeSwitcher.switchModeForUserKey(keyCode));
            this.resetToIdleState(false);
            this.mSkbContainer.updateInputMode();
        } else {
            if (sKey.isKeyCodeKey()) {
                KeyEvent eDown = new KeyEvent(0L, 0L, 0, keyCode, 0, 0, 0, 0, 2);
                KeyEvent eUp = new KeyEvent(0L, 0L, 1, keyCode, 0, 0, 0, 0, 2);
                this.onKeyDown(keyCode, eDown);
                this.onKeyUp(keyCode, eUp);
            } else if (sKey.isUniStrKey()) {
                boolean kUsed = false;
                String keyLabel = sKey.getKeyLabel();
                if (this.mInputModeSwitcher.isChineseTextWithSkb() && (ImeState.STATE_INPUT == this.mImeState || ImeState.STATE_COMPOSING == this.mImeState) && this.mDecInfo.length() > 0 && keyLabel.length() == 1 && keyLabel.charAt(0) == '\'') {
                    this.processSurfaceChange(39, 0);
                    kUsed = true;
                }
                if (!kUsed) {
                    if (ImeState.STATE_INPUT == this.mImeState) {
                        this.commitResultText(this.mDecInfo.getCurrentFullSent(this.mCandidatesContainer.getActiveCandiatePos()));
                    } else if (ImeState.STATE_COMPOSING == this.mImeState) {
                        this.commitResultText(this.mDecInfo.getComposingStr());
                    }
                    this.commitResultText(keyLabel);
                    this.resetToIdleState(false);
                }
            }
            if (!this.mSkbContainer.isCurrentSkbSticky()) {
                this.updateIcon(this.mInputModeSwitcher.requestBackToPreviousSkb());
                this.resetToIdleState(false);
                this.mSkbContainer.updateInputMode();
            }
        }
    }

    private void showCandidateWindow(boolean showComposingView) {
        if (this.mEnvironment.needDebug()) {
            Log.d((String)TAG, (String)("Candidates window is shown. Parent = " + this.mCandidatesContainer));
        }
        this.setCandidatesViewShown(true);
        if (null != this.mSkbContainer) {
            this.mSkbContainer.requestLayout();
        }
        if (null == this.mCandidatesContainer) {
            this.resetToIdleState(false);
            return;
        }
        this.updateComposingText(showComposingView);
        this.mCandidatesContainer.showCandidates(this.mDecInfo, ImeState.STATE_COMPOSING != this.mImeState);
        this.mFloatingWindowTimer.postShowFloatingWindow();
    }

    private void dismissCandidateWindow() {
        if (this.mEnvironment.needDebug()) {
            Log.d((String)TAG, (String)"Candidates window is to be dismissed");
        }
        if (null == this.mCandidatesContainer) {
            return;
        }
        try {
            this.mFloatingWindowTimer.cancelShowing();
            this.mFloatingWindow.dismiss();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Fail to show the PopupWindow.");
        }
        this.setCandidatesViewShown(false);
        if (null != this.mSkbContainer && this.mSkbContainer.isShown()) {
            this.mSkbContainer.toggleCandidateMode(false);
        }
    }

    private void resetCandidateWindow() {
        if (this.mEnvironment.needDebug()) {
            Log.d((String)TAG, (String)"Candidates window is to be reset");
        }
        if (null == this.mCandidatesContainer) {
            return;
        }
        try {
            this.mFloatingWindowTimer.cancelShowing();
            this.mFloatingWindow.dismiss();
        }
        catch (Exception e) {
            Log.e((String)TAG, (String)"Fail to show the PopupWindow.");
        }
        if (null != this.mSkbContainer && this.mSkbContainer.isShown()) {
            this.mSkbContainer.toggleCandidateMode(false);
        }
        this.mDecInfo.resetCandidates();
        if (null != this.mCandidatesContainer && this.mCandidatesContainer.isShown()) {
            this.showCandidateWindow(false);
        }
    }

    private void updateIcon(int iconId) {
        if (iconId > 0) {
            this.showStatusIcon(iconId);
        } else {
            this.hideStatusIcon();
        }
    }

    public View onCreateInputView() {
        if (this.mEnvironment.needDebug()) {
            Log.d((String)TAG, (String)"onCreateInputView.");
        }
        LayoutInflater inflater = this.getLayoutInflater();
        this.mSkbContainer = (SkbContainer)inflater.inflate(2130903042, null);
        this.mSkbContainer.setService(this);
        this.mSkbContainer.setInputModeSwitcher(this.mInputModeSwitcher);
        this.mSkbContainer.setGestureDetector(this.mGestureDetectorSkb);
        return this.mSkbContainer;
    }

    public void onStartInput(EditorInfo editorInfo, boolean restarting) {
        if (this.mEnvironment.needDebug()) {
            Log.d((String)TAG, (String)("onStartInput  ccontentType: " + String.valueOf(editorInfo.inputType) + " Restarting:" + String.valueOf(restarting)));
        }
        this.updateIcon(this.mInputModeSwitcher.requestInputWithHkb(editorInfo));
        this.resetToIdleState(false);
    }

    public void onStartInputView(EditorInfo editorInfo, boolean restarting) {
        if (this.mEnvironment.needDebug()) {
            Log.d((String)TAG, (String)("onStartInputView  contentType: " + String.valueOf(editorInfo.inputType) + " Restarting:" + String.valueOf(restarting)));
        }
        this.updateIcon(this.mInputModeSwitcher.requestInputWithSkb(editorInfo));
        this.resetToIdleState(false);
        this.mSkbContainer.updateInputMode();
        this.setCandidatesViewShown(false);
    }

    public void onFinishInputView(boolean finishingInput) {
        if (this.mEnvironment.needDebug()) {
            Log.d((String)TAG, (String)"onFinishInputView.");
        }
        this.resetToIdleState(false);
        super.onFinishInputView(finishingInput);
    }

    public void onFinishInput() {
        if (this.mEnvironment.needDebug()) {
            Log.d((String)TAG, (String)"onFinishInput.");
        }
        this.resetToIdleState(false);
        super.onFinishInput();
    }

    public void onFinishCandidatesView(boolean finishingInput) {
        if (this.mEnvironment.needDebug()) {
            Log.d((String)TAG, (String)"onFinishCandidateView.");
        }
        this.resetToIdleState(false);
        super.onFinishCandidatesView(finishingInput);
    }

    public void onDisplayCompletions(CompletionInfo[] completions) {
        if (!this.isFullscreenMode()) {
            return;
        }
        if (null == completions || completions.length <= 0) {
            return;
        }
        if (null == this.mSkbContainer || !this.mSkbContainer.isShown()) {
            return;
        }
        if (!this.mInputModeSwitcher.isChineseText() || ImeState.STATE_IDLE == this.mImeState || ImeState.STATE_PREDICT == this.mImeState) {
            this.mImeState = ImeState.STATE_APP_COMPLETION;
            this.mDecInfo.prepareAppCompletions(completions);
            this.showCandidateWindow(false);
        }
    }

    private void onChoiceTouched(int activeCandNo) {
        if (this.mImeState == ImeState.STATE_COMPOSING) {
            this.changeToStateInput(true);
        } else if (this.mImeState == ImeState.STATE_INPUT || this.mImeState == ImeState.STATE_PREDICT) {
            this.chooseCandidate(activeCandNo);
        } else if (this.mImeState == ImeState.STATE_APP_COMPLETION) {
            CompletionInfo ci;
            if (null != this.mDecInfo.mAppCompletions && activeCandNo >= 0 && activeCandNo < this.mDecInfo.mAppCompletions.length && null != (ci = this.mDecInfo.mAppCompletions[activeCandNo])) {
                InputConnection ic = this.getCurrentInputConnection();
                ic.commitCompletion(ci);
            }
            this.resetToIdleState(false);
        }
    }

    public void requestHideSelf(int flags) {
        if (this.mEnvironment.needDebug()) {
            Log.d((String)TAG, (String)"DimissSoftInput.");
        }
        this.dismissCandidateWindow();
        if (null != this.mSkbContainer && this.mSkbContainer.isShown()) {
            this.mSkbContainer.dismissPopups();
        }
        super.requestHideSelf(flags);
    }

    public void showOptionsMenu() {
        AlertDialog.Builder builder = new AlertDialog.Builder((Context)this);
        builder.setCancelable(true);
        builder.setIcon(2130837504);
        builder.setNegativeButton(0x1040000, null);
        String itemSettings = this.getString(2131296257);
        String itemInputMethod = this.getString(17040109);
        builder.setItems(new CharSequence[]{itemSettings, itemInputMethod}, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface di, int position) {
                di.dismiss();
                switch (position) {
                    case 0: {
                        PinyinIME.this.launchSettings();
                        break;
                    }
                    case 1: {
                        InputMethodManager.getInstance((Context)PinyinIME.this).showInputMethodPicker();
                    }
                }
            }
        });
        builder.setTitle((CharSequence)this.getString(2131296256));
        this.mOptionsDialog = builder.create();
        Window window = this.mOptionsDialog.getWindow();
        WindowManager.LayoutParams lp = window.getAttributes();
        lp.token = this.mSkbContainer.getWindowToken();
        lp.type = 1003;
        window.setAttributes(lp);
        window.addFlags(131072);
        this.mOptionsDialog.show();
    }

    private void launchSettings() {
        Intent intent = new Intent();
        intent.setClass((Context)this, SettingsActivity.class);
        intent.setFlags(0x10000000);
        this.startActivity(intent);
    }

    public class DecodingInfo {
        private static final int PY_STRING_MAX = 28;
        private static final int MAX_PAGE_SIZE_DISPLAY = 10;
        private StringBuffer mSurface;
        private byte[] mPyBuf;
        private int mSurfaceDecodedLen = 0;
        private String mComposingStr;
        private int mActiveCmpsLen;
        private String mComposingStrDisplay;
        private int mActiveCmpsDisplayLen;
        private String mFullSent;
        private int mFixedLen;
        private boolean mFinishSelection;
        private int[] mSplStart;
        private int mCursorPos;
        private IPinyinDecoderService mIPinyinDecoderService;
        private CompletionInfo[] mAppCompletions;
        public int mTotalChoicesNum;
        public List<String> mCandidatesList = new Vector<String>();
        public Vector<Integer> mPageStart = new Vector();
        public Vector<Integer> mCnToPage = new Vector();
        public int mPosDelSpl = -1;
        public boolean mIsPosInSpl;

        public DecodingInfo() {
            this.mSurface = new StringBuffer();
        }

        public void reset() {
            this.mSurface.delete(0, this.mSurface.length());
            this.mSurfaceDecodedLen = 0;
            this.mCursorPos = 0;
            this.mFullSent = "";
            this.mFixedLen = 0;
            this.mFinishSelection = false;
            this.mComposingStr = "";
            this.mComposingStrDisplay = "";
            this.mActiveCmpsLen = 0;
            this.mActiveCmpsDisplayLen = 0;
            this.resetCandidates();
        }

        public boolean isCandidatesListEmpty() {
            return this.mCandidatesList.size() == 0;
        }

        public boolean isSplStrFull() {
            return this.mSurface.length() >= 27;
        }

        public void addSplChar(char ch, boolean reset) {
            if (reset) {
                this.mSurface.delete(0, this.mSurface.length());
                this.mSurfaceDecodedLen = 0;
                this.mCursorPos = 0;
                try {
                    this.mIPinyinDecoderService.imResetSearch();
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
            }
            this.mSurface.insert(this.mCursorPos, ch);
            ++this.mCursorPos;
        }

        public void prepareDeleteBeforeCursor() {
            if (this.mCursorPos > 0) {
                for (int pos = 0; pos < this.mFixedLen; ++pos) {
                    if (this.mSplStart[pos + 2] < this.mCursorPos || this.mSplStart[pos + 1] >= this.mCursorPos) continue;
                    this.mPosDelSpl = pos;
                    this.mCursorPos = this.mSplStart[pos + 1];
                    this.mIsPosInSpl = true;
                    break;
                }
                if (this.mPosDelSpl < 0) {
                    this.mPosDelSpl = this.mCursorPos - 1;
                    --this.mCursorPos;
                    this.mIsPosInSpl = false;
                }
            }
        }

        public int length() {
            return this.mSurface.length();
        }

        public char charAt(int index) {
            return this.mSurface.charAt(index);
        }

        public StringBuffer getOrigianlSplStr() {
            return this.mSurface;
        }

        public int getSplStrDecodedLen() {
            return this.mSurfaceDecodedLen;
        }

        public int[] getSplStart() {
            return this.mSplStart;
        }

        public String getComposingStr() {
            return this.mComposingStr;
        }

        public String getComposingStrActivePart() {
            assert (this.mActiveCmpsLen <= this.mComposingStr.length());
            return this.mComposingStr.substring(0, this.mActiveCmpsLen);
        }

        public int getActiveCmpsLen() {
            return this.mActiveCmpsLen;
        }

        public String getComposingStrForDisplay() {
            return this.mComposingStrDisplay;
        }

        public int getActiveCmpsDisplayLen() {
            return this.mActiveCmpsDisplayLen;
        }

        public String getFullSent() {
            return this.mFullSent;
        }

        public String getCurrentFullSent(int activeCandPos) {
            try {
                String retStr = this.mFullSent.substring(0, this.mFixedLen);
                retStr = retStr + this.mCandidatesList.get(activeCandPos);
                return retStr;
            }
            catch (Exception e) {
                return "";
            }
        }

        public void resetCandidates() {
            this.mCandidatesList.clear();
            this.mTotalChoicesNum = 0;
            this.mPageStart.clear();
            this.mPageStart.add(0);
            this.mCnToPage.clear();
            this.mCnToPage.add(0);
        }

        public boolean candidatesFromApp() {
            return ImeState.STATE_APP_COMPLETION == PinyinIME.this.mImeState;
        }

        public boolean canDoPrediction() {
            return this.mComposingStr.length() == this.mFixedLen;
        }

        public boolean selectionFinished() {
            return this.mFinishSelection;
        }

        private void chooseDecodingCandidate(int candId) {
            if (PinyinIME.this.mImeState != ImeState.STATE_PREDICT) {
                this.resetCandidates();
                int totalChoicesNum = 0;
                try {
                    if (candId < 0) {
                        if (this.length() == 0) {
                            totalChoicesNum = 0;
                        } else {
                            if (this.mPyBuf == null) {
                                this.mPyBuf = new byte[28];
                            }
                            for (int i = 0; i < this.length(); ++i) {
                                this.mPyBuf[i] = (byte)this.charAt(i);
                            }
                            this.mPyBuf[this.length()] = 0;
                            if (this.mPosDelSpl < 0) {
                                totalChoicesNum = this.mIPinyinDecoderService.imSearch(this.mPyBuf, this.length());
                            } else {
                                boolean clear_fixed_this_step = true;
                                if (ImeState.STATE_COMPOSING == PinyinIME.this.mImeState) {
                                    clear_fixed_this_step = false;
                                }
                                totalChoicesNum = this.mIPinyinDecoderService.imDelSearch(this.mPosDelSpl, this.mIsPosInSpl, clear_fixed_this_step);
                                this.mPosDelSpl = -1;
                            }
                        }
                    } else {
                        totalChoicesNum = this.mIPinyinDecoderService.imChoose(candId);
                    }
                }
                catch (RemoteException remoteException) {
                    // empty catch block
                }
                this.updateDecInfoForSearch(totalChoicesNum);
            }
        }

        private void updateDecInfoForSearch(int totalChoicesNum) {
            this.mTotalChoicesNum = totalChoicesNum;
            if (this.mTotalChoicesNum < 0) {
                this.mTotalChoicesNum = 0;
                return;
            }
            try {
                this.mSplStart = this.mIPinyinDecoderService.imGetSplStart();
                String pyStr = this.mIPinyinDecoderService.imGetPyStr(false);
                this.mSurfaceDecodedLen = this.mIPinyinDecoderService.imGetPyStrLen(true);
                assert (this.mSurfaceDecodedLen <= pyStr.length());
                this.mFullSent = this.mIPinyinDecoderService.imGetChoice(0);
                this.mFixedLen = this.mIPinyinDecoderService.imGetFixedLen();
                this.mSurface.replace(0, this.mSurface.length(), pyStr);
                if (this.mCursorPos > this.mSurface.length()) {
                    this.mCursorPos = this.mSurface.length();
                }
                this.mComposingStr = this.mFullSent.substring(0, this.mFixedLen) + this.mSurface.substring(this.mSplStart[this.mFixedLen + 1]);
                this.mActiveCmpsLen = this.mComposingStr.length();
                if (this.mSurfaceDecodedLen > 0) {
                    this.mActiveCmpsLen -= this.mSurface.length() - this.mSurfaceDecodedLen;
                }
                if (0 == this.mSurfaceDecodedLen) {
                    this.mComposingStrDisplay = this.mComposingStr;
                    this.mActiveCmpsDisplayLen = this.mComposingStr.length();
                } else {
                    this.mComposingStrDisplay = this.mFullSent.substring(0, this.mFixedLen);
                    for (int pos = this.mFixedLen + 1; pos < this.mSplStart.length - 1; ++pos) {
                        this.mComposingStrDisplay = this.mComposingStrDisplay + this.mSurface.substring(this.mSplStart[pos], this.mSplStart[pos + 1]);
                        if (this.mSplStart[pos + 1] >= this.mSurfaceDecodedLen) continue;
                        this.mComposingStrDisplay = this.mComposingStrDisplay + " ";
                    }
                    this.mActiveCmpsDisplayLen = this.mComposingStrDisplay.length();
                    if (this.mSurfaceDecodedLen < this.mSurface.length()) {
                        this.mComposingStrDisplay = this.mComposingStrDisplay + this.mSurface.substring(this.mSurfaceDecodedLen);
                    }
                }
                this.mFinishSelection = this.mSplStart.length == this.mFixedLen + 2;
            }
            catch (RemoteException e) {
                Log.w((String)PinyinIME.TAG, (String)"PinyinDecoderService died", (Throwable)e);
            }
            catch (Exception e) {
                this.mTotalChoicesNum = 0;
                this.mComposingStr = "";
            }
            if (!this.mFinishSelection) {
                this.preparePage(0);
            }
        }

        private void choosePredictChoice(int choiceId) {
            if (ImeState.STATE_PREDICT != PinyinIME.this.mImeState || choiceId < 0 || choiceId >= this.mTotalChoicesNum) {
                return;
            }
            String tmp = this.mCandidatesList.get(choiceId);
            this.resetCandidates();
            this.mCandidatesList.add(tmp);
            this.mTotalChoicesNum = 1;
            this.mSurface.replace(0, this.mSurface.length(), "");
            this.mCursorPos = 0;
            this.mFullSent = tmp;
            this.mFixedLen = tmp.length();
            this.mComposingStr = this.mFullSent;
            this.mActiveCmpsLen = this.mFixedLen;
            this.mFinishSelection = true;
        }

        public String getCandidate(int candId) {
            if (candId < 0 || candId > this.mCandidatesList.size()) {
                return null;
            }
            return this.mCandidatesList.get(candId);
        }

        private void getCandiagtesForCache() {
            int fetchStart = this.mCandidatesList.size();
            int fetchSize = this.mTotalChoicesNum - fetchStart;
            if (fetchSize > 10) {
                fetchSize = 10;
            }
            try {
                List<String> newList = null;
                if (ImeState.STATE_INPUT == PinyinIME.this.mImeState || ImeState.STATE_IDLE == PinyinIME.this.mImeState || ImeState.STATE_COMPOSING == PinyinIME.this.mImeState) {
                    newList = this.mIPinyinDecoderService.imGetChoiceList(fetchStart, fetchSize, this.mFixedLen);
                } else if (ImeState.STATE_PREDICT == PinyinIME.this.mImeState) {
                    newList = this.mIPinyinDecoderService.imGetPredictList(fetchStart, fetchSize);
                } else if (ImeState.STATE_APP_COMPLETION == PinyinIME.this.mImeState) {
                    newList = new ArrayList<String>();
                    if (null != this.mAppCompletions) {
                        for (int pos = fetchStart; pos < fetchSize; ++pos) {
                            CharSequence s;
                            CompletionInfo ci = this.mAppCompletions[pos];
                            if (null == ci || null == (s = ci.getText())) continue;
                            newList.add(((Object)s).toString());
                        }
                    }
                }
                this.mCandidatesList.addAll(newList);
            }
            catch (RemoteException e) {
                Log.w((String)PinyinIME.TAG, (String)"PinyinDecoderService died", (Throwable)e);
            }
        }

        public boolean pageReady(int pageNo) {
            if (pageNo < 0) {
                return false;
            }
            return this.mPageStart.size() > pageNo + 1;
        }

        public boolean preparePage(int pageNo) {
            if (pageNo < 0) {
                return false;
            }
            if (this.mPageStart.size() <= pageNo) {
                return false;
            }
            if (this.mPageStart.size() > pageNo + 1) {
                return true;
            }
            if (this.mCandidatesList.size() - this.mPageStart.elementAt(pageNo) >= 10) {
                return true;
            }
            this.getCandiagtesForCache();
            return this.mPageStart.elementAt(pageNo) < this.mCandidatesList.size();
        }

        public void preparePredicts(CharSequence history) {
            if (null == history) {
                return;
            }
            this.resetCandidates();
            if (Settings.getPrediction()) {
                String preEdit = ((Object)history).toString();
                boolean predictNum = false;
                if (null != preEdit) {
                    try {
                        this.mTotalChoicesNum = this.mIPinyinDecoderService.imGetPredictsNum(preEdit);
                    }
                    catch (RemoteException e) {
                        return;
                    }
                }
            }
            this.preparePage(0);
            this.mFinishSelection = false;
        }

        private void prepareAppCompletions(CompletionInfo[] completions) {
            this.resetCandidates();
            this.mAppCompletions = completions;
            this.mTotalChoicesNum = completions.length;
            this.preparePage(0);
            this.mFinishSelection = false;
        }

        public int getCurrentPageSize(int currentPage) {
            if (this.mPageStart.size() <= currentPage + 1) {
                return 0;
            }
            return this.mPageStart.elementAt(currentPage + 1) - this.mPageStart.elementAt(currentPage);
        }

        public int getCurrentPageStart(int currentPage) {
            if (this.mPageStart.size() < currentPage + 1) {
                return this.mTotalChoicesNum;
            }
            return this.mPageStart.elementAt(currentPage);
        }

        public boolean pageForwardable(int currentPage) {
            if (this.mPageStart.size() <= currentPage + 1) {
                return false;
            }
            return this.mPageStart.elementAt(currentPage + 1) < this.mTotalChoicesNum;
        }

        public boolean pageBackwardable(int currentPage) {
            return currentPage > 0;
        }

        public boolean charBeforeCursorIsSeparator() {
            int len = this.mSurface.length();
            if (this.mCursorPos > len) {
                return false;
            }
            return this.mCursorPos > 0 && this.mSurface.charAt(this.mCursorPos - 1) == '\'';
        }

        public int getCursorPos() {
            return this.mCursorPos;
        }

        public int getCursorPosInCmps() {
            int cursorPos = this.mCursorPos;
            boolean fixedLen = false;
            for (int hzPos = 0; hzPos < this.mFixedLen; ++hzPos) {
                if (this.mCursorPos < this.mSplStart[hzPos + 2]) continue;
                cursorPos -= this.mSplStart[hzPos + 2] - this.mSplStart[hzPos + 1];
                ++cursorPos;
            }
            return cursorPos;
        }

        public int getCursorPosInCmpsDisplay() {
            int cursorPos = this.getCursorPosInCmps();
            for (int pos = this.mFixedLen + 2; pos < this.mSplStart.length - 1 && this.mCursorPos > this.mSplStart[pos]; ++pos) {
                ++cursorPos;
            }
            return cursorPos;
        }

        public void moveCursorToEdge(boolean left) {
            this.mCursorPos = left ? 0 : this.mSurface.length();
        }

        public void moveCursor(int offset) {
            if (offset > 1 || offset < -1) {
                return;
            }
            if (offset != 0) {
                int hzPos = 0;
                for (hzPos = 0; hzPos <= this.mFixedLen; ++hzPos) {
                    if (this.mCursorPos != this.mSplStart[hzPos + 1]) continue;
                    if (offset < 0) {
                        if (hzPos <= 0) break;
                        offset = this.mSplStart[hzPos] - this.mSplStart[hzPos + 1];
                        break;
                    }
                    if (hzPos >= this.mFixedLen) break;
                    offset = this.mSplStart[hzPos + 2] - this.mSplStart[hzPos + 1];
                    break;
                }
            }
            this.mCursorPos += offset;
            if (this.mCursorPos < 0) {
                this.mCursorPos = 0;
            } else if (this.mCursorPos > this.mSurface.length()) {
                this.mCursorPos = this.mSurface.length();
            }
        }

        public int getSplNum() {
            return this.mSplStart[0];
        }

        public int getFixedLen() {
            return this.mFixedLen;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ImeState {
        STATE_BYPASS,
        STATE_IDLE,
        STATE_INPUT,
        STATE_COMPOSING,
        STATE_PREDICT,
        STATE_APP_COMPLETION;

    }

    public class PinyinDecoderServiceConnection
    implements ServiceConnection {
        public void onServiceConnected(ComponentName name, IBinder service) {
            PinyinIME.this.mDecInfo.mIPinyinDecoderService = IPinyinDecoderService.Stub.asInterface(service);
        }

        public void onServiceDisconnected(ComponentName name) {
        }
    }

    public class OnGestureListener
    extends GestureDetector.SimpleOnGestureListener {
        private static final int MIN_X_FOR_DRAG = 60;
        private static final int MIN_Y_FOR_DRAG = 40;
        private static final float VELOCITY_THRESHOLD_X1 = 0.3f;
        private static final float VELOCITY_THRESHOLD_X2 = 0.7f;
        private static final float VELOCITY_THRESHOLD_Y1 = 0.2f;
        private static final float VELOCITY_THRESHOLD_Y2 = 0.45f;
        private boolean mReponseGestures;
        private float mMinVelocityX = Float.MAX_VALUE;
        private float mMinVelocityY = Float.MAX_VALUE;
        private long mTimeDown;
        private long mTimeLastOnScroll;
        private boolean mNotGesture;
        private boolean mGestureRecognized;

        public OnGestureListener(boolean reponseGestures) {
            this.mReponseGestures = reponseGestures;
        }

        public boolean onDown(MotionEvent e) {
            this.mMinVelocityX = 2.1474836E9f;
            this.mMinVelocityY = 2.1474836E9f;
            this.mTimeLastOnScroll = this.mTimeDown = e.getEventTime();
            this.mNotGesture = false;
            this.mGestureRecognized = false;
            return false;
        }

        public boolean onScroll(MotionEvent e1, MotionEvent e2, float distanceX, float distanceY) {
            float k2;
            float vYThis;
            float vYTotal;
            float kY;
            float vXThis;
            float vXTotal;
            float kX;
            float k1;
            if (this.mNotGesture) {
                return false;
            }
            if (this.mGestureRecognized) {
                return true;
            }
            if (Math.abs(e1.getX() - e2.getX()) < 60.0f && Math.abs(e1.getY() - e2.getY()) < 40.0f) {
                return false;
            }
            long timeNow = e2.getEventTime();
            long spanTotal = timeNow - this.mTimeDown;
            long spanThis = timeNow - this.mTimeLastOnScroll;
            if (0L == spanTotal) {
                spanTotal = 1L;
            }
            if (0L == spanThis) {
                spanThis = 1L;
            }
            if ((double)((k1 = (kX = (vXTotal = (e2.getX() - e1.getX()) / (float)spanTotal) * (vXThis = -distanceX / (float)spanThis)) + (kY = (vYTotal = (e2.getY() - e1.getY()) / (float)spanTotal) * (vYThis = -distanceY / (float)spanThis))) / (k2 = Math.abs(kX) + Math.abs(kY))) < 0.8) {
                this.mNotGesture = true;
                return false;
            }
            float absVXTotal = Math.abs(vXTotal);
            float absVYTotal = Math.abs(vYTotal);
            if (absVXTotal < this.mMinVelocityX) {
                this.mMinVelocityX = absVXTotal;
            }
            if (absVYTotal < this.mMinVelocityY) {
                this.mMinVelocityY = absVYTotal;
            }
            if (this.mMinVelocityX < 0.3f && this.mMinVelocityY < 0.2f) {
                this.mNotGesture = true;
                return false;
            }
            if (vXTotal > 0.7f && absVYTotal < 0.45f) {
                if (this.mReponseGestures) {
                    this.onDirectionGesture(5);
                }
                this.mGestureRecognized = true;
            } else if (vXTotal < -0.7f && absVYTotal < 0.45f) {
                if (this.mReponseGestures) {
                    this.onDirectionGesture(3);
                }
                this.mGestureRecognized = true;
            } else if (vYTotal > 0.45f && absVXTotal < 0.7f) {
                if (this.mReponseGestures) {
                    this.onDirectionGesture(80);
                }
                this.mGestureRecognized = true;
            } else if (vYTotal < -0.45f && absVXTotal < 0.7f) {
                if (this.mReponseGestures) {
                    this.onDirectionGesture(48);
                }
                this.mGestureRecognized = true;
            }
            this.mTimeLastOnScroll = timeNow;
            return this.mGestureRecognized;
        }

        public boolean onFling(MotionEvent me1, MotionEvent me2, float velocityX, float velocityY) {
            return this.mGestureRecognized;
        }

        public void onDirectionGesture(int gravity) {
            if (0 == gravity) {
                return;
            }
            if ((3 == gravity || 5 == gravity) && PinyinIME.this.mCandidatesContainer.isShown()) {
                if (3 == gravity) {
                    PinyinIME.this.mCandidatesContainer.pageForward(true, true);
                } else {
                    PinyinIME.this.mCandidatesContainer.pageBackward(true, true);
                }
                return;
            }
        }
    }

    public class ChoiceNotifier
    extends Handler
    implements CandidateViewListener {
        PinyinIME mIme;

        ChoiceNotifier(PinyinIME ime) {
            this.mIme = ime;
        }

        public void onClickChoice(int choiceId) {
            if (choiceId >= 0) {
                this.mIme.onChoiceTouched(choiceId);
            }
        }

        public void onToLeftGesture() {
            if (ImeState.STATE_COMPOSING == PinyinIME.this.mImeState) {
                PinyinIME.this.changeToStateInput(true);
            }
            PinyinIME.this.mCandidatesContainer.pageForward(true, false);
        }

        public void onToRightGesture() {
            if (ImeState.STATE_COMPOSING == PinyinIME.this.mImeState) {
                PinyinIME.this.changeToStateInput(true);
            }
            PinyinIME.this.mCandidatesContainer.pageBackward(true, false);
        }

        public void onToTopGesture() {
        }

        public void onToBottomGesture() {
        }
    }

    private class PopupTimer
    extends Handler
    implements Runnable {
        private int[] mParentLocation = new int[2];

        private PopupTimer() {
        }

        void postShowFloatingWindow() {
            PinyinIME.this.mFloatingContainer.measure(-2, -2);
            PinyinIME.this.mFloatingWindow.setWidth(PinyinIME.this.mFloatingContainer.getMeasuredWidth());
            PinyinIME.this.mFloatingWindow.setHeight(PinyinIME.this.mFloatingContainer.getMeasuredHeight());
            this.post(this);
        }

        void cancelShowing() {
            if (PinyinIME.this.mFloatingWindow.isShowing()) {
                PinyinIME.this.mFloatingWindow.dismiss();
            }
            this.removeCallbacks(this);
        }

        public void run() {
            PinyinIME.this.mCandidatesContainer.getLocationInWindow(this.mParentLocation);
            if (!PinyinIME.this.mFloatingWindow.isShowing()) {
                PinyinIME.this.mFloatingWindow.showAtLocation((View)PinyinIME.this.mCandidatesContainer, 51, this.mParentLocation[0], this.mParentLocation[1] - PinyinIME.this.mFloatingWindow.getHeight());
            } else {
                PinyinIME.this.mFloatingWindow.update(this.mParentLocation[0], this.mParentLocation[1] - PinyinIME.this.mFloatingWindow.getHeight(), PinyinIME.this.mFloatingWindow.getWidth(), PinyinIME.this.mFloatingWindow.getHeight());
            }
        }
    }
}

