/*
 * Decompiled with CFR 0.152.
 */
package com.android.inputmethod.pinyin;

import android.app.Service;
import android.content.Intent;
import android.content.res.AssetFileDescriptor;
import android.os.IBinder;
import android.util.Log;
import com.android.inputmethod.pinyin.Environment;
import com.android.inputmethod.pinyin.IPinyinDecoderService;
import java.io.FileDescriptor;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.List;
import java.util.Vector;

public class PinyinDecoderService
extends Service {
    private static final int MAX_PATH_FILE_LENGTH = 100;
    private static boolean inited = false;
    private String mUsr_dict_file;
    private final IPinyinDecoderService.Stub mBinder = new IPinyinDecoderService.Stub(){

        @Override
        public int getInt() {
            return 12345;
        }

        @Override
        public void setMaxLens(int maxSpsLen, int maxHzsLen) {
            PinyinDecoderService.nativeImSetMaxLens(maxSpsLen, maxHzsLen);
        }

        @Override
        public int imSearch(byte[] pyBuf, int pyLen) {
            return PinyinDecoderService.nativeImSearch(pyBuf, pyLen);
        }

        @Override
        public int imDelSearch(int pos, boolean is_pos_in_splid, boolean clear_fixed_this_step) {
            return PinyinDecoderService.nativeImDelSearch(pos, is_pos_in_splid, clear_fixed_this_step);
        }

        @Override
        public void imResetSearch() {
            PinyinDecoderService.nativeImResetSearch();
        }

        @Override
        public int imAddLetter(byte ch) {
            return PinyinDecoderService.nativeImAddLetter(ch);
        }

        @Override
        public String imGetPyStr(boolean decoded) {
            return PinyinDecoderService.nativeImGetPyStr(decoded);
        }

        @Override
        public int imGetPyStrLen(boolean decoded) {
            return PinyinDecoderService.nativeImGetPyStrLen(decoded);
        }

        @Override
        public int[] imGetSplStart() {
            return PinyinDecoderService.nativeImGetSplStart();
        }

        @Override
        public String imGetChoice(int choiceId) {
            return PinyinDecoderService.nativeImGetChoice(choiceId);
        }

        @Override
        public String imGetChoices(int choicesNum) {
            String retStr = null;
            for (int i = 0; i < choicesNum; ++i) {
                retStr = null == retStr ? PinyinDecoderService.nativeImGetChoice(i) : retStr + " " + PinyinDecoderService.nativeImGetChoice(i);
            }
            return retStr;
        }

        @Override
        public List<String> imGetChoiceList(int choicesStart, int choicesNum, int sentFixedLen) {
            Vector<String> choiceList = new Vector<String>();
            for (int i = choicesStart; i < choicesStart + choicesNum; ++i) {
                String retStr = PinyinDecoderService.nativeImGetChoice(i);
                if (0 == i) {
                    retStr = retStr.substring(sentFixedLen);
                }
                choiceList.add(retStr);
            }
            return choiceList;
        }

        @Override
        public int imChoose(int choiceId) {
            return PinyinDecoderService.nativeImChoose(choiceId);
        }

        @Override
        public int imCancelLastChoice() {
            return PinyinDecoderService.nativeImCancelLastChoice();
        }

        @Override
        public int imGetFixedLen() {
            return PinyinDecoderService.nativeImGetFixedLen();
        }

        @Override
        public boolean imCancelInput() {
            return PinyinDecoderService.nativeImCancelInput();
        }

        @Override
        public void imFlushCache() {
            PinyinDecoderService.nativeImFlushCache();
        }

        @Override
        public int imGetPredictsNum(String fixedStr) {
            return PinyinDecoderService.nativeImGetPredictsNum(fixedStr);
        }

        @Override
        public String imGetPredictItem(int predictNo) {
            return PinyinDecoderService.nativeImGetPredictItem(predictNo);
        }

        @Override
        public List<String> imGetPredictList(int predictsStart, int predictsNum) {
            Vector<String> predictList = new Vector<String>();
            for (int i = predictsStart; i < predictsStart + predictsNum; ++i) {
                predictList.add(PinyinDecoderService.nativeImGetPredictItem(i));
            }
            return predictList;
        }

        @Override
        public String syncUserDict(String tomerge) {
            byte[] usr_dict = new byte[100];
            if (PinyinDecoderService.this.getUsrDictFileName(usr_dict)) {
                return PinyinDecoderService.nativeSyncUserDict(usr_dict, tomerge);
            }
            return null;
        }

        @Override
        public boolean syncBegin() {
            byte[] usr_dict = new byte[100];
            if (PinyinDecoderService.this.getUsrDictFileName(usr_dict)) {
                return PinyinDecoderService.nativeSyncBegin(usr_dict);
            }
            return false;
        }

        @Override
        public void syncFinish() {
            PinyinDecoderService.nativeSyncFinish();
        }

        @Override
        public int syncPutLemmas(String tomerge) {
            return PinyinDecoderService.nativeSyncPutLemmas(tomerge);
        }

        @Override
        public String syncGetLemmas() {
            return PinyinDecoderService.nativeSyncGetLemmas();
        }

        @Override
        public int syncGetLastCount() {
            return PinyinDecoderService.nativeSyncGetLastCount();
        }

        @Override
        public int syncGetTotalCount() {
            return PinyinDecoderService.nativeSyncGetTotalCount();
        }

        @Override
        public void syncClearLastGot() {
            PinyinDecoderService.nativeSyncClearLastGot();
        }

        @Override
        public int imSyncGetCapacity() {
            return PinyinDecoderService.nativeSyncGetCapacity();
        }
    };

    static native boolean nativeImOpenDecoder(byte[] var0, byte[] var1);

    static native boolean nativeImOpenDecoderFd(FileDescriptor var0, long var1, long var3, byte[] var5);

    static native void nativeImSetMaxLens(int var0, int var1);

    static native boolean nativeImCloseDecoder();

    static native int nativeImSearch(byte[] var0, int var1);

    static native int nativeImDelSearch(int var0, boolean var1, boolean var2);

    static native void nativeImResetSearch();

    static native int nativeImAddLetter(byte var0);

    static native String nativeImGetPyStr(boolean var0);

    static native int nativeImGetPyStrLen(boolean var0);

    static native int[] nativeImGetSplStart();

    static native String nativeImGetChoice(int var0);

    static native int nativeImChoose(int var0);

    static native int nativeImCancelLastChoice();

    static native int nativeImGetFixedLen();

    static native boolean nativeImCancelInput();

    static native boolean nativeImFlushCache();

    static native int nativeImGetPredictsNum(String var0);

    static native String nativeImGetPredictItem(int var0);

    static native String nativeSyncUserDict(byte[] var0, String var1);

    static native boolean nativeSyncBegin(byte[] var0);

    static native boolean nativeSyncFinish();

    static native String nativeSyncGetLemmas();

    static native int nativeSyncPutLemmas(String var0);

    static native int nativeSyncGetLastCount();

    static native int nativeSyncGetTotalCount();

    static native boolean nativeSyncClearLastGot();

    static native int nativeSyncGetCapacity();

    private boolean getUsrDictFileName(byte[] usr_dict) {
        if (null == usr_dict) {
            return false;
        }
        for (int i = 0; i < this.mUsr_dict_file.length(); ++i) {
            usr_dict[i] = (byte)this.mUsr_dict_file.charAt(i);
        }
        usr_dict[this.mUsr_dict_file.length()] = 0;
        return true;
    }

    private void initPinyinEngine() {
        byte[] usr_dict = new byte[100];
        AssetFileDescriptor afd = this.getResources().openRawResourceFd(2131034112);
        if (Environment.getInstance().needDebug()) {
            Log.i((String)"foo", (String)("Dict: start=" + afd.getStartOffset() + ", length=" + afd.getLength() + ", fd=" + afd.getParcelFileDescriptor()));
        }
        if (this.getUsrDictFileName(usr_dict)) {
            inited = PinyinDecoderService.nativeImOpenDecoderFd(afd.getFileDescriptor(), afd.getStartOffset(), afd.getLength(), usr_dict);
        }
        try {
            afd.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public void onCreate() {
        super.onCreate();
        this.mUsr_dict_file = this.getFileStreamPath("usr_dict.dat").getPath();
        try {
            this.openFileOutput("dummy", 0).close();
        }
        catch (FileNotFoundException e) {
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.initPinyinEngine();
    }

    public void onDestroy() {
        PinyinDecoderService.nativeImCloseDecoder();
        inited = false;
        super.onDestroy();
    }

    public IBinder onBind(Intent intent) {
        return this.mBinder;
    }

    static {
        try {
            System.loadLibrary("jni_pinyinime");
        }
        catch (UnsatisfiedLinkError ule) {
            Log.e((String)"PinyinDecoderService", (String)"WARNING: Could not load jni_pinyinime natives");
        }
    }
}

