/*
 * Decompiled with CFR 0.152.
 */
package com.android.inputmethod.pinyin;

import android.content.Context;
import android.content.res.Configuration;
import android.view.Display;
import android.view.WindowManager;

public class Environment {
    private static final float KEY_HEIGHT_RATIO_PORTRAIT = 0.105f;
    private static final float KEY_HEIGHT_RATIO_LANDSCAPE = 0.147f;
    private static final float CANDIDATES_AREA_HEIGHT_RATIO_PORTRAIT = 0.084f;
    private static final float CANDIDATES_AREA_HEIGHT_RATIO_LANDSCAPE = 0.125f;
    private static final float KEY_BALLOON_WIDTH_PLUS_RATIO = 0.08f;
    private static final float KEY_BALLOON_HEIGHT_PLUS_RATIO = 0.07f;
    private static final float NORMAL_KEY_TEXT_SIZE_RATIO = 0.075f;
    private static final float FUNCTION_KEY_TEXT_SIZE_RATIO = 0.055f;
    private static final float NORMAL_BALLOON_TEXT_SIZE_RATIO = 0.14f;
    private static final float FUNCTION_BALLOON_TEXT_SIZE_RATIO = 0.085f;
    private static Environment mInstance;
    private int mScreenWidth;
    private int mScreenHeight;
    private int mKeyHeight;
    private int mCandidatesAreaHeight;
    private int mKeyBalloonWidthPlus;
    private int mKeyBalloonHeightPlus;
    private int mNormalKeyTextSize;
    private int mFunctionKeyTextSize;
    private int mNormalBalloonTextSize;
    private int mFunctionBalloonTextSize;
    private Configuration mConfig = new Configuration();
    private boolean mDebug = false;

    private Environment() {
    }

    public static Environment getInstance() {
        if (null == mInstance) {
            mInstance = new Environment();
        }
        return mInstance;
    }

    public void onConfigurationChanged(Configuration newConfig, Context context) {
        if (this.mConfig.orientation != newConfig.orientation) {
            int scale;
            WindowManager wm = (WindowManager)context.getSystemService("window");
            Display d = wm.getDefaultDisplay();
            this.mScreenWidth = d.getWidth();
            this.mScreenHeight = d.getHeight();
            if (this.mScreenHeight > this.mScreenWidth) {
                this.mKeyHeight = (int)((float)this.mScreenHeight * 0.105f);
                this.mCandidatesAreaHeight = (int)((float)this.mScreenHeight * 0.084f);
                scale = this.mScreenWidth;
            } else {
                this.mKeyHeight = (int)((float)this.mScreenHeight * 0.147f);
                this.mCandidatesAreaHeight = (int)((float)this.mScreenHeight * 0.125f);
                scale = this.mScreenHeight;
            }
            this.mNormalKeyTextSize = (int)((float)scale * 0.075f);
            this.mFunctionKeyTextSize = (int)((float)scale * 0.055f);
            this.mNormalBalloonTextSize = (int)((float)scale * 0.14f);
            this.mFunctionBalloonTextSize = (int)((float)scale * 0.085f);
            this.mKeyBalloonWidthPlus = (int)((float)scale * 0.08f);
            this.mKeyBalloonHeightPlus = (int)((float)scale * 0.07f);
        }
        this.mConfig.updateFrom(newConfig);
    }

    public Configuration getConfiguration() {
        return this.mConfig;
    }

    public int getScreenWidth() {
        return this.mScreenWidth;
    }

    public int getScreenHeight() {
        return this.mScreenHeight;
    }

    public int getHeightForCandidates() {
        return this.mCandidatesAreaHeight;
    }

    public float getKeyXMarginFactor() {
        return 1.0f;
    }

    public float getKeyYMarginFactor() {
        if (2 == this.mConfig.orientation) {
            return 0.7f;
        }
        return 1.0f;
    }

    public int getKeyHeight() {
        return this.mKeyHeight;
    }

    public int getKeyBalloonWidthPlus() {
        return this.mKeyBalloonWidthPlus;
    }

    public int getKeyBalloonHeightPlus() {
        return this.mKeyBalloonHeightPlus;
    }

    public int getSkbHeight() {
        if (1 == this.mConfig.orientation) {
            return this.mKeyHeight * 4;
        }
        if (2 == this.mConfig.orientation) {
            return this.mKeyHeight * 4;
        }
        return 0;
    }

    public int getKeyTextSize(boolean isFunctionKey) {
        if (isFunctionKey) {
            return this.mFunctionKeyTextSize;
        }
        return this.mNormalKeyTextSize;
    }

    public int getBalloonTextSize(boolean isFunctionKey) {
        if (isFunctionKey) {
            return this.mFunctionBalloonTextSize;
        }
        return this.mNormalBalloonTextSize;
    }

    public boolean hasHardKeyboard() {
        return this.mConfig.keyboard != 1 && this.mConfig.hardKeyboardHidden != 2;
    }

    public boolean needDebug() {
        return this.mDebug;
    }
}

