/*
 * Decompiled with CFR 0.152.
 */
package com.android.inputmethod.pinyin;

import android.content.Context;
import android.media.AudioManager;

public class SoundManager {
    private static SoundManager mInstance = null;
    private Context mContext;
    private AudioManager mAudioManager;
    private final float FX_VOLUME = -1.0f;
    private boolean mSilentMode;

    private SoundManager(Context context) {
        this.mContext = context;
        this.updateRingerMode();
    }

    public void updateRingerMode() {
        if (this.mAudioManager == null) {
            this.mAudioManager = (AudioManager)this.mContext.getSystemService("audio");
        }
        this.mSilentMode = this.mAudioManager.getRingerMode() != 2;
    }

    public static SoundManager getInstance(Context context) {
        if (null == mInstance && null != context) {
            mInstance = new SoundManager(context);
        }
        return mInstance;
    }

    public void playKeyDown() {
        if (this.mAudioManager == null) {
            this.updateRingerMode();
        }
        if (!this.mSilentMode) {
            int sound = 5;
            this.mAudioManager.playSoundEffect(sound, -1.0f);
        }
    }
}

