/*
 * Decompiled with CFR 0.152.
 */
package com.android.inputmethod.pinyin;

import android.graphics.Rect;
import android.graphics.drawable.Drawable;
import com.android.inputmethod.pinyin.Environment;
import com.android.inputmethod.pinyin.InputModeSwitcher;
import com.android.inputmethod.pinyin.SkbTemplate;
import com.android.inputmethod.pinyin.SoftKey;
import com.android.inputmethod.pinyin.SoftKeyToggle;
import java.util.ArrayList;
import java.util.List;

public class SoftKeyboard {
    private int mSkbXmlId;
    private boolean mCacheFlag;
    private boolean mStickyFlag;
    private int mCacheId;
    private boolean mNewlyLoadedFlag = true;
    private int mSkbCoreWidth;
    private int mSkbCoreHeight;
    private SkbTemplate mSkbTemplate;
    private boolean mIsQwerty;
    private boolean mIsQwertyUpperCase;
    private int mEnabledRowId;
    private List<KeyRow> mKeyRows;
    public Drawable mSkbBg;
    private Drawable mBalloonBg;
    private Drawable mPopupBg;
    private float mKeyXMargin = 0.0f;
    private float mKeyYMargin = 0.0f;
    private Rect mTmpRect = new Rect();

    public SoftKeyboard(int skbXmlId, SkbTemplate skbTemplate, int skbWidth, int skbHeight) {
        this.mSkbXmlId = skbXmlId;
        this.mSkbTemplate = skbTemplate;
        this.mSkbCoreWidth = skbWidth;
        this.mSkbCoreHeight = skbHeight;
    }

    public void setFlags(boolean cacheFlag, boolean stickyFlag, boolean isQwerty, boolean isQwertyUpperCase) {
        this.mCacheFlag = cacheFlag;
        this.mStickyFlag = stickyFlag;
        this.mIsQwerty = isQwerty;
        this.mIsQwertyUpperCase = isQwertyUpperCase;
    }

    public boolean getCacheFlag() {
        return this.mCacheFlag;
    }

    public void setCacheId(int cacheId) {
        this.mCacheId = cacheId;
    }

    public boolean getStickyFlag() {
        return this.mStickyFlag;
    }

    public void setSkbBackground(Drawable skbBg) {
        this.mSkbBg = skbBg;
    }

    public void setPopupBackground(Drawable popupBg) {
        this.mPopupBg = popupBg;
    }

    public void setKeyBalloonBackground(Drawable balloonBg) {
        this.mBalloonBg = balloonBg;
    }

    public void setKeyMargins(float xMargin, float yMargin) {
        this.mKeyXMargin = xMargin;
        this.mKeyYMargin = yMargin;
    }

    public int getCacheId() {
        return this.mCacheId;
    }

    public void reset() {
        if (null != this.mKeyRows) {
            this.mKeyRows.clear();
        }
    }

    public void setNewlyLoadedFlag(boolean newlyLoadedFlag) {
        this.mNewlyLoadedFlag = newlyLoadedFlag;
    }

    public boolean getNewlyLoadedFlag() {
        return this.mNewlyLoadedFlag;
    }

    public void beginNewRow(int rowId, float yStartingPos) {
        if (null == this.mKeyRows) {
            this.mKeyRows = new ArrayList<KeyRow>();
        }
        KeyRow keyRow = new KeyRow();
        keyRow.mRowId = rowId;
        keyRow.mTopF = yStartingPos;
        keyRow.mBottomF = yStartingPos;
        keyRow.mSoftKeys = new ArrayList<SoftKey>();
        this.mKeyRows.add(keyRow);
    }

    public boolean addSoftKey(SoftKey softKey) {
        if (this.mKeyRows.size() == 0) {
            return false;
        }
        KeyRow keyRow = this.mKeyRows.get(this.mKeyRows.size() - 1);
        if (null == keyRow) {
            return false;
        }
        List<SoftKey> softKeys = keyRow.mSoftKeys;
        softKey.setSkbCoreSize(this.mSkbCoreWidth, this.mSkbCoreHeight);
        softKeys.add(softKey);
        if (softKey.mTopF < keyRow.mTopF) {
            keyRow.mTopF = softKey.mTopF;
        }
        if (softKey.mBottomF > keyRow.mBottomF) {
            keyRow.mBottomF = softKey.mBottomF;
        }
        return true;
    }

    public int getSkbXmlId() {
        return this.mSkbXmlId;
    }

    public void setSkbCoreSize(int skbCoreWidth, int skbCoreHeight) {
        if (null == this.mKeyRows || skbCoreWidth == this.mSkbCoreWidth && skbCoreHeight == this.mSkbCoreHeight) {
            return;
        }
        for (int row = 0; row < this.mKeyRows.size(); ++row) {
            KeyRow keyRow = this.mKeyRows.get(row);
            keyRow.mBottom = (int)((float)skbCoreHeight * keyRow.mBottomF);
            keyRow.mTop = (int)((float)skbCoreHeight * keyRow.mTopF);
            List<SoftKey> softKeys = keyRow.mSoftKeys;
            for (int i = 0; i < softKeys.size(); ++i) {
                SoftKey softKey = softKeys.get(i);
                softKey.setSkbCoreSize(skbCoreWidth, skbCoreHeight);
            }
        }
        this.mSkbCoreWidth = skbCoreWidth;
        this.mSkbCoreHeight = skbCoreHeight;
    }

    public int getSkbCoreWidth() {
        return this.mSkbCoreWidth;
    }

    public int getSkbCoreHeight() {
        return this.mSkbCoreHeight;
    }

    public int getSkbTotalWidth() {
        Rect padding = this.getPadding();
        return this.mSkbCoreWidth + padding.left + padding.right;
    }

    public int getSkbTotalHeight() {
        Rect padding = this.getPadding();
        return this.mSkbCoreHeight + padding.top + padding.bottom;
    }

    public int getKeyXMargin() {
        Environment env = Environment.getInstance();
        return (int)(this.mKeyXMargin * (float)this.mSkbCoreWidth * env.getKeyXMarginFactor());
    }

    public int getKeyYMargin() {
        Environment env = Environment.getInstance();
        return (int)(this.mKeyYMargin * (float)this.mSkbCoreHeight * env.getKeyYMarginFactor());
    }

    public Drawable getSkbBackground() {
        if (null != this.mSkbBg) {
            return this.mSkbBg;
        }
        return this.mSkbTemplate.getSkbBackground();
    }

    public Drawable getBalloonBackground() {
        if (null != this.mBalloonBg) {
            return this.mBalloonBg;
        }
        return this.mSkbTemplate.getBalloonBackground();
    }

    public Drawable getPopupBackground() {
        if (null != this.mPopupBg) {
            return this.mPopupBg;
        }
        return this.mSkbTemplate.getPopupBackground();
    }

    public int getRowNum() {
        if (null != this.mKeyRows) {
            return this.mKeyRows.size();
        }
        return 0;
    }

    public KeyRow getKeyRowForDisplay(int row) {
        if (null != this.mKeyRows && this.mKeyRows.size() > row) {
            KeyRow keyRow = this.mKeyRows.get(row);
            if (-1 == keyRow.mRowId || keyRow.mRowId == this.mEnabledRowId) {
                return keyRow;
            }
        }
        return null;
    }

    public SoftKey getKey(int row, int location) {
        List<SoftKey> softKeys;
        if (null != this.mKeyRows && this.mKeyRows.size() > row && (softKeys = this.mKeyRows.get((int)row).mSoftKeys).size() > location) {
            return softKeys.get(location);
        }
        return null;
    }

    public SoftKey mapToKey(int x, int y) {
        if (null == this.mKeyRows) {
            return null;
        }
        int rowNum = this.mKeyRows.size();
        for (int row = 0; row < rowNum; ++row) {
            KeyRow keyRow = this.mKeyRows.get(row);
            if (-1 != keyRow.mRowId && keyRow.mRowId != this.mEnabledRowId || keyRow.mTop > y && keyRow.mBottom <= y) continue;
            List<SoftKey> softKeys = keyRow.mSoftKeys;
            int keyNum = softKeys.size();
            for (int i = 0; i < keyNum; ++i) {
                SoftKey sKey = softKeys.get(i);
                if (sKey.mLeft > x || sKey.mTop > y || sKey.mRight <= x || sKey.mBottom <= y) continue;
                return sKey;
            }
        }
        SoftKey nearestKey = null;
        float nearestDis = Float.MAX_VALUE;
        for (int row = 0; row < rowNum; ++row) {
            KeyRow keyRow = this.mKeyRows.get(row);
            if (-1 != keyRow.mRowId && keyRow.mRowId != this.mEnabledRowId || keyRow.mTop > y && keyRow.mBottom <= y) continue;
            List<SoftKey> softKeys = keyRow.mSoftKeys;
            int keyNum = softKeys.size();
            for (int i = 0; i < keyNum; ++i) {
                SoftKey sKey = softKeys.get(i);
                int disx = (sKey.mLeft + sKey.mRight) / 2 - x;
                int disy = (sKey.mTop + sKey.mBottom) / 2 - y;
                float dis = disx * disx + disy * disy;
                if (!(dis < nearestDis)) continue;
                nearestDis = dis;
                nearestKey = sKey;
            }
        }
        return nearestKey;
    }

    public void switchQwertyMode(int toggle_state_id, boolean upperCase) {
        if (!this.mIsQwerty) {
            return;
        }
        int rowNum = this.mKeyRows.size();
        for (int row = 0; row < rowNum; ++row) {
            KeyRow keyRow = this.mKeyRows.get(row);
            List<SoftKey> softKeys = keyRow.mSoftKeys;
            int keyNum = softKeys.size();
            for (int i = 0; i < keyNum; ++i) {
                SoftKey sKey = softKeys.get(i);
                if (sKey instanceof SoftKeyToggle) {
                    ((SoftKeyToggle)sKey).enableToggleState(toggle_state_id, true);
                }
                if (sKey.mKeyCode < 29 || sKey.mKeyCode > 54) continue;
                sKey.changeCase(upperCase);
            }
        }
    }

    public void enableToggleState(int toggleStateId, boolean resetIfNotFound) {
        int rowNum = this.mKeyRows.size();
        for (int row = 0; row < rowNum; ++row) {
            KeyRow keyRow = this.mKeyRows.get(row);
            List<SoftKey> softKeys = keyRow.mSoftKeys;
            int keyNum = softKeys.size();
            for (int i = 0; i < keyNum; ++i) {
                SoftKey sKey = softKeys.get(i);
                if (!(sKey instanceof SoftKeyToggle)) continue;
                ((SoftKeyToggle)sKey).enableToggleState(toggleStateId, resetIfNotFound);
            }
        }
    }

    public void disableToggleState(int toggleStateId, boolean resetIfNotFound) {
        int rowNum = this.mKeyRows.size();
        for (int row = 0; row < rowNum; ++row) {
            KeyRow keyRow = this.mKeyRows.get(row);
            List<SoftKey> softKeys = keyRow.mSoftKeys;
            int keyNum = softKeys.size();
            for (int i = 0; i < keyNum; ++i) {
                SoftKey sKey = softKeys.get(i);
                if (!(sKey instanceof SoftKeyToggle)) continue;
                ((SoftKeyToggle)sKey).disableToggleState(toggleStateId, resetIfNotFound);
            }
        }
    }

    public void enableToggleStates(InputModeSwitcher.ToggleStates toggleStates) {
        if (null == toggleStates) {
            return;
        }
        this.enableRow(toggleStates.mRowIdToEnable);
        boolean isQwerty = toggleStates.mQwerty;
        boolean isQwertyUpperCase = toggleStates.mQwertyUpperCase;
        boolean needUpdateQwerty = isQwerty && this.mIsQwerty && this.mIsQwertyUpperCase != isQwertyUpperCase;
        int[] states = toggleStates.mKeyStates;
        int statesNum = toggleStates.mKeyStatesNum;
        int rowNum = this.mKeyRows.size();
        for (int row = 0; row < rowNum; ++row) {
            KeyRow keyRow = this.mKeyRows.get(row);
            if (-1 != keyRow.mRowId && keyRow.mRowId != this.mEnabledRowId) continue;
            List<SoftKey> softKeys = keyRow.mSoftKeys;
            int keyNum = softKeys.size();
            for (int keyPos = 0; keyPos < keyNum; ++keyPos) {
                SoftKey sKey = softKeys.get(keyPos);
                if (sKey instanceof SoftKeyToggle) {
                    for (int statePos = 0; statePos < statesNum; ++statePos) {
                        ((SoftKeyToggle)sKey).enableToggleState(states[statePos], statePos == 0);
                    }
                    if (0 == statesNum) {
                        ((SoftKeyToggle)sKey).disableAllToggleStates();
                    }
                }
                if (!needUpdateQwerty || sKey.mKeyCode < 29 || sKey.mKeyCode > 54) continue;
                sKey.changeCase(isQwertyUpperCase);
            }
        }
        this.mIsQwertyUpperCase = isQwertyUpperCase;
    }

    private Rect getPadding() {
        this.mTmpRect.set(0, 0, 0, 0);
        Drawable skbBg = this.getSkbBackground();
        if (null == skbBg) {
            return this.mTmpRect;
        }
        skbBg.getPadding(this.mTmpRect);
        return this.mTmpRect;
    }

    private boolean enableRow(int rowId) {
        if (-1 == rowId) {
            return false;
        }
        boolean enabled = false;
        int rowNum = this.mKeyRows.size();
        for (int row = rowNum - 1; row >= 0; --row) {
            if (this.mKeyRows.get((int)row).mRowId != rowId) continue;
            enabled = true;
            break;
        }
        if (enabled) {
            this.mEnabledRowId = rowId;
        }
        return enabled;
    }

    public String toString() {
        String str = "------------------SkbInfo----------------------\n";
        String endStr = "-----------------------------------------------\n";
        str = str + "Width: " + String.valueOf(this.mSkbCoreWidth) + "\n";
        str = str + "Height: " + String.valueOf(this.mSkbCoreHeight) + "\n";
        str = str + ("KeyRowNum: " + this.mKeyRows == null ? "0" : String.valueOf(this.mKeyRows.size()) + "\n");
        if (null == this.mKeyRows) {
            return str + endStr;
        }
        int rowNum = this.mKeyRows.size();
        for (int row = 0; row < rowNum; ++row) {
            KeyRow keyRow = this.mKeyRows.get(row);
            List<SoftKey> softKeys = keyRow.mSoftKeys;
            int keyNum = softKeys.size();
            for (int i = 0; i < softKeys.size(); ++i) {
                str = str + "-key " + String.valueOf(i) + ":" + softKeys.get(i).toString();
            }
        }
        return str + endStr;
    }

    public String toShortString() {
        return super.toString();
    }

    class KeyRow {
        static final int ALWAYS_SHOW_ROW_ID = -1;
        static final int DEFAULT_ROW_ID = 0;
        List<SoftKey> mSoftKeys;
        int mRowId;
        float mTopF;
        float mBottomF;
        int mTop;
        int mBottom;

        KeyRow() {
        }
    }
}

