/*
 * Decompiled with CFR 0.152.
 */
package com.android.inputmethod.pinyin;

import android.graphics.drawable.Drawable;
import com.android.inputmethod.pinyin.SoftKeyType;

public class SoftKey {
    protected static final int KEYMASK_REPEAT = 0x10000000;
    protected static final int KEYMASK_BALLOON = 0x20000000;
    public static final int MAX_MOVE_TOLERANCE_X = 0;
    public static final int MAX_MOVE_TOLERANCE_Y = 0;
    protected int mKeyMask;
    protected SoftKeyType mKeyType;
    protected Drawable mKeyIcon;
    protected Drawable mKeyIconPopup;
    protected String mKeyLabel;
    protected int mKeyCode;
    public int mPopupSkbId;
    public float mLeftF;
    public float mRightF;
    public float mTopF;
    public float mBottomF;
    public int mLeft;
    public int mRight;
    public int mTop;
    public int mBottom;

    public void setKeyType(SoftKeyType keyType, Drawable keyIcon, Drawable keyIconPopup) {
        this.mKeyType = keyType;
        this.mKeyIcon = keyIcon;
        this.mKeyIconPopup = keyIconPopup;
    }

    public void setKeyDimensions(float left, float top, float right, float bottom) {
        this.mLeftF = left;
        this.mTopF = top;
        this.mRightF = right;
        this.mBottomF = bottom;
    }

    public void setKeyAttribute(int keyCode, String label, boolean repeat, boolean balloon) {
        this.mKeyCode = keyCode;
        this.mKeyLabel = label;
        this.mKeyMask = repeat ? (this.mKeyMask |= 0x10000000) : (this.mKeyMask &= 0xEFFFFFFF);
        this.mKeyMask = balloon ? (this.mKeyMask |= 0x20000000) : (this.mKeyMask &= 0xDFFFFFFF);
    }

    public void setPopupSkbId(int popupSkbId) {
        this.mPopupSkbId = popupSkbId;
    }

    public void setSkbCoreSize(int skbWidth, int skbHeight) {
        this.mLeft = (int)(this.mLeftF * (float)skbWidth);
        this.mRight = (int)(this.mRightF * (float)skbWidth);
        this.mTop = (int)(this.mTopF * (float)skbHeight);
        this.mBottom = (int)(this.mBottomF * (float)skbHeight);
    }

    public Drawable getKeyIcon() {
        return this.mKeyIcon;
    }

    public Drawable getKeyIconPopup() {
        if (null != this.mKeyIconPopup) {
            return this.mKeyIconPopup;
        }
        return this.mKeyIcon;
    }

    public int getKeyCode() {
        return this.mKeyCode;
    }

    public String getKeyLabel() {
        return this.mKeyLabel;
    }

    public void changeCase(boolean upperCase) {
        if (null != this.mKeyLabel) {
            this.mKeyLabel = upperCase ? this.mKeyLabel.toUpperCase() : this.mKeyLabel.toLowerCase();
        }
    }

    public Drawable getKeyBg() {
        return this.mKeyType.mKeyBg;
    }

    public Drawable getKeyHlBg() {
        return this.mKeyType.mKeyHlBg;
    }

    public int getColor() {
        return this.mKeyType.mColor;
    }

    public int getColorHl() {
        return this.mKeyType.mColorHl;
    }

    public int getColorBalloon() {
        return this.mKeyType.mColorBalloon;
    }

    public boolean isKeyCodeKey() {
        return this.mKeyCode > 0;
    }

    public boolean isUserDefKey() {
        return this.mKeyCode < 0;
    }

    public boolean isUniStrKey() {
        return null != this.mKeyLabel && this.mKeyCode == 0;
    }

    public boolean needBalloon() {
        return (this.mKeyMask & 0x20000000) != 0;
    }

    public boolean repeatable() {
        return (this.mKeyMask & 0x10000000) != 0;
    }

    public int getPopupResId() {
        return this.mPopupSkbId;
    }

    public int width() {
        return this.mRight - this.mLeft;
    }

    public int height() {
        return this.mBottom - this.mTop;
    }

    public boolean moveWithinKey(int x, int y) {
        return this.mLeft - 0 <= x && this.mTop - 0 <= y && this.mRight + 0 > x && this.mBottom + 0 > y;
    }

    public String toString() {
        String str = "\n";
        str = str + "  keyCode: " + String.valueOf(this.mKeyCode) + "\n";
        str = str + "  keyMask: " + String.valueOf(this.mKeyMask) + "\n";
        str = str + "  keyLabel: " + (this.mKeyLabel == null ? "null" : this.mKeyLabel) + "\n";
        str = str + "  popupResId: " + String.valueOf(this.mPopupSkbId) + "\n";
        str = str + "  Position: " + String.valueOf(this.mLeftF) + ", " + String.valueOf(this.mTopF) + ", " + String.valueOf(this.mRightF) + ", " + String.valueOf(this.mBottomF) + "\n";
        return str;
    }
}

