/*
 * Decompiled with CFR 0.152.
 */
package com.android.inputmethod.pinyin;

import android.graphics.drawable.Drawable;
import com.android.inputmethod.pinyin.KeyIconRecord;
import com.android.inputmethod.pinyin.KeyRecord;
import com.android.inputmethod.pinyin.SoftKey;
import com.android.inputmethod.pinyin.SoftKeyType;
import java.util.Vector;

public class SkbTemplate {
    private int mSkbTemplateId;
    private Drawable mSkbBg;
    private Drawable mBalloonBg;
    private Drawable mPopupBg;
    private float mXMargin = 0.0f;
    private float mYMargin = 0.0f;
    private Vector<SoftKeyType> mKeyTypeList = new Vector();
    private Vector<KeyIconRecord> mKeyIconRecords = new Vector();
    private Vector<KeyRecord> mKeyRecords = new Vector();

    public SkbTemplate(int skbTemplateId) {
        this.mSkbTemplateId = skbTemplateId;
    }

    public int getSkbTemplateId() {
        return this.mSkbTemplateId;
    }

    public void setBackgrounds(Drawable skbBg, Drawable balloonBg, Drawable popupBg) {
        this.mSkbBg = skbBg;
        this.mBalloonBg = balloonBg;
        this.mPopupBg = popupBg;
    }

    public Drawable getSkbBackground() {
        return this.mSkbBg;
    }

    public Drawable getBalloonBackground() {
        return this.mBalloonBg;
    }

    public Drawable getPopupBackground() {
        return this.mPopupBg;
    }

    public void setMargins(float xMargin, float yMargin) {
        this.mXMargin = xMargin;
        this.mYMargin = yMargin;
    }

    public float getXMargin() {
        return this.mXMargin;
    }

    public float getYMargin() {
        return this.mYMargin;
    }

    public SoftKeyType createKeyType(int id2, Drawable bg, Drawable hlBg) {
        return new SoftKeyType(id2, bg, hlBg);
    }

    public boolean addKeyType(SoftKeyType keyType) {
        if (this.mKeyTypeList.size() != keyType.mKeyTypeId) {
            return false;
        }
        this.mKeyTypeList.add(keyType);
        return true;
    }

    public SoftKeyType getKeyType(int typeId) {
        if (typeId < 0 || typeId > this.mKeyTypeList.size()) {
            return null;
        }
        return this.mKeyTypeList.elementAt(typeId);
    }

    public void addDefaultKeyIcons(int keyCode, Drawable icon, Drawable iconPopup) {
        int pos;
        if (null == icon || null == iconPopup) {
            return;
        }
        KeyIconRecord iconRecord = new KeyIconRecord();
        iconRecord.icon = icon;
        iconRecord.iconPopup = iconPopup;
        iconRecord.keyCode = keyCode;
        int size = this.mKeyIconRecords.size();
        for (pos = 0; pos < size && this.mKeyIconRecords.get((int)pos).keyCode < keyCode; ++pos) {
        }
        this.mKeyIconRecords.add(pos, iconRecord);
    }

    public Drawable getDefaultKeyIcon(int keyCode) {
        int size = this.mKeyIconRecords.size();
        for (int pos = 0; pos < size; ++pos) {
            KeyIconRecord iconRecord = this.mKeyIconRecords.get(pos);
            if (iconRecord.keyCode < keyCode) {
                continue;
            }
            if (iconRecord.keyCode == keyCode) {
                return iconRecord.icon;
            }
            return null;
        }
        return null;
    }

    public Drawable getDefaultKeyIconPopup(int keyCode) {
        int size = this.mKeyIconRecords.size();
        for (int pos = 0; pos < size; ++pos) {
            KeyIconRecord iconRecord = this.mKeyIconRecords.get(pos);
            if (iconRecord.keyCode < keyCode) {
                continue;
            }
            if (iconRecord.keyCode == keyCode) {
                return iconRecord.iconPopup;
            }
            return null;
        }
        return null;
    }

    public void addDefaultKey(int keyId, SoftKey softKey) {
        int pos;
        if (null == softKey) {
            return;
        }
        KeyRecord keyRecord = new KeyRecord();
        keyRecord.keyId = keyId;
        keyRecord.softKey = softKey;
        int size = this.mKeyRecords.size();
        for (pos = 0; pos < size && this.mKeyRecords.get((int)pos).keyId < keyId; ++pos) {
        }
        this.mKeyRecords.add(pos, keyRecord);
    }

    public SoftKey getDefaultKey(int keyId) {
        int size = this.mKeyRecords.size();
        for (int pos = 0; pos < size; ++pos) {
            KeyRecord keyRecord = this.mKeyRecords.get(pos);
            if (keyRecord.keyId < keyId) {
                continue;
            }
            if (keyRecord.keyId == keyId) {
                return keyRecord.softKey;
            }
            return null;
        }
        return null;
    }
}

