/*
 * Decompiled with CFR 0.152.
 */
package com.android.inputmethod.pinyin;

import android.content.Context;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.os.Bundle;
import android.preference.CheckBoxPreference;
import android.preference.Preference;
import android.preference.PreferenceActivity;
import android.preference.PreferenceGroup;
import android.preference.PreferenceManager;
import android.preference.PreferenceScreen;
import com.android.inputmethod.pinyin.Settings;
import java.util.List;

public class SettingsActivity
extends PreferenceActivity
implements Preference.OnPreferenceChangeListener {
    private static String TAG = "SettingsActivity";
    private CheckBoxPreference mKeySoundPref;
    private CheckBoxPreference mVibratePref;
    private CheckBoxPreference mPredictionPref;

    protected void onCreate(Bundle savedInstanceState) {
        super.onCreate(savedInstanceState);
        this.addPreferencesFromResource(2130968577);
        PreferenceScreen prefSet = this.getPreferenceScreen();
        this.mKeySoundPref = (CheckBoxPreference)prefSet.findPreference((CharSequence)this.getString(2131296276));
        this.mVibratePref = (CheckBoxPreference)prefSet.findPreference((CharSequence)this.getString(2131296277));
        this.mPredictionPref = (CheckBoxPreference)prefSet.findPreference((CharSequence)this.getString(2131296278));
        prefSet.setOnPreferenceChangeListener((Preference.OnPreferenceChangeListener)this);
        Settings.getInstance(PreferenceManager.getDefaultSharedPreferences((Context)this.getApplicationContext()));
        this.updatePreference((PreferenceGroup)prefSet, this.getString(2131296280));
        this.updateWidgets();
    }

    protected void onResume() {
        super.onResume();
        this.updateWidgets();
    }

    protected void onDestroy() {
        Settings.releaseInstance();
        super.onDestroy();
    }

    protected void onPause() {
        super.onPause();
        Settings.setKeySound(this.mKeySoundPref.isChecked());
        Settings.setVibrate(this.mVibratePref.isChecked());
        Settings.setPrediction(this.mPredictionPref.isChecked());
        Settings.writeBack();
    }

    public boolean onPreferenceChange(Preference preference, Object newValue) {
        return true;
    }

    private void updateWidgets() {
        this.mKeySoundPref.setChecked(Settings.getKeySound());
        this.mVibratePref.setChecked(Settings.getVibrate());
        this.mPredictionPref.setChecked(Settings.getPrediction());
    }

    public void updatePreference(PreferenceGroup parentPref, String prefKey) {
        PackageManager pm;
        List list;
        int listSize;
        Preference preference = parentPref.findPreference((CharSequence)prefKey);
        if (preference == null) {
            return;
        }
        Intent intent = preference.getIntent();
        if (intent != null && (listSize = (list = (pm = this.getPackageManager()).queryIntentActivities(intent, 0)).size()) == 0) {
            parentPref.removePreference(preference);
        }
    }
}

