/*
 * Decompiled with CFR 0.152.
 */
package com.android.inputmethod.pinyin;

import android.content.SharedPreferences;

public class Settings {
    private static final String ANDPY_CONFS_KEYSOUND_KEY = "Sound";
    private static final String ANDPY_CONFS_VIBRATE_KEY = "Vibrate";
    private static final String ANDPY_CONFS_PREDICTION_KEY = "Prediction";
    private static boolean mKeySound;
    private static boolean mVibrate;
    private static boolean mPrediction;
    private static Settings mInstance;
    private static int mRefCount;
    private static SharedPreferences mSharedPref;

    protected Settings(SharedPreferences pref) {
        mSharedPref = pref;
        this.initConfs();
    }

    public static Settings getInstance(SharedPreferences pref) {
        if (mInstance == null) {
            mInstance = new Settings(pref);
        }
        assert (pref == mSharedPref);
        ++mRefCount;
        return mInstance;
    }

    public static void writeBack() {
        SharedPreferences.Editor editor = mSharedPref.edit();
        editor.putBoolean(ANDPY_CONFS_VIBRATE_KEY, mVibrate);
        editor.putBoolean(ANDPY_CONFS_KEYSOUND_KEY, mKeySound);
        editor.putBoolean(ANDPY_CONFS_PREDICTION_KEY, mPrediction);
        editor.commit();
    }

    public static void releaseInstance() {
        if (--mRefCount == 0) {
            mInstance = null;
        }
    }

    private void initConfs() {
        mKeySound = mSharedPref.getBoolean(ANDPY_CONFS_KEYSOUND_KEY, true);
        mVibrate = mSharedPref.getBoolean(ANDPY_CONFS_VIBRATE_KEY, false);
        mPrediction = mSharedPref.getBoolean(ANDPY_CONFS_PREDICTION_KEY, true);
    }

    public static boolean getKeySound() {
        return mKeySound;
    }

    public static void setKeySound(boolean v) {
        if (mKeySound == v) {
            return;
        }
        mKeySound = v;
    }

    public static boolean getVibrate() {
        return mVibrate;
    }

    public static void setVibrate(boolean v) {
        if (mVibrate == v) {
            return;
        }
        mVibrate = v;
    }

    public static boolean getPrediction() {
        return mPrediction;
    }

    public static void setPrediction(boolean v) {
        if (mPrediction == v) {
            return;
        }
        mPrediction = v;
    }

    static {
        mInstance = null;
        mRefCount = 0;
        mSharedPref = null;
    }
}

