/*
 * Decompiled with CFR 0.152.
 */
package com.android.inputmethod.pinyin;

import android.content.res.Resources;
import android.view.inputmethod.EditorInfo;
import com.android.inputmethod.pinyin.Environment;
import com.android.inputmethod.pinyin.PinyinIME;

public class InputModeSwitcher {
    private static final int USERDEF_KEYCODE_SHIFT_1 = -1;
    private static final int USERDEF_KEYCODE_LANG_2 = -2;
    private static final int USERDEF_KEYCODE_SYM_3 = -3;
    public static final int USERDEF_KEYCODE_PHONE_SYM_4 = -4;
    private static final int USERDEF_KEYCODE_MORE_SYM_5 = -5;
    private static final int USERDEF_KEYCODE_SMILEY_6 = -6;
    private static final int MASK_SKB_LAYOUT = -268435456;
    private static final int MASK_SKB_LAYOUT_QWERTY = 0x10000000;
    private static final int MASK_SKB_LAYOUT_SYMBOL1 = 0x20000000;
    private static final int MASK_SKB_LAYOUT_SYMBOL2 = 0x30000000;
    private static final int MASK_SKB_LAYOUT_SMILEY = 0x40000000;
    private static final int MASK_SKB_LAYOUT_PHONE = 0x50000000;
    private static final int MASK_LANGUAGE = 0xF000000;
    private static final int MASK_LANGUAGE_CN = 0x1000000;
    private static final int MASK_LANGUAGE_EN = 0x2000000;
    private static final int MASK_CASE = 0xF00000;
    private static final int MASK_CASE_LOWER = 0x100000;
    private static final int MASK_CASE_UPPER = 0x200000;
    public static final int MODE_SKB_CHINESE = 0x11000000;
    public static final int MODE_SKB_SYMBOL1_CN = 0x21000000;
    public static final int MODE_SKB_SYMBOL2_CN = 0x31000000;
    public static final int MODE_SKB_ENGLISH_LOWER = 0x12100000;
    public static final int MODE_SKB_ENGLISH_UPPER = 0x12200000;
    public static final int MODE_SKB_SYMBOL1_EN = 0x22000000;
    public static final int MODE_SKB_SYMBOL2_EN = 0x32000000;
    public static final int MODE_SKB_SMILEY = 0x41000000;
    public static final int MODE_SKB_PHONE_NUM = 0x50000000;
    public static final int MODE_SKB_PHONE_SYM = 0x50200000;
    public static final int MODE_HKB_CHINESE = 0x1000000;
    public static final int MODE_HKB_ENGLISH = 0x2000000;
    public static final int MODE_UNSET = 0;
    public static final int MAX_TOGGLE_STATES = 4;
    private int mInputMode = 0;
    private int mPreviousInputMode = 0x11000000;
    private int mRecentLauageInputMode = 0x11000000;
    private EditorInfo mEditorInfo;
    private ToggleStates mToggleStates = new ToggleStates();
    private boolean mShortMessageField;
    private boolean mEnterKeyNormal = true;
    int mInputIcon = 2130837563;
    private PinyinIME mImeService;
    private int mToggleStateCn;
    private int mToggleStateCnCand;
    private int mToggleStateEnLower;
    private int mToggleStateEnUpper;
    private int mToggleStateEnSym1;
    private int mToggleStateEnSym2;
    private int mToggleStateSmiley;
    private int mToggleStatePhoneSym;
    private int mToggleStateGo;
    private int mToggleStateSearch;
    private int mToggleStateSend;
    private int mToggleStateNext;
    private int mToggleStateDone;
    private int mToggleRowCn;
    private int mToggleRowEn;
    private int mToggleRowUri;
    private int mToggleRowEmailAddress;

    public InputModeSwitcher(PinyinIME imeService) {
        this.mImeService = imeService;
        Resources r = this.mImeService.getResources();
        this.mToggleStateCn = Integer.parseInt(r.getString(2131296259));
        this.mToggleStateCnCand = Integer.parseInt(r.getString(2131296260));
        this.mToggleStateEnLower = Integer.parseInt(r.getString(2131296261));
        this.mToggleStateEnUpper = Integer.parseInt(r.getString(2131296262));
        this.mToggleStateEnSym1 = Integer.parseInt(r.getString(2131296263));
        this.mToggleStateEnSym2 = Integer.parseInt(r.getString(2131296264));
        this.mToggleStateSmiley = Integer.parseInt(r.getString(2131296265));
        this.mToggleStatePhoneSym = Integer.parseInt(r.getString(2131296275));
        this.mToggleStateGo = Integer.parseInt(r.getString(2131296266));
        this.mToggleStateSearch = Integer.parseInt(r.getString(2131296267));
        this.mToggleStateSend = Integer.parseInt(r.getString(2131296268));
        this.mToggleStateNext = Integer.parseInt(r.getString(2131296269));
        this.mToggleStateDone = Integer.parseInt(r.getString(2131296270));
        this.mToggleRowCn = Integer.parseInt(r.getString(2131296271));
        this.mToggleRowEn = Integer.parseInt(r.getString(2131296272));
        this.mToggleRowUri = Integer.parseInt(r.getString(2131296273));
        this.mToggleRowEmailAddress = Integer.parseInt(r.getString(2131296274));
    }

    public int getInputMode() {
        return this.mInputMode;
    }

    public ToggleStates getToggleStates() {
        return this.mToggleStates;
    }

    public int getSkbLayout() {
        int layout2 = this.mInputMode & 0xF0000000;
        switch (layout2) {
            case 0x10000000: {
                return 2130968579;
            }
            case 0x20000000: {
                return 2130968581;
            }
            case 0x30000000: {
                return 2130968582;
            }
            case 0x40000000: {
                return 2130968580;
            }
            case 0x50000000: {
                return 2130968578;
            }
        }
        return 0;
    }

    public int switchLanguageWithHkb() {
        int newInputMode = 0x1000000;
        this.mInputIcon = 2130837563;
        if (0x1000000 == this.mInputMode) {
            newInputMode = 0x2000000;
            this.mInputIcon = 2130837562;
        }
        this.saveInputMode(newInputMode);
        return this.mInputIcon;
    }

    public int switchModeForUserKey(int userKey) {
        int newInputMode = 0;
        if (-2 == userKey) {
            if (0x11000000 == this.mInputMode) {
                newInputMode = 0x12100000;
            } else if (0x12100000 == this.mInputMode || 0x12200000 == this.mInputMode) {
                newInputMode = 0x11000000;
            } else if (0x21000000 == this.mInputMode) {
                newInputMode = 0x22000000;
            } else if (0x22000000 == this.mInputMode) {
                newInputMode = 0x21000000;
            } else if (0x31000000 == this.mInputMode) {
                newInputMode = 0x32000000;
            } else if (0x32000000 == this.mInputMode) {
                newInputMode = 0x31000000;
            } else if (0x41000000 == this.mInputMode) {
                newInputMode = 0x11000000;
            }
        } else if (-3 == userKey) {
            if (0x11000000 == this.mInputMode) {
                newInputMode = 0x21000000;
            } else if (0x12200000 == this.mInputMode || 0x12100000 == this.mInputMode) {
                newInputMode = 0x22000000;
            } else if (0x22000000 == this.mInputMode || 0x32000000 == this.mInputMode) {
                newInputMode = 0x12100000;
            } else if (0x21000000 == this.mInputMode || 0x31000000 == this.mInputMode) {
                newInputMode = 0x11000000;
            } else if (0x41000000 == this.mInputMode) {
                newInputMode = 0x21000000;
            }
        } else if (-1 == userKey) {
            if (0x12100000 == this.mInputMode) {
                newInputMode = 0x12200000;
            } else if (0x12200000 == this.mInputMode) {
                newInputMode = 0x12100000;
            }
        } else if (-5 == userKey) {
            int sym = 0xF0000000 & this.mInputMode;
            sym = 0x20000000 == sym ? 0x30000000 : 0x20000000;
            newInputMode = this.mInputMode & 0xFFFFFFF | sym;
        } else if (-6 == userKey) {
            newInputMode = 0x11000000 == this.mInputMode ? 0x41000000 : 0x11000000;
        } else if (-4 == userKey) {
            newInputMode = 0x50000000 == this.mInputMode ? 0x50200000 : 0x50000000;
        }
        if (newInputMode == this.mInputMode || 0 == newInputMode) {
            return this.mInputIcon;
        }
        this.saveInputMode(newInputMode);
        this.prepareToggleStates(true);
        return this.mInputIcon;
    }

    public int requestInputWithHkb(EditorInfo editorInfo) {
        this.mShortMessageField = false;
        boolean english = false;
        int newInputMode = 0x1000000;
        switch (editorInfo.inputType & 0xF) {
            case 2: 
            case 3: 
            case 4: {
                english = true;
                break;
            }
            case 1: {
                int v = editorInfo.inputType & 0xFF0;
                if (v == 32 || v == 128 || v == 144 || v == 16) {
                    english = true;
                    break;
                }
                if (v != 64) break;
                this.mShortMessageField = true;
                break;
            }
        }
        newInputMode = english ? 0x2000000 : ((this.mRecentLauageInputMode & 0xF000000) == 0x1000000 ? 0x1000000 : 0x2000000);
        this.mEditorInfo = editorInfo;
        this.saveInputMode(newInputMode);
        this.prepareToggleStates(false);
        return this.mInputIcon;
    }

    public int requestInputWithSkb(EditorInfo editorInfo) {
        this.mShortMessageField = false;
        int newInputMode = 0x11000000;
        switch (editorInfo.inputType & 0xF) {
            case 2: 
            case 4: {
                newInputMode = 0x22000000;
                break;
            }
            case 3: {
                newInputMode = 0x50000000;
                break;
            }
            case 1: {
                int v = editorInfo.inputType & 0xFF0;
                if (v == 32 || v == 128 || v == 144 || v == 16) {
                    newInputMode = 0x12100000;
                    break;
                }
                if (v == 64) {
                    this.mShortMessageField = true;
                }
                int skbLayout = this.mInputMode & 0xF0000000;
                newInputMode = this.mInputMode;
                if (0 != skbLayout) break;
                if ((this.mInputMode & 0xF000000) == 0x1000000) {
                    newInputMode = 0x11000000;
                    break;
                }
                newInputMode = 0x12100000;
                break;
            }
            default: {
                int skbLayout = this.mInputMode & 0xF0000000;
                newInputMode = this.mInputMode;
                if (0 != skbLayout) break;
                newInputMode = (this.mInputMode & 0xF000000) == 0x1000000 ? 0x11000000 : 0x12100000;
            }
        }
        this.mEditorInfo = editorInfo;
        this.saveInputMode(newInputMode);
        this.prepareToggleStates(true);
        return this.mInputIcon;
    }

    public int requestBackToPreviousSkb() {
        int layout2 = this.mInputMode & 0xF0000000;
        int lastLayout = this.mPreviousInputMode & 0xF0000000;
        if (0 != layout2 && 0 != lastLayout) {
            this.mInputMode = this.mPreviousInputMode;
            this.saveInputMode(this.mInputMode);
            this.prepareToggleStates(true);
            return this.mInputIcon;
        }
        return 0;
    }

    public int getTooggleStateForCnCand() {
        return this.mToggleStateCnCand;
    }

    public boolean isEnglishWithHkb() {
        return 0x2000000 == this.mInputMode;
    }

    public boolean isEnglishWithSkb() {
        return 0x12100000 == this.mInputMode || 0x12200000 == this.mInputMode;
    }

    public boolean isEnglishUpperCaseWithSkb() {
        return 0x12200000 == this.mInputMode;
    }

    public boolean isChineseText() {
        int language;
        int skbLayout = this.mInputMode & 0xF0000000;
        return (0x10000000 == skbLayout || 0 == skbLayout) && 0x1000000 == (language = this.mInputMode & 0xF000000);
    }

    public boolean isChineseTextWithHkb() {
        int language;
        int skbLayout = this.mInputMode & 0xF0000000;
        return 0 == skbLayout && 0x1000000 == (language = this.mInputMode & 0xF000000);
    }

    public boolean isChineseTextWithSkb() {
        int language;
        int skbLayout = this.mInputMode & 0xF0000000;
        return 0x10000000 == skbLayout && 0x1000000 == (language = this.mInputMode & 0xF000000);
    }

    public boolean isSymbolWithSkb() {
        int skbLayout = this.mInputMode & 0xF0000000;
        return 0x20000000 == skbLayout || 0x30000000 == skbLayout;
    }

    public boolean isEnterNoramlState() {
        return this.mEnterKeyNormal;
    }

    public boolean tryHandleLongPressSwitch(int keyCode) {
        if (-2 == keyCode || -4 == keyCode) {
            this.mImeService.showOptionsMenu();
            return true;
        }
        return false;
    }

    private void saveInputMode(int newInputMode) {
        this.mPreviousInputMode = this.mInputMode;
        this.mInputMode = newInputMode;
        int skbLayout = this.mInputMode & 0xF0000000;
        if (0x10000000 == skbLayout || 0 == skbLayout) {
            this.mRecentLauageInputMode = this.mInputMode;
        }
        this.mInputIcon = 2130837563;
        if (this.isEnglishWithHkb()) {
            this.mInputIcon = 2130837562;
        } else if (this.isChineseTextWithHkb()) {
            this.mInputIcon = 2130837563;
        }
        if (!Environment.getInstance().hasHardKeyboard()) {
            this.mInputIcon = 0;
        }
    }

    private void prepareToggleStates(boolean needSkb) {
        this.mEnterKeyNormal = true;
        if (!needSkb) {
            return;
        }
        this.mToggleStates.mQwerty = false;
        this.mToggleStates.mKeyStatesNum = 0;
        int[] states = this.mToggleStates.mKeyStates;
        int statesNum = 0;
        int language = this.mInputMode & 0xF000000;
        int layout2 = this.mInputMode & 0xF0000000;
        int charcase = this.mInputMode & 0xF00000;
        int variation = this.mEditorInfo.inputType & 0xFF0;
        if (0x50000000 != layout2) {
            if (0x1000000 == language) {
                if (0x10000000 == layout2) {
                    this.mToggleStates.mQwerty = true;
                    this.mToggleStates.mQwertyUpperCase = true;
                    if (this.mShortMessageField) {
                        states[statesNum] = this.mToggleStateSmiley;
                        ++statesNum;
                    }
                }
            } else if (0x2000000 == language) {
                if (0x10000000 == layout2) {
                    this.mToggleStates.mQwerty = true;
                    this.mToggleStates.mQwertyUpperCase = false;
                    states[statesNum] = this.mToggleStateEnLower;
                    if (0x200000 == charcase) {
                        this.mToggleStates.mQwertyUpperCase = true;
                        states[statesNum] = this.mToggleStateEnUpper;
                    }
                    ++statesNum;
                } else if (0x20000000 == layout2) {
                    states[statesNum] = this.mToggleStateEnSym1;
                    ++statesNum;
                } else if (0x30000000 == layout2) {
                    states[statesNum] = this.mToggleStateEnSym2;
                    ++statesNum;
                }
            }
            this.mToggleStates.mRowIdToEnable = 0;
            if (variation == 32) {
                this.mToggleStates.mRowIdToEnable = this.mToggleRowEmailAddress;
            } else if (variation == 16) {
                this.mToggleStates.mRowIdToEnable = this.mToggleRowUri;
            } else if (0x1000000 == language) {
                this.mToggleStates.mRowIdToEnable = this.mToggleRowCn;
            } else if (0x2000000 == language) {
                this.mToggleStates.mRowIdToEnable = this.mToggleRowEn;
            }
        } else if (0x200000 == charcase) {
            states[statesNum] = this.mToggleStatePhoneSym;
            ++statesNum;
        }
        int action = this.mEditorInfo.imeOptions & 0x400000FF;
        if (action == 2) {
            states[statesNum] = this.mToggleStateGo;
            ++statesNum;
            this.mEnterKeyNormal = false;
        } else if (action == 3) {
            states[statesNum] = this.mToggleStateSearch;
            ++statesNum;
            this.mEnterKeyNormal = false;
        } else if (action == 4) {
            states[statesNum] = this.mToggleStateSend;
            ++statesNum;
            this.mEnterKeyNormal = false;
        } else if (action == 5) {
            int f = this.mEditorInfo.inputType & 0xFFF000;
            if (f != 131072) {
                states[statesNum] = this.mToggleStateNext;
                ++statesNum;
                this.mEnterKeyNormal = false;
            }
        } else if (action == 6) {
            states[statesNum] = this.mToggleStateDone;
            ++statesNum;
            this.mEnterKeyNormal = false;
        }
        this.mToggleStates.mKeyStatesNum = statesNum;
    }

    class ToggleStates {
        boolean mQwerty;
        boolean mQwertyUpperCase;
        public int mRowIdToEnable;
        public int[] mKeyStates = new int[4];
        public int mKeyStatesNum;

        ToggleStates() {
        }
    }
}

