/*
 * Decompiled with CFR 0.152.
 */
package com.android.inputmethod.pinyin;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.util.AttributeSet;
import android.view.View;
import com.android.inputmethod.pinyin.PinyinIME;

public class ComposingView
extends View {
    private static final int LEFT_RIGHT_MARGIN = 5;
    private Paint mPaint;
    private Drawable mHlDrawable;
    private Drawable mCursor;
    private Paint.FontMetricsInt mFmi;
    private int mStrColor;
    private int mStrColorHl;
    private int mStrColorIdle;
    private int mFontSize;
    private ComposingStatus mComposingStatus;
    PinyinIME.DecodingInfo mDecInfo;

    public ComposingView(Context context, AttributeSet attrs) {
        super(context, attrs);
        Resources r = context.getResources();
        this.mHlDrawable = r.getDrawable(2130837517);
        this.mCursor = r.getDrawable(2130837516);
        this.mStrColor = r.getColor(0x7F070007);
        this.mStrColorHl = r.getColor(2131165192);
        this.mStrColorIdle = r.getColor(2131165193);
        this.mFontSize = r.getDimensionPixelSize(2131230722);
        this.mPaint = new Paint();
        this.mPaint.setColor(this.mStrColor);
        this.mPaint.setAntiAlias(true);
        this.mPaint.setTextSize((float)this.mFontSize);
        this.mFmi = this.mPaint.getFontMetricsInt();
    }

    public void reset() {
        this.mComposingStatus = ComposingStatus.SHOW_PINYIN;
    }

    public void setDecodingInfo(PinyinIME.DecodingInfo decInfo, PinyinIME.ImeState imeStatus) {
        this.mDecInfo = decInfo;
        if (PinyinIME.ImeState.STATE_INPUT == imeStatus) {
            this.mComposingStatus = ComposingStatus.SHOW_PINYIN;
            this.mDecInfo.moveCursorToEdge(false);
        } else {
            this.mComposingStatus = decInfo.getFixedLen() != 0 || ComposingStatus.EDIT_PINYIN == this.mComposingStatus ? ComposingStatus.EDIT_PINYIN : ComposingStatus.SHOW_STRING_LOWERCASE;
            this.mDecInfo.moveCursor(0);
        }
        this.measure(-2, -2);
        this.requestLayout();
        this.invalidate();
    }

    public boolean moveCursor(int keyCode) {
        if (keyCode != 21 && keyCode != 22) {
            return false;
        }
        if (ComposingStatus.EDIT_PINYIN == this.mComposingStatus) {
            int offset = 0;
            if (keyCode == 21) {
                offset = -1;
            } else if (keyCode == 22) {
                offset = 1;
            }
            this.mDecInfo.moveCursor(offset);
        } else if (ComposingStatus.SHOW_STRING_LOWERCASE == this.mComposingStatus && (keyCode == 21 || keyCode == 22)) {
            this.mComposingStatus = ComposingStatus.EDIT_PINYIN;
            this.measure(-2, -2);
            this.requestLayout();
        }
        this.invalidate();
        return true;
    }

    public ComposingStatus getComposingStatus() {
        return this.mComposingStatus;
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        float width;
        int height = this.mFmi.bottom - this.mFmi.top + this.mPaddingTop + this.mPaddingBottom;
        if (null == this.mDecInfo) {
            width = 0.0f;
        } else {
            width = this.mPaddingLeft + this.mPaddingRight + 10;
            String str = ComposingStatus.SHOW_STRING_LOWERCASE == this.mComposingStatus ? this.mDecInfo.getOrigianlSplStr().toString() : this.mDecInfo.getComposingStrForDisplay();
            width += this.mPaint.measureText(str, 0, str.length());
        }
        this.setMeasuredDimension((int)(width + 0.5f), height);
    }

    protected void onDraw(Canvas canvas) {
        if (ComposingStatus.EDIT_PINYIN == this.mComposingStatus || ComposingStatus.SHOW_PINYIN == this.mComposingStatus) {
            this.drawForPinyin(canvas);
            return;
        }
        float x = this.mPaddingLeft + 5;
        float y = -this.mFmi.top + this.mPaddingTop;
        this.mPaint.setColor(this.mStrColorHl);
        this.mHlDrawable.setBounds(this.mPaddingLeft, this.mPaddingTop, this.getWidth() - this.mPaddingRight, this.getHeight() - this.mPaddingBottom);
        this.mHlDrawable.draw(canvas);
        String splStr = this.mDecInfo.getOrigianlSplStr().toString();
        canvas.drawText(splStr, 0, splStr.length(), x, y, this.mPaint);
    }

    private void drawCursor(Canvas canvas, float x) {
        this.mCursor.setBounds((int)x, this.mPaddingTop, (int)x + this.mCursor.getIntrinsicWidth(), this.getHeight() - this.mPaddingBottom);
        this.mCursor.draw(canvas);
    }

    private void drawForPinyin(Canvas canvas) {
        int cursorPos;
        float x = this.mPaddingLeft + 5;
        float y = -this.mFmi.top + this.mPaddingTop;
        this.mPaint.setColor(this.mStrColor);
        int cmpsPos = cursorPos = this.mDecInfo.getCursorPosInCmpsDisplay();
        String cmpsStr = this.mDecInfo.getComposingStrForDisplay();
        int activeCmpsLen = this.mDecInfo.getActiveCmpsDisplayLen();
        if (cursorPos > activeCmpsLen) {
            cmpsPos = activeCmpsLen;
        }
        canvas.drawText(cmpsStr, 0, cmpsPos, x, y, this.mPaint);
        x += this.mPaint.measureText(cmpsStr, 0, cmpsPos);
        if (cursorPos <= activeCmpsLen) {
            if (ComposingStatus.EDIT_PINYIN == this.mComposingStatus) {
                this.drawCursor(canvas, x);
            }
            canvas.drawText(cmpsStr, cmpsPos, activeCmpsLen, x, y, this.mPaint);
        }
        x += this.mPaint.measureText(cmpsStr, cmpsPos, activeCmpsLen);
        if (cmpsStr.length() > activeCmpsLen) {
            this.mPaint.setColor(this.mStrColorIdle);
            int oriPos = activeCmpsLen;
            if (cursorPos > activeCmpsLen) {
                if (cursorPos > cmpsStr.length()) {
                    cursorPos = cmpsStr.length();
                }
                canvas.drawText(cmpsStr, oriPos, cursorPos, x, y, this.mPaint);
                x += this.mPaint.measureText(cmpsStr, oriPos, cursorPos);
                if (ComposingStatus.EDIT_PINYIN == this.mComposingStatus) {
                    this.drawCursor(canvas, x);
                }
                oriPos = cursorPos;
            }
            canvas.drawText(cmpsStr, oriPos, cmpsStr.length(), x, y, this.mPaint);
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum ComposingStatus {
        SHOW_PINYIN,
        SHOW_STRING_LOWERCASE,
        EDIT_PINYIN;

    }
}

