/*
 * Decompiled with CFR 0.152.
 */
package com.android.inputmethod.pinyin;

import android.content.Context;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import android.view.animation.AlphaAnimation;
import android.view.animation.Animation;
import android.view.animation.AnimationSet;
import android.view.animation.TranslateAnimation;
import android.widget.ImageButton;
import android.widget.RelativeLayout;
import android.widget.ViewFlipper;
import com.android.inputmethod.pinyin.ArrowUpdater;
import com.android.inputmethod.pinyin.BalloonHint;
import com.android.inputmethod.pinyin.CandidateView;
import com.android.inputmethod.pinyin.CandidateViewListener;
import com.android.inputmethod.pinyin.Environment;
import com.android.inputmethod.pinyin.PinyinIME;

public class CandidatesContainer
extends RelativeLayout
implements View.OnTouchListener,
Animation.AnimationListener,
ArrowUpdater {
    private static int ARROW_ALPHA_ENABLED = 255;
    private static int ARROW_ALPHA_DISABLED = 64;
    private static int ANIMATION_TIME = 200;
    private CandidateViewListener mCvListener;
    private ImageButton mLeftArrowBtn;
    private ImageButton mRightArrowBtn;
    private PinyinIME.DecodingInfo mDecInfo;
    private ViewFlipper mFlipper;
    private int xOffsetForFlipper;
    private Animation mInAnimPushLeft;
    private Animation mInAnimPushRight;
    private Animation mInAnimPushUp;
    private Animation mInAnimPushDown;
    private Animation mOutAnimPushLeft;
    private Animation mOutAnimPushRight;
    private Animation mOutAnimPushUp;
    private Animation mOutAnimPushDown;
    private Animation mInAnimInUse;
    private Animation mOutAnimInUse;
    private int mCurrentPage = -1;

    public CandidatesContainer(Context context, AttributeSet attrs) {
        super(context, attrs);
    }

    public void initialize(CandidateViewListener cvListener, BalloonHint balloonHint, GestureDetector gestureDetector) {
        this.mCvListener = cvListener;
        this.mLeftArrowBtn = (ImageButton)this.findViewById(2131361793);
        this.mRightArrowBtn = (ImageButton)this.findViewById(2131361794);
        this.mLeftArrowBtn.setOnTouchListener((View.OnTouchListener)this);
        this.mRightArrowBtn.setOnTouchListener((View.OnTouchListener)this);
        this.mFlipper = (ViewFlipper)this.findViewById(2131361795);
        this.mFlipper.setMeasureAllChildren(true);
        this.invalidate();
        this.requestLayout();
        for (int i = 0; i < this.mFlipper.getChildCount(); ++i) {
            CandidateView cv = (CandidateView)this.mFlipper.getChildAt(i);
            cv.initialize(this, balloonHint, gestureDetector, this.mCvListener);
        }
    }

    public void showCandidates(PinyinIME.DecodingInfo decInfo, boolean enableActiveHighlight) {
        if (null == decInfo) {
            return;
        }
        this.mDecInfo = decInfo;
        this.mCurrentPage = 0;
        if (decInfo.isCandidatesListEmpty()) {
            this.showArrow(this.mLeftArrowBtn, false);
            this.showArrow(this.mRightArrowBtn, false);
        } else {
            this.showArrow(this.mLeftArrowBtn, true);
            this.showArrow(this.mRightArrowBtn, true);
        }
        for (int i = 0; i < this.mFlipper.getChildCount(); ++i) {
            CandidateView cv = (CandidateView)this.mFlipper.getChildAt(i);
            cv.setDecodingInfo(this.mDecInfo);
        }
        this.stopAnimation();
        CandidateView cv = (CandidateView)this.mFlipper.getCurrentView();
        cv.showPage(this.mCurrentPage, 0, enableActiveHighlight);
        this.updateArrowStatus();
        this.invalidate();
    }

    public int getCurrentPage() {
        return this.mCurrentPage;
    }

    public void enableActiveHighlight(boolean enableActiveHighlight) {
        CandidateView cv = (CandidateView)this.mFlipper.getCurrentView();
        cv.enableActiveHighlight(enableActiveHighlight);
        this.invalidate();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        Environment env = Environment.getInstance();
        int measuredWidth = env.getScreenWidth();
        int measuredHeight = this.getPaddingTop();
        widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)measuredWidth, (int)0x40000000);
        heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)(measuredHeight += env.getHeightForCandidates()), (int)0x40000000);
        super.onMeasure(widthMeasureSpec, heightMeasureSpec);
        if (null != this.mLeftArrowBtn) {
            this.xOffsetForFlipper = this.mLeftArrowBtn.getMeasuredWidth();
        }
    }

    public boolean activeCurseBackward() {
        if (this.mFlipper.isFlipping() || null == this.mDecInfo) {
            return false;
        }
        CandidateView cv = (CandidateView)this.mFlipper.getCurrentView();
        if (cv.activeCurseBackward()) {
            cv.invalidate();
            return true;
        }
        return this.pageBackward(true, true);
    }

    public boolean activeCurseForward() {
        if (this.mFlipper.isFlipping() || null == this.mDecInfo) {
            return false;
        }
        CandidateView cv = (CandidateView)this.mFlipper.getCurrentView();
        if (cv.activeCursorForward()) {
            cv.invalidate();
            return true;
        }
        return this.pageForward(true, true);
    }

    public boolean pageBackward(boolean animLeftRight, boolean enableActiveHighlight) {
        if (null == this.mDecInfo) {
            return false;
        }
        if (this.mFlipper.isFlipping() || 0 == this.mCurrentPage) {
            return false;
        }
        int child = this.mFlipper.getDisplayedChild();
        int childNext = (child + 1) % 2;
        CandidateView cv = (CandidateView)this.mFlipper.getChildAt(child);
        CandidateView cvNext = (CandidateView)this.mFlipper.getChildAt(childNext);
        --this.mCurrentPage;
        int activeCandInPage = cv.getActiveCandiatePosInPage();
        if (animLeftRight) {
            activeCandInPage = this.mDecInfo.mPageStart.elementAt(this.mCurrentPage + 1) - this.mDecInfo.mPageStart.elementAt(this.mCurrentPage) - 1;
        }
        cvNext.showPage(this.mCurrentPage, activeCandInPage, enableActiveHighlight);
        this.loadAnimation(animLeftRight, false);
        this.startAnimation();
        this.updateArrowStatus();
        return true;
    }

    public boolean pageForward(boolean animLeftRight, boolean enableActiveHighlight) {
        if (null == this.mDecInfo) {
            return false;
        }
        if (this.mFlipper.isFlipping() || !this.mDecInfo.preparePage(this.mCurrentPage + 1)) {
            return false;
        }
        int child = this.mFlipper.getDisplayedChild();
        int childNext = (child + 1) % 2;
        CandidateView cv = (CandidateView)this.mFlipper.getChildAt(child);
        int activeCandInPage = cv.getActiveCandiatePosInPage();
        cv.enableActiveHighlight(enableActiveHighlight);
        CandidateView cvNext = (CandidateView)this.mFlipper.getChildAt(childNext);
        ++this.mCurrentPage;
        if (animLeftRight) {
            activeCandInPage = 0;
        }
        cvNext.showPage(this.mCurrentPage, activeCandInPage, enableActiveHighlight);
        this.loadAnimation(animLeftRight, true);
        this.startAnimation();
        this.updateArrowStatus();
        return true;
    }

    public int getActiveCandiatePos() {
        if (null == this.mDecInfo) {
            return -1;
        }
        CandidateView cv = (CandidateView)this.mFlipper.getCurrentView();
        return cv.getActiveCandiatePosGlobal();
    }

    public void updateArrowStatus() {
        if (this.mCurrentPage < 0) {
            return;
        }
        boolean forwardEnabled = this.mDecInfo.pageForwardable(this.mCurrentPage);
        boolean backwardEnabled = this.mDecInfo.pageBackwardable(this.mCurrentPage);
        if (backwardEnabled) {
            this.enableArrow(this.mLeftArrowBtn, true);
        } else {
            this.enableArrow(this.mLeftArrowBtn, false);
        }
        if (forwardEnabled) {
            this.enableArrow(this.mRightArrowBtn, true);
        } else {
            this.enableArrow(this.mRightArrowBtn, false);
        }
    }

    private void enableArrow(ImageButton arrowBtn, boolean enabled) {
        arrowBtn.setEnabled(enabled);
        if (enabled) {
            arrowBtn.setAlpha(ARROW_ALPHA_ENABLED);
        } else {
            arrowBtn.setAlpha(ARROW_ALPHA_DISABLED);
        }
    }

    private void showArrow(ImageButton arrowBtn, boolean show) {
        if (show) {
            arrowBtn.setVisibility(0);
        } else {
            arrowBtn.setVisibility(4);
        }
    }

    public boolean onTouch(View v, MotionEvent event) {
        if (event.getAction() == 0) {
            if (v == this.mLeftArrowBtn) {
                this.mCvListener.onToRightGesture();
            } else if (v == this.mRightArrowBtn) {
                this.mCvListener.onToLeftGesture();
            }
        } else if (event.getAction() == 1) {
            CandidateView cv = (CandidateView)this.mFlipper.getCurrentView();
            cv.enableActiveHighlight(true);
        }
        return false;
    }

    public boolean onTouchEvent(MotionEvent event) {
        event.offsetLocation((float)(-this.xOffsetForFlipper), 0.0f);
        CandidateView cv = (CandidateView)this.mFlipper.getCurrentView();
        cv.onTouchEventReal(event);
        return true;
    }

    public void loadAnimation(boolean animLeftRight, boolean forward) {
        if (animLeftRight) {
            if (forward) {
                if (null == this.mInAnimPushLeft) {
                    this.mInAnimPushLeft = this.createAnimation(1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, ANIMATION_TIME);
                    this.mOutAnimPushLeft = this.createAnimation(0.0f, -1.0f, 0.0f, 0.0f, 1.0f, 0.0f, ANIMATION_TIME);
                }
                this.mInAnimInUse = this.mInAnimPushLeft;
                this.mOutAnimInUse = this.mOutAnimPushLeft;
            } else {
                if (null == this.mInAnimPushRight) {
                    this.mInAnimPushRight = this.createAnimation(-1.0f, 0.0f, 0.0f, 0.0f, 0.0f, 1.0f, ANIMATION_TIME);
                    this.mOutAnimPushRight = this.createAnimation(0.0f, 1.0f, 0.0f, 0.0f, 1.0f, 0.0f, ANIMATION_TIME);
                }
                this.mInAnimInUse = this.mInAnimPushRight;
                this.mOutAnimInUse = this.mOutAnimPushRight;
            }
        } else if (forward) {
            if (null == this.mInAnimPushUp) {
                this.mInAnimPushUp = this.createAnimation(0.0f, 0.0f, 1.0f, 0.0f, 0.0f, 1.0f, ANIMATION_TIME);
                this.mOutAnimPushUp = this.createAnimation(0.0f, 0.0f, 0.0f, -1.0f, 1.0f, 0.0f, ANIMATION_TIME);
            }
            this.mInAnimInUse = this.mInAnimPushUp;
            this.mOutAnimInUse = this.mOutAnimPushUp;
        } else {
            if (null == this.mInAnimPushDown) {
                this.mInAnimPushDown = this.createAnimation(0.0f, 0.0f, -1.0f, 0.0f, 0.0f, 1.0f, ANIMATION_TIME);
                this.mOutAnimPushDown = this.createAnimation(0.0f, 0.0f, 0.0f, 1.0f, 1.0f, 0.0f, ANIMATION_TIME);
            }
            this.mInAnimInUse = this.mInAnimPushDown;
            this.mOutAnimInUse = this.mOutAnimPushDown;
        }
        this.mInAnimInUse.setAnimationListener((Animation.AnimationListener)this);
        this.mFlipper.setInAnimation(this.mInAnimInUse);
        this.mFlipper.setOutAnimation(this.mOutAnimInUse);
    }

    private Animation createAnimation(float xFrom, float xTo, float yFrom, float yTo, float alphaFrom, float alphaTo, long duration) {
        AnimationSet animSet = new AnimationSet(this.getContext(), null);
        TranslateAnimation trans = new TranslateAnimation(1, xFrom, 1, xTo, 1, yFrom, 1, yTo);
        AlphaAnimation alpha = new AlphaAnimation(alphaFrom, alphaTo);
        animSet.addAnimation((Animation)trans);
        animSet.addAnimation((Animation)alpha);
        animSet.setDuration(duration);
        return animSet;
    }

    private void startAnimation() {
        this.mFlipper.showNext();
    }

    private void stopAnimation() {
        this.mFlipper.stopFlipping();
    }

    public void onAnimationEnd(Animation animation) {
        if (!this.mLeftArrowBtn.isPressed() && !this.mRightArrowBtn.isPressed()) {
            CandidateView cv = (CandidateView)this.mFlipper.getCurrentView();
            cv.enableActiveHighlight(true);
        }
    }

    public void onAnimationRepeat(Animation animation) {
    }

    public void onAnimationStart(Animation animation) {
    }
}

