/*
 * Decompiled with CFR 0.152.
 */
package com.android.inputmethod.pinyin;

import android.content.Context;
import android.content.res.Configuration;
import android.content.res.Resources;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.RectF;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.util.AttributeSet;
import android.view.GestureDetector;
import android.view.MotionEvent;
import android.view.View;
import com.android.inputmethod.pinyin.ArrowUpdater;
import com.android.inputmethod.pinyin.BalloonHint;
import com.android.inputmethod.pinyin.CandidateViewListener;
import com.android.inputmethod.pinyin.PinyinIME;
import java.util.Vector;

public class CandidateView
extends View {
    private static final float MIN_ITEM_WIDTH = 22.0f;
    private static final String SUSPENSION_POINTS = "...";
    private int mContentWidth;
    private int mContentHeight;
    private boolean mShowFootnote = true;
    private BalloonHint mBalloonHint;
    private int[] mHintPositionToInputView = new int[2];
    private PinyinIME.DecodingInfo mDecInfo;
    private CandidateViewListener mCvListener;
    private ArrowUpdater mArrowUpdater;
    private boolean mUpdateArrowStatusWhenDraw = false;
    private int mPageNo;
    private int mActiveCandInPage;
    private boolean mEnableActiveHighlight = true;
    private int mPageNoCalculated = -1;
    private Drawable mActiveCellDrawable;
    private Drawable mSeparatorDrawable;
    private int mImeCandidateColor;
    private int mRecommendedCandidateColor;
    private int mNormalCandidateColor;
    private int mActiveCandidateColor;
    private int mImeCandidateTextSize;
    private int mRecommendedCandidateTextSize;
    private int mCandidateTextSize;
    private Paint mCandidatesPaint;
    private Paint mFootnotePaint;
    private float mSuspensionPointsWidth;
    private RectF mActiveCellRect;
    private float mCandidateMargin;
    private float mCandidateMarginExtra;
    private Vector<RectF> mCandRects;
    private Paint.FontMetricsInt mFmiCandidates;
    private Paint.FontMetricsInt mFmiFootnote;
    private PressTimer mTimer = new PressTimer();
    private GestureDetector mGestureDetector;
    private int[] mLocationTmp = new int[2];

    public CandidateView(Context context, AttributeSet attrs) {
        super(context, attrs);
        Resources r = context.getResources();
        Configuration conf = r.getConfiguration();
        if (conf.keyboard == 1 || conf.hardKeyboardHidden == 2) {
            this.mShowFootnote = false;
        }
        this.mActiveCellDrawable = r.getDrawable(2130837509);
        this.mSeparatorDrawable = r.getDrawable(2130837511);
        this.mCandidateMargin = r.getDimension(2131230721);
        this.mImeCandidateColor = r.getColor(2131165187);
        this.mRecommendedCandidateColor = r.getColor(2131165189);
        this.mNormalCandidateColor = this.mImeCandidateColor;
        this.mActiveCandidateColor = r.getColor(2131165188);
        this.mCandidatesPaint = new Paint();
        this.mCandidatesPaint.setAntiAlias(true);
        this.mFootnotePaint = new Paint();
        this.mFootnotePaint.setAntiAlias(true);
        this.mFootnotePaint.setColor(r.getColor(2131165190));
        this.mActiveCellRect = new RectF();
        this.mCandRects = new Vector();
    }

    protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
        int mOldWidth = this.mMeasuredWidth;
        int mOldHeight = this.mMeasuredHeight;
        this.setMeasuredDimension(CandidateView.getDefaultSize((int)this.getSuggestedMinimumWidth(), (int)widthMeasureSpec), CandidateView.getDefaultSize((int)this.getSuggestedMinimumHeight(), (int)heightMeasureSpec));
        if (mOldWidth != this.mMeasuredWidth || mOldHeight != this.mMeasuredHeight) {
            this.onSizeChanged();
        }
    }

    public void initialize(ArrowUpdater arrowUpdater, BalloonHint balloonHint, GestureDetector gestureDetector, CandidateViewListener cvListener) {
        this.mArrowUpdater = arrowUpdater;
        this.mBalloonHint = balloonHint;
        this.mGestureDetector = gestureDetector;
        this.mCvListener = cvListener;
    }

    public void setDecodingInfo(PinyinIME.DecodingInfo decInfo) {
        if (null == decInfo) {
            return;
        }
        this.mDecInfo = decInfo;
        this.mPageNoCalculated = -1;
        if (this.mDecInfo.candidatesFromApp()) {
            this.mNormalCandidateColor = this.mRecommendedCandidateColor;
            this.mCandidateTextSize = this.mRecommendedCandidateTextSize;
        } else {
            this.mNormalCandidateColor = this.mImeCandidateColor;
            this.mCandidateTextSize = this.mImeCandidateTextSize;
        }
        if (this.mCandidatesPaint.getTextSize() != (float)this.mCandidateTextSize) {
            this.mCandidatesPaint.setTextSize((float)this.mCandidateTextSize);
            this.mFmiCandidates = this.mCandidatesPaint.getFontMetricsInt();
            this.mSuspensionPointsWidth = this.mCandidatesPaint.measureText(SUSPENSION_POINTS);
        }
        this.mTimer.removeTimer();
    }

    public int getActiveCandiatePosInPage() {
        return this.mActiveCandInPage;
    }

    public int getActiveCandiatePosGlobal() {
        return this.mDecInfo.mPageStart.get(this.mPageNo) + this.mActiveCandInPage;
    }

    public void showPage(int pageNo, int activeCandInPage, boolean enableActiveHighlight) {
        if (null == this.mDecInfo) {
            return;
        }
        this.mPageNo = pageNo;
        this.mActiveCandInPage = activeCandInPage;
        if (this.mEnableActiveHighlight != enableActiveHighlight) {
            this.mEnableActiveHighlight = enableActiveHighlight;
        }
        this.mUpdateArrowStatusWhenDraw = !this.calculatePage(this.mPageNo);
        this.invalidate();
    }

    public void enableActiveHighlight(boolean enableActiveHighlight) {
        if (enableActiveHighlight == this.mEnableActiveHighlight) {
            return;
        }
        this.mEnableActiveHighlight = enableActiveHighlight;
        this.invalidate();
    }

    public boolean activeCursorForward() {
        if (!this.mDecInfo.pageReady(this.mPageNo)) {
            return false;
        }
        int pageSize = this.mDecInfo.mPageStart.get(this.mPageNo + 1) - this.mDecInfo.mPageStart.get(this.mPageNo);
        if (this.mActiveCandInPage + 1 < pageSize) {
            this.showPage(this.mPageNo, this.mActiveCandInPage + 1, true);
            return true;
        }
        return false;
    }

    public boolean activeCurseBackward() {
        if (this.mActiveCandInPage > 0) {
            this.showPage(this.mPageNo, this.mActiveCandInPage - 1, true);
            return true;
        }
        return false;
    }

    private void onSizeChanged() {
        this.mContentWidth = this.mMeasuredWidth - this.mPaddingLeft - this.mPaddingRight;
        this.mContentHeight = (int)((float)(this.mMeasuredHeight - this.mPaddingTop - this.mPaddingBottom) * 0.95f);
        int textSize = 1;
        this.mCandidatesPaint.setTextSize((float)textSize);
        this.mFmiCandidates = this.mCandidatesPaint.getFontMetricsInt();
        while (this.mFmiCandidates.bottom - this.mFmiCandidates.top < this.mContentHeight) {
            this.mCandidatesPaint.setTextSize((float)(++textSize));
            this.mFmiCandidates = this.mCandidatesPaint.getFontMetricsInt();
        }
        this.mImeCandidateTextSize = textSize;
        this.mRecommendedCandidateTextSize = textSize * 3 / 4;
        if (null == this.mDecInfo) {
            this.mCandidateTextSize = this.mImeCandidateTextSize;
            this.mCandidatesPaint.setTextSize((float)this.mCandidateTextSize);
            this.mFmiCandidates = this.mCandidatesPaint.getFontMetricsInt();
            this.mSuspensionPointsWidth = this.mCandidatesPaint.measureText(SUSPENSION_POINTS);
        } else {
            this.setDecodingInfo(this.mDecInfo);
        }
        textSize = 1;
        this.mFootnotePaint.setTextSize((float)textSize);
        this.mFmiFootnote = this.mFootnotePaint.getFontMetricsInt();
        while (this.mFmiFootnote.bottom - this.mFmiFootnote.top < this.mContentHeight / 2) {
            this.mFootnotePaint.setTextSize((float)(++textSize));
            this.mFmiFootnote = this.mFootnotePaint.getFontMetricsInt();
        }
        this.mFootnotePaint.setTextSize((float)(--textSize));
        this.mFmiFootnote = this.mFootnotePaint.getFontMetricsInt();
        this.mPageNo = 0;
        this.mActiveCandInPage = 0;
    }

    private boolean calculatePage(int pageNo) {
        if (pageNo == this.mPageNoCalculated) {
            return true;
        }
        this.mContentWidth = this.mMeasuredWidth - this.mPaddingLeft - this.mPaddingRight;
        this.mContentHeight = (int)((float)(this.mMeasuredHeight - this.mPaddingTop - this.mPaddingBottom) * 0.95f);
        if (this.mContentWidth <= 0 || this.mContentHeight <= 0) {
            return false;
        }
        int candSize = this.mDecInfo.mCandidatesList.size();
        boolean onlyExtraMargin = false;
        int fromPage = this.mDecInfo.mPageStart.size() - 1;
        if (this.mDecInfo.mPageStart.size() > pageNo + 1) {
            onlyExtraMargin = true;
            fromPage = pageNo;
        }
        for (int p = fromPage; p <= pageNo; ++p) {
            int pStart = this.mDecInfo.mPageStart.get(p);
            int pSize = 0;
            int charNum = 0;
            float lastItemWidth = 0.0f;
            float xPos = 0.0f;
            xPos += (float)this.mSeparatorDrawable.getIntrinsicWidth();
            while (xPos < (float)this.mContentWidth && pStart + pSize < candSize) {
                int itemPos = pStart + pSize;
                String itemStr = this.mDecInfo.mCandidatesList.get(itemPos);
                float itemWidth = this.mCandidatesPaint.measureText(itemStr);
                if (itemWidth < 22.0f) {
                    itemWidth = 22.0f;
                }
                itemWidth += this.mCandidateMargin * 2.0f;
                if (!(xPos + (itemWidth += (float)this.mSeparatorDrawable.getIntrinsicWidth()) < (float)this.mContentWidth) && 0 != pSize) break;
                xPos += itemWidth;
                lastItemWidth = itemWidth;
                ++pSize;
                charNum += itemStr.length();
            }
            if (!onlyExtraMargin) {
                this.mDecInfo.mPageStart.add(pStart + pSize);
                this.mDecInfo.mCnToPage.add(this.mDecInfo.mCnToPage.get(p) + charNum);
            }
            float marginExtra = ((float)this.mContentWidth - xPos) / (float)pSize / 2.0f;
            if ((float)this.mContentWidth - xPos > lastItemWidth) {
                if (this.mCandidateMarginExtra <= marginExtra) {
                    marginExtra = this.mCandidateMarginExtra;
                }
            } else if (pSize == 1) {
                marginExtra = 0.0f;
            }
            this.mCandidateMarginExtra = marginExtra;
        }
        this.mPageNoCalculated = pageNo;
        return true;
    }

    protected void onDraw(Canvas canvas) {
        super.onDraw(canvas);
        if (null == this.mDecInfo || this.mDecInfo.isCandidatesListEmpty()) {
            return;
        }
        this.calculatePage(this.mPageNo);
        int pStart = this.mDecInfo.mPageStart.get(this.mPageNo);
        int pSize = this.mDecInfo.mPageStart.get(this.mPageNo + 1) - pStart;
        float candMargin = this.mCandidateMargin + this.mCandidateMarginExtra;
        if (this.mActiveCandInPage > pSize - 1) {
            this.mActiveCandInPage = pSize - 1;
        }
        this.mCandRects.removeAllElements();
        float xPos = this.mPaddingLeft;
        int yPos = (this.getMeasuredHeight() - (this.mFmiCandidates.bottom - this.mFmiCandidates.top)) / 2 - this.mFmiCandidates.top;
        xPos += this.drawVerticalSeparator(canvas, xPos);
        for (int i = 0; i < pSize; ++i) {
            float footnoteSize = 0.0f;
            String footnote = null;
            if (this.mShowFootnote) {
                footnote = Integer.toString(i + 1);
                footnoteSize = this.mFootnotePaint.measureText(footnote);
                assert (footnoteSize < candMargin);
            }
            String cand = this.mDecInfo.mCandidatesList.get(pStart + i);
            float candidateWidth = this.mCandidatesPaint.measureText(cand);
            float centerOffset = 0.0f;
            if (candidateWidth < 22.0f) {
                centerOffset = (22.0f - candidateWidth) / 2.0f;
                candidateWidth = 22.0f;
            }
            float itemTotalWidth = candidateWidth + 2.0f * candMargin;
            if (this.mActiveCandInPage == i && this.mEnableActiveHighlight) {
                this.mActiveCellRect.set(xPos, (float)(this.mPaddingTop + 1), xPos + itemTotalWidth, (float)(this.getHeight() - this.mPaddingBottom - 1));
                this.mActiveCellDrawable.setBounds((int)this.mActiveCellRect.left, (int)this.mActiveCellRect.top, (int)this.mActiveCellRect.right, (int)this.mActiveCellRect.bottom);
                this.mActiveCellDrawable.draw(canvas);
            }
            if (this.mCandRects.size() < pSize) {
                this.mCandRects.add(new RectF());
            }
            this.mCandRects.elementAt(i).set(xPos - 1.0f, (float)(yPos + this.mFmiCandidates.top), xPos + itemTotalWidth + 1.0f, (float)(yPos + this.mFmiCandidates.bottom));
            if (this.mShowFootnote) {
                canvas.drawText(footnote, xPos + (candMargin - footnoteSize) / 2.0f, (float)yPos, this.mFootnotePaint);
            }
            if (candidateWidth > (float)this.mContentWidth - (xPos += candMargin) - centerOffset) {
                cand = this.getLimitedCandidateForDrawing(cand, (float)this.mContentWidth - xPos - centerOffset);
            }
            if (this.mActiveCandInPage == i && this.mEnableActiveHighlight) {
                this.mCandidatesPaint.setColor(this.mActiveCandidateColor);
            } else {
                this.mCandidatesPaint.setColor(this.mNormalCandidateColor);
            }
            canvas.drawText(cand, xPos + centerOffset, (float)yPos, this.mCandidatesPaint);
            xPos += candidateWidth + candMargin;
            xPos += this.drawVerticalSeparator(canvas, xPos);
        }
        if (null != this.mArrowUpdater && this.mUpdateArrowStatusWhenDraw) {
            this.mArrowUpdater.updateArrowStatus();
            this.mUpdateArrowStatusWhenDraw = false;
        }
    }

    private String getLimitedCandidateForDrawing(String rawCandidate, float widthToDraw) {
        float width;
        int subLen = rawCandidate.length();
        if (subLen <= 1) {
            return rawCandidate;
        }
        while (!((width = this.mCandidatesPaint.measureText(rawCandidate, 0, --subLen)) + this.mSuspensionPointsWidth <= widthToDraw) && 1 < subLen) {
        }
        return rawCandidate.substring(0, subLen) + SUSPENSION_POINTS;
    }

    private float drawVerticalSeparator(Canvas canvas, float xPos) {
        this.mSeparatorDrawable.setBounds((int)xPos, this.mPaddingTop, (int)xPos + this.mSeparatorDrawable.getIntrinsicWidth(), this.getMeasuredHeight() - this.mPaddingBottom);
        this.mSeparatorDrawable.draw(canvas);
        return this.mSeparatorDrawable.getIntrinsicWidth();
    }

    private int mapToItemInPage(int x, int y) {
        if (!this.mDecInfo.pageReady(this.mPageNo) || this.mPageNoCalculated != this.mPageNo || this.mCandRects.size() == 0) {
            return -1;
        }
        int pageStart = this.mDecInfo.mPageStart.get(this.mPageNo);
        int pageSize = this.mDecInfo.mPageStart.get(this.mPageNo + 1) - pageStart;
        if (this.mCandRects.size() < pageSize) {
            return -1;
        }
        float nearestDis = Float.MAX_VALUE;
        int nearest = -1;
        for (int i = 0; i < pageSize; ++i) {
            RectF r = this.mCandRects.elementAt(i);
            if (r.left < (float)x && r.right > (float)x && r.top < (float)y && r.bottom > (float)y) {
                return i;
            }
            float disx = (r.left + r.right) / 2.0f - (float)x;
            float disy = (r.top + r.bottom) / 2.0f - (float)y;
            float dis = disx * disx + disy * disy;
            if (!(dis < nearestDis)) continue;
            nearestDis = dis;
            nearest = i;
        }
        return nearest;
    }

    public boolean onTouchEvent(MotionEvent event) {
        return super.onTouchEvent(event);
    }

    public boolean onTouchEventReal(MotionEvent event) {
        if (null == this.mDecInfo || !this.mDecInfo.pageReady(this.mPageNo) || this.mPageNoCalculated != this.mPageNo) {
            return true;
        }
        int x = (int)event.getX();
        int y = (int)event.getY();
        if (this.mGestureDetector.onTouchEvent(event)) {
            this.mTimer.removeTimer();
            this.mBalloonHint.delayedDismiss(0L);
            return true;
        }
        int clickedItemInPage = -1;
        switch (event.getAction()) {
            case 1: {
                clickedItemInPage = this.mapToItemInPage(x, y);
                if (clickedItemInPage >= 0) {
                    this.invalidate();
                    this.mCvListener.onClickChoice(clickedItemInPage + this.mDecInfo.mPageStart.get(this.mPageNo));
                }
                this.mBalloonHint.delayedDismiss(200L);
                break;
            }
            case 0: {
                clickedItemInPage = this.mapToItemInPage(x, y);
                if (clickedItemInPage < 0) break;
                this.showBalloon(clickedItemInPage, true);
                this.mTimer.startTimer(0L, this.mPageNo, clickedItemInPage);
                break;
            }
            case 3: {
                break;
            }
            case 2: {
                clickedItemInPage = this.mapToItemInPage(x, y);
                if (clickedItemInPage < 0 || clickedItemInPage == this.mTimer.getActiveCandOfPageToShow() && this.mPageNo == this.mTimer.getPageToShow()) break;
                this.showBalloon(clickedItemInPage, true);
                this.mTimer.startTimer(0L, this.mPageNo, clickedItemInPage);
            }
        }
        return true;
    }

    private void showBalloon(int candPos, boolean delayedShow) {
        this.mBalloonHint.removeTimer();
        RectF r = this.mCandRects.elementAt(candPos);
        int desired_width = (int)(r.right - r.left);
        int desired_height = (int)(r.bottom - r.top);
        this.mBalloonHint.setBalloonConfig(this.mDecInfo.mCandidatesList.get(this.mDecInfo.mPageStart.get(this.mPageNo) + candPos), 44.0f, true, this.mImeCandidateColor, desired_width, desired_height);
        this.getLocationOnScreen(this.mLocationTmp);
        this.mHintPositionToInputView[0] = this.mLocationTmp[0] + (int)(r.left - (float)((this.mBalloonHint.getWidth() - desired_width) / 2));
        this.mHintPositionToInputView[1] = -this.mBalloonHint.getHeight();
        long delay = 0L;
        if (!delayedShow) {
            delay = 0L;
        }
        this.mBalloonHint.dismiss();
        if (!this.mBalloonHint.isShowing()) {
            this.mBalloonHint.delayedShow(delay, this.mHintPositionToInputView);
        } else {
            this.mBalloonHint.delayedUpdate(0L, this.mHintPositionToInputView, -1, -1);
        }
    }

    private class PressTimer
    extends Handler
    implements Runnable {
        private boolean mTimerPending = false;
        private int mPageNoToShow;
        private int mActiveCandOfPage;

        public void startTimer(long afterMillis, int pageNo, int activeInPage) {
            CandidateView.this.mTimer.removeTimer();
            this.postDelayed(this, afterMillis);
            this.mTimerPending = true;
            this.mPageNoToShow = pageNo;
            this.mActiveCandOfPage = activeInPage;
        }

        public int getPageToShow() {
            return this.mPageNoToShow;
        }

        public int getActiveCandOfPageToShow() {
            return this.mActiveCandOfPage;
        }

        public boolean removeTimer() {
            if (this.mTimerPending) {
                this.mTimerPending = false;
                this.removeCallbacks(this);
                return true;
            }
            return false;
        }

        public boolean isPending() {
            return this.mTimerPending;
        }

        public void run() {
            if (this.mPageNoToShow >= 0 && this.mActiveCandOfPage >= 0) {
                CandidateView.this.showPage(this.mPageNoToShow, this.mActiveCandOfPage, true);
                CandidateView.this.invalidate();
            }
            this.mTimerPending = false;
        }
    }
}

