/*
 * Decompiled with CFR 0.152.
 */
package com.android.inputmethod.pinyin;

import android.content.Context;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.Rect;
import android.graphics.drawable.ColorDrawable;
import android.graphics.drawable.Drawable;
import android.os.Handler;
import android.view.View;
import android.widget.PopupWindow;
import com.android.inputmethod.pinyin.Environment;

public class BalloonHint
extends PopupWindow {
    public static final int TIME_DELAY_SHOW = 0;
    public static final int TIME_DELAY_DISMISS = 200;
    private Rect mPaddingRect = new Rect();
    private Context mContext;
    private View mParent;
    BalloonView mBalloonView;
    private int mMeasureSpecMode;
    private boolean mForceDismiss;
    private BalloonTimer mBalloonTimer;
    private int[] mParentLocationInWindow = new int[2];

    public BalloonHint(Context context, View parent, int measureSpecMode) {
        super(context);
        this.mParent = parent;
        this.mMeasureSpecMode = measureSpecMode;
        this.setInputMethodMode(2);
        this.setTouchable(false);
        this.setBackgroundDrawable((Drawable)new ColorDrawable(0));
        this.mBalloonView = new BalloonView(context);
        this.mBalloonView.setClickable(false);
        this.setContentView(this.mBalloonView);
        this.mBalloonTimer = new BalloonTimer();
    }

    public Context getContext() {
        return this.mContext;
    }

    public Rect getPadding() {
        return this.mPaddingRect;
    }

    public void setBalloonBackground(Drawable drawable2) {
        if (this.mBalloonView.getBackground() == drawable2) {
            return;
        }
        this.mBalloonView.setBackgroundDrawable(drawable2);
        if (null != drawable2) {
            drawable2.getPadding(this.mPaddingRect);
        } else {
            this.mPaddingRect.set(0, 0, 0, 0);
        }
    }

    public void setBalloonConfig(String label, float textSize, boolean textBold, int textColor, int width, int height) {
        this.mBalloonView.setTextConfig(label, textSize, textBold, textColor);
        this.setBalloonSize(width, height);
    }

    public void setBalloonConfig(Drawable icon, int width, int height) {
        this.mBalloonView.setIcon(icon);
        this.setBalloonSize(width, height);
    }

    public boolean needForceDismiss() {
        return this.mForceDismiss;
    }

    public int getPaddingLeft() {
        return this.mPaddingRect.left;
    }

    public int getPaddingTop() {
        return this.mPaddingRect.top;
    }

    public int getPaddingRight() {
        return this.mPaddingRect.right;
    }

    public int getPaddingBottom() {
        return this.mPaddingRect.bottom;
    }

    public void delayedShow(long delay, int[] locationInParent) {
        if (this.mBalloonTimer.isPending()) {
            this.mBalloonTimer.removeTimer();
        }
        if (delay <= 0L) {
            this.mParent.getLocationInWindow(this.mParentLocationInWindow);
            this.showAtLocation(this.mParent, 51, locationInParent[0], locationInParent[1] + this.mParentLocationInWindow[1]);
        } else {
            this.mBalloonTimer.startTimer(delay, 1, locationInParent, -1, -1);
        }
    }

    public void delayedUpdate(long delay, int[] locationInParent, int width, int height) {
        this.mBalloonView.invalidate();
        if (this.mBalloonTimer.isPending()) {
            this.mBalloonTimer.removeTimer();
        }
        if (delay <= 0L) {
            this.mParent.getLocationInWindow(this.mParentLocationInWindow);
            this.update(locationInParent[0], locationInParent[1] + this.mParentLocationInWindow[1], width, height);
        } else {
            this.mBalloonTimer.startTimer(delay, 3, locationInParent, width, height);
        }
    }

    public void delayedDismiss(long delay) {
        if (this.mBalloonTimer.isPending()) {
            this.mBalloonTimer.removeTimer();
            int pendingAction = this.mBalloonTimer.getAction();
            if (0L != delay && 2 != pendingAction) {
                this.mBalloonTimer.run();
            }
        }
        if (delay <= 0L) {
            this.dismiss();
        } else {
            this.mBalloonTimer.startTimer(delay, 2, null, -1, -1);
        }
    }

    public void removeTimer() {
        if (this.mBalloonTimer.isPending()) {
            this.mBalloonTimer.removeTimer();
        }
    }

    private void setBalloonSize(int width, int height) {
        int widthMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)width, (int)this.mMeasureSpecMode);
        int heightMeasureSpec = View.MeasureSpec.makeMeasureSpec((int)height, (int)this.mMeasureSpecMode);
        this.mBalloonView.measure(widthMeasureSpec, heightMeasureSpec);
        int oldWidth = this.getWidth();
        int oldHeight = this.getHeight();
        int newWidth = this.mBalloonView.getMeasuredWidth() + this.getPaddingLeft() + this.getPaddingRight();
        int newHeight = this.mBalloonView.getMeasuredHeight() + this.getPaddingTop() + this.getPaddingBottom();
        this.setWidth(newWidth);
        this.setHeight(newHeight);
        this.mForceDismiss = false;
        if (this.isShowing()) {
            this.mForceDismiss = oldWidth - newWidth > 1 || newWidth - oldWidth > 1;
        }
    }

    private class BalloonView
    extends View {
        private static final String SUSPENSION_POINTS = "...";
        private Drawable mIcon;
        private String mLabel;
        private int mLabeColor;
        private Paint mPaintLabel;
        private Paint.FontMetricsInt mFmi;
        private float mSuspensionPointsWidth;

        public BalloonView(Context context) {
            super(context);
            this.mLabeColor = -16777216;
            this.mPaintLabel = new Paint();
            this.mPaintLabel.setColor(this.mLabeColor);
            this.mPaintLabel.setAntiAlias(true);
            this.mPaintLabel.setFakeBoldText(true);
            this.mFmi = this.mPaintLabel.getFontMetricsInt();
        }

        public void setIcon(Drawable icon) {
            this.mIcon = icon;
        }

        public void setTextConfig(String label, float fontSize, boolean textBold, int textColor) {
            this.mIcon = null;
            this.mLabel = label;
            this.mPaintLabel.setTextSize(fontSize);
            this.mPaintLabel.setFakeBoldText(textBold);
            this.mPaintLabel.setColor(textColor);
            this.mFmi = this.mPaintLabel.getFontMetricsInt();
            this.mSuspensionPointsWidth = this.mPaintLabel.measureText(SUSPENSION_POINTS);
        }

        protected void onMeasure(int widthMeasureSpec, int heightMeasureSpec) {
            int maxWidth;
            int widthMode = View.MeasureSpec.getMode((int)widthMeasureSpec);
            int heightMode = View.MeasureSpec.getMode((int)heightMeasureSpec);
            int widthSize = View.MeasureSpec.getSize((int)widthMeasureSpec);
            int heightSize = View.MeasureSpec.getSize((int)heightMeasureSpec);
            if (widthMode == 0x40000000) {
                this.setMeasuredDimension(widthSize, heightSize);
                return;
            }
            int measuredWidth = this.mPaddingLeft + this.mPaddingRight;
            int measuredHeight = this.mPaddingTop + this.mPaddingBottom;
            if (null != this.mIcon) {
                measuredWidth += this.mIcon.getIntrinsicWidth();
                measuredHeight += this.mIcon.getIntrinsicHeight();
            } else if (null != this.mLabel) {
                measuredWidth += (int)this.mPaintLabel.measureText(this.mLabel);
                measuredHeight += this.mFmi.bottom - this.mFmi.top;
            }
            if (widthSize > measuredWidth || widthMode == Integer.MIN_VALUE) {
                measuredWidth = widthSize;
            }
            if (heightSize > measuredHeight || heightMode == Integer.MIN_VALUE) {
                measuredHeight = heightSize;
            }
            if (measuredWidth > (maxWidth = Environment.getInstance().getScreenWidth() - this.mPaddingLeft - this.mPaddingRight)) {
                measuredWidth = maxWidth;
            }
            this.setMeasuredDimension(measuredWidth, measuredHeight);
        }

        protected void onDraw(Canvas canvas) {
            int width = this.getWidth();
            int height = this.getHeight();
            if (null != this.mIcon) {
                int marginLeft = (width - this.mIcon.getIntrinsicWidth()) / 2;
                int marginRight = width - this.mIcon.getIntrinsicWidth() - marginLeft;
                int marginTop = (height - this.mIcon.getIntrinsicHeight()) / 2;
                int marginBottom = height - this.mIcon.getIntrinsicHeight() - marginTop;
                this.mIcon.setBounds(marginLeft, marginTop, width - marginRight, height - marginBottom);
                this.mIcon.draw(canvas);
            } else if (null != this.mLabel) {
                float labelMeasuredWidth = this.mPaintLabel.measureText(this.mLabel);
                float x = this.mPaddingLeft;
                x += ((float)width - labelMeasuredWidth - (float)this.mPaddingLeft - (float)this.mPaddingRight) / 2.0f;
                String labelToDraw = this.mLabel;
                if (x < (float)this.mPaddingLeft) {
                    x = this.mPaddingLeft;
                    labelToDraw = this.getLimitedLabelForDrawing(this.mLabel, width - this.mPaddingLeft - this.mPaddingRight);
                }
                int fontHeight = this.mFmi.bottom - this.mFmi.top;
                float marginY = (float)(height - fontHeight) / 2.0f;
                float y = marginY - (float)this.mFmi.top;
                canvas.drawText(labelToDraw, x, y, this.mPaintLabel);
            }
        }

        private String getLimitedLabelForDrawing(String rawLabel, float widthToDraw) {
            float width;
            int subLen = rawLabel.length();
            if (subLen <= 1) {
                return rawLabel;
            }
            while (!((width = this.mPaintLabel.measureText(rawLabel, 0, --subLen)) + this.mSuspensionPointsWidth <= widthToDraw) && 1 < subLen) {
            }
            return rawLabel.substring(0, subLen) + SUSPENSION_POINTS;
        }
    }

    private class BalloonTimer
    extends Handler
    implements Runnable {
        public static final int ACTION_SHOW = 1;
        public static final int ACTION_HIDE = 2;
        public static final int ACTION_UPDATE = 3;
        private int mAction;
        private int[] mPositionInParent = new int[2];
        private int mWidth;
        private int mHeight;
        private boolean mTimerPending = false;

        private BalloonTimer() {
        }

        public void startTimer(long time, int action, int[] positionInParent, int width, int height) {
            this.mAction = action;
            if (2 != action) {
                this.mPositionInParent[0] = positionInParent[0];
                this.mPositionInParent[1] = positionInParent[1];
            }
            this.mWidth = width;
            this.mHeight = height;
            this.postDelayed(this, time);
            this.mTimerPending = true;
        }

        public boolean isPending() {
            return this.mTimerPending;
        }

        public boolean removeTimer() {
            if (this.mTimerPending) {
                this.mTimerPending = false;
                this.removeCallbacks(this);
                return true;
            }
            return false;
        }

        public int getAction() {
            return this.mAction;
        }

        public void run() {
            switch (this.mAction) {
                case 1: {
                    BalloonHint.this.mParent.getLocationInWindow(BalloonHint.this.mParentLocationInWindow);
                    BalloonHint.this.showAtLocation(BalloonHint.this.mParent, 51, this.mPositionInParent[0], this.mPositionInParent[1] + BalloonHint.this.mParentLocationInWindow[1]);
                    break;
                }
                case 2: {
                    BalloonHint.this.dismiss();
                    break;
                }
                case 3: {
                    BalloonHint.this.mParent.getLocationInWindow(BalloonHint.this.mParentLocationInWindow);
                    BalloonHint.this.update(this.mPositionInParent[0], this.mPositionInParent[1] + BalloonHint.this.mParentLocationInWindow[1], this.mWidth, this.mHeight);
                }
            }
            this.mTimerPending = false;
        }
    }
}

