/*
 * Decompiled with CFR 0.152.
 */
package com.android.quicksearchbox.tests.partial;

import android.content.ContentProvider;
import android.content.ContentValues;
import android.database.Cursor;
import android.database.MatrixCursor;
import android.net.Uri;
import android.os.Bundle;
import android.os.Handler;
import android.os.Message;
import android.util.Log;

public class PartialSuggestionProvider
extends ContentProvider {
    private static final String TAG = PartialSuggestionProvider.class.getSimpleName();
    private static final int MSG_COMPLETE = 1;
    private MutableMatrixCursor mCursor;
    private int mType = -1;
    private static final String[] COLUMNS = new String[]{"_id", "suggest_text_1", "suggest_text_2", "suggest_intent_action", "suggest_intent_data"};
    Handler mHandler = new Handler(){

        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 1: {
                    PartialSuggestionProvider.this.mCursor.getExtras().putBoolean("in_progress", false);
                    PartialSuggestionProvider.this.addRows(PartialSuggestionProvider.this.mCursor, false);
                    PartialSuggestionProvider.this.mCursor.notifyChange();
                }
            }
        }
    };

    public boolean onCreate() {
        return true;
    }

    private void addRows(MatrixCursor cursor, boolean partial) {
        for (int i = 0; i < 3; ++i) {
            cursor.addRow(new Object[]{i, (partial ? "Partial" : "Final ") + " suggestion " + i, "This is a suggestion", "android.intent.action.VIEW", "content://com.android.quicksearchbox.partial/partial/" + i});
        }
    }

    public Cursor query(Uri uri, String[] projectionIn, String selection, String[] selectionArgs, String sortOrder) {
        Log.d((String)TAG, (String)("query(" + uri + ")"));
        this.mType = (this.mType + 1) % 3;
        if (this.mType == 0) {
            Log.d((String)TAG, (String)"returning null cursor");
            return null;
        }
        MutableMatrixCursor cursor = new MutableMatrixCursor(COLUMNS);
        if (this.mType == 1) {
            this.addRows(cursor, true);
        } else {
            Log.d((String)TAG, (String)"returning empty cursor");
        }
        cursor.getExtras().putBoolean("in_progress", true);
        this.mCursor = cursor;
        this.mHandler.removeMessages(1);
        this.mHandler.sendMessageDelayed(this.mHandler.obtainMessage(1), 2000L);
        return cursor;
    }

    public String getType(Uri uri) {
        return "vnd.android.cursor.dir/vnd.android.search.suggest";
    }

    public Uri insert(Uri uri, ContentValues values) {
        throw new UnsupportedOperationException();
    }

    public int update(Uri uri, ContentValues values, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException();
    }

    public int delete(Uri uri, String selection, String[] selectionArgs) {
        throw new UnsupportedOperationException();
    }

    private static class MutableMatrixCursor
    extends MatrixCursor {
        Bundle mBundle;

        MutableMatrixCursor(String[] columns) {
            super(columns);
        }

        public Bundle getExtras() {
            if (this.mBundle == null) {
                this.mBundle = new Bundle();
            }
            return this.mBundle;
        }

        public void notifyChange() {
            this.onChange(false);
        }
    }
}

