/*
 * Decompiled with CFR 0.152.
 */
package com.android.nfc.ndefpush;

import android.nfc.FormatException;
import android.util.Log;
import com.android.internal.nfc.LlcpException;
import com.android.internal.nfc.LlcpServiceSocket;
import com.android.internal.nfc.LlcpSocket;
import com.android.nfc.NfcService;
import com.android.nfc.ndefpush.NdefPushProtocol;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class NdefPushServer {
    private static final String TAG = "NdefPushServer";
    private static final boolean DBG = true;
    private static final int SERVICE_SAP = 16;
    private static final int MIU = 248;
    static final String SERVICE_NAME = "com.android.npp";
    NfcService mService = NfcService.getInstance();
    ServerThread mServerThread = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void start() {
        NdefPushServer ndefPushServer = this;
        synchronized (ndefPushServer) {
            Log.d((String)TAG, (String)("start, thread = " + this.mServerThread));
            if (this.mServerThread == null) {
                Log.d((String)TAG, (String)"starting new server thread");
                this.mServerThread = new ServerThread();
                this.mServerThread.start();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        NdefPushServer ndefPushServer = this;
        synchronized (ndefPushServer) {
            Log.d((String)TAG, (String)("stop, thread = " + this.mServerThread));
            if (this.mServerThread != null) {
                Log.d((String)TAG, (String)"shuting down server thread");
                this.mServerThread.shutdown();
                this.mServerThread = null;
            }
        }
    }

    class ServerThread
    extends Thread {
        boolean mRunning = true;
        LlcpServiceSocket mServerSocket;

        ServerThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (this.mRunning) {
                Log.d((String)NdefPushServer.TAG, (String)"about create LLCP service socket");
                this.mServerSocket = NdefPushServer.this.mService.createLlcpServiceSocket(16, NdefPushServer.SERVICE_NAME, 248, 1, 1024);
                if (this.mServerSocket == null) {
                    Log.d((String)NdefPushServer.TAG, (String)"failed to create LLCP service socket");
                    return;
                }
                Log.d((String)NdefPushServer.TAG, (String)"created LLCP service socket");
                try {
                    while (this.mRunning) {
                        Log.d((String)NdefPushServer.TAG, (String)"about to accept");
                        LlcpSocket communicationSocket = this.mServerSocket.accept();
                        Log.d((String)NdefPushServer.TAG, (String)("accept returned " + communicationSocket));
                        if (communicationSocket == null) continue;
                        new ConnectionThread(communicationSocket).start();
                    }
                    Log.d((String)NdefPushServer.TAG, (String)"stop running");
                }
                catch (LlcpException e) {
                    Log.e((String)NdefPushServer.TAG, (String)"llcp error", (Throwable)e);
                }
                catch (IOException e) {
                    Log.e((String)NdefPushServer.TAG, (String)"IO error", (Throwable)e);
                }
                finally {
                    if (this.mServerSocket == null) continue;
                    Log.d((String)NdefPushServer.TAG, (String)"about to close");
                    this.mServerSocket.close();
                    this.mServerSocket = null;
                }
            }
        }

        public void shutdown() {
            this.mRunning = false;
            if (this.mServerSocket != null) {
                this.mServerSocket.close();
                this.mServerSocket = null;
            }
        }
    }

    private class ConnectionThread
    extends Thread {
        private LlcpSocket mSock;

        ConnectionThread(LlcpSocket sock) {
            super(NdefPushServer.TAG);
            this.mSock = sock;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            Log.d((String)NdefPushServer.TAG, (String)"starting connection thread");
            try {
                ByteArrayOutputStream buffer = new ByteArrayOutputStream(1024);
                byte[] partial = new byte[1024];
                boolean connectionBroken = false;
                while (!connectionBroken) {
                    try {
                        int size = this.mSock.receive(partial);
                        Log.d((String)NdefPushServer.TAG, (String)("read " + size + " bytes"));
                        if (size < 0) {
                            connectionBroken = true;
                            break;
                        }
                        buffer.write(partial, 0, size);
                    }
                    catch (IOException e) {
                        connectionBroken = true;
                        Log.d((String)NdefPushServer.TAG, (String)"connection broken by IOException", (Throwable)e);
                    }
                }
                NdefPushProtocol msg = new NdefPushProtocol(buffer.toByteArray());
                Log.d((String)NdefPushServer.TAG, (String)("got message " + msg.toString()));
                NdefPushServer.this.mService.sendMockNdefTag(msg.getImmediate());
            }
            catch (FormatException e) {
                Log.e((String)NdefPushServer.TAG, (String)"badly formatted NDEF message, ignoring", (Throwable)e);
            }
            finally {
                try {
                    Log.d((String)NdefPushServer.TAG, (String)"about to close");
                    this.mSock.close();
                }
                catch (IOException iOException) {}
            }
            Log.d((String)NdefPushServer.TAG, (String)"finished connection thread");
        }
    }
}

