/*
 * Decompiled with CFR 0.152.
 */
package com.android.nfc.ndefpush;

import android.nfc.FormatException;
import android.nfc.NdefMessage;
import android.util.Log;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;

public class NdefPushProtocol {
    public static final byte ACTION_IMMEDIATE = 1;
    public static final byte ACTION_BACKGROUND = 2;
    private static final String TAG = "NdefMessageSet";
    private static final byte VERSION = 1;
    private int mNumMessages;
    private byte[] mActions;
    private NdefMessage[] mMessages;

    public NdefPushProtocol(NdefMessage msg, byte action) {
        this.mNumMessages = 1;
        this.mActions = new byte[1];
        this.mActions[0] = action;
        this.mMessages = new NdefMessage[1];
        this.mMessages[0] = msg;
    }

    public NdefPushProtocol(byte[] actions, NdefMessage[] messages) {
        if (actions.length != messages.length || actions.length == 0) {
            throw new IllegalArgumentException("actions and messages must be the same size and non-empty");
        }
        int numMessages = actions.length;
        this.mActions = new byte[numMessages];
        System.arraycopy(actions, 0, this.mActions, 0, numMessages);
        this.mMessages = new NdefMessage[numMessages];
        System.arraycopy(messages, 0, this.mMessages, 0, numMessages);
        this.mNumMessages = numMessages;
    }

    public NdefPushProtocol(byte[] data) throws FormatException {
        byte version;
        ByteArrayInputStream buffer = new ByteArrayInputStream(data);
        DataInputStream input = new DataInputStream(buffer);
        try {
            version = input.readByte();
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"Unable to read version");
            throw new FormatException("Unable to read version");
        }
        if (version != 1) {
            Log.w((String)TAG, (String)("Got version " + version + ",  expected " + 1));
            throw new FormatException("Got version " + version + ",  expected " + 1);
        }
        try {
            this.mNumMessages = input.readInt();
        }
        catch (IOException e) {
            Log.w((String)TAG, (String)"Unable to read numMessages");
            throw new FormatException("Error while parsing NdefMessageSet");
        }
        if (this.mNumMessages == 0) {
            Log.w((String)TAG, (String)"No NdefMessage inside NdefMessageSet packet");
            throw new FormatException("Error while parsing NdefMessageSet");
        }
        this.mActions = new byte[this.mNumMessages];
        this.mMessages = new NdefMessage[this.mNumMessages];
        for (int i = 0; i < this.mNumMessages; ++i) {
            int lengthRead;
            int length;
            try {
                this.mActions[i] = input.readByte();
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)("Unable to read action for message " + i));
                throw new FormatException("Error while parsing NdefMessageSet");
            }
            try {
                length = input.readInt();
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)("Unable to read length for message " + i));
                throw new FormatException("Error while parsing NdefMessageSet");
            }
            byte[] bytes = new byte[length];
            try {
                lengthRead = input.read(bytes);
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)("Unable to read bytes for message " + i));
                throw new FormatException("Error while parsing NdefMessageSet");
            }
            if (length != lengthRead) {
                Log.w((String)TAG, (String)("Read " + lengthRead + " bytes but expected " + length));
                throw new FormatException("Error while parsing NdefMessageSet");
            }
            this.mMessages[i] = new NdefMessage(bytes);
            continue;
        }
    }

    public NdefMessage getImmediate() {
        for (int i = 0; i < this.mNumMessages; ++i) {
            if (this.mActions[i] != 1) continue;
            return this.mMessages[i];
        }
        return null;
    }

    public byte[] toByteArray() {
        ByteArrayOutputStream buffer = new ByteArrayOutputStream(1024);
        DataOutputStream output = new DataOutputStream(buffer);
        try {
            output.writeByte(1);
            output.writeInt(this.mNumMessages);
            for (int i = 0; i < this.mNumMessages; ++i) {
                output.writeByte(this.mActions[i]);
                byte[] bytes = this.mMessages[i].toByteArray();
                output.writeInt(bytes.length);
                output.write(bytes);
            }
        }
        catch (IOException e) {
            return null;
        }
        return buffer.toByteArray();
    }
}

