/*
 * Decompiled with CFR 0.152.
 */
package com.android.nfc.ndefpush;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.nfc.NdefMessage;
import android.nfc.NfcAdapter;
import android.os.AsyncTask;
import android.util.Log;
import com.android.internal.nfc.LlcpException;
import com.android.internal.nfc.LlcpSocket;
import com.android.nfc.NfcService;
import com.android.nfc.ndefpush.NdefPushProtocol;
import java.io.IOException;
import java.util.Arrays;

public class NdefPushClient
extends BroadcastReceiver {
    private static final String TAG = "NdefPushClient";
    private static final int MIU = 128;
    private static final boolean DBG = true;
    NdefMessage mForegroundMsg;

    public NdefPushClient(Context context) {
        context.registerReceiver((BroadcastReceiver)this, new IntentFilter("android.nfc.action.LLCP_LINK_STATE_CHANGED"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean setForegroundMessage(NdefMessage msg) {
        NdefPushClient ndefPushClient = this;
        synchronized (ndefPushClient) {
            boolean set = this.mForegroundMsg != null;
            this.mForegroundMsg = msg;
            return set;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NdefMessage getForegroundMessage() {
        NdefPushClient ndefPushClient = this;
        synchronized (ndefPushClient) {
            return this.mForegroundMsg;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void onReceive(Context context, Intent intent) {
        NdefMessage foregroundMsg;
        int linkState = intent.getIntExtra("android.nfc.extra.LLCP_LINK_STATE", 1);
        if (linkState != 0) {
            return;
        }
        Log.d((String)TAG, (String)"LLCP connection up and running");
        NdefPushClient ndefPushClient = this;
        synchronized (ndefPushClient) {
            foregroundMsg = this.mForegroundMsg;
        }
        NfcAdapter adapter = NfcAdapter.getDefaultAdapter((Context)context);
        NdefMessage myTag = adapter.getLocalNdefMessage();
        if (foregroundMsg != null && myTag != null) {
            Log.d((String)TAG, (String)"sending foreground and my tag");
            new SendAsync().execute(new NdefMessage[]{foregroundMsg, myTag});
        } else if (myTag != null) {
            Log.d((String)TAG, (String)"sending my tag");
            new SendAsync().execute(new NdefMessage[]{myTag});
        } else if (foregroundMsg != null) {
            Log.d((String)TAG, (String)"sending foreground");
            new SendAsync().execute(new NdefMessage[]{foregroundMsg});
        } else {
            Log.d((String)TAG, (String)"no tags set, bailing");
            return;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    final class SendAsync
    extends AsyncTask<NdefMessage, Void, Void> {
        SendAsync() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public Void doInBackground(NdefMessage ... msgs) {
            NfcService service = NfcService.getInstance();
            NdefPushProtocol msg = new NdefPushProtocol(msgs[0], 1);
            byte[] buffer = msg.toByteArray();
            LlcpSocket sock = null;
            try {
                int length;
                Log.d((String)NdefPushClient.TAG, (String)"about to create socket");
                sock = service.createLlcpSocket(0, 128, 1, 1024);
                Log.d((String)NdefPushClient.TAG, (String)"about to connect to service com.android.npp");
                sock.connect("com.android.npp");
                int remoteMiu = sock.getRemoteSocketMiu();
                Log.d((String)NdefPushClient.TAG, (String)("about to send a " + buffer.length + " byte message"));
                for (int offset = 0; offset < buffer.length; offset += length) {
                    length = Math.min(buffer.length - offset, remoteMiu);
                    byte[] tmpBuffer = Arrays.copyOfRange(buffer, offset, offset + length);
                    Log.d((String)NdefPushClient.TAG, (String)("about to send a " + length + " byte packet"));
                    sock.send(tmpBuffer);
                }
            }
            catch (IOException e) {
                Log.e((String)NdefPushClient.TAG, (String)"couldn't send tag");
                Log.d((String)NdefPushClient.TAG, (String)"exception:", (Throwable)e);
            }
            catch (LlcpException e) {
                Log.e((String)NdefPushClient.TAG, (String)"couldn't send tag");
                Log.d((String)NdefPushClient.TAG, (String)"exception:", (Throwable)e);
            }
            finally {
                if (sock != null) {
                    try {
                        Log.d((String)NdefPushClient.TAG, (String)"about to close");
                        sock.close();
                    }
                    catch (IOException e) {}
                }
            }
            return null;
        }
    }
}

