/*
 * Decompiled with CFR 0.152.
 */
package com.android.nfc;

import android.content.BroadcastReceiver;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.pm.ActivityInfo;
import android.content.pm.PackageManager;
import android.content.pm.ResolveInfo;
import android.content.res.Resources;
import android.content.res.XmlResourceParser;
import android.util.Log;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.atomic.AtomicReference;
import org.xmlpull.v1.XmlPullParser;
import org.xmlpull.v1.XmlPullParserException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RegisteredComponentCache {
    private static final String TAG = "RegisteredComponentCache";
    final Context mContext;
    final String mAction;
    final String mMetaDataName;
    final AtomicReference<BroadcastReceiver> mReceiver;
    private ArrayList<ComponentInfo> mComponents;

    public RegisteredComponentCache(Context context, String action, String metaDataName) {
        this.mContext = context;
        this.mAction = action;
        this.mMetaDataName = metaDataName;
        this.generateComponentsList();
        BroadcastReceiver receiver = new BroadcastReceiver(){

            public void onReceive(Context context1, Intent intent) {
                RegisteredComponentCache.this.generateComponentsList();
            }
        };
        this.mReceiver = new AtomicReference<1>(receiver);
        IntentFilter intentFilter = new IntentFilter();
        intentFilter.addAction("android.intent.action.PACKAGE_ADDED");
        intentFilter.addAction("android.intent.action.PACKAGE_CHANGED");
        intentFilter.addAction("android.intent.action.PACKAGE_REMOVED");
        intentFilter.addDataScheme("package");
        this.mContext.registerReceiver(receiver, intentFilter);
        IntentFilter sdFilter = new IntentFilter();
        sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_AVAILABLE");
        sdFilter.addAction("android.intent.action.EXTERNAL_APPLICATIONS_UNAVAILABLE");
        this.mContext.registerReceiver(receiver, sdFilter);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ArrayList<ComponentInfo> getComponents() {
        RegisteredComponentCache registeredComponentCache = this;
        synchronized (registeredComponentCache) {
            return this.mComponents;
        }
    }

    public void close() {
        BroadcastReceiver receiver = this.mReceiver.getAndSet(null);
        if (receiver != null) {
            this.mContext.unregisterReceiver(receiver);
        }
    }

    protected void finalize() throws Throwable {
        if (this.mReceiver.get() != null) {
            Log.e((String)TAG, (String)"RegisteredServicesCache finalized without being closed");
        }
        this.close();
        super.finalize();
    }

    void dump(ArrayList<ComponentInfo> components) {
        for (ComponentInfo component : components) {
            Log.i((String)TAG, (String)component.toString());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void generateComponentsList() {
        PackageManager pm = this.mContext.getPackageManager();
        ArrayList<ComponentInfo> components = new ArrayList<ComponentInfo>();
        List resolveInfos = pm.queryIntentActivities(new Intent(this.mAction), 128);
        for (ResolveInfo resolveInfo : resolveInfos) {
            try {
                this.parseComponentInfo(resolveInfo, components);
            }
            catch (XmlPullParserException e) {
                Log.w((String)TAG, (String)("Unable to load component info " + resolveInfo.toString()), (Throwable)e);
            }
            catch (IOException e) {
                Log.w((String)TAG, (String)("Unable to load component info " + resolveInfo.toString()), (Throwable)e);
            }
        }
        this.dump(components);
        RegisteredComponentCache registeredComponentCache = this;
        synchronized (registeredComponentCache) {
            this.mComponents = components;
        }
    }

    void parseComponentInfo(ResolveInfo info, ArrayList<ComponentInfo> components) throws XmlPullParserException, IOException {
        ActivityInfo ai = info.activityInfo;
        PackageManager pm = this.mContext.getPackageManager();
        XmlResourceParser parser = null;
        try {
            parser = ai.loadXmlMetaData(pm, this.mMetaDataName);
            if (parser == null) {
                throw new XmlPullParserException("No " + this.mMetaDataName + " meta-data");
            }
            this.parseTechLists(pm.getResourcesForApplication(ai.applicationInfo), ai.packageName, (XmlPullParser)parser, info, components);
        }
        catch (PackageManager.NameNotFoundException e) {
            throw new XmlPullParserException("Unable to load resources for " + ai.packageName);
        }
        finally {
            if (parser != null) {
                parser.close();
            }
        }
    }

    void parseTechLists(Resources res, String packageName, XmlPullParser parser, ResolveInfo resolveInfo, ArrayList<ComponentInfo> components) throws XmlPullParserException, IOException {
        int eventType = parser.getEventType();
        while (eventType != 2) {
            eventType = parser.next();
        }
        ArrayList<String> items = new ArrayList<String>();
        eventType = parser.next();
        do {
            int size;
            String tagName = parser.getName();
            if (eventType == 2 && "tech".equals(tagName)) {
                items.add(parser.nextText());
                continue;
            }
            if (eventType != 3 || !"tech-list".equals(tagName) || (size = items.size()) <= 0) continue;
            String[] techs = new String[size];
            techs = items.toArray(techs);
            items.clear();
            components.add(new ComponentInfo(resolveInfo, techs));
        } while ((eventType = parser.next()) != 1);
    }

    public static class ComponentInfo {
        public final ResolveInfo resolveInfo;
        public final String[] techs;

        ComponentInfo(ResolveInfo resolveInfo, String[] techs) {
            this.resolveInfo = resolveInfo;
            this.techs = techs;
        }

        public String toString() {
            StringBuilder out = new StringBuilder("ComponentInfo: ");
            out.append(this.resolveInfo);
            out.append(", techs: ");
            for (String tech : this.techs) {
                out.append(tech);
                out.append(", ");
            }
            return out.toString();
        }
    }
}

