/*
 * Decompiled with CFR 0.152.
 */
package com.android.nfc;

import android.app.ActivityManagerNative;
import android.app.Application;
import android.app.IActivityManager;
import android.app.PendingIntent;
import android.app.StatusBarManager;
import android.content.ActivityNotFoundException;
import android.content.BroadcastReceiver;
import android.content.ComponentName;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.content.SharedPreferences;
import android.content.pm.ResolveInfo;
import android.net.Uri;
import android.nfc.ErrorCodes;
import android.nfc.FormatException;
import android.nfc.ILlcpConnectionlessSocket;
import android.nfc.ILlcpServiceSocket;
import android.nfc.ILlcpSocket;
import android.nfc.INfcAdapter;
import android.nfc.INfcAdapterExtras;
import android.nfc.INfcTag;
import android.nfc.IP2pInitiator;
import android.nfc.IP2pTarget;
import android.nfc.LlcpPacket;
import android.nfc.NdefMessage;
import android.nfc.NdefRecord;
import android.nfc.Tag;
import android.nfc.TechListParcel;
import android.nfc.TransceiveResult;
import android.os.AsyncTask;
import android.os.Bundle;
import android.os.Handler;
import android.os.IBinder;
import android.os.Message;
import android.os.Parcelable;
import android.os.PowerManager;
import android.os.RemoteException;
import android.os.ServiceManager;
import android.util.Log;
import com.android.internal.nfc.LlcpServiceSocket;
import com.android.internal.nfc.LlcpSocket;
import com.android.nfc.NativeLlcpConnectionlessSocket;
import com.android.nfc.NativeLlcpServiceSocket;
import com.android.nfc.NativeLlcpSocket;
import com.android.nfc.NativeNfcManager;
import com.android.nfc.NativeNfcSecureElement;
import com.android.nfc.NativeNfcTag;
import com.android.nfc.NativeP2pDevice;
import com.android.nfc.RegisteredComponentCache;
import com.android.nfc.TechListChooserActivity;
import com.android.nfc.ndefpush.NdefPushClient;
import com.android.nfc.ndefpush.NdefPushServer;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class NfcService
extends Application {
    private static final String ACTION_MASTER_CLEAR_NOTIFICATION = "android.intent.action.MASTER_CLEAR_NOTIFICATION";
    static final boolean DBG = false;
    private static final String MY_TAG_FILE_NAME = "mytag";
    private static final String SE_RESET_SCRIPT_FILE_NAME = "/system/etc/se-reset-script";
    private static final String NFC_CONTROLLER_FIRMWARE_FILE_NAME = "/system/lib/libpn544_fw.so";
    private static final String[] URI_PREFIX_MAP;
    public static final String SERVICE_NAME = "nfc";
    private static final String TAG = "NfcService";
    private static final String NFC_PERM = "android.permission.NFC";
    private static final String NFC_PERM_ERROR = "NFC permission required";
    private static final String ADMIN_PERM = "android.permission.WRITE_SECURE_SETTINGS";
    private static final String ADMIN_PERM_ERROR = "WRITE_SECURE_SETTINGS permission required";
    private static final String NFCEE_ADMIN_PERM = "com.android.nfc.permission.NFCEE_ADMIN";
    private static final String NFCEE_ADMIN_PERM_ERROR = "NFCEE_ADMIN permission required";
    private static final String PREF = "NfcServicePrefs";
    private static final String PREF_NFC_ON = "nfc_on";
    private static final boolean NFC_ON_DEFAULT = true;
    private static final String PREF_FIRST_BOOT = "first_boot";
    private static final String PREF_LLCP_LTO = "llcp_lto";
    private static final int LLCP_LTO_DEFAULT = 150;
    private static final int LLCP_LTO_MAX = 255;
    private static final String PREF_LLCP_MIU = "llcp_miu";
    private static final int LLCP_MIU_DEFAULT = 128;
    private static final int LLCP_MIU_MAX = 2176;
    private static final String PREF_LLCP_WKS = "llcp_wks";
    private static final int LLCP_WKS_DEFAULT = 1;
    private static final int LLCP_WKS_MAX = 15;
    private static final String PREF_LLCP_OPT = "llcp_opt";
    private static final int LLCP_OPT_DEFAULT = 0;
    private static final int LLCP_OPT_MAX = 3;
    private static final String PREF_DISCOVERY_A = "discovery_a";
    private static final boolean DISCOVERY_A_DEFAULT = true;
    private static final String PREF_DISCOVERY_B = "discovery_b";
    private static final boolean DISCOVERY_B_DEFAULT = true;
    private static final String PREF_DISCOVERY_F = "discovery_f";
    private static final boolean DISCOVERY_F_DEFAULT = true;
    private static final String PREF_DISCOVERY_15693 = "discovery_15693";
    private static final boolean DISCOVERY_15693_DEFAULT = true;
    private static final String PREF_DISCOVERY_NFCIP = "discovery_nfcip";
    private static final boolean DISCOVERY_NFCIP_DEFAULT = true;
    private static final String PREF_FIRMWARE_MODTIME = "firmware_modtime";
    private static final long FIRMWARE_MODTIME_DEFAULT = -1L;
    private static final int DISCOVERY_MODE_READER = 0;
    private static final int PROPERTY_LLCP_LTO = 0;
    private static final String PROPERTY_LLCP_LTO_VALUE = "llcp.lto";
    private static final int PROPERTY_LLCP_MIU = 1;
    private static final String PROPERTY_LLCP_MIU_VALUE = "llcp.miu";
    private static final int PROPERTY_LLCP_WKS = 2;
    private static final String PROPERTY_LLCP_WKS_VALUE = "llcp.wks";
    private static final int PROPERTY_LLCP_OPT = 3;
    private static final String PROPERTY_LLCP_OPT_VALUE = "llcp.opt";
    private static final int PROPERTY_NFC_DISCOVERY_A = 4;
    private static final String PROPERTY_NFC_DISCOVERY_A_VALUE = "discovery.iso14443A";
    private static final int PROPERTY_NFC_DISCOVERY_B = 5;
    private static final String PROPERTY_NFC_DISCOVERY_B_VALUE = "discovery.iso14443B";
    private static final int PROPERTY_NFC_DISCOVERY_F = 6;
    private static final String PROPERTY_NFC_DISCOVERY_F_VALUE = "discovery.felica";
    private static final int PROPERTY_NFC_DISCOVERY_15693 = 7;
    private static final String PROPERTY_NFC_DISCOVERY_15693_VALUE = "discovery.iso15693";
    private static final int PROPERTY_NFC_DISCOVERY_NFCIP = 8;
    private static final String PROPERTY_NFC_DISCOVERY_NFCIP_VALUE = "discovery.nfcip";
    static final int MSG_NDEF_TAG = 0;
    static final int MSG_CARD_EMULATION = 1;
    static final int MSG_LLCP_LINK_ACTIVATION = 2;
    static final int MSG_LLCP_LINK_DEACTIVATED = 3;
    static final int MSG_TARGET_DESELECTED = 4;
    static final int MSG_SHOW_MY_TAG_ICON = 5;
    static final int MSG_HIDE_MY_TAG_ICON = 6;
    static final int MSG_MOCK_NDEF = 7;
    static final int MSG_SE_FIELD_ACTIVATED = 8;
    static final int MSG_SE_FIELD_DEACTIVATED = 9;
    static final int MSG_SE_APDU_RECEIVED = 10;
    static final int MSG_SE_EMV_CARD_REMOVAL = 11;
    static final int MSG_SE_MIFARE_ACCESS = 12;
    static final int STATUS_CODE_TARGET_LOST = 146;
    static final int ROUTE_OFF = 1;
    static final int ROUTE_ON_WHEN_SCREEN_ON = 2;
    public static final String ACTION_RF_FIELD_ON_DETECTED = "com.android.nfc_extras.action.RF_FIELD_ON_DETECTED";
    public static final String ACTION_RF_FIELD_OFF_DETECTED = "com.android.nfc_extras.action.RF_FIELD_OFF_DETECTED";
    public static final String ACTION_AID_SELECTED = "com.android.nfc_extras.action.AID_SELECTED";
    public static final String EXTRA_AID = "com.android.nfc_extras.extra.AID";
    public static final String ACTION_APDU_RECEIVED = "com.android.nfc_extras.action.APDU_RECEIVED";
    public static final String EXTRA_APDU_BYTES = "com.android.nfc_extras.extra.APDU_BYTES";
    public static final String ACTION_EMV_CARD_REMOVAL = "com.android.nfc_extras.action.EMV_CARD_REMOVAL";
    public static final String ACTION_MIFARE_ACCESS_DETECTED = "com.android.nfc_extras.action.MIFARE_ACCESS_DETECTED";
    public static final String EXTRA_MIFARE_BLOCK = "com.android.nfc_extras.extra.MIFARE_BLOCK";
    PendingIntent mDispatchOverrideIntent;
    IntentFilter[] mDispatchOverrideFilters;
    String[][] mDispatchOverrideTechLists;
    private int mGeneratedSocketHandle = 0;
    private volatile boolean mIsNfcEnabled = false;
    private boolean mIsDiscoveryOn = false;
    private static final int SECURE_ELEMENT_ID = 11259375;
    private NativeNfcSecureElement mSecureElement;
    private OpenSecureElement mOpenEe;
    private int mEeRoutingState;
    private final HashMap<Integer, Object> mObjectMap = new HashMap();
    private final HashMap<Integer, Object> mSocketMap = new HashMap();
    private boolean mScreenOn;
    private HashSet<String> mSePackages = new HashSet();
    Context mContext;
    private NativeNfcManager mManager;
    private SharedPreferences mPrefs;
    private SharedPreferences.Editor mPrefsEditor;
    private PowerManager.WakeLock mWakeLock;
    private IActivityManager mIActivityManager;
    NdefPushClient mNdefPushClient;
    NdefPushServer mNdefPushServer;
    RegisteredComponentCache mTechListFilters;
    private static NfcService sService;
    private final INfcAdapter.Stub mNfcAdapter = new INfcAdapter.Stub(){
        NdefMessage mLocalMessage = null;

        public boolean enable() throws RemoteException {
            NfcService.enforceAdminPerm(NfcService.this.mContext);
            boolean isSuccess = false;
            boolean previouslyEnabled = this.isEnabled();
            if (!previouslyEnabled) {
                NfcService.this.reset();
                isSuccess = NfcService.this._enable(previouslyEnabled, true);
            }
            return isSuccess;
        }

        public boolean disable() throws RemoteException {
            boolean isSuccess = false;
            NfcService.enforceAdminPerm(NfcService.this.mContext);
            boolean previouslyEnabled = this.isEnabled();
            if (previouslyEnabled) {
                isSuccess = NfcService.this._disable(previouslyEnabled, true);
            }
            return isSuccess;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void enableForegroundDispatch(ComponentName activity, PendingIntent intent, IntentFilter[] filters, TechListParcel techListsParcel) {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            if (activity == null || intent == null) {
                throw new IllegalArgumentException();
            }
            if (filters != null) {
                if (filters.length == 0) {
                    filters = null;
                } else {
                    for (IntentFilter filter : filters) {
                        if (filter != null) continue;
                        throw new IllegalArgumentException("null IntentFilter");
                    }
                }
            }
            String[][] techLists = null;
            if (techListsParcel != null) {
                techLists = techListsParcel.getTechLists();
            }
            2 var6_7 = this;
            synchronized (var6_7) {
                if (NfcService.this.mDispatchOverrideIntent != null) {
                    Log.e((String)NfcService.TAG, (String)"Replacing active dispatch overrides");
                }
                NfcService.this.mDispatchOverrideIntent = intent;
                NfcService.this.mDispatchOverrideFilters = filters;
                NfcService.this.mDispatchOverrideTechLists = techLists;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void disableForegroundDispatch(ComponentName activity) {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            2 var2_2 = this;
            synchronized (var2_2) {
                if (NfcService.this.mDispatchOverrideIntent == null) {
                    Log.e((String)NfcService.TAG, (String)"No active foreground dispatching");
                }
                NfcService.this.mDispatchOverrideIntent = null;
                NfcService.this.mDispatchOverrideFilters = null;
            }
        }

        public void enableForegroundNdefPush(ComponentName activity, NdefMessage msg) {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            if (activity == null || msg == null) {
                throw new IllegalArgumentException();
            }
            if (NfcService.this.mNdefPushClient.setForegroundMessage(msg)) {
                Log.e((String)NfcService.TAG, (String)"Replacing active NDEF push message");
            }
        }

        public void disableForegroundNdefPush(ComponentName activity) {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            if (!NfcService.this.mNdefPushClient.setForegroundMessage(null)) {
                Log.e((String)NfcService.TAG, (String)"No active foreground NDEF push message");
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int createLlcpConnectionlessSocket(int sap) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            if (!NfcService.this.mIsNfcEnabled) {
                return -17;
            }
            int sockeHandle = NfcService.this.mGeneratedSocketHandle;
            NativeLlcpConnectionlessSocket socket = NfcService.this.mManager.doCreateLlcpConnectionlessSocket(sap);
            if (socket != null) {
                NfcService nfcService = NfcService.this;
                synchronized (nfcService) {
                    NfcService.this.mGeneratedSocketHandle++;
                    NfcService.this.mSocketMap.put(NfcService.this.mGeneratedSocketHandle, socket);
                    return NfcService.this.mGeneratedSocketHandle;
                }
            }
            int errorStatus = NfcService.this.mManager.doGetLastError();
            switch (errorStatus) {
                case -12: {
                    return -12;
                }
                case -9: {
                    return -9;
                }
            }
            return -10;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int createLlcpServiceSocket(int sap, String sn, int miu, int rw, int linearBufferLength) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            if (!NfcService.this.mIsNfcEnabled) {
                return -17;
            }
            NativeLlcpServiceSocket socket = NfcService.this.mManager.doCreateLlcpServiceSocket(sap, sn, miu, rw, linearBufferLength);
            if (socket != null) {
                NfcService nfcService = NfcService.this;
                synchronized (nfcService) {
                    NfcService.this.mGeneratedSocketHandle++;
                    NfcService.this.mSocketMap.put(NfcService.this.mGeneratedSocketHandle, socket);
                    return NfcService.this.mGeneratedSocketHandle;
                }
            }
            int errorStatus = NfcService.this.mManager.doGetLastError();
            switch (errorStatus) {
                case -12: {
                    return -12;
                }
                case -9: {
                    return -9;
                }
            }
            return -10;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int createLlcpSocket(int sap, int miu, int rw, int linearBufferLength) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            if (!NfcService.this.mIsNfcEnabled) {
                return -17;
            }
            NativeLlcpSocket socket = NfcService.this.mManager.doCreateLlcpSocket(sap, miu, rw, linearBufferLength);
            if (socket != null) {
                NfcService nfcService = NfcService.this;
                synchronized (nfcService) {
                    NfcService.this.mGeneratedSocketHandle++;
                    NfcService.this.mSocketMap.put(NfcService.this.mGeneratedSocketHandle, socket);
                    return NfcService.this.mGeneratedSocketHandle;
                }
            }
            int errorStatus = NfcService.this.mManager.doGetLastError();
            Log.d((String)NfcService.TAG, (String)("failed to create llcp socket: " + ErrorCodes.asString((int)errorStatus)));
            switch (errorStatus) {
                case -12: {
                    return -12;
                }
                case -9: {
                    return -9;
                }
            }
            return -10;
        }

        public ILlcpConnectionlessSocket getLlcpConnectionlessInterface() throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            return NfcService.this.mLlcpConnectionlessSocketService;
        }

        public ILlcpSocket getLlcpInterface() throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            return NfcService.this.mLlcpSocket;
        }

        public ILlcpServiceSocket getLlcpServiceInterface() throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            return NfcService.this.mLlcpServerSocketService;
        }

        public INfcTag getNfcTagInterface() throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            return NfcService.this.mNfcTagService;
        }

        public IP2pInitiator getP2pInitiatorInterface() throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            return NfcService.this.mP2pInitiatorService;
        }

        public IP2pTarget getP2pTargetInterface() throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            return NfcService.this.mP2pTargetService;
        }

        public INfcAdapterExtras getNfcAdapterExtrasInterface() {
            NfcService.enforceNfceeAdminPerm(NfcService.this.mContext);
            return NfcService.this.mExtrasService;
        }

        public String getProperties(String param) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            if (param == null) {
                return null;
            }
            if (param.equals(NfcService.PROPERTY_LLCP_LTO_VALUE)) {
                return Integer.toString(NfcService.this.mPrefs.getInt(NfcService.PREF_LLCP_LTO, 150));
            }
            if (param.equals(NfcService.PROPERTY_LLCP_MIU_VALUE)) {
                return Integer.toString(NfcService.this.mPrefs.getInt(NfcService.PREF_LLCP_MIU, 128));
            }
            if (param.equals(NfcService.PROPERTY_LLCP_WKS_VALUE)) {
                return Integer.toString(NfcService.this.mPrefs.getInt(NfcService.PREF_LLCP_WKS, 1));
            }
            if (param.equals(NfcService.PROPERTY_LLCP_OPT_VALUE)) {
                return Integer.toString(NfcService.this.mPrefs.getInt(NfcService.PREF_LLCP_OPT, 0));
            }
            if (param.equals(NfcService.PROPERTY_NFC_DISCOVERY_A_VALUE)) {
                return Boolean.toString(NfcService.this.mPrefs.getBoolean(NfcService.PREF_DISCOVERY_A, true));
            }
            if (param.equals(NfcService.PROPERTY_NFC_DISCOVERY_B_VALUE)) {
                return Boolean.toString(NfcService.this.mPrefs.getBoolean(NfcService.PREF_DISCOVERY_B, true));
            }
            if (param.equals(NfcService.PROPERTY_NFC_DISCOVERY_F_VALUE)) {
                return Boolean.toString(NfcService.this.mPrefs.getBoolean(NfcService.PREF_DISCOVERY_F, true));
            }
            if (param.equals(NfcService.PROPERTY_NFC_DISCOVERY_NFCIP_VALUE)) {
                return Boolean.toString(NfcService.this.mPrefs.getBoolean(NfcService.PREF_DISCOVERY_NFCIP, true));
            }
            if (param.equals(NfcService.PROPERTY_NFC_DISCOVERY_15693_VALUE)) {
                return Boolean.toString(NfcService.this.mPrefs.getBoolean(NfcService.PREF_DISCOVERY_15693, true));
            }
            return "Unknown property";
        }

        public boolean isEnabled() throws RemoteException {
            return NfcService.this.mIsNfcEnabled;
        }

        public int setProperties(String param, String value) throws RemoteException {
            NfcService.enforceAdminPerm(NfcService.this.mContext);
            if (this.isEnabled()) {
                return -16;
            }
            if (param == null || value == null) {
                return -8;
            }
            if (param.equals(NfcService.PROPERTY_LLCP_LTO_VALUE)) {
                int val = Integer.parseInt(value);
                if (val > 255) {
                    return -8;
                }
                NfcService.this.mPrefsEditor.putInt(NfcService.PREF_LLCP_LTO, val);
                NfcService.this.mPrefsEditor.apply();
                NfcService.this.mManager.doSetProperties(0, val);
            } else if (param.equals(NfcService.PROPERTY_LLCP_MIU_VALUE)) {
                int val = Integer.parseInt(value);
                if (val < 128 || val > 2176) {
                    return -8;
                }
                NfcService.this.mPrefsEditor.putInt(NfcService.PREF_LLCP_MIU, val);
                NfcService.this.mPrefsEditor.apply();
                NfcService.this.mManager.doSetProperties(1, val);
            } else if (param.equals(NfcService.PROPERTY_LLCP_WKS_VALUE)) {
                int val = Integer.parseInt(value);
                if (val > 15) {
                    return -8;
                }
                NfcService.this.mPrefsEditor.putInt(NfcService.PREF_LLCP_WKS, val);
                NfcService.this.mPrefsEditor.apply();
                NfcService.this.mManager.doSetProperties(2, val);
            } else if (param.equals(NfcService.PROPERTY_LLCP_OPT_VALUE)) {
                int val = Integer.parseInt(value);
                if (val > 3) {
                    return -8;
                }
                NfcService.this.mPrefsEditor.putInt(NfcService.PREF_LLCP_OPT, val);
                NfcService.this.mPrefsEditor.apply();
                NfcService.this.mManager.doSetProperties(3, val);
            } else if (param.equals(NfcService.PROPERTY_NFC_DISCOVERY_A_VALUE)) {
                boolean b = Boolean.parseBoolean(value);
                NfcService.this.mPrefsEditor.putBoolean(NfcService.PREF_DISCOVERY_A, b);
                NfcService.this.mPrefsEditor.apply();
                NfcService.this.mManager.doSetProperties(4, b ? 1 : 0);
            } else if (param.equals(NfcService.PROPERTY_NFC_DISCOVERY_B_VALUE)) {
                boolean b = Boolean.parseBoolean(value);
                NfcService.this.mPrefsEditor.putBoolean(NfcService.PREF_DISCOVERY_B, b);
                NfcService.this.mPrefsEditor.apply();
                NfcService.this.mManager.doSetProperties(5, b ? 1 : 0);
            } else if (param.equals(NfcService.PROPERTY_NFC_DISCOVERY_F_VALUE)) {
                boolean b = Boolean.parseBoolean(value);
                NfcService.this.mPrefsEditor.putBoolean(NfcService.PREF_DISCOVERY_F, b);
                NfcService.this.mPrefsEditor.apply();
                NfcService.this.mManager.doSetProperties(6, b ? 1 : 0);
            } else if (param.equals(NfcService.PROPERTY_NFC_DISCOVERY_15693_VALUE)) {
                boolean b = Boolean.parseBoolean(value);
                NfcService.this.mPrefsEditor.putBoolean(NfcService.PREF_DISCOVERY_15693, b);
                NfcService.this.mPrefsEditor.apply();
                NfcService.this.mManager.doSetProperties(7, b ? 1 : 0);
            } else if (param.equals(NfcService.PROPERTY_NFC_DISCOVERY_NFCIP_VALUE)) {
                boolean b = Boolean.parseBoolean(value);
                NfcService.this.mPrefsEditor.putBoolean(NfcService.PREF_DISCOVERY_NFCIP, b);
                NfcService.this.mPrefsEditor.apply();
                NfcService.this.mManager.doSetProperties(8, b ? 1 : 0);
            } else {
                return -8;
            }
            return 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public NdefMessage localGet() throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            2 var1_1 = this;
            synchronized (var1_1) {
                return this.mLocalMessage;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void localSet(NdefMessage message) throws RemoteException {
            NfcService.enforceAdminPerm(NfcService.this.mContext);
            2 var2_2 = this;
            synchronized (var2_2) {
                this.mLocalMessage = message;
                Context context = NfcService.this.getApplicationContext();
                if (message != null) {
                    FileOutputStream out = null;
                    try {
                        out = context.openFileOutput(NfcService.MY_TAG_FILE_NAME, 0);
                        byte[] bytes = message.toByteArray();
                        if (bytes.length == 0) {
                            Log.w((String)NfcService.TAG, (String)"Setting a empty mytag");
                        }
                        out.write(bytes);
                    }
                    catch (IOException e) {
                        Log.e((String)NfcService.TAG, (String)"Could not write mytag file", (Throwable)e);
                    }
                    finally {
                        try {
                            if (out != null) {
                                out.flush();
                                out.close();
                            }
                        }
                        catch (IOException e) {}
                    }
                    if (NfcService.this.mIsNfcEnabled) {
                        NfcService.this.sendMessage(5, null);
                    }
                } else {
                    context.deleteFile(NfcService.MY_TAG_FILE_NAME);
                    NfcService.this.sendMessage(6, null);
                }
            }
        }
    };
    private final ILlcpSocket mLlcpSocket = new ILlcpSocket.Stub(){

        private NativeLlcpSocket findSocket(int nativeHandle) {
            Object socket = NfcService.this.findSocket(nativeHandle);
            if (!(socket instanceof NativeLlcpSocket)) {
                return null;
            }
            return (NativeLlcpSocket)socket;
        }

        public int close(int nativeHandle) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            NativeLlcpSocket socket = null;
            if (!NfcService.this.mIsNfcEnabled) {
                return -17;
            }
            socket = this.findSocket(nativeHandle);
            if (socket != null) {
                socket.doClose();
                NfcService.this.RemoveSocket(nativeHandle);
                return 0;
            }
            return -1;
        }

        public int connect(int nativeHandle, int sap) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            NativeLlcpSocket socket = null;
            boolean isSuccess = false;
            if (!NfcService.this.mIsNfcEnabled) {
                return -17;
            }
            socket = this.findSocket(nativeHandle);
            if (socket != null) {
                isSuccess = socket.doConnect(sap);
                if (isSuccess) {
                    return 0;
                }
                return -1;
            }
            return -1;
        }

        public int connectByName(int nativeHandle, String sn) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            NativeLlcpSocket socket = null;
            boolean isSuccess = false;
            if (!NfcService.this.mIsNfcEnabled) {
                return -17;
            }
            socket = this.findSocket(nativeHandle);
            if (socket != null) {
                isSuccess = socket.doConnectBy(sn);
                if (isSuccess) {
                    return 0;
                }
                return -1;
            }
            return -1;
        }

        public int getLocalSap(int nativeHandle) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            NativeLlcpSocket socket = null;
            if (!NfcService.this.mIsNfcEnabled) {
                return -17;
            }
            socket = this.findSocket(nativeHandle);
            if (socket != null) {
                return socket.getSap();
            }
            return 0;
        }

        public int getLocalSocketMiu(int nativeHandle) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            NativeLlcpSocket socket = null;
            if (!NfcService.this.mIsNfcEnabled) {
                return -17;
            }
            socket = this.findSocket(nativeHandle);
            if (socket != null) {
                return socket.getMiu();
            }
            return 0;
        }

        public int getLocalSocketRw(int nativeHandle) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            NativeLlcpSocket socket = null;
            if (!NfcService.this.mIsNfcEnabled) {
                return -17;
            }
            socket = this.findSocket(nativeHandle);
            if (socket != null) {
                return socket.getRw();
            }
            return 0;
        }

        public int getRemoteSocketMiu(int nativeHandle) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            NativeLlcpSocket socket = null;
            if (!NfcService.this.mIsNfcEnabled) {
                return -17;
            }
            socket = this.findSocket(nativeHandle);
            if (socket != null) {
                if (socket.doGetRemoteSocketMiu() != 0) {
                    return socket.doGetRemoteSocketMiu();
                }
                return -11;
            }
            return -11;
        }

        public int getRemoteSocketRw(int nativeHandle) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            NativeLlcpSocket socket = null;
            if (!NfcService.this.mIsNfcEnabled) {
                return -17;
            }
            socket = this.findSocket(nativeHandle);
            if (socket != null) {
                if (socket.doGetRemoteSocketRw() != 0) {
                    return socket.doGetRemoteSocketRw();
                }
                return -11;
            }
            return -11;
        }

        public int receive(int nativeHandle, byte[] receiveBuffer) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            NativeLlcpSocket socket = null;
            if (!NfcService.this.mIsNfcEnabled) {
                return -17;
            }
            socket = this.findSocket(nativeHandle);
            if (socket != null) {
                return socket.doReceive(receiveBuffer);
            }
            return 0;
        }

        public int send(int nativeHandle, byte[] data) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            NativeLlcpSocket socket = null;
            boolean isSuccess = false;
            if (!NfcService.this.mIsNfcEnabled) {
                return -17;
            }
            socket = this.findSocket(nativeHandle);
            if (socket != null) {
                isSuccess = socket.doSend(data);
                if (isSuccess) {
                    return 0;
                }
                return -1;
            }
            return -1;
        }
    };
    private final ILlcpServiceSocket mLlcpServerSocketService = new ILlcpServiceSocket.Stub(){

        private NativeLlcpServiceSocket findSocket(int nativeHandle) {
            Object socket = NfcService.this.findSocket(nativeHandle);
            if (!(socket instanceof NativeLlcpServiceSocket)) {
                return null;
            }
            return (NativeLlcpServiceSocket)socket;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public int accept(int nativeHandle) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            NativeLlcpServiceSocket socket = null;
            NativeLlcpSocket clientSocket = null;
            if (!NfcService.this.mIsNfcEnabled) {
                return -17;
            }
            socket = this.findSocket(nativeHandle);
            if (socket != null) {
                clientSocket = socket.doAccept(socket.getMiu(), socket.getRw(), socket.getLinearBufferLength());
                if (clientSocket != null) {
                    4 var4_4 = this;
                    synchronized (var4_4) {
                        NfcService.this.mGeneratedSocketHandle++;
                        NfcService.this.mSocketMap.put(NfcService.this.mGeneratedSocketHandle, clientSocket);
                        return NfcService.this.mGeneratedSocketHandle;
                    }
                }
                return -1;
            }
            return -1;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void close(int nativeHandle) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            NativeLlcpServiceSocket socket = null;
            if (!NfcService.this.mIsNfcEnabled) {
                return;
            }
            socket = this.findSocket(nativeHandle);
            if (socket != null) {
                socket.doClose();
                4 var3_3 = this;
                synchronized (var3_3) {
                    NfcService.this.RemoveSocket(nativeHandle);
                }
            }
        }
    };
    private final ILlcpConnectionlessSocket mLlcpConnectionlessSocketService = new ILlcpConnectionlessSocket.Stub(){

        private NativeLlcpConnectionlessSocket findSocket(int nativeHandle) {
            Object socket = NfcService.this.findSocket(nativeHandle);
            if (!(socket instanceof NativeLlcpConnectionlessSocket)) {
                return null;
            }
            return (NativeLlcpConnectionlessSocket)socket;
        }

        public void close(int nativeHandle) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            NativeLlcpConnectionlessSocket socket = null;
            if (!NfcService.this.mIsNfcEnabled) {
                return;
            }
            socket = this.findSocket(nativeHandle);
            if (socket != null) {
                socket.doClose();
                NfcService.this.RemoveSocket(nativeHandle);
            }
        }

        public int getSap(int nativeHandle) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            NativeLlcpConnectionlessSocket socket = null;
            if (!NfcService.this.mIsNfcEnabled) {
                return -17;
            }
            socket = this.findSocket(nativeHandle);
            if (socket != null) {
                return socket.getSap();
            }
            return 0;
        }

        public LlcpPacket receiveFrom(int nativeHandle) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            NativeLlcpConnectionlessSocket socket = null;
            if (!NfcService.this.mIsNfcEnabled) {
                return null;
            }
            socket = this.findSocket(nativeHandle);
            if (socket != null) {
                LlcpPacket packet = socket.doReceiveFrom(socket.getLinkMiu());
                if (packet != null) {
                    return packet;
                }
                return null;
            }
            return null;
        }

        public int sendTo(int nativeHandle, LlcpPacket packet) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            NativeLlcpConnectionlessSocket socket = null;
            boolean isSuccess = false;
            if (!NfcService.this.mIsNfcEnabled) {
                return -17;
            }
            socket = this.findSocket(nativeHandle);
            if (socket != null) {
                isSuccess = socket.doSendTo(packet.getRemoteSap(), packet.getDataBuffer());
                if (isSuccess) {
                    return 0;
                }
                return -1;
            }
            return -1;
        }
    };
    private final INfcTag mNfcTagService = new INfcTag.Stub(){

        public int close(int nativeHandle) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            NativeNfcTag tag = null;
            if (!NfcService.this.mIsNfcEnabled) {
                return -17;
            }
            tag = (NativeNfcTag)NfcService.this.findObject(nativeHandle);
            if (tag != null) {
                NfcService.this.unregisterObject(nativeHandle);
                tag.disconnect();
                return 0;
            }
            NfcService.this.applyRouting();
            return -5;
        }

        public int connect(int nativeHandle, int technology) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            NativeNfcTag tag = null;
            if (!NfcService.this.mIsNfcEnabled) {
                return -17;
            }
            tag = (NativeNfcTag)NfcService.this.findObject(nativeHandle);
            if (tag == null) {
                return -5;
            }
            if (tag.connect(technology) == 0) {
                return 0;
            }
            return -5;
        }

        public int reconnect(int nativeHandle) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            NativeNfcTag tag = null;
            if (!NfcService.this.mIsNfcEnabled) {
                return -17;
            }
            tag = (NativeNfcTag)NfcService.this.findObject(nativeHandle);
            if (tag != null) {
                if (tag.reconnect() == 0) {
                    return 0;
                }
                return -5;
            }
            return -5;
        }

        public int[] getTechList(int nativeHandle) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            if (!NfcService.this.mIsNfcEnabled) {
                return null;
            }
            NativeNfcTag tag = (NativeNfcTag)NfcService.this.findObject(nativeHandle);
            if (tag != null) {
                return tag.getTechList();
            }
            return null;
        }

        public byte[] getUid(int nativeHandle) throws RemoteException {
            NativeNfcTag tag = null;
            if (!NfcService.this.mIsNfcEnabled) {
                return null;
            }
            tag = (NativeNfcTag)NfcService.this.findObject(nativeHandle);
            if (tag != null) {
                byte[] uid = tag.getUid();
                return uid;
            }
            return null;
        }

        public boolean isPresent(int nativeHandle) throws RemoteException {
            NativeNfcTag tag = null;
            if (!NfcService.this.mIsNfcEnabled) {
                return false;
            }
            tag = (NativeNfcTag)NfcService.this.findObject(nativeHandle);
            if (tag == null) {
                return false;
            }
            return tag.isPresent();
        }

        public boolean isNdef(int nativeHandle) throws RemoteException {
            NativeNfcTag tag = null;
            if (!NfcService.this.mIsNfcEnabled) {
                return false;
            }
            tag = (NativeNfcTag)NfcService.this.findObject(nativeHandle);
            int[] ndefInfo = new int[2];
            if (tag == null) {
                return false;
            }
            return tag.checkNdef(ndefInfo) == 0;
        }

        public TransceiveResult transceive(int nativeHandle, byte[] data, boolean raw) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            NativeNfcTag tag = null;
            if (!NfcService.this.mIsNfcEnabled) {
                return null;
            }
            tag = (NativeNfcTag)NfcService.this.findObject(nativeHandle);
            if (tag != null) {
                int[] targetLost = new int[1];
                byte[] response = tag.transceive(data, raw, targetLost);
                TransceiveResult transResult = new TransceiveResult(response != null, targetLost[0] == 1, response);
                return transResult;
            }
            return null;
        }

        public NdefMessage ndefRead(int nativeHandle) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            if (!NfcService.this.mIsNfcEnabled) {
                return null;
            }
            NativeNfcTag tag = (NativeNfcTag)NfcService.this.findObject(nativeHandle);
            if (tag != null) {
                byte[] buf = tag.read();
                if (buf == null) {
                    return null;
                }
                try {
                    return new NdefMessage(buf);
                }
                catch (FormatException e) {
                    return null;
                }
            }
            return null;
        }

        public int ndefWrite(int nativeHandle, NdefMessage msg) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            if (!NfcService.this.mIsNfcEnabled) {
                return -17;
            }
            NativeNfcTag tag = (NativeNfcTag)NfcService.this.findObject(nativeHandle);
            if (tag == null) {
                return -1;
            }
            if (tag.write(msg.toByteArray())) {
                return 0;
            }
            return -1;
        }

        public int getLastError(int nativeHandle) throws RemoteException {
            return NfcService.this.mManager.doGetLastError();
        }

        public boolean ndefIsWritable(int nativeHandle) throws RemoteException {
            throw new UnsupportedOperationException();
        }

        public int ndefMakeReadOnly(int nativeHandle) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            if (!NfcService.this.mIsNfcEnabled) {
                return -17;
            }
            NativeNfcTag tag = (NativeNfcTag)NfcService.this.findObject(nativeHandle);
            if (tag == null) {
                return -1;
            }
            if (tag.makeReadonly()) {
                return 0;
            }
            return -1;
        }

        public int formatNdef(int nativeHandle, byte[] key) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            if (!NfcService.this.mIsNfcEnabled) {
                return -17;
            }
            NativeNfcTag tag = (NativeNfcTag)NfcService.this.findObject(nativeHandle);
            if (tag == null) {
                return -1;
            }
            if (tag.formatNdef(key)) {
                return 0;
            }
            return -1;
        }

        public void setIsoDepTimeout(int timeout) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            NfcService.this.mManager.setIsoDepTimeout(timeout);
        }

        public void resetIsoDepTimeout() throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            NfcService.this.mManager.resetIsoDepTimeout();
        }
    };
    private final IP2pInitiator mP2pInitiatorService = new IP2pInitiator.Stub(){

        public byte[] getGeneralBytes(int nativeHandle) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            if (!NfcService.this.mIsNfcEnabled) {
                return null;
            }
            NativeP2pDevice device = (NativeP2pDevice)NfcService.this.findObject(nativeHandle);
            if (device != null) {
                byte[] buff = device.getGeneralBytes();
                if (buff == null) {
                    return null;
                }
                return buff;
            }
            return null;
        }

        public int getMode(int nativeHandle) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            if (!NfcService.this.mIsNfcEnabled) {
                return -17;
            }
            NativeP2pDevice device = (NativeP2pDevice)NfcService.this.findObject(nativeHandle);
            if (device != null) {
                return device.getMode();
            }
            return -8;
        }

        public byte[] receive(int nativeHandle) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            if (!NfcService.this.mIsNfcEnabled) {
                return null;
            }
            NativeP2pDevice device = (NativeP2pDevice)NfcService.this.findObject(nativeHandle);
            if (device != null) {
                byte[] buff = device.doReceive();
                if (buff == null) {
                    return null;
                }
                return buff;
            }
            NfcService.this.applyRouting();
            return null;
        }

        public boolean send(int nativeHandle, byte[] data) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            boolean isSuccess = false;
            if (!NfcService.this.mIsNfcEnabled) {
                return isSuccess;
            }
            NativeP2pDevice device = (NativeP2pDevice)NfcService.this.findObject(nativeHandle);
            if (device != null) {
                isSuccess = device.doSend(data);
            }
            return isSuccess;
        }
    };
    private final IP2pTarget mP2pTargetService = new IP2pTarget.Stub(){

        public int connect(int nativeHandle) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            if (!NfcService.this.mIsNfcEnabled) {
                return -17;
            }
            NativeP2pDevice device = (NativeP2pDevice)NfcService.this.findObject(nativeHandle);
            if (device != null && device.doConnect()) {
                return 0;
            }
            return -5;
        }

        public boolean disconnect(int nativeHandle) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            boolean isSuccess = false;
            if (!NfcService.this.mIsNfcEnabled) {
                return isSuccess;
            }
            NativeP2pDevice device = (NativeP2pDevice)NfcService.this.findObject(nativeHandle);
            if (device != null && (isSuccess = device.doDisconnect())) {
                NfcService.this.unregisterObject(nativeHandle);
                NfcService.this.applyRouting();
            }
            return isSuccess;
        }

        public byte[] getGeneralBytes(int nativeHandle) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            if (!NfcService.this.mIsNfcEnabled) {
                return null;
            }
            NativeP2pDevice device = (NativeP2pDevice)NfcService.this.findObject(nativeHandle);
            if (device != null) {
                byte[] buff = device.getGeneralBytes();
                if (buff == null) {
                    return null;
                }
                return buff;
            }
            return null;
        }

        public int getMode(int nativeHandle) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            if (!NfcService.this.mIsNfcEnabled) {
                return -17;
            }
            NativeP2pDevice device = (NativeP2pDevice)NfcService.this.findObject(nativeHandle);
            if (device != null) {
                return device.getMode();
            }
            return -8;
        }

        public byte[] transceive(int nativeHandle, byte[] data) throws RemoteException {
            NfcService.this.mContext.enforceCallingOrSelfPermission(NfcService.NFC_PERM, NfcService.NFC_PERM_ERROR);
            if (!NfcService.this.mIsNfcEnabled) {
                return null;
            }
            NativeP2pDevice device = (NativeP2pDevice)NfcService.this.findObject(nativeHandle);
            if (device != null) {
                byte[] buff = device.doTransceive(data);
                if (buff == null) {
                    return null;
                }
                return buff;
            }
            return null;
        }
    };
    private INfcAdapterExtras mExtrasService = new INfcAdapterExtras.Stub(){

        private Bundle writeNoException() {
            Bundle p = new Bundle();
            p.putInt("e", 0);
            return p;
        }

        private Bundle writeIoException(IOException e) {
            Bundle p = new Bundle();
            p.putInt("e", -1);
            p.putString("m", e.getMessage());
            return p;
        }

        public Bundle open(IBinder b) throws RemoteException {
            Bundle result;
            NfcService.enforceNfceeAdminPerm(NfcService.this.mContext);
            try {
                this._open(b);
                result = this.writeNoException();
            }
            catch (IOException e) {
                result = this.writeIoException(e);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void _open(IBinder b) throws IOException, RemoteException {
            NfcService nfcService = NfcService.this;
            synchronized (nfcService) {
                if (!NfcService.this.mIsNfcEnabled) {
                    throw new IOException("NFC adapter is disabled");
                }
                if (NfcService.this.mOpenEe != null) {
                    throw new IOException("NFC EE already open");
                }
                int handle = NfcService.this.mSecureElement.doOpenSecureElementConnection();
                if (handle == 0) {
                    throw new IOException("NFC EE failed to open");
                }
                NfcService.this.mManager.doSetIsoDepTimeout(10000);
                NfcService.this.mOpenEe = new OpenSecureElement(9.getCallingPid(), handle);
                try {
                    b.linkToDeath((IBinder.DeathRecipient)NfcService.this.mOpenEe, 0);
                }
                catch (RemoteException e) {
                    NfcService.this.mOpenEe.binderDied();
                }
                for (String packageName : NfcService.this.getPackageManager().getPackagesForUid(9.getCallingUid())) {
                    NfcService.this.mSePackages.add(packageName);
                }
            }
        }

        public Bundle close() throws RemoteException {
            Bundle result;
            NfcService.enforceNfceeAdminPerm(NfcService.this.mContext);
            try {
                NfcService.this._nfcEeClose(true, 9.getCallingPid());
                result = this.writeNoException();
            }
            catch (IOException e) {
                result = this.writeIoException(e);
            }
            return result;
        }

        public Bundle transceive(byte[] in) throws RemoteException {
            Bundle result;
            NfcService.enforceNfceeAdminPerm(NfcService.this.mContext);
            try {
                byte[] out = this._transceive(in);
                result = this.writeNoException();
                result.putByteArray("out", out);
            }
            catch (IOException e) {
                result = this.writeIoException(e);
            }
            return result;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private byte[] _transceive(byte[] data) throws IOException, RemoteException {
            NfcService nfcService = NfcService.this;
            synchronized (nfcService) {
                if (!NfcService.this.mIsNfcEnabled) {
                    throw new IOException("NFC is not enabled");
                }
                if (NfcService.this.mOpenEe == null) {
                    throw new IOException("NFC EE is not open");
                }
                if (9.getCallingPid() != ((NfcService)NfcService.this).mOpenEe.pid) {
                    throw new SecurityException("Wrong PID");
                }
            }
            return NfcService.this.mSecureElement.doTransceive(((NfcService)NfcService.this).mOpenEe.handle, data);
        }

        public int getCardEmulationRoute() throws RemoteException {
            NfcService.enforceNfceeAdminPerm(NfcService.this.mContext);
            return NfcService.this.mEeRoutingState;
        }

        public void setCardEmulationRoute(int route) throws RemoteException {
            NfcService.enforceNfceeAdminPerm(NfcService.this.mContext);
            NfcService.this.mEeRoutingState = route;
            NfcService.this.applyRouting();
        }

        public void authenticate(byte[] token) throws RemoteException {
            NfcService.enforceNfceeAdminPerm(NfcService.this.mContext);
        }
    };
    private static final byte[][] SE_RESET_APDUS;
    private NfcServiceHandler mHandler = new NfcServiceHandler();
    private final BroadcastReceiver mReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            boolean dataRemoved;
            if (intent.getAction().equals("com.android.nfc.action.INTERNAL_TARGET_DESELECTED")) {
                NfcService.this.applyRouting();
            } else if (intent.getAction().equals("android.intent.action.SCREEN_ON")) {
                new EnableDisableDiscoveryTask().execute(new Boolean[]{new Boolean(true)});
            } else if (intent.getAction().equals("android.intent.action.SCREEN_OFF")) {
                new EnableDisableDiscoveryTask().execute(new Boolean[]{new Boolean(false)});
            } else if (intent.getAction().equals(NfcService.ACTION_MASTER_CLEAR_NOTIFICATION)) {
                NfcService.this.executeSeReset();
            } else if (intent.getAction().equals("android.intent.action.PACKAGE_REMOVED") && (dataRemoved = intent.getBooleanExtra("android.intent.extra.DATA_REMOVED", false))) {
                Uri data = intent.getData();
                if (data == null) {
                    return;
                }
                String packageName = data.getSchemeSpecificPart();
                NfcService nfcService = NfcService.this;
                synchronized (nfcService) {
                    if (NfcService.this.mSePackages.contains(packageName)) {
                        NfcService.this.executeSeReset();
                        NfcService.this.mSePackages.remove(packageName);
                    }
                }
            }
        }
    };

    public static void enforceAdminPerm(Context context) {
        int admin = context.checkCallingOrSelfPermission(ADMIN_PERM);
        int nfcee = context.checkCallingOrSelfPermission(NFCEE_ADMIN_PERM);
        if (admin != 0 && nfcee != 0) {
            throw new SecurityException(ADMIN_PERM_ERROR);
        }
    }

    public static void enforceNfceeAdminPerm(Context context) {
        context.enforceCallingOrSelfPermission(NFCEE_ADMIN_PERM, NFCEE_ADMIN_PERM_ERROR);
    }

    public static NfcService getInstance() {
        return sService;
    }

    public void onCreate() {
        super.onCreate();
        Log.i((String)TAG, (String)"Starting NFC service");
        sService = this;
        this.mContext = this;
        this.mManager = new NativeNfcManager(this.mContext, this);
        this.mManager.initializeNativeStructure();
        this.mNdefPushClient = new NdefPushClient((Context)this);
        this.mNdefPushServer = new NdefPushServer();
        this.mTechListFilters = new RegisteredComponentCache((Context)this, "android.nfc.action.TECH_DISCOVERED", "android.nfc.action.TECH_DISCOVERED");
        this.mSecureElement = new NativeNfcSecureElement();
        this.mEeRoutingState = 1;
        this.mPrefs = this.mContext.getSharedPreferences(PREF, 0);
        this.mPrefsEditor = this.mPrefs.edit();
        this.mIsNfcEnabled = false;
        PowerManager pm = (PowerManager)this.getSystemService("power");
        this.mScreenOn = pm.isScreenOn();
        this.mWakeLock = pm.newWakeLock(1, TAG);
        this.mIActivityManager = ActivityManagerNative.getDefault();
        ServiceManager.addService((String)SERVICE_NAME, (IBinder)this.mNfcAdapter);
        IntentFilter filter = new IntentFilter("com.android.nfc.action.INTERNAL_TARGET_DESELECTED");
        filter.addAction("android.intent.action.SCREEN_OFF");
        filter.addAction("android.intent.action.SCREEN_ON");
        filter.addAction(ACTION_MASTER_CLEAR_NOTIFICATION);
        this.mContext.registerReceiver(this.mReceiver, filter);
        filter = new IntentFilter();
        filter.addAction("android.intent.action.PACKAGE_REMOVED");
        filter.addDataScheme("package");
        this.mContext.registerReceiver(this.mReceiver, filter);
        Thread t = new Thread(){

            public void run() {
                Log.d((String)NfcService.TAG, (String)"checking on firmware download");
                boolean nfc_on = NfcService.this.mPrefs.getBoolean(NfcService.PREF_NFC_ON, true);
                if (nfc_on) {
                    Log.d((String)NfcService.TAG, (String)"NFC is on. Doing normal stuff");
                    NfcService.this._enable(false, true);
                } else {
                    Log.d((String)NfcService.TAG, (String)"NFC is off.  Checking firmware version");
                    NfcService.this._maybeUpdateFirmware();
                }
                NfcService.this.resetSeOnFirstBoot();
            }
        };
        t.start();
    }

    public void onTerminate() {
        super.onTerminate();
        Log.wtf((String)TAG, (String)"NFC service is under attack!");
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void _nfcEeClose(boolean checkPid, int callingPid) throws IOException {
        NfcService nfcService = this;
        synchronized (nfcService) {
            if (!this.mIsNfcEnabled) {
                throw new IOException("NFC adapter is disabled");
            }
            if (this.mOpenEe == null) {
                throw new IOException("NFC EE closed");
            }
            if (checkPid && this.mOpenEe.pid != -1 && callingPid != this.mOpenEe.pid) {
                throw new SecurityException("Wrong PID");
            }
            this.mManager.doResetIsoDepTimeout();
            this.mSecureElement.doDisconnect(this.mOpenEe.handle);
            this.mOpenEe = null;
            this.applyRouting();
        }
    }

    private boolean _enable(boolean oldEnabledState, boolean savePref) {
        this.applyProperties();
        boolean isSuccess = this.mManager.initialize();
        if (isSuccess) {
            this.mIsNfcEnabled = true;
            this.mIsDiscoveryOn = true;
            this.applyRouting();
            this.mNdefPushServer.start();
        } else {
            Log.w((String)TAG, (String)"Error enabling NFC");
            this.mIsNfcEnabled = false;
        }
        if (savePref) {
            this.updateNfcOnSetting(oldEnabledState);
        }
        return isSuccess;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private boolean _disable(boolean oldEnabledState, boolean savePref) {
        WatchDogThread watchDog = new WatchDogThread();
        watchDog.start();
        this.mNdefPushServer.stop();
        this.mIsDiscoveryOn = false;
        this.applyRouting();
        this.maybeDisconnectTarget();
        boolean isSuccess = this.mManager.deinitialize();
        if (isSuccess) {
            this.mIsNfcEnabled = false;
            NfcService nfcService = this;
            synchronized (nfcService) {
                this.mDispatchOverrideFilters = null;
                this.mDispatchOverrideIntent = null;
            }
            this.mNdefPushClient.setForegroundMessage(null);
        }
        if (savePref) {
            this.updateNfcOnSetting(oldEnabledState);
        }
        watchDog.cancel();
        return isSuccess;
    }

    private void _maybeUpdateFirmware() {
        File firmwareFile;
        try {
            firmwareFile = new File(NFC_CONTROLLER_FIRMWARE_FILE_NAME);
        }
        catch (NullPointerException npe) {
            Log.e((String)TAG, (String)"path to firmware file was null");
            return;
        }
        long modtime = firmwareFile.lastModified();
        long prev_fw_modtime = this.mPrefs.getLong(PREF_FIRMWARE_MODTIME, -1L);
        Log.d((String)TAG, (String)("prev modtime: " + prev_fw_modtime));
        Log.d((String)TAG, (String)("new modtime: " + modtime));
        if (prev_fw_modtime == modtime) {
            return;
        }
        for (int nbRetry = 0; nbRetry < 5; ++nbRetry) {
            Log.d((String)TAG, (String)"Perform Download");
            if (this.mManager.doDownload()) {
                Log.d((String)TAG, (String)"Download Success");
                this.mPrefsEditor.putLong(PREF_FIRMWARE_MODTIME, modtime);
                this.mPrefsEditor.apply();
                break;
            }
            Log.d((String)TAG, (String)"Download Failed");
        }
    }

    private synchronized void applyRouting() {
        if (this.mIsNfcEnabled && this.mOpenEe == null) {
            if (this.mScreenOn) {
                if (this.mEeRoutingState == 2) {
                    Log.d((String)TAG, (String)"NFC-EE routing ON");
                    this.mManager.doSelectSecureElement(11259375);
                } else {
                    Log.d((String)TAG, (String)"NFC-EE routing OFF");
                    this.mManager.doDeselectSecureElement(11259375);
                }
                if (this.mIsDiscoveryOn) {
                    Log.d((String)TAG, (String)"NFC-C discovery ON");
                    this.mManager.enableDiscovery(0);
                } else {
                    Log.d((String)TAG, (String)"NFC-C discovery OFF");
                    this.mManager.disableDiscovery();
                }
            } else {
                Log.d((String)TAG, (String)"NFC-EE routing OFF");
                this.mManager.doDeselectSecureElement(11259375);
                Log.d((String)TAG, (String)"NFC-C discovery OFF");
                this.mManager.disableDiscovery();
            }
        }
    }

    private synchronized void maybeDisconnectTarget() {
        if (this.mIsNfcEnabled) {
            Iterator<Object> iterator = this.mObjectMap.values().iterator();
            while (iterator.hasNext()) {
                NativeP2pDevice device;
                Object object = iterator.next();
                if (object instanceof NativeNfcTag) {
                    NativeNfcTag tag = (NativeNfcTag)object;
                    tag.disconnect();
                } else if (object instanceof NativeP2pDevice && (device = (NativeP2pDevice)object).getMode() == 0) {
                    device.doDisconnect();
                }
                iterator.remove();
            }
        }
    }

    private void resetSeOnFirstBoot() {
        if (this.mPrefs.getBoolean(PREF_FIRST_BOOT, true)) {
            Log.i((String)TAG, (String)"First Boot");
            this.mPrefsEditor.putBoolean(PREF_FIRST_BOOT, false);
            this.mPrefsEditor.apply();
            this.executeSeReset();
        }
    }

    private synchronized void executeSeReset() {
        boolean tempEnable;
        byte[][] apdus = SE_RESET_APDUS;
        if (apdus == null) {
            return;
        }
        boolean bl = tempEnable = !this.mIsNfcEnabled;
        if (tempEnable && !this._enable(false, false)) {
            Log.w((String)TAG, (String)"Could not enable NFC to reset EE!");
            return;
        }
        Log.i((String)TAG, (String)"Executing SE Reset Script");
        int handle = this.mSecureElement.doOpenSecureElementConnection();
        if (handle == 0) {
            Log.e((String)TAG, (String)"Could not open the secure element!");
            if (tempEnable) {
                this._disable(true, false);
            }
            return;
        }
        this.mManager.doSetIsoDepTimeout(10000);
        for (byte[] cmd : apdus) {
            this.mSecureElement.doTransceive(handle, cmd);
        }
        this.mManager.doResetIsoDepTimeout();
        this.mSecureElement.doDisconnect(handle);
        if (tempEnable) {
            this._disable(true, false);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<byte[]> readSeResetApdus() {
        FileInputStream input = null;
        ArrayList<byte[]> apdus = null;
        try {
            input = this.openFileInput(SE_RESET_SCRIPT_FILE_NAME);
            DataInputStream stream = new DataInputStream(input);
            int commandsSize = stream.readInt();
            apdus = new ArrayList<byte[]>(commandsSize);
            for (int i = 0; i < commandsSize; ++i) {
                int length = stream.readInt();
                byte[] cmd = new byte[length];
                stream.read(cmd);
                apdus.add(cmd);
            }
            ArrayList<byte[]> arrayList = apdus;
            return arrayList;
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)"SE Reset Script not found: /system/etc/se-reset-script");
        }
        catch (IOException e) {
            Log.e((String)TAG, (String)"SE Reset Script corrupt: ", (Throwable)e);
            apdus = null;
        }
        finally {
            try {
                if (input != null) {
                    input.close();
                }
            }
            catch (IOException e) {}
        }
        return apdus;
    }

    private void applyProperties() {
        this.mManager.doSetProperties(0, this.mPrefs.getInt(PREF_LLCP_LTO, 150));
        this.mManager.doSetProperties(1, this.mPrefs.getInt(PREF_LLCP_MIU, 128));
        this.mManager.doSetProperties(2, this.mPrefs.getInt(PREF_LLCP_WKS, 1));
        this.mManager.doSetProperties(3, this.mPrefs.getInt(PREF_LLCP_OPT, 0));
        this.mManager.doSetProperties(4, this.mPrefs.getBoolean(PREF_DISCOVERY_A, true) ? 1 : 0);
        this.mManager.doSetProperties(5, this.mPrefs.getBoolean(PREF_DISCOVERY_B, true) ? 1 : 0);
        this.mManager.doSetProperties(6, this.mPrefs.getBoolean(PREF_DISCOVERY_F, true) ? 1 : 0);
        this.mManager.doSetProperties(7, this.mPrefs.getBoolean(PREF_DISCOVERY_15693, true) ? 1 : 0);
        this.mManager.doSetProperties(8, this.mPrefs.getBoolean(PREF_DISCOVERY_NFCIP, true) ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateNfcOnSetting(boolean oldEnabledState) {
        this.mPrefsEditor.putBoolean(PREF_NFC_ON, this.mIsNfcEnabled);
        this.mPrefsEditor.apply();
        NfcService nfcService = this;
        synchronized (nfcService) {
            if (oldEnabledState != this.mIsNfcEnabled) {
                Intent intent = new Intent("android.nfc.action.ADAPTER_STATE_CHANGE");
                intent.setFlags(0x10000000);
                intent.putExtra("android.nfc.isEnabled", this.mIsNfcEnabled);
                this.mContext.sendBroadcast(intent);
            }
            if (this.mIsNfcEnabled) {
                Context context = this.getApplicationContext();
                NdefMessage myTag = null;
                FileInputStream input = null;
                try {
                    input = context.openFileInput(MY_TAG_FILE_NAME);
                    ByteArrayOutputStream bytes = new ByteArrayOutputStream();
                    byte[] buffer = new byte[4096];
                    int read = 0;
                    while ((read = input.read(buffer)) > 0) {
                        bytes.write(buffer, 0, read);
                    }
                    myTag = new NdefMessage(bytes.toByteArray());
                }
                catch (FileNotFoundException e) {
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"Could not read mytag file: ", (Throwable)e);
                    context.deleteFile(MY_TAG_FILE_NAME);
                }
                catch (FormatException e) {
                    Log.e((String)TAG, (String)"Invalid NdefMessage for mytag", (Throwable)e);
                    context.deleteFile(MY_TAG_FILE_NAME);
                }
                finally {
                    try {
                        if (input != null) {
                            input.close();
                        }
                    }
                    catch (IOException e) {}
                }
                try {
                    this.mNfcAdapter.localSet(myTag);
                }
                catch (RemoteException e) {}
            } else {
                this.sendMessage(6, null);
            }
        }
    }

    private synchronized void reset() {
        this.mObjectMap.clear();
        this.mSocketMap.clear();
        this.mIsNfcEnabled = false;
    }

    private synchronized Object findObject(int key) {
        Object device = null;
        device = this.mObjectMap.get(key);
        if (device == null) {
            Log.w((String)TAG, (String)"Handle not found !");
        }
        return device;
    }

    synchronized void registerTagObject(NativeNfcTag nativeTag) {
        this.mObjectMap.put(nativeTag.getHandle(), nativeTag);
    }

    synchronized void unregisterObject(int handle) {
        this.mObjectMap.remove(handle);
    }

    private synchronized Object findSocket(int key) {
        if (this.mSocketMap == null) {
            return null;
        }
        return this.mSocketMap.get(key);
    }

    private void RemoveSocket(int key) {
        this.mSocketMap.remove(key);
    }

    public LlcpSocket createLlcpSocket(int sap, int miu, int rw, int linearBufferLength) {
        try {
            int handle = this.mNfcAdapter.createLlcpSocket(sap, miu, rw, linearBufferLength);
            if (ErrorCodes.isError((int)handle)) {
                Log.e((String)TAG, (String)("unable to create socket: " + ErrorCodes.asString((int)handle)));
                return null;
            }
            return new LlcpSocket(this.mLlcpSocket, handle);
        }
        catch (RemoteException e) {
            throw new IllegalStateException("unable to talk to myself", e);
        }
    }

    public LlcpServiceSocket createLlcpServiceSocket(int sap, String sn, int miu, int rw, int linearBufferLength) {
        try {
            int handle = this.mNfcAdapter.createLlcpServiceSocket(sap, sn, miu, rw, linearBufferLength);
            if (ErrorCodes.isError((int)handle)) {
                Log.e((String)TAG, (String)("unable to create socket: " + ErrorCodes.asString((int)handle)));
                return null;
            }
            return new LlcpServiceSocket(this.mLlcpServerSocketService, this.mLlcpSocket, handle);
        }
        catch (RemoteException e) {
            throw new IllegalStateException("unable to talk to myself", e);
        }
    }

    private void activateLlcpLink() {
        Intent LlcpLinkIntent = new Intent();
        LlcpLinkIntent.setAction("android.nfc.action.LLCP_LINK_STATE_CHANGED");
        LlcpLinkIntent.putExtra("android.nfc.extra.LLCP_LINK_STATE", 0);
        this.mContext.sendOrderedBroadcast(LlcpLinkIntent, NFC_PERM);
    }

    public void sendMockNdefTag(NdefMessage msg) {
        this.sendMessage(7, msg);
    }

    void sendMessage(int what, Object obj) {
        Message msg = this.mHandler.obtainMessage();
        msg.what = what;
        msg.obj = obj;
        this.mHandler.sendMessage(msg);
    }

    static {
        System.loadLibrary("nfc_jni");
        URI_PREFIX_MAP = new String[]{"", "http://www.", "https://www.", "http://", "https://", "tel:", "mailto:", "ftp://anonymous:anonymous@", "ftp://ftp.", "ftps://", "sftp://", "smb://", "nfs://", "ftp://", "dav://", "news:", "telnet://", "imap:", "rtsp://", "urn:", "pop:", "sip:", "sips:", "tftp:", "btspp://", "btl2cap://", "btgoep://", "tcpobex://", "irdaobex://", "file://", "urn:epc:id:", "urn:epc:tag:", "urn:epc:pat:", "urn:epc:raw:", "urn:epc:"};
        SE_RESET_APDUS = new byte[][]{{0, -92, 4, 0, 0}, {0, -92, 4, 0, 7, -96, 0, 0, 4, 118, 32, 16, 0}, {-128, -30, 1, 3, 0}, {0, -92, 4, 0, 0}, {0, -92, 4, 0, 7, -96, 0, 0, 4, 118, 48, 48, 0}, {-128, -76, 0, 0, 0}, {0, -92, 4, 0, 0}};
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class EnableDisableDiscoveryTask
    extends AsyncTask<Boolean, Void, Void> {
        private EnableDisableDiscoveryTask() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        protected Void doInBackground(Boolean ... enable) {
            if (enable != null && enable.length > 0 && enable[0].booleanValue()) {
                NfcService nfcService = NfcService.this;
                synchronized (nfcService) {
                    NfcService.this.mScreenOn = true;
                    NfcService.this.applyRouting();
                }
            }
            NfcService nfcService = NfcService.this;
            synchronized (nfcService) {
                NfcService.this.mWakeLock.acquire();
                NfcService.this.mScreenOn = false;
                NfcService.this.applyRouting();
                NfcService.this.maybeDisconnectTarget();
                NfcService.this.mWakeLock.release();
            }
            return null;
        }
    }

    final class NfcServiceHandler
    extends Handler {
        NfcServiceHandler() {
        }

        public NdefMessage[] findAndReadNdef(NativeNfcTag nativeTag) {
            int[] technologies = nativeTag.getTechList();
            int[] handles = nativeTag.getHandleList();
            int lastHandleScanned = 0;
            boolean ndefFoundAndConnected = false;
            boolean isTargetLost = false;
            NdefMessage[] ndefMsgs = null;
            boolean foundFormattable = false;
            int formattableHandle = 0;
            int formattableTechnology = 0;
            for (int techIndex = 0; !ndefFoundAndConnected && techIndex < technologies.length && !isTargetLost; ++techIndex) {
                if (handles[techIndex] != lastHandleScanned) {
                    int status = nativeTag.connect(technologies[techIndex]);
                    if (status == 0) {
                        int[] ndefinfo;
                        if (!foundFormattable) {
                            if (nativeTag.isNdefFormatable()) {
                                foundFormattable = true;
                                formattableHandle = nativeTag.getConnectedHandle();
                                formattableTechnology = nativeTag.getConnectedTechnology();
                            }
                            nativeTag.reconnect();
                        }
                        if ((status = nativeTag.checkNdef(ndefinfo = new int[2])) == 0) {
                            ndefFoundAndConnected = true;
                            boolean generateEmptyNdef = false;
                            int supportedNdefLength = ndefinfo[0];
                            int cardState = ndefinfo[1];
                            byte[] buff = nativeTag.read();
                            if (buff != null) {
                                ndefMsgs = new NdefMessage[1];
                                try {
                                    ndefMsgs[0] = new NdefMessage(buff);
                                    nativeTag.addNdefTechnology(ndefMsgs[0], nativeTag.getConnectedHandle(), nativeTag.getConnectedLibNfcType(), nativeTag.getConnectedTechnology(), supportedNdefLength, cardState);
                                    nativeTag.reconnect();
                                }
                                catch (FormatException e) {
                                    generateEmptyNdef = true;
                                }
                            } else {
                                generateEmptyNdef = true;
                            }
                            if (generateEmptyNdef) {
                                ndefMsgs = new NdefMessage[]{};
                                nativeTag.addNdefTechnology(null, nativeTag.getConnectedHandle(), nativeTag.getConnectedLibNfcType(), nativeTag.getConnectedTechnology(), supportedNdefLength, cardState);
                                nativeTag.reconnect();
                            }
                        } else {
                            Log.d((String)NfcService.TAG, (String)("Check NDEF Failed - status = " + status));
                            if (status == 146) {
                                isTargetLost = true;
                            }
                        }
                    } else {
                        Log.d((String)NfcService.TAG, (String)("Connect Failed - status = " + status));
                        if (status == 146) {
                            isTargetLost = true;
                        }
                    }
                }
                lastHandleScanned = handles[techIndex];
            }
            if (ndefMsgs == null && foundFormattable) {
                nativeTag.addNdefFormatableTechnology(formattableHandle, formattableTechnology);
            }
            return ndefMsgs;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleMessage(Message msg) {
            switch (msg.what) {
                case 7: {
                    NdefMessage ndefMsg = (NdefMessage)msg.obj;
                    Tag tag = Tag.createMockTag((byte[])new byte[]{0}, (int[])new int[0], (Bundle[])new Bundle[0]);
                    Log.d((String)NfcService.TAG, (String)"mock NDEF tag, starting corresponding activity");
                    Log.d((String)NfcService.TAG, (String)tag.toString());
                    this.dispatchTag(tag, new NdefMessage[]{ndefMsg});
                    break;
                }
                case 0: {
                    NativeNfcTag nativeTag = (NativeNfcTag)msg.obj;
                    NdefMessage[] ndefMsgs = this.findAndReadNdef(nativeTag);
                    if (ndefMsgs != null) {
                        nativeTag.startPresenceChecking();
                        this.dispatchNativeTag(nativeTag, ndefMsgs);
                        break;
                    }
                    if (nativeTag.getLastStatusCode() != 146) {
                        if (nativeTag.reconnect() != 0) break;
                        nativeTag.startPresenceChecking();
                        this.dispatchNativeTag(nativeTag, null);
                        break;
                    }
                    nativeTag.disconnect();
                    break;
                }
                case 1: {
                    byte[] aid = (byte[])msg.obj;
                    Intent aidIntent = new Intent();
                    aidIntent.setAction(NfcService.ACTION_AID_SELECTED);
                    aidIntent.putExtra(NfcService.EXTRA_AID, aid);
                    NfcService.this.mContext.sendBroadcast(aidIntent, NfcService.NFCEE_ADMIN_PERM);
                    break;
                }
                case 11: {
                    Intent cardRemovalIntent = new Intent();
                    cardRemovalIntent.setAction(NfcService.ACTION_EMV_CARD_REMOVAL);
                    NfcService.this.mContext.sendBroadcast(cardRemovalIntent, NfcService.NFCEE_ADMIN_PERM);
                    break;
                }
                case 10: {
                    byte[] apduBytes = (byte[])msg.obj;
                    Intent apduReceivedIntent = new Intent();
                    apduReceivedIntent.setAction(NfcService.ACTION_APDU_RECEIVED);
                    if (apduBytes != null && apduBytes.length > 0) {
                        apduReceivedIntent.putExtra(NfcService.EXTRA_APDU_BYTES, apduBytes);
                    }
                    NfcService.this.mContext.sendBroadcast(apduReceivedIntent, NfcService.NFCEE_ADMIN_PERM);
                    break;
                }
                case 12: {
                    byte[] mifareCmd = (byte[])msg.obj;
                    Intent mifareAccessIntent = new Intent();
                    mifareAccessIntent.setAction(NfcService.ACTION_MIFARE_ACCESS_DETECTED);
                    if (mifareCmd != null && mifareCmd.length > 1) {
                        int mifareBlock = mifareCmd[1] & 0xFF;
                        mifareAccessIntent.putExtra(NfcService.EXTRA_MIFARE_BLOCK, mifareBlock);
                    }
                    NfcService.this.mContext.sendBroadcast(mifareAccessIntent, NfcService.NFCEE_ADMIN_PERM);
                    break;
                }
                case 2: {
                    NativeP2pDevice device = (NativeP2pDevice)msg.obj;
                    Log.d((String)NfcService.TAG, (String)"LLCP Activation message");
                    if (device.getMode() == 0) {
                        if (!device.doConnect()) break;
                        if (NfcService.this.mManager.doCheckLlcp()) {
                            if (NfcService.this.mManager.doActivateLlcp()) {
                                NfcService.this.mObjectMap.put(device.getHandle(), device);
                                NfcService.this.activateLlcpLink();
                                break;
                            }
                            Log.w((String)NfcService.TAG, (String)"Initiator Activate LLCP NOK. Disconnect.");
                            device.doDisconnect();
                            break;
                        }
                        device.doDisconnect();
                        break;
                    }
                    if (device.getMode() != 1) break;
                    if (NfcService.this.mManager.doCheckLlcp()) {
                        if (!NfcService.this.mManager.doActivateLlcp()) break;
                        NfcService.this.mObjectMap.put(device.getHandle(), device);
                        NfcService.this.activateLlcpLink();
                        break;
                    }
                    Log.w((String)NfcService.TAG, (String)"checkLlcp failed");
                    break;
                }
                case 3: {
                    NativeP2pDevice device = (NativeP2pDevice)msg.obj;
                    Log.d((String)NfcService.TAG, (String)"LLCP Link Deactivated message. Restart polling loop.");
                    NfcService nfcService = NfcService.this;
                    synchronized (nfcService) {
                        if (NfcService.this.mObjectMap.remove(device.getHandle()) != null && device.getMode() == 0) {
                            device.doDisconnect();
                        }
                    }
                    Intent LlcpLinkIntent = new Intent();
                    LlcpLinkIntent.setAction("android.nfc.action.LLCP_LINK_STATE_CHANGED");
                    LlcpLinkIntent.putExtra("android.nfc.extra.LLCP_LINK_STATE", 1);
                    NfcService.this.mContext.sendOrderedBroadcast(LlcpLinkIntent, NfcService.NFC_PERM);
                    break;
                }
                case 4: {
                    Intent TargetDeselectedIntent = new Intent();
                    NfcService.this.mManager;
                    TargetDeselectedIntent.setAction("com.android.nfc.action.INTERNAL_TARGET_DESELECTED");
                    NfcService.this.mContext.sendOrderedBroadcast(TargetDeselectedIntent, NfcService.NFC_PERM);
                    break;
                }
                case 5: {
                    StatusBarManager sb = (StatusBarManager)NfcService.this.getSystemService("statusbar");
                    sb.setIcon(NfcService.SERVICE_NAME, 2130837508, 0);
                    break;
                }
                case 6: {
                    StatusBarManager sb = (StatusBarManager)NfcService.this.getSystemService("statusbar");
                    sb.removeIcon(NfcService.SERVICE_NAME);
                    break;
                }
                case 8: {
                    Intent eventFieldOnIntent = new Intent();
                    eventFieldOnIntent.setAction(NfcService.ACTION_RF_FIELD_ON_DETECTED);
                    NfcService.this.mContext.sendBroadcast(eventFieldOnIntent, NfcService.NFCEE_ADMIN_PERM);
                    break;
                }
                case 9: {
                    Intent eventFieldOffIntent = new Intent();
                    eventFieldOffIntent.setAction(NfcService.ACTION_RF_FIELD_OFF_DETECTED);
                    NfcService.this.mContext.sendBroadcast(eventFieldOffIntent, NfcService.NFCEE_ADMIN_PERM);
                    break;
                }
                default: {
                    Log.e((String)NfcService.TAG, (String)"Unknown message received");
                }
            }
        }

        private Intent buildTagIntent(Tag tag, NdefMessage[] msgs, String action) {
            Intent intent = new Intent(action);
            intent.putExtra("android.nfc.extra.TAG", (Parcelable)tag);
            intent.putExtra("android.nfc.extra.ID", tag.getId());
            intent.putExtra("android.nfc.extra.NDEF_MESSAGES", (Parcelable[])msgs);
            intent.addFlags(0x10000000);
            return intent;
        }

        private void dispatchNativeTag(NativeNfcTag nativeTag, NdefMessage[] msgs) {
            Tag tag = new Tag(nativeTag.getUid(), nativeTag.getTechList(), nativeTag.getTechExtras(), nativeTag.getHandle(), NfcService.this.mNfcTagService);
            NfcService.this.registerTagObject(nativeTag);
            if (!this.dispatchTag(tag, msgs)) {
                NfcService.this.unregisterObject(nativeTag.getHandle());
                nativeTag.disconnect();
            }
        }

        public byte[] concat(byte[] ... arrays) {
            int length = 0;
            for (byte[] array : arrays) {
                length += array.length;
            }
            byte[] result = new byte[length];
            int pos = 0;
            for (byte[] array : arrays) {
                System.arraycopy(array, 0, result, pos, array.length);
                pos += array.length;
            }
            return result;
        }

        private Uri parseWellKnownUriRecord(NdefRecord record) {
            byte[] payload = record.getPayload();
            String prefix = URI_PREFIX_MAP[payload[0] & 0xFF];
            byte[] fullUri = this.concat(prefix.getBytes(Charsets.UTF_8), Arrays.copyOfRange(payload, 1, payload.length));
            return Uri.parse((String)new String(fullUri, Charsets.UTF_8));
        }

        private boolean setTypeOrDataFromNdef(Intent intent, NdefRecord record) {
            short tnf = record.getTnf();
            byte[] type = record.getType();
            try {
                switch (tnf) {
                    case 2: {
                        intent.setType(new String(type, Charsets.US_ASCII));
                        return true;
                    }
                    case 3: {
                        intent.setData(Uri.parse((String)new String(type, Charsets.UTF_8)));
                        return true;
                    }
                    case 1: {
                        byte[] payload = record.getPayload();
                        if (payload == null || payload.length == 0) {
                            return false;
                        }
                        if (Arrays.equals(type, NdefRecord.RTD_TEXT)) {
                            intent.setType("text/plain");
                            return true;
                        }
                        if (Arrays.equals(type, NdefRecord.RTD_SMART_POSTER)) {
                            try {
                                NdefMessage msg = new NdefMessage(record.getPayload());
                                for (NdefRecord subRecord : msg.getRecords()) {
                                    short subTnf = subRecord.getTnf();
                                    if (subTnf == 1 && Arrays.equals(subRecord.getType(), NdefRecord.RTD_URI)) {
                                        intent.setData(this.parseWellKnownUriRecord(subRecord));
                                        return true;
                                    }
                                    if (subTnf != 3) continue;
                                    intent.setData(Uri.parse((String)new String(subRecord.getType(), Charsets.UTF_8)));
                                    return true;
                                }
                            }
                            catch (FormatException e) {
                                return false;
                            }
                        } else if (Arrays.equals(type, NdefRecord.RTD_URI)) {
                            intent.setData(this.parseWellKnownUriRecord(record));
                            return true;
                        }
                        return false;
                    }
                    case 4: {
                        intent.setData(Uri.parse((String)("vnd.android.nfc://ext/" + new String(record.getType(), Charsets.US_ASCII))));
                        return true;
                    }
                }
                return false;
            }
            catch (Exception e) {
                Log.e((String)NfcService.TAG, (String)"failed to parse record", (Throwable)e);
                return false;
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private boolean dispatchTag(Tag tag, NdefMessage[] msgs) {
            String[][] overrideTechLists;
            PendingIntent overrideIntent;
            IntentFilter[] overrideFilters;
            boolean foregroundNdefPush = NfcService.this.mNdefPushClient.getForegroundMessage() != null;
            INfcAdapter.Stub stub = NfcService.this.mNfcAdapter;
            synchronized (stub) {
                overrideFilters = NfcService.this.mDispatchOverrideFilters;
                overrideIntent = NfcService.this.mDispatchOverrideIntent;
                overrideTechLists = NfcService.this.mDispatchOverrideTechLists;
            }
            if (overrideIntent != null) {
                try {
                    if (this.dispatchTagInternal(tag, msgs, overrideIntent, overrideFilters, overrideTechLists)) {
                        return true;
                    }
                    Log.w((String)NfcService.TAG, (String)"Dispatch override registered, but no filters matched");
                }
                catch (PendingIntent.CanceledException e) {
                    Log.w((String)NfcService.TAG, (String)"Dispatch overrides pending intent was canceled");
                    INfcAdapter.Stub stub2 = NfcService.this.mNfcAdapter;
                    synchronized (stub2) {
                        NfcService.this.mDispatchOverrideFilters = null;
                        NfcService.this.mDispatchOverrideIntent = null;
                        NfcService.this.mDispatchOverrideTechLists = null;
                    }
                }
            }
            if (!foregroundNdefPush) {
                try {
                    return this.dispatchTagInternal(tag, msgs, null, null, null);
                }
                catch (PendingIntent.CanceledException e) {
                    Log.e((String)NfcService.TAG, (String)"CanceledException unexpected here", (Throwable)e);
                    return false;
                }
            }
            return false;
        }

        private boolean filterMatch(String[] tagTechs, String[] filterTechs) {
            if (filterTechs == null || filterTechs.length == 0) {
                return false;
            }
            for (String tech : filterTechs) {
                if (Arrays.binarySearch(tagTechs, tech) >= 0) continue;
                return false;
            }
            return true;
        }

        private boolean dispatchTagInternal(Tag tag, NdefMessage[] msgs, PendingIntent overrideIntent, IntentFilter[] overrideFilters, String[][] overrideTechLists) throws PendingIntent.CanceledException {
            Intent intent;
            NdefMessage msg;
            NdefRecord[] records;
            if (msgs != null && msgs.length > 0 && (records = (msg = msgs[0]).getRecords()).length > 0) {
                NdefRecord record = records[0];
                intent = this.buildTagIntent(tag, msgs, "android.nfc.action.NDEF_DISCOVERED");
                if (this.setTypeOrDataFromNdef(intent, record) && this.startDispatchActivity(intent, overrideIntent, overrideFilters, overrideTechLists)) {
                    return true;
                }
            }
            Object[] tagTechs = tag.getTechList();
            Arrays.sort(tagTechs);
            if (overrideIntent != null) {
                if (overrideTechLists != null) {
                    for (String[] filterTechs : overrideTechLists) {
                        if (!this.filterMatch((String[])tagTechs, filterTechs)) continue;
                        intent = this.buildTagIntent(tag, msgs, "android.nfc.action.TECH_DISCOVERED");
                        overrideIntent.send(NfcService.this.mContext, -1, intent);
                        return true;
                    }
                }
            } else {
                ArrayList<ResolveInfo> matches = new ArrayList<ResolveInfo>();
                ArrayList<RegisteredComponentCache.ComponentInfo> registered = NfcService.this.mTechListFilters.getComponents();
                for (RegisteredComponentCache.ComponentInfo info : registered) {
                    if (!this.filterMatch((String[])tagTechs, info.techs) || matches.contains(info.resolveInfo)) continue;
                    matches.add(info.resolveInfo);
                }
                if (matches.size() == 1) {
                    intent = this.buildTagIntent(tag, msgs, "android.nfc.action.TECH_DISCOVERED");
                    ResolveInfo info = (ResolveInfo)matches.get(0);
                    intent.setClassName(info.activityInfo.packageName, info.activityInfo.name);
                    try {
                        NfcService.this.mContext.startActivity(intent);
                        return true;
                    }
                    catch (ActivityNotFoundException e) {}
                } else if (matches.size() > 1) {
                    intent = new Intent(NfcService.this.mContext, TechListChooserActivity.class);
                    intent.addFlags(0x10000000);
                    intent.putExtra("android.intent.extra.INTENT", (Parcelable)this.buildTagIntent(tag, msgs, "android.nfc.action.TECH_DISCOVERED"));
                    intent.putParcelableArrayListExtra("rlist", matches);
                    try {
                        NfcService.this.mContext.startActivity(intent);
                        return true;
                    }
                    catch (ActivityNotFoundException e) {
                        // empty catch block
                    }
                }
            }
            if (this.startDispatchActivity(intent = this.buildTagIntent(tag, msgs, "android.nfc.action.TAG_DISCOVERED"), overrideIntent, overrideFilters, overrideTechLists)) {
                return true;
            }
            Log.e((String)NfcService.TAG, (String)("No tag fallback activity found for " + intent));
            return false;
        }

        private boolean startDispatchActivity(Intent intent, PendingIntent overrideIntent, IntentFilter[] overrideFilters, String[][] overrideTechLists) throws PendingIntent.CanceledException {
            if (overrideIntent != null) {
                boolean found = false;
                if (overrideFilters == null && overrideTechLists == null) {
                    found = true;
                } else if (overrideFilters != null) {
                    for (IntentFilter filter : overrideFilters) {
                        if (filter.match(NfcService.this.mContext.getContentResolver(), intent, false, NfcService.TAG) < 0) continue;
                        found = true;
                        break;
                    }
                }
                if (found) {
                    Log.i((String)NfcService.TAG, (String)("Dispatching to override intent " + overrideIntent));
                    overrideIntent.send(NfcService.this.mContext, -1, intent);
                    return true;
                }
                return false;
            }
            try {
                NfcService.this.mIActivityManager.resumeAppSwitches();
            }
            catch (RemoteException e) {
                // empty catch block
            }
            try {
                NfcService.this.mContext.startActivity(intent);
                return true;
            }
            catch (ActivityNotFoundException e) {
                return false;
            }
        }
    }

    private class WatchDogThread
    extends Thread {
        boolean mWatchDogCanceled = false;

        private WatchDogThread() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            boolean slept = false;
            while (!slept) {
                try {
                    Thread.sleep(10000L);
                    slept = true;
                }
                catch (InterruptedException interruptedException) {}
            }
            WatchDogThread watchDogThread = this;
            synchronized (watchDogThread) {
                if (!this.mWatchDogCanceled) {
                    Log.e((String)NfcService.TAG, (String)"Watch dog triggered");
                    NfcService.this.mManager.doAbort();
                }
            }
        }

        public synchronized void cancel() {
            this.mWatchDogCanceled = true;
        }
    }

    private class OpenSecureElement
    implements IBinder.DeathRecipient {
        public int pid;
        public int handle;

        public OpenSecureElement(int pid, int handle) {
            this.pid = pid;
            this.handle = handle;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void binderDied() {
            NfcService nfcService = NfcService.this;
            synchronized (nfcService) {
                this.pid = -1;
                try {
                    NfcService.this._nfcEeClose(false, -1);
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
        }
    }
}

