/*
 * Decompiled with CFR 0.152.
 */
package com.android.nfc;

import android.nfc.NdefMessage;
import android.os.Bundle;
import android.os.Parcelable;
import android.util.Log;

public class NativeNfcTag {
    static final boolean DBG = false;
    private int[] mTechList;
    private int[] mTechHandles;
    private int[] mTechLibNfcTypes;
    private Bundle[] mTechExtras;
    private byte[][] mTechPollBytes;
    private byte[][] mTechActBytes;
    private byte[] mUid;
    private int mConnectedTechnology;
    private int mLastStatusCode;
    private final String TAG = "NativeNfcTag";
    private boolean mIsPresent;
    private PresenceCheckWatchdog mWatchdog;

    private native int doConnect(int var1);

    public synchronized int connect(int technology) {
        if (this.mWatchdog != null) {
            this.mWatchdog.pause();
        }
        int status = -1;
        for (int i = 0; i < this.mTechList.length; ++i) {
            if (this.mTechList[i] != technology) continue;
            if (this.mConnectedTechnology != i) {
                if (this.mConnectedTechnology == -1) {
                    status = this.doConnect(this.mTechHandles[i]);
                } else if (this.mConnectedTechnology != -1 && this.mTechHandles[this.mConnectedTechnology] != this.mTechHandles[i]) {
                    status = this.reconnect(this.mTechHandles[i]);
                } else if (technology == 6 || technology == 7) {
                    status = 0;
                } else if (technology == 3 || !this.hasTechOnHandle(3, this.mTechHandles[i])) {
                    status = 0;
                }
                if (status != 0) break;
                this.mConnectedTechnology = i;
                break;
            }
            status = 0;
            break;
        }
        if (this.mWatchdog != null) {
            this.mWatchdog.doResume();
        }
        this.mLastStatusCode = status;
        return status;
    }

    public synchronized void startPresenceChecking() {
        this.mIsPresent = true;
        if (this.mWatchdog == null) {
            this.mWatchdog = new PresenceCheckWatchdog();
            this.mWatchdog.start();
        }
    }

    public synchronized boolean isPresent() {
        return this.mIsPresent;
    }

    native boolean doDisconnect();

    public synchronized boolean disconnect() {
        boolean result = false;
        this.mIsPresent = false;
        if (this.mWatchdog != null) {
            this.mWatchdog.end();
            try {
                this.mWatchdog.join();
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
            this.mWatchdog = null;
            result = true;
        } else {
            result = this.doDisconnect();
        }
        this.mConnectedTechnology = -1;
        return result;
    }

    native int doReconnect();

    public synchronized int reconnect() {
        if (this.mWatchdog != null) {
            this.mWatchdog.pause();
        }
        int status = this.doReconnect();
        if (this.mWatchdog != null) {
            this.mWatchdog.doResume();
        }
        return status;
    }

    native int doHandleReconnect(int var1);

    public synchronized int reconnect(int handle) {
        if (this.mWatchdog != null) {
            this.mWatchdog.pause();
        }
        int status = this.doHandleReconnect(handle);
        if (this.mWatchdog != null) {
            this.mWatchdog.doResume();
        }
        return status;
    }

    private native byte[] doTransceive(byte[] var1, boolean var2, int[] var3);

    public synchronized byte[] transceive(byte[] data, boolean raw, int[] returnCode) {
        if (this.mWatchdog != null) {
            this.mWatchdog.pause();
        }
        byte[] result = this.doTransceive(data, raw, returnCode);
        if (this.mWatchdog != null) {
            this.mWatchdog.doResume();
        }
        return result;
    }

    private native int doCheckNdef(int[] var1);

    public synchronized int checkNdef(int[] ndefinfo) {
        if (this.mWatchdog != null) {
            this.mWatchdog.pause();
        }
        int status = this.doCheckNdef(ndefinfo);
        if (this.mWatchdog != null) {
            this.mWatchdog.doResume();
        }
        this.mLastStatusCode = status;
        return status;
    }

    private native byte[] doRead();

    public synchronized byte[] read() {
        if (this.mWatchdog != null) {
            this.mWatchdog.pause();
        }
        byte[] result = this.doRead();
        if (this.mWatchdog != null) {
            this.mWatchdog.doResume();
        }
        return result;
    }

    private native boolean doWrite(byte[] var1);

    public synchronized boolean write(byte[] buf) {
        if (this.mWatchdog != null) {
            this.mWatchdog.pause();
        }
        boolean result = this.doWrite(buf);
        if (this.mWatchdog != null) {
            this.mWatchdog.doResume();
        }
        return result;
    }

    native boolean doPresenceCheck();

    public synchronized boolean presenceCheck() {
        if (this.mWatchdog != null) {
            this.mWatchdog.pause();
        }
        boolean result = this.doPresenceCheck();
        if (this.mWatchdog != null) {
            this.mWatchdog.doResume();
        }
        return result;
    }

    native boolean doNdefFormat(byte[] var1);

    public synchronized boolean formatNdef(byte[] key) {
        if (this.mWatchdog != null) {
            this.mWatchdog.pause();
        }
        boolean result = this.doNdefFormat(key);
        if (this.mWatchdog != null) {
            this.mWatchdog.doResume();
        }
        return result;
    }

    native boolean doMakeReadonly();

    public synchronized boolean makeReadonly() {
        if (this.mWatchdog != null) {
            this.mWatchdog.pause();
        }
        boolean result = this.doMakeReadonly();
        if (this.mWatchdog != null) {
            this.mWatchdog.doResume();
        }
        return result;
    }

    native boolean doIsNdefFormatable(int var1, byte[] var2, byte[] var3, byte[] var4);

    public synchronized boolean isNdefFormatable() {
        int nfcaTechIndex = this.getTechIndex(1);
        int nfcvTechIndex = this.getTechIndex(5);
        if (nfcaTechIndex != -1) {
            return this.doIsNdefFormatable(this.mTechLibNfcTypes[nfcaTechIndex], this.mUid, this.mTechPollBytes[nfcaTechIndex], this.mTechActBytes[nfcaTechIndex]);
        }
        if (nfcvTechIndex != -1) {
            return this.doIsNdefFormatable(this.mTechLibNfcTypes[nfcvTechIndex], this.mUid, this.mTechPollBytes[nfcvTechIndex], this.mTechActBytes[nfcvTechIndex]);
        }
        return false;
    }

    private NativeNfcTag() {
    }

    public int getLastStatusCode() {
        return this.mLastStatusCode;
    }

    public int getHandle() {
        if (this.mTechHandles.length > 0) {
            return this.mTechHandles[0];
        }
        return 0;
    }

    public byte[] getUid() {
        return this.mUid;
    }

    public int[] getTechList() {
        return this.mTechList;
    }

    public int[] getHandleList() {
        return this.mTechHandles;
    }

    public int getConnectedHandle() {
        if (this.mConnectedTechnology != -1 && this.mConnectedTechnology < this.mTechHandles.length) {
            return this.mTechHandles[this.mConnectedTechnology];
        }
        return 0;
    }

    public int getConnectedLibNfcType() {
        if (this.mConnectedTechnology != -1 && this.mConnectedTechnology < this.mTechLibNfcTypes.length) {
            return this.mTechLibNfcTypes[this.mConnectedTechnology];
        }
        return 0;
    }

    public int getConnectedTechnology() {
        if (this.mConnectedTechnology != -1 && this.mConnectedTechnology < this.mTechList.length) {
            return this.mTechList[this.mConnectedTechnology];
        }
        return 0;
    }

    native int doGetNdefType(int var1, int var2);

    private int getNdefType(int libnfctype, int javatype) {
        return this.doGetNdefType(libnfctype, javatype);
    }

    private void addTechnology(int tech, int handle, int libnfctype) {
        int[] mNewTechList = new int[this.mTechList.length + 1];
        System.arraycopy(this.mTechList, 0, mNewTechList, 0, this.mTechList.length);
        mNewTechList[this.mTechList.length] = tech;
        this.mTechList = mNewTechList;
        int[] mNewHandleList = new int[this.mTechHandles.length + 1];
        System.arraycopy(this.mTechHandles, 0, mNewHandleList, 0, this.mTechHandles.length);
        mNewHandleList[this.mTechHandles.length] = handle;
        this.mTechHandles = mNewHandleList;
        int[] mNewTypeList = new int[this.mTechLibNfcTypes.length + 1];
        System.arraycopy(this.mTechLibNfcTypes, 0, mNewTypeList, 0, this.mTechLibNfcTypes.length);
        mNewTypeList[this.mTechLibNfcTypes.length] = libnfctype;
        this.mTechLibNfcTypes = mNewTypeList;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNdefFormatableTechnology(int handle, int libnfcType) {
        NativeNfcTag nativeNfcTag = this;
        synchronized (nativeNfcTag) {
            this.addTechnology(7, handle, libnfcType);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addNdefTechnology(NdefMessage msg, int handle, int libnfcType, int javaType, int maxLength, int cardState) {
        NativeNfcTag nativeNfcTag = this;
        synchronized (nativeNfcTag) {
            this.addTechnology(6, handle, libnfcType);
            Bundle extras = new Bundle();
            extras.putParcelable("ndefmsg", (Parcelable)msg);
            extras.putInt("ndefmaxlength", maxLength);
            extras.putInt("ndefcardstate", cardState);
            extras.putInt("ndeftype", this.getNdefType(libnfcType, javaType));
            if (this.mTechExtras == null) {
                Bundle[] builtTechExtras = this.getTechExtras();
                builtTechExtras[builtTechExtras.length - 1] = extras;
            } else {
                Bundle[] oldTechExtras = this.getTechExtras();
                Bundle[] newTechExtras = new Bundle[oldTechExtras.length + 1];
                System.arraycopy(oldTechExtras, 0, newTechExtras, 0, oldTechExtras.length);
                newTechExtras[oldTechExtras.length] = extras;
                this.mTechExtras = newTechExtras;
            }
        }
    }

    private int getTechIndex(int tech) {
        int techIndex = -1;
        for (int i = 0; i < this.mTechList.length; ++i) {
            if (this.mTechList[i] != tech) continue;
            techIndex = i;
            break;
        }
        return techIndex;
    }

    private boolean hasTech(int tech) {
        boolean hasTech = false;
        for (int i = 0; i < this.mTechList.length; ++i) {
            if (this.mTechList[i] != tech) continue;
            hasTech = true;
            break;
        }
        return hasTech;
    }

    private boolean hasTechOnHandle(int tech, int handle) {
        boolean hasTech = false;
        for (int i = 0; i < this.mTechList.length; ++i) {
            if (this.mTechList[i] != tech || this.mTechHandles[i] != handle) continue;
            hasTech = true;
            break;
        }
        return hasTech;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Bundle[] getTechExtras() {
        NativeNfcTag nativeNfcTag = this;
        synchronized (nativeNfcTag) {
            if (this.mTechExtras != null) {
                return this.mTechExtras;
            }
            this.mTechExtras = new Bundle[this.mTechList.length];
            block10: for (int i = 0; i < this.mTechList.length; ++i) {
                Bundle extras = new Bundle();
                switch (this.mTechList[i]) {
                    case 1: {
                        byte[] actBytes = this.mTechActBytes[i];
                        if (actBytes != null && actBytes.length > 0) {
                            extras.putShort("sak", (short)(actBytes[0] & 0xFF));
                        }
                        extras.putByteArray("atqa", this.mTechPollBytes[i]);
                        break;
                    }
                    case 2: {
                        byte[] appData = new byte[4];
                        byte[] protInfo = new byte[3];
                        if (this.mTechPollBytes[i].length < 7) break;
                        System.arraycopy(this.mTechPollBytes[i], 0, appData, 0, 4);
                        System.arraycopy(this.mTechPollBytes[i], 4, protInfo, 0, 3);
                        extras.putByteArray("appdata", appData);
                        extras.putByteArray("protinfo", protInfo);
                        break;
                    }
                    case 4: {
                        byte[] pmm = new byte[8];
                        byte[] sc = new byte[2];
                        if (this.mTechPollBytes[i].length >= 8) {
                            System.arraycopy(this.mTechPollBytes[i], 0, pmm, 0, 8);
                            extras.putByteArray("pmm", pmm);
                        }
                        if (this.mTechPollBytes[i].length != 10) break;
                        System.arraycopy(this.mTechPollBytes[i], 8, sc, 0, 2);
                        extras.putByteArray("systemcode", sc);
                        break;
                    }
                    case 3: {
                        if (this.hasTech(1)) {
                            extras.putByteArray("histbytes", this.mTechActBytes[i]);
                            break;
                        }
                        extras.putByteArray("hiresp", this.mTechActBytes[i]);
                        break;
                    }
                    case 5: {
                        if (this.mTechPollBytes[i] == null || this.mTechPollBytes[i].length < 2) break;
                        extras.putByte("respflags", this.mTechPollBytes[i][0]);
                        extras.putByte("dsfid", this.mTechPollBytes[i][1]);
                        break;
                    }
                    default: {
                        continue block10;
                    }
                }
                this.mTechExtras[i] = extras;
            }
            return this.mTechExtras;
        }
    }

    class PresenceCheckWatchdog
    extends Thread {
        private int watchdogTimeout = 125;
        private boolean isPresent = true;
        private boolean isStopped = false;
        private boolean isPaused = false;
        private boolean doCheck = true;

        PresenceCheckWatchdog() {
        }

        public synchronized void pause() {
            this.isPaused = true;
            this.doCheck = false;
            this.notifyAll();
        }

        public synchronized void doResume() {
            this.isPaused = false;
            this.doCheck = false;
            this.notifyAll();
        }

        public synchronized void end() {
            this.isStopped = true;
            this.doCheck = false;
            this.notifyAll();
        }

        public synchronized void setTimeout(int timeout) {
            this.watchdogTimeout = timeout;
            this.doCheck = false;
            this.notifyAll();
        }

        public synchronized void run() {
            while (this.isPresent && !this.isStopped) {
                try {
                    if (!this.isPaused) {
                        this.doCheck = true;
                    }
                    this.wait(this.watchdogTimeout);
                    if (!this.doCheck) continue;
                    this.isPresent = NativeNfcTag.this.doPresenceCheck();
                }
                catch (InterruptedException interruptedException) {}
            }
            NativeNfcTag.this.mIsPresent = false;
            Log.d((String)"NativeNfcTag", (String)"Tag lost, restarting polling loop");
            NativeNfcTag.this.doDisconnect();
        }
    }
}

