/*
 * Decompiled with CFR 0.152.
 */
package com.android.nfc;

import android.content.Context;
import com.android.nfc.NativeLlcpConnectionlessSocket;
import com.android.nfc.NativeLlcpServiceSocket;
import com.android.nfc.NativeLlcpSocket;
import com.android.nfc.NativeNfcTag;
import com.android.nfc.NativeP2pDevice;
import com.android.nfc.NfcService;

public class NativeNfcManager {
    public static final String INTERNAL_LLCP_LINK_STATE_CHANGED_ACTION = "com.android.nfc.action.INTERNAL_LLCP_LINK_STATE_CHANGED";
    public static final String INTERNAL_LLCP_LINK_STATE_CHANGED_EXTRA = "com.android.nfc.extra.INTERNAL_LLCP_LINK_STATE";
    public static final String INTERNAL_TARGET_DESELECTED_ACTION = "com.android.nfc.action.INTERNAL_TARGET_DESELECTED";
    private static final String NFC_PERM = "android.permission.NFC";
    private int mNative;
    private final Context mContext;
    private final NfcService mNfcService;
    private static final String TAG = "NativeNfcManager";

    public NativeNfcManager(Context context, NfcService service) {
        this.mContext = context;
        this.mNfcService = service;
    }

    public native boolean initializeNativeStructure();

    public native boolean initialize();

    public native boolean deinitialize();

    public native void enableDiscovery(int var1);

    public native void disableDiscovery();

    public native int[] doGetSecureElementList();

    public native void doSelectSecureElement(int var1);

    public native void doDeselectSecureElement(int var1);

    public native int doGetLastError();

    public native void doSetProperties(int var1, int var2);

    public native NativeLlcpConnectionlessSocket doCreateLlcpConnectionlessSocket(int var1);

    public native NativeLlcpServiceSocket doCreateLlcpServiceSocket(int var1, String var2, int var3, int var4, int var5);

    public native NativeLlcpSocket doCreateLlcpSocket(int var1, int var2, int var3, int var4);

    public native boolean doCheckLlcp();

    public native boolean doActivateLlcp();

    public native void doAbort();

    public native void doResetIsoDepTimeout();

    public void resetIsoDepTimeout() {
        this.doResetIsoDepTimeout();
    }

    public native void doSetIsoDepTimeout(int var1);

    public void setIsoDepTimeout(int timeout) {
        this.doSetIsoDepTimeout(timeout);
    }

    public native boolean doDownload();

    private void notifyNdefMessageListeners(NativeNfcTag tag) {
        this.mNfcService.sendMessage(0, tag);
    }

    private void notifyTargetDeselected() {
        this.mNfcService.sendMessage(4, null);
    }

    private void notifyTransactionListeners(byte[] aid) {
        this.mNfcService.sendMessage(1, aid);
    }

    private void notifyLlcpLinkActivation(NativeP2pDevice device) {
        this.mNfcService.sendMessage(2, device);
    }

    private void notifyLlcpLinkDeactivated(NativeP2pDevice device) {
        this.mNfcService.sendMessage(3, device);
    }

    private void notifySeFieldActivated() {
        this.mNfcService.sendMessage(8, null);
    }

    private void notifySeFieldDeactivated() {
        this.mNfcService.sendMessage(9, null);
    }

    private void notifySeApduReceived(byte[] apdu) {
        this.mNfcService.sendMessage(10, apdu);
    }

    private void notifySeEmvCardRemoval() {
        this.mNfcService.sendMessage(11, null);
    }

    private void notifySeMifareAccess(byte[] block) {
        this.mNfcService.sendMessage(12, block);
    }
}

