/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.util;

import android.content.BroadcastReceiver;
import android.content.ContentResolver;
import android.content.ContentValues;
import android.content.Context;
import android.content.Intent;
import android.content.IntentFilter;
import android.database.Cursor;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.provider.Telephony;
import android.util.Log;

public class RateController {
    private static final String TAG = "RateController";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    private static final int RATE_LIMIT = 100;
    private static final long ONE_HOUR = 3600000L;
    private static final int NO_ANSWER = 0;
    private static final int ANSWER_YES = 1;
    private static final int ANSWER_NO = 2;
    public static final int ANSWER_TIMEOUT = 20000;
    public static final String RATE_LIMIT_SURPASSED_ACTION = "com.android.mms.RATE_LIMIT_SURPASSED";
    public static final String RATE_LIMIT_CONFIRMED_ACTION = "com.android.mms.RATE_LIMIT_CONFIRMED";
    private static RateController sInstance;
    private static boolean sMutexLock;
    private final Context mContext;
    private int mAnswer;
    private final BroadcastReceiver mBroadcastReceiver = new BroadcastReceiver(){

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onReceive(Context context, Intent intent) {
            if (RateController.RATE_LIMIT_CONFIRMED_ACTION.equals(intent.getAction())) {
                1 var3_3 = this;
                synchronized (var3_3) {
                    RateController.this.mAnswer = intent.getBooleanExtra("answer", false) ? 1 : 2;
                    ((Object)((Object)this)).notifyAll();
                }
            }
        }
    };

    private RateController(Context context) {
        this.mContext = context;
    }

    public static void init(Context context) {
        if (sInstance != null) {
            Log.w((String)TAG, (String)"Already initialized.");
        }
        sInstance = new RateController(context);
    }

    public static RateController getInstance() {
        if (sInstance == null) {
            throw new IllegalStateException("Uninitialized.");
        }
        return sInstance;
    }

    public final void update() {
        ContentValues values = new ContentValues(1);
        values.put("sent_time", Long.valueOf(System.currentTimeMillis()));
        SqliteWrapper.insert((Context)this.mContext, (ContentResolver)this.mContext.getContentResolver(), (Uri)Telephony.Mms.Rate.CONTENT_URI, (ContentValues)values);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final boolean isLimitSurpassed() {
        long oneHourAgo = System.currentTimeMillis() - 3600000L;
        Cursor c = SqliteWrapper.query((Context)this.mContext, (ContentResolver)this.mContext.getContentResolver(), (Uri)Telephony.Mms.Rate.CONTENT_URI, (String[])new String[]{"COUNT(*) AS rate"}, (String)("sent_time>" + oneHourAgo), null, null);
        if (c != null) {
            try {
                if (c.moveToFirst()) {
                    boolean bl = c.getInt(0) >= 100;
                    return bl;
                }
            }
            finally {
                c.close();
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean isAllowedByUser() {
        while (sMutexLock) {
            try {
                this.wait();
            }
            catch (InterruptedException _) {}
        }
        sMutexLock = true;
        this.mContext.registerReceiver(this.mBroadcastReceiver, new IntentFilter(RATE_LIMIT_CONFIRMED_ACTION));
        this.mAnswer = 0;
        try {
            Intent intent = new Intent(RATE_LIMIT_SURPASSED_ACTION);
            intent.addFlags(0x10000000);
            this.mContext.startActivity(intent);
            boolean bl = this.waitForAnswer() == 1;
            return bl;
        }
        finally {
            this.mContext.unregisterReceiver(this.mBroadcastReceiver);
            sMutexLock = false;
            this.notifyAll();
        }
    }

    private synchronized int waitForAnswer() {
        for (int t = 0; this.mAnswer == 0 && t < 20000; t += 1000) {
            try {
                this.wait(1000L);
                continue;
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
        return this.mAnswer;
    }
}

