/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.util;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SqliteWrapper;
import android.net.Uri;
import android.provider.Telephony;
import android.util.Log;
import java.util.HashSet;
import java.util.Iterator;

public class DraftCache {
    private static final String TAG = "Mms/draft";
    private static DraftCache sInstance;
    private final Context mContext;
    private HashSet<Long> mDraftSet = new HashSet(4);
    private final HashSet<OnDraftChangedListener> mChangeListeners = new HashSet(1);
    static final String[] DRAFT_PROJECTION;
    static final int COLUMN_DRAFT_THREAD_ID = 0;

    private DraftCache(Context context) {
        if (Log.isLoggable((String)"Mms:app", (int)3)) {
            this.log("DraftCache.constructor", new Object[0]);
        }
        this.mContext = context;
        this.refresh();
    }

    public void refresh() {
        if (Log.isLoggable((String)"Mms:app", (int)3)) {
            this.log("refresh", new Object[0]);
        }
        new Thread(new Runnable(){

            public void run() {
                DraftCache.this.rebuildCache();
            }
        }).start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void rebuildCache() {
        if (Log.isLoggable((String)"Mms:app", (int)3)) {
            this.log("rebuildCache", new Object[0]);
        }
        HashSet<Long> oldDraftSet = this.mDraftSet;
        HashSet<Long> newDraftSet = new HashSet<Long>(oldDraftSet.size());
        Cursor cursor = SqliteWrapper.query((Context)this.mContext, (ContentResolver)this.mContext.getContentResolver(), (Uri)Telephony.MmsSms.CONTENT_DRAFT_URI, (String[])DRAFT_PROJECTION, null, null, null);
        try {
            if (cursor.moveToFirst()) {
                while (!cursor.isAfterLast()) {
                    long threadId = cursor.getLong(0);
                    newDraftSet.add(threadId);
                    if (Log.isLoggable((String)"Mms:app", (int)3)) {
                        this.log("rebuildCache: add tid=" + threadId, new Object[0]);
                    }
                    cursor.moveToNext();
                }
            }
        }
        finally {
            cursor.close();
        }
        this.mDraftSet = newDraftSet;
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            this.dump();
        }
        if (this.mChangeListeners.size() < 1) {
            return;
        }
        HashSet added = new HashSet(newDraftSet);
        added.removeAll(oldDraftSet);
        HashSet<Long> removed = new HashSet<Long>(oldDraftSet);
        removed.removeAll(newDraftSet);
        for (OnDraftChangedListener l : this.mChangeListeners) {
            long threadId;
            Iterator i$ = added.iterator();
            while (i$.hasNext()) {
                threadId = (Long)i$.next();
                l.onDraftChanged(threadId, true);
            }
            i$ = removed.iterator();
            while (i$.hasNext()) {
                threadId = (Long)i$.next();
                l.onDraftChanged(threadId, false);
            }
        }
    }

    public synchronized void setDraftState(long threadId, boolean hasDraft) {
        if (threadId <= 0L) {
            return;
        }
        boolean changed = hasDraft ? this.mDraftSet.add(threadId) : this.mDraftSet.remove(threadId);
        if (Log.isLoggable((String)"Mms:app", (int)3)) {
            this.log("setDraftState: tid=" + threadId + ", value=" + hasDraft + ", changed=" + changed, new Object[0]);
        }
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            this.dump();
        }
        if (changed) {
            for (OnDraftChangedListener l : this.mChangeListeners) {
                l.onDraftChanged(threadId, hasDraft);
            }
        }
    }

    public synchronized boolean hasDraft(long threadId) {
        return this.mDraftSet.contains(threadId);
    }

    public synchronized void addOnDraftChangedListener(OnDraftChangedListener l) {
        if (Log.isLoggable((String)"Mms:app", (int)3)) {
            this.log("addOnDraftChangedListener " + l, new Object[0]);
        }
        this.mChangeListeners.add(l);
    }

    public synchronized void removeOnDraftChangedListener(OnDraftChangedListener l) {
        if (Log.isLoggable((String)"Mms:app", (int)3)) {
            this.log("removeOnDraftChangedListener " + l, new Object[0]);
        }
        this.mChangeListeners.remove(l);
    }

    public static void init(Context context) {
        sInstance = new DraftCache(context);
    }

    public static DraftCache getInstance() {
        return sInstance;
    }

    public void dump() {
        Log.i((String)TAG, (String)"dump:");
        for (Long threadId : this.mDraftSet) {
            Log.i((String)TAG, (String)("  tid: " + threadId));
        }
    }

    private void log(String format, Object ... args) {
        String s = String.format(format, args);
        Log.d((String)TAG, (String)("[DraftCache/" + Thread.currentThread().getId() + "] " + s));
    }

    static {
        DRAFT_PROJECTION = new String[]{"thread_id"};
    }

    public static interface OnDraftChangedListener {
        public void onDraftChanged(long var1, boolean var3);
    }
}

