/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.database.sqlite.SqliteWrapper;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.net.Uri;
import android.text.TextUtils;
import android.util.Log;
import android.webkit.MimeTypeMap;
import com.android.mms.model.ImageModel;
import com.google.android.mms.pdu.PduPart;
import java.io.ByteArrayOutputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public class UriImage {
    private static final String TAG = "Mms/image";
    private static final boolean DEBUG = true;
    private static final boolean LOCAL_LOGV = true;
    private final Context mContext;
    private final Uri mUri;
    private String mContentType;
    private String mPath;
    private String mSrc;
    private int mWidth;
    private int mHeight;
    private static final int NUMBER_OF_RESIZE_ATTEMPTS = 4;

    public UriImage(Context context, Uri uri) {
        if (null == context || null == uri) {
            throw new IllegalArgumentException();
        }
        String scheme = uri.getScheme();
        if (scheme.equals("content")) {
            this.initFromContentUri(context, uri);
        } else if (uri.getScheme().equals("file")) {
            this.initFromFile(context, uri);
        }
        this.mSrc = this.mPath.substring(this.mPath.lastIndexOf(47) + 1);
        if (this.mSrc.startsWith(".") && this.mSrc.length() > 1) {
            this.mSrc = this.mSrc.substring(1);
        }
        this.mSrc = this.mSrc.replace(' ', '_');
        this.mContext = context;
        this.mUri = uri;
        this.decodeBoundsInfo();
    }

    private void initFromFile(Context context, Uri uri) {
        int dotPos;
        this.mPath = uri.getPath();
        MimeTypeMap mimeTypeMap = MimeTypeMap.getSingleton();
        String extension = MimeTypeMap.getFileExtensionFromUrl((String)this.mPath);
        if (TextUtils.isEmpty((CharSequence)extension) && 0 <= (dotPos = this.mPath.lastIndexOf(46))) {
            extension = this.mPath.substring(dotPos + 1);
        }
        this.mContentType = mimeTypeMap.getMimeTypeFromExtension(extension);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void initFromContentUri(Context context, Uri uri) {
        Cursor c = SqliteWrapper.query((Context)context, (ContentResolver)context.getContentResolver(), (Uri)uri, null, null, null, null);
        if (c == null) {
            throw new IllegalArgumentException("Query on " + uri + " returns null result.");
        }
        try {
            String filePath;
            if (c.getCount() != 1 || !c.moveToFirst()) {
                throw new IllegalArgumentException("Query on " + uri + " returns 0 or multiple rows.");
            }
            if (ImageModel.isMmsUri(uri)) {
                filePath = c.getString(c.getColumnIndexOrThrow("fn"));
                if (TextUtils.isEmpty((CharSequence)filePath)) {
                    filePath = c.getString(c.getColumnIndexOrThrow("_data"));
                }
                this.mContentType = c.getString(c.getColumnIndexOrThrow("ct"));
            } else {
                filePath = c.getString(c.getColumnIndexOrThrow("_data"));
                this.mContentType = c.getString(c.getColumnIndexOrThrow("mime_type"));
            }
            this.mPath = filePath;
        }
        finally {
            c.close();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void decodeBoundsInfo() {
        InputStream input = null;
        try {
            input = this.mContext.getContentResolver().openInputStream(this.mUri);
            BitmapFactory.Options opt = new BitmapFactory.Options();
            opt.inJustDecodeBounds = true;
            BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)opt);
            this.mWidth = opt.outWidth;
            this.mHeight = opt.outHeight;
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)"IOException caught while opening stream", (Throwable)e);
        }
        finally {
            if (null != input) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)"IOException caught while closing stream", (Throwable)e);
                }
            }
        }
    }

    public String getContentType() {
        return this.mContentType;
    }

    public String getSrc() {
        return this.mSrc;
    }

    public int getWidth() {
        return this.mWidth;
    }

    public int getHeight() {
        return this.mHeight;
    }

    public PduPart getResizedImageAsPart(int widthLimit, int heightLimit, int byteLimit) {
        PduPart part = new PduPart();
        byte[] data = this.getResizedImageData(widthLimit, heightLimit, byteLimit);
        if (data == null) {
            Log.v((String)TAG, (String)"Resize image failed.");
            return null;
        }
        part.setData(data);
        part.setContentType(this.getContentType().getBytes());
        return part;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private byte[] getResizedImageData(int widthLimit, int heightLimit, int byteLimit) {
        int outWidth = this.mWidth;
        int outHeight = this.mHeight;
        int scaleFactor = 1;
        while (outWidth / scaleFactor > widthLimit || outHeight / scaleFactor > heightLimit) {
            scaleFactor *= 2;
        }
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            Log.v((String)TAG, (String)("getResizedImageData: wlimit=" + widthLimit + ", hlimit=" + heightLimit + ", sizeLimit=" + byteLimit + ", mWidth=" + this.mWidth + ", mHeight=" + this.mHeight + ", initialScaleFactor=" + scaleFactor));
        }
        InputStream input = null;
        try {
            Object options;
            ByteArrayOutputStream os = null;
            int attempts = 1;
            do {
                Bitmap b;
                int quality;
                block34: {
                    options = new BitmapFactory.Options();
                    options.inSampleSize = scaleFactor;
                    input = this.mContext.getContentResolver().openInputStream(this.mUri);
                    quality = 80;
                    b = BitmapFactory.decodeStream((InputStream)input, null, (BitmapFactory.Options)options);
                    if (b == null) {
                        byte[] byArray = null;
                        return byArray;
                    }
                    if (options.outWidth <= widthLimit && options.outHeight <= heightLimit) break block34;
                    int scaledWidth = outWidth / scaleFactor;
                    int scaledHeight = outHeight / scaleFactor;
                    if (Log.isLoggable((String)"Mms:app", (int)2)) {
                        Log.v((String)TAG, (String)("getResizedImageData: retry scaling using Bitmap.createScaledBitmap: w=" + scaledWidth + ", h=" + scaledHeight));
                    }
                    if ((b = Bitmap.createScaledBitmap((Bitmap)b, (int)(outWidth / scaleFactor), (int)(outHeight / scaleFactor), (boolean)false)) == null) {
                        byte[] byArray = null;
                        return byArray;
                    }
                }
                try {
                    int reducedQuality;
                    os = new ByteArrayOutputStream();
                    b.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)os);
                    int jpgFileSize = os.size();
                    if (jpgFileSize > byteLimit && (reducedQuality = quality * byteLimit / jpgFileSize) >= 50) {
                        quality = reducedQuality;
                        if (Log.isLoggable((String)"Mms:app", (int)2)) {
                            Log.v((String)TAG, (String)("getResizedImageData: compress(2) w/ quality=" + quality));
                        }
                        os = new ByteArrayOutputStream();
                        b.compress(Bitmap.CompressFormat.JPEG, quality, (OutputStream)os);
                    }
                    b.recycle();
                }
                catch (OutOfMemoryError e) {
                    Log.w((String)TAG, (String)("getResizedImageData - image too big (OutOfMemoryError), will try  with smaller scale factor, cur scale factor: " + scaleFactor));
                }
                if (Log.isLoggable((String)"Mms:app", (int)2)) {
                    Log.v((String)TAG, (String)("attempt=" + attempts + " size=" + (os == null ? 0 : os.size()) + " width=" + outWidth / scaleFactor + " height=" + outHeight / scaleFactor + " scaleFactor=" + scaleFactor + " quality=" + quality));
                }
                scaleFactor *= 2;
            } while ((os == null || os.size() > byteLimit) && ++attempts < 4);
            options = os == null ? null : os.toByteArray();
            return options;
        }
        catch (FileNotFoundException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        catch (OutOfMemoryError e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            byte[] byArray = null;
            return byArray;
        }
        finally {
            if (input != null) {
                try {
                    input.close();
                }
                catch (IOException e) {
                    Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
                }
            }
        }
    }
}

