/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.content.Context;
import android.drm.mobile1.DrmException;
import android.os.Handler;
import android.util.Log;
import android.widget.Toast;
import com.android.mms.model.AudioModel;
import com.android.mms.model.ImageModel;
import com.android.mms.model.LayoutModel;
import com.android.mms.model.MediaModel;
import com.android.mms.model.Model;
import com.android.mms.model.RegionMediaModel;
import com.android.mms.model.RegionModel;
import com.android.mms.model.SlideModel;
import com.android.mms.model.SlideshowModel;
import com.android.mms.model.TextModel;
import com.android.mms.model.VideoModel;
import com.android.mms.ui.AdaptableSlideViewInterface;
import com.android.mms.ui.Presenter;
import com.android.mms.ui.SlideViewInterface;
import com.android.mms.ui.ViewInterface;

public class SlideshowPresenter
extends Presenter {
    private static final String TAG = "SlideshowPresenter";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    protected int mLocation = 0;
    protected final int mSlideNumber;
    protected float mWidthTransformRatio;
    protected float mHeightTransformRatio;
    protected final Handler mHandler = new Handler();
    private final AdaptableSlideViewInterface.OnSizeChangedListener mViewSizeChangedListener = new AdaptableSlideViewInterface.OnSizeChangedListener(){

        public void onSizeChanged(int width, int height) {
            float ratio;
            LayoutModel layout2 = ((SlideshowModel)SlideshowPresenter.this.mModel).getLayout();
            SlideshowPresenter.this.mWidthTransformRatio = SlideshowPresenter.this.getWidthTransformRatio(width, layout2.getLayoutWidth());
            SlideshowPresenter.this.mHeightTransformRatio = SlideshowPresenter.this.getHeightTransformRatio(height, layout2.getLayoutHeight());
            SlideshowPresenter.this.mWidthTransformRatio = ratio = SlideshowPresenter.this.mWidthTransformRatio > SlideshowPresenter.this.mHeightTransformRatio ? SlideshowPresenter.this.mWidthTransformRatio : SlideshowPresenter.this.mHeightTransformRatio;
            SlideshowPresenter.this.mHeightTransformRatio = ratio;
        }
    };

    public SlideshowPresenter(Context context, ViewInterface view, Model model) {
        super(context, view, model);
        this.mSlideNumber = ((SlideshowModel)this.mModel).size();
        if (view instanceof AdaptableSlideViewInterface) {
            ((AdaptableSlideViewInterface)view).setOnSizeChangedListener(this.mViewSizeChangedListener);
        }
    }

    private float getWidthTransformRatio(int width, int layoutWidth) {
        if (width > 0) {
            return (float)layoutWidth / (float)width;
        }
        return 1.0f;
    }

    private float getHeightTransformRatio(int height, int layoutHeight) {
        if (height > 0) {
            return (float)layoutHeight / (float)height;
        }
        return 1.0f;
    }

    private int transformWidth(int width) {
        return (int)((float)width / this.mWidthTransformRatio);
    }

    private int transformHeight(int height) {
        return (int)((float)height / this.mHeightTransformRatio);
    }

    public void present() {
        this.presentSlide((SlideViewInterface)this.mView, ((SlideshowModel)this.mModel).get(this.mLocation));
    }

    protected void presentSlide(SlideViewInterface view, SlideModel model) {
        view.reset();
        try {
            for (MediaModel media : model) {
                if (media instanceof RegionMediaModel) {
                    this.presentRegionMedia(view, (RegionMediaModel)media, true);
                    continue;
                }
                if (!media.isAudio()) continue;
                this.presentAudio(view, (AudioModel)media, true);
            }
        }
        catch (DrmException e) {
            Log.e((String)TAG, (String)e.getMessage(), (Throwable)e);
            Toast.makeText((Context)this.mContext, (CharSequence)this.mContext.getString(2131165221), (int)0).show();
        }
    }

    protected void presentRegionMedia(SlideViewInterface view, RegionMediaModel rMedia, boolean dataChanged) throws DrmException {
        RegionModel r = rMedia.getRegion();
        if (rMedia.isText()) {
            this.presentText(view, (TextModel)rMedia, r, dataChanged);
        } else if (rMedia.isImage()) {
            this.presentImage(view, (ImageModel)rMedia, r, dataChanged);
        } else if (rMedia.isVideo()) {
            this.presentVideo(view, (VideoModel)rMedia, r, dataChanged);
        }
    }

    protected void presentAudio(SlideViewInterface view, AudioModel audio, boolean dataChanged) throws DrmException {
        MediaModel.MediaAction action;
        if (dataChanged) {
            view.setAudio(audio.getUriWithDrmCheck(), audio.getSrc(), audio.getExtras());
        }
        if ((action = audio.getCurrentAction()) == MediaModel.MediaAction.START) {
            view.startAudio();
        } else if (action == MediaModel.MediaAction.PAUSE) {
            view.pauseAudio();
        } else if (action == MediaModel.MediaAction.STOP) {
            view.stopAudio();
        } else if (action == MediaModel.MediaAction.SEEK) {
            view.seekAudio(audio.getSeekTo());
        }
    }

    protected void presentText(SlideViewInterface view, TextModel text, RegionModel r, boolean dataChanged) {
        if (dataChanged) {
            view.setText(text.getSrc(), text.getText());
        }
        if (view instanceof AdaptableSlideViewInterface) {
            ((AdaptableSlideViewInterface)view).setTextRegion(this.transformWidth(r.getLeft()), this.transformHeight(r.getTop()), this.transformWidth(r.getWidth()), this.transformHeight(r.getHeight()));
        }
        view.setTextVisibility(text.isVisible());
    }

    protected void presentImage(SlideViewInterface view, ImageModel image, RegionModel r, boolean dataChanged) throws DrmException {
        if (dataChanged) {
            view.setImage(image.getSrc(), image.getBitmapWithDrmCheck());
        }
        if (view instanceof AdaptableSlideViewInterface) {
            ((AdaptableSlideViewInterface)view).setImageRegion(this.transformWidth(r.getLeft()), this.transformHeight(r.getTop()), this.transformWidth(r.getWidth()), this.transformHeight(r.getHeight()));
        }
        view.setImageRegionFit(r.getFit());
        view.setImageVisibility(image.isVisible());
    }

    protected void presentVideo(SlideViewInterface view, VideoModel video, RegionModel r, boolean dataChanged) throws DrmException {
        if (dataChanged) {
            view.setVideo(video.getSrc(), video.getUriWithDrmCheck());
        }
        if (view instanceof AdaptableSlideViewInterface) {
            ((AdaptableSlideViewInterface)view).setVideoRegion(this.transformWidth(r.getLeft()), this.transformHeight(r.getTop()), this.transformWidth(r.getWidth()), this.transformHeight(r.getHeight()));
        }
        view.setVideoVisibility(video.isVisible());
        MediaModel.MediaAction action = video.getCurrentAction();
        if (action == MediaModel.MediaAction.START) {
            view.startVideo();
        } else if (action == MediaModel.MediaAction.PAUSE) {
            view.pauseVideo();
        } else if (action == MediaModel.MediaAction.STOP) {
            view.stopVideo();
        } else if (action == MediaModel.MediaAction.SEEK) {
            view.seekVideo(video.getSeekTo());
        }
    }

    public void setLocation(int location) {
        this.mLocation = location;
    }

    public int getLocation() {
        return this.mLocation;
    }

    public void goBackward() {
        if (this.mLocation > 0) {
            --this.mLocation;
        }
    }

    public void goForward() {
        if (this.mLocation < this.mSlideNumber - 1) {
            ++this.mLocation;
        }
    }

    public void onModelChanged(final Model model, final boolean dataChanged) {
        final SlideViewInterface view = (SlideViewInterface)this.mView;
        if (!(model instanceof SlideshowModel)) {
            if (model instanceof SlideModel) {
                if (((SlideModel)model).isVisible()) {
                    this.mHandler.post(new Runnable(){

                        public void run() {
                            SlideshowPresenter.this.presentSlide(view, (SlideModel)model);
                        }
                    });
                } else {
                    this.mHandler.post(new Runnable(){

                        public void run() {
                            SlideshowPresenter.this.goForward();
                        }
                    });
                }
            } else if (model instanceof MediaModel) {
                if (model instanceof RegionMediaModel) {
                    this.mHandler.post(new Runnable(){

                        public void run() {
                            try {
                                SlideshowPresenter.this.presentRegionMedia(view, (RegionMediaModel)model, dataChanged);
                            }
                            catch (DrmException e) {
                                Log.e((String)SlideshowPresenter.TAG, (String)e.getMessage(), (Throwable)e);
                                Toast.makeText((Context)SlideshowPresenter.this.mContext, (CharSequence)SlideshowPresenter.this.mContext.getString(2131165221), (int)0).show();
                            }
                        }
                    });
                } else if (((MediaModel)model).isAudio()) {
                    this.mHandler.post(new Runnable(){

                        public void run() {
                            try {
                                SlideshowPresenter.this.presentAudio(view, (AudioModel)model, dataChanged);
                            }
                            catch (DrmException e) {
                                Log.e((String)SlideshowPresenter.TAG, (String)e.getMessage(), (Throwable)e);
                                Toast.makeText((Context)SlideshowPresenter.this.mContext, (CharSequence)SlideshowPresenter.this.mContext.getString(2131165221), (int)0).show();
                            }
                        }
                    });
                }
            } else if (model instanceof RegionModel) {
                // empty if block
            }
        }
    }
}

