/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.content.Context;
import android.net.Uri;
import android.util.Log;
import com.android.mms.model.AudioModel;
import com.android.mms.model.ImageModel;
import com.android.mms.model.RegionModel;
import com.android.mms.model.SlideModel;
import com.android.mms.model.SlideshowModel;
import com.android.mms.model.TextModel;
import com.android.mms.model.VideoModel;
import com.google.android.mms.MmsException;

public class SlideshowEditor {
    private static final String TAG = "Mms:slideshow";
    public static final int MAX_SLIDE_NUM = 10;
    private final Context mContext;
    private final SlideshowModel mModel;

    public SlideshowEditor(Context context, SlideshowModel model) {
        this.mContext = context;
        this.mModel = model;
    }

    public boolean addNewSlide() {
        int position = this.mModel.size();
        return this.addNewSlide(position);
    }

    public boolean addNewSlide(int position) {
        int size = this.mModel.size();
        if (size < 10) {
            SlideModel slide = new SlideModel(this.mModel);
            TextModel text = new TextModel(this.mContext, "text/plain", "text_" + size + ".txt", this.mModel.getLayout().getTextRegion());
            slide.add(text);
            this.mModel.add(position, slide);
            return true;
        }
        Log.w((String)TAG, (String)"The limitation of the number of slides is reached.");
        return false;
    }

    public void removeSlide(int position) {
        this.mModel.remove(position);
    }

    public void removeAllSlides() {
        while (this.mModel.size() > 0) {
            this.removeSlide(0);
        }
    }

    public boolean removeText(int position) {
        return this.mModel.get(position).removeText();
    }

    public boolean removeImage(int position) {
        return this.mModel.get(position).removeImage();
    }

    public boolean removeVideo(int position) {
        return this.mModel.get(position).removeVideo();
    }

    public boolean removeAudio(int position) {
        return this.mModel.get(position).removeAudio();
    }

    public void changeText(int position, String newText) {
        if (newText != null) {
            SlideModel slide = this.mModel.get(position);
            TextModel text = slide.getText();
            if (text == null) {
                text = new TextModel(this.mContext, "text/plain", "text_" + position + ".txt", this.mModel.getLayout().getTextRegion());
                text.setText(newText);
                slide.add(text);
            } else if (!newText.equals(text.getText())) {
                text.setText(newText);
            }
        }
    }

    public void changeImage(int position, Uri newImage) throws MmsException {
        this.mModel.get(position).add(new ImageModel(this.mContext, newImage, this.mModel.getLayout().getImageRegion()));
    }

    public void changeAudio(int position, Uri newAudio) throws MmsException {
        AudioModel audio = new AudioModel(this.mContext, newAudio);
        SlideModel slide = this.mModel.get(position);
        slide.add(audio);
        slide.updateDuration(audio.getDuration());
    }

    public void changeVideo(int position, Uri newVideo) throws MmsException {
        VideoModel video = new VideoModel(this.mContext, newVideo, this.mModel.getLayout().getImageRegion());
        SlideModel slide = this.mModel.get(position);
        slide.add(video);
        slide.updateDuration(video.getDuration());
    }

    public void moveSlideUp(int position) {
        this.mModel.add(position - 1, this.mModel.remove(position));
    }

    public void moveSlideDown(int position) {
        this.mModel.add(position + 1, this.mModel.remove(position));
    }

    public void changeDuration(int position, int dur) {
        if (dur >= 0) {
            this.mModel.get(position).setDuration(dur);
        }
    }

    public void changeLayout(int layout2) {
        this.mModel.getLayout().changeTo(layout2);
    }

    public RegionModel getImageRegion() {
        return this.mModel.getLayout().getImageRegion();
    }

    public RegionModel getTextRegion() {
        return this.mModel.getLayout().getTextRegion();
    }
}

