/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.content.Context;
import android.provider.Telephony;
import android.telephony.PhoneNumberUtils;
import android.text.Annotation;
import android.text.Editable;
import android.text.Layout;
import android.text.Spannable;
import android.text.SpannableString;
import android.text.SpannableStringBuilder;
import android.text.Spanned;
import android.text.TextUtils;
import android.text.TextWatcher;
import android.util.AttributeSet;
import android.view.ContextMenu;
import android.view.MotionEvent;
import android.widget.MultiAutoCompleteTextView;
import com.android.mms.MmsConfig;
import com.android.mms.data.Contact;
import com.android.mms.data.ContactList;
import com.android.mms.ui.MessageUtils;
import java.util.ArrayList;
import java.util.List;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class RecipientsEditor
extends MultiAutoCompleteTextView {
    private int mLongPressedPosition = -1;
    private final RecipientsEditorTokenizer mTokenizer;
    private char mLastSeparator = (char)44;

    public RecipientsEditor(Context context, AttributeSet attrs) {
        super(context, attrs, 16842859);
        this.mTokenizer = new RecipientsEditorTokenizer(context, this);
        this.setTokenizer(this.mTokenizer);
        this.setImeOptions(5);
        this.addTextChangedListener(new TextWatcher(){
            private Annotation[] mAffected;

            public void beforeTextChanged(CharSequence s, int start, int count, int after) {
                this.mAffected = (Annotation[])((Spanned)s).getSpans(start, start + count, Annotation.class);
            }

            public void onTextChanged(CharSequence s, int start, int before, int after) {
                char c;
                if (before == 0 && after == 1 && ((c = s.charAt(start)) == ',' || c == ';')) {
                    RecipientsEditor.this.mLastSeparator = c;
                }
            }

            public void afterTextChanged(Editable s) {
                if (this.mAffected != null) {
                    for (Annotation a : this.mAffected) {
                        s.removeSpan((Object)a);
                    }
                }
                this.mAffected = null;
            }
        });
    }

    public boolean enoughToFilter() {
        int len;
        if (!super.enoughToFilter()) {
            return false;
        }
        int end = this.getSelectionEnd();
        return end == (len = this.getText().length());
    }

    public int getRecipientCount() {
        return this.mTokenizer.getNumbers().size();
    }

    public List<String> getNumbers() {
        return this.mTokenizer.getNumbers();
    }

    public ContactList constructContactsFromInput() {
        List<String> numbers = this.mTokenizer.getNumbers();
        ContactList list = new ContactList();
        for (String number : numbers) {
            Contact contact = Contact.get(number, false);
            contact.setNumber(number);
            list.add(contact);
        }
        return list;
    }

    private boolean isValidAddress(String number, boolean isMms) {
        if (isMms) {
            return MessageUtils.isValidMmsAddress(number);
        }
        return PhoneNumberUtils.isWellFormedSmsAddress((String)number) || Telephony.Mms.isEmailAddress((String)number);
    }

    public boolean hasValidRecipient(boolean isMms) {
        for (String number : this.mTokenizer.getNumbers()) {
            if (!this.isValidAddress(number, isMms)) continue;
            return true;
        }
        return false;
    }

    public boolean hasInvalidRecipient(boolean isMms) {
        for (String number : this.mTokenizer.getNumbers()) {
            if (this.isValidAddress(number, isMms)) continue;
            if (MmsConfig.getEmailGateway() == null) {
                return true;
            }
            if (MessageUtils.isAlias(number)) continue;
            return true;
        }
        return false;
    }

    public String formatInvalidNumbers(boolean isMms) {
        StringBuilder sb = new StringBuilder();
        for (String number : this.mTokenizer.getNumbers()) {
            if (this.isValidAddress(number, isMms)) continue;
            if (sb.length() != 0) {
                sb.append(", ");
            }
            sb.append(number);
        }
        return sb.toString();
    }

    public boolean containsEmail() {
        if (TextUtils.indexOf((CharSequence)this.getText(), (char)'@') == -1) {
            return false;
        }
        List<String> numbers = this.mTokenizer.getNumbers();
        for (String number : numbers) {
            if (!Telephony.Mms.isEmailAddress((String)number)) continue;
            return true;
        }
        return false;
    }

    public static CharSequence contactToToken(Contact c) {
        SpannableString s = new SpannableString((CharSequence)c.getNameAndNumber());
        int len = s.length();
        if (len == 0) {
            return s;
        }
        s.setSpan((Object)new Annotation("number", c.getNumber()), 0, len, 33);
        return s;
    }

    public void populate(ContactList list) {
        SpannableStringBuilder sb = new SpannableStringBuilder();
        for (Contact c : list) {
            if (sb.length() != 0) {
                sb.append((CharSequence)", ");
            }
            sb.append(RecipientsEditor.contactToToken(c));
        }
        this.setText((CharSequence)sb);
    }

    private int pointToPosition(int x, int y) {
        x -= this.getCompoundPaddingLeft();
        y -= this.getExtendedPaddingTop();
        x += this.getScrollX();
        y += this.getScrollY();
        Layout layout2 = this.getLayout();
        if (layout2 == null) {
            return -1;
        }
        int line = layout2.getLineForVertical(y);
        int off = layout2.getOffsetForHorizontal(line, (float)x);
        return off;
    }

    public boolean onTouchEvent(MotionEvent ev) {
        int action = ev.getAction();
        int x = (int)ev.getX();
        int y = (int)ev.getY();
        if (action == 0) {
            this.mLongPressedPosition = this.pointToPosition(x, y);
        }
        return super.onTouchEvent(ev);
    }

    protected ContextMenu.ContextMenuInfo getContextMenuInfo() {
        int start;
        int end;
        Editable text;
        if (this.mLongPressedPosition >= 0 && this.mLongPressedPosition <= (text = this.getText()).length() && (end = this.mTokenizer.findTokenEnd((CharSequence)text, start = this.mTokenizer.findTokenStart((CharSequence)text, this.mLongPressedPosition))) != start) {
            String number = RecipientsEditor.getNumberAt((Spanned)this.getText(), start, end, this.getContext());
            Contact c = Contact.get(number, false);
            return new RecipientContextMenuInfo(c);
        }
        return null;
    }

    private static String getNumberAt(Spanned sp, int start, int end, Context context) {
        return RecipientsEditor.getFieldAt("number", sp, start, end, context);
    }

    private static int getSpanLength(Spanned sp, int start, int end, Context context) {
        Annotation[] a = (Annotation[])sp.getSpans(start, end, Annotation.class);
        if (a.length > 0) {
            return sp.getSpanEnd((Object)a[0]);
        }
        return 0;
    }

    private static String getFieldAt(String field, Spanned sp, int start, int end, Context context) {
        Annotation[] a = (Annotation[])sp.getSpans(start, end, Annotation.class);
        String fieldValue = RecipientsEditor.getAnnotation(a, field);
        if (TextUtils.isEmpty((CharSequence)fieldValue)) {
            fieldValue = TextUtils.substring((CharSequence)sp, (int)start, (int)end);
        }
        return fieldValue;
    }

    private static String getAnnotation(Annotation[] a, String key) {
        for (int i = 0; i < a.length; ++i) {
            if (!a[i].getKey().equals(key)) continue;
            return a[i].getValue();
        }
        return "";
    }

    static class RecipientContextMenuInfo
    implements ContextMenu.ContextMenuInfo {
        final Contact recipient;

        RecipientContextMenuInfo(Contact r) {
            this.recipient = r;
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private class RecipientsEditorTokenizer
    implements MultiAutoCompleteTextView.Tokenizer {
        private final MultiAutoCompleteTextView mList;
        private final Context mContext;

        RecipientsEditorTokenizer(Context context, MultiAutoCompleteTextView list) {
            this.mList = list;
            this.mContext = context;
        }

        public int findTokenStart(CharSequence text, int cursor) {
            char c;
            int i;
            for (i = cursor; i > 0 && (c = text.charAt(i - 1)) != ',' && c != ';'; --i) {
            }
            while (i < cursor && text.charAt(i) == ' ') {
                ++i;
            }
            return i;
        }

        public int findTokenEnd(CharSequence text, int cursor) {
            int len = text.length();
            for (int i = cursor; i < len; ++i) {
                char c = text.charAt(i);
                if (c != ',' && c != ';') continue;
                return i;
            }
            return len;
        }

        public CharSequence terminateToken(CharSequence text) {
            char c;
            int i;
            for (i = text.length(); i > 0 && text.charAt(i - 1) == ' '; --i) {
            }
            if (i > 0 && ((c = text.charAt(i - 1)) == ',' || c == ';')) {
                return text;
            }
            String separator = RecipientsEditor.this.mLastSeparator + " ";
            if (text instanceof Spanned) {
                SpannableString sp = new SpannableString((CharSequence)(text + separator));
                TextUtils.copySpansFrom((Spanned)((Spanned)text), (int)0, (int)text.length(), Object.class, (Spannable)sp, (int)0);
                return sp;
            }
            return text + separator;
        }

        public List<String> getNumbers() {
            Editable sp = this.mList.getText();
            int len = sp.length();
            ArrayList<String> list = new ArrayList<String>();
            int start = 0;
            int i = 0;
            while (i < len + 1) {
                char c;
                if (i == len || (c = sp.charAt(i)) == ',' || c == ';') {
                    if (i > start) {
                        list.add(RecipientsEditor.getNumberAt((Spanned)sp, start, i, this.mContext));
                        int spanLen = RecipientsEditor.getSpanLength((Spanned)sp, start, i, this.mContext);
                        if (spanLen > i) {
                            i = spanLen;
                        }
                    }
                    ++i;
                    while (i < len && sp.charAt(i) == ' ') {
                        ++i;
                    }
                    start = i;
                    continue;
                }
                ++i;
            }
            return list;
        }
    }
}

