/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.content.ContentResolver;
import android.content.Context;
import android.database.Cursor;
import android.database.MergeCursor;
import android.net.Uri;
import android.provider.ContactsContract;
import android.telephony.PhoneNumberUtils;
import android.text.Annotation;
import android.text.SpannableString;
import android.text.TextUtils;
import android.view.View;
import android.widget.ResourceCursorAdapter;
import android.widget.TextView;
import com.android.common.ArrayListCursor;
import com.android.mms.data.Contact;
import java.util.ArrayList;

public class RecipientsAdapter
extends ResourceCursorAdapter {
    public static final int CONTACT_ID_INDEX = 1;
    public static final int TYPE_INDEX = 2;
    public static final int NUMBER_INDEX = 3;
    public static final int LABEL_INDEX = 4;
    public static final int NAME_INDEX = 5;
    private static final String[] PROJECTION_PHONE = new String[]{"_id", "contact_id", "data2", "data1", "data3", "display_name"};
    private static final String SORT_ORDER = "times_contacted DESC,display_name,data2";
    private final Context mContext;
    private final ContentResolver mContentResolver;

    public RecipientsAdapter(Context context) {
        super(context, 2130903061, null, false);
        this.mContext = context;
        this.mContentResolver = context.getContentResolver();
    }

    public final CharSequence convertToString(Cursor cursor) {
        String number = cursor.getString(3);
        if (number == null) {
            return "";
        }
        number = number.trim();
        String name = cursor.getString(5);
        int type = cursor.getInt(2);
        String label = cursor.getString(4);
        CharSequence displayLabel = ContactsContract.CommonDataKinds.Phone.getDisplayLabel((Context)this.mContext, (int)type, (CharSequence)label);
        name = name == null ? "" : name.replace(", ", " ").replace(",", " ");
        String nameAndNumber = Contact.formatNameAndNumber(name, number);
        SpannableString out = new SpannableString((CharSequence)nameAndNumber);
        int len = out.length();
        if (!TextUtils.isEmpty((CharSequence)name)) {
            out.setSpan((Object)new Annotation("name", name), 0, len, 33);
        } else {
            out.setSpan((Object)new Annotation("name", number), 0, len, 33);
        }
        String person_id = cursor.getString(1);
        out.setSpan((Object)new Annotation("person_id", person_id), 0, len, 33);
        out.setSpan((Object)new Annotation("label", ((Object)displayLabel).toString()), 0, len, 33);
        out.setSpan((Object)new Annotation("number", number), 0, len, 33);
        return out;
    }

    public final void bindView(View view, Context context, Cursor cursor) {
        TextView name = (TextView)view.findViewById(2131361875);
        name.setText((CharSequence)cursor.getString(5));
        TextView label = (TextView)view.findViewById(2131361845);
        int type = cursor.getInt(2);
        CharSequence labelText = ContactsContract.CommonDataKinds.Phone.getDisplayLabel((Context)this.mContext, (int)type, (CharSequence)cursor.getString(4));
        if (labelText.length() == 0 || labelText.length() == 1 && labelText.charAt(0) == '\u00a0') {
            label.setVisibility(8);
        } else {
            label.setText(labelText);
            label.setVisibility(0);
        }
        TextView number = (TextView)view.findViewById(2131361877);
        number.setText((CharSequence)cursor.getString(3));
    }

    public Cursor runQueryOnBackgroundThread(CharSequence constraint) {
        String phone = "";
        String cons = null;
        if (constraint != null && this.usefulAsDigits(cons = ((Object)constraint).toString())) {
            phone = PhoneNumberUtils.convertKeypadLettersToDigits((String)cons);
            phone = phone.equals(cons) ? "" : phone.trim();
        }
        Uri uri = Uri.withAppendedPath((Uri)ContactsContract.CommonDataKinds.Phone.CONTENT_FILTER_URI, (String)Uri.encode((String)cons));
        Cursor phoneCursor = this.mContentResolver.query(uri, PROJECTION_PHONE, null, null, SORT_ORDER);
        if (phone.length() > 0) {
            ArrayList<Object> result = new ArrayList<Object>();
            result.add(-1);
            result.add(-1L);
            result.add(0);
            result.add(phone);
            result.add("\u00a0");
            result.add(cons);
            ArrayList<ArrayList> wrap = new ArrayList<ArrayList>();
            wrap.add(result);
            ArrayListCursor translated = new ArrayListCursor(PROJECTION_PHONE, wrap);
            return new MergeCursor(new Cursor[]{translated, phoneCursor});
        }
        return phoneCursor;
    }

    private boolean usefulAsDigits(CharSequence cons) {
        int len = cons.length();
        for (int i = 0; i < len; ++i) {
            char c = cons.charAt(i);
            if (c >= '0' && c <= '9' || c == ' ' || c == '-' || c == '(' || c == ')' || c == '.' || c == '+' || c == '#' || c == '*' || c >= 'A' && c <= 'Z' || c >= 'a' && c <= 'z') continue;
            return false;
        }
        return true;
    }
}

