/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.content.Context;
import android.util.Log;
import com.android.mms.model.Model;
import com.android.mms.ui.Presenter;
import com.android.mms.ui.ViewInterface;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;

public class PresenterFactory {
    private static final String TAG = "PresenterFactory";
    private static final String PRESENTER_PACKAGE = "com.android.mms.ui.";

    public static Presenter getPresenter(String className, Context context, ViewInterface view, Model model) {
        try {
            if (className.indexOf(".") == -1) {
                className = PRESENTER_PACKAGE + className;
            }
            Class<?> c = Class.forName(className);
            Constructor<?> constructor = c.getConstructor(Context.class, ViewInterface.class, Model.class);
            return (Presenter)constructor.newInstance(context, view, model);
        }
        catch (ClassNotFoundException e) {
            Log.e((String)TAG, (String)("Type not found: " + className), (Throwable)e);
        }
        catch (NoSuchMethodException e) {
            Log.e((String)TAG, (String)"No such constructor.", (Throwable)e);
        }
        catch (InvocationTargetException e) {
            Log.e((String)TAG, (String)"Unexpected InvocationTargetException", (Throwable)e);
        }
        catch (IllegalAccessException e) {
            Log.e((String)TAG, (String)"Unexpected IllegalAccessException", (Throwable)e);
        }
        catch (InstantiationException e) {
            Log.e((String)TAG, (String)"Unexpected InstantiationException", (Throwable)e);
        }
        return null;
    }
}

