/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.os.Bundle;
import android.util.AttributeSet;
import android.view.LayoutInflater;
import android.view.View;
import com.android.mms.ui.NumberPicker;

public class NumberPickerDialog
extends AlertDialog
implements DialogInterface.OnClickListener {
    private int mInitialNumber;
    private static final String NUMBER = "number";
    private final NonWrapNumberPicker mNumberPicker;
    private final OnNumberSetListener mCallback;

    public NumberPickerDialog(Context context, OnNumberSetListener callBack, int number, int rangeMin, int rangeMax, int title) {
        this(context, 16973987, callBack, number, rangeMin, rangeMax, title);
    }

    public NumberPickerDialog(Context context, int theme, OnNumberSetListener callBack, int number, int rangeMin, int rangeMax, int title) {
        super(context, theme);
        this.mCallback = callBack;
        this.mInitialNumber = number;
        this.setTitle(title);
        this.setButton(-1, context.getText(0x7F070077), this);
        this.setButton(-2, context.getText(2131165302), null);
        LayoutInflater inflater = (LayoutInflater)context.getSystemService("layout_inflater");
        View view = inflater.inflate(2130903059, null);
        this.setView(view);
        this.mNumberPicker = (NonWrapNumberPicker)view.findViewById(2131361872);
        this.mNumberPicker.setRange(rangeMin, rangeMax);
        this.mNumberPicker.setCurrent(number);
        this.mNumberPicker.setSpeed(150L);
    }

    public void onClick(DialogInterface dialog, int which) {
        if (this.mCallback != null) {
            this.mNumberPicker.clearFocus();
            this.mCallback.onNumberSet(this.mNumberPicker.getCurrent());
            dialog.dismiss();
        }
    }

    public Bundle onSaveInstanceState() {
        Bundle state = super.onSaveInstanceState();
        state.putInt(NUMBER, this.mNumberPicker.getCurrent());
        return state;
    }

    public void onRestoreInstanceState(Bundle savedInstanceState) {
        super.onRestoreInstanceState(savedInstanceState);
        int number = savedInstanceState.getInt(NUMBER);
        this.mNumberPicker.setCurrent(number);
    }

    public static class NonWrapNumberPicker
    extends NumberPicker {
        public NonWrapNumberPicker(Context context) {
            this(context, null);
        }

        public NonWrapNumberPicker(Context context, AttributeSet attrs) {
            this(context, attrs, 0);
        }

        public NonWrapNumberPicker(Context context, AttributeSet attrs, int defStyle) {
            super(context, attrs);
        }

        protected void changeCurrent(int current) {
            if (current > this.getEndRange()) {
                current = this.getEndRange();
            } else if (current < this.getBeginRange()) {
                current = this.getBeginRange();
            }
            super.changeCurrent(current);
        }
    }

    public static interface OnNumberSetListener {
        public void onNumberSet(int var1);
    }
}

