/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.app.Activity;
import android.app.AlertDialog;
import android.content.ContentResolver;
import android.content.ContentUris;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.res.Resources;
import android.database.Cursor;
import android.database.sqlite.SqliteWrapper;
import android.graphics.Bitmap;
import android.net.Uri;
import android.os.Debug;
import android.os.Environment;
import android.os.Handler;
import android.provider.Telephony;
import android.telephony.PhoneNumberUtils;
import android.text.TextUtils;
import android.text.format.DateUtils;
import android.text.format.Time;
import android.text.style.URLSpan;
import android.util.Log;
import android.widget.Toast;
import com.android.mms.MmsApp;
import com.android.mms.MmsConfig;
import com.android.mms.data.WorkingMessage;
import com.android.mms.model.RegionMediaModel;
import com.android.mms.model.SlideModel;
import com.android.mms.model.SlideshowModel;
import com.android.mms.transaction.MmsMessageSender;
import com.android.mms.ui.SlideshowActivity;
import com.android.mms.ui.UriImage;
import com.android.mms.util.AddressUtils;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu.EncodedStringValue;
import com.google.android.mms.pdu.MultimediaMessagePdu;
import com.google.android.mms.pdu.NotificationInd;
import com.google.android.mms.pdu.PduBody;
import com.google.android.mms.pdu.PduPart;
import com.google.android.mms.pdu.PduPersister;
import com.google.android.mms.pdu.RetrieveConf;
import com.google.android.mms.pdu.SendReq;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageUtils {
    private static final String TAG = "Mms";
    private static String sLocalNumber;
    private static final Map<String, String> sRecipientAddress;
    private static final char[] NUMERIC_CHARS_SUGAR;
    private static HashMap numericSugarMap;
    public static final int IMAGE_COMPRESSION_QUALITY = 80;
    public static final int MINIMUM_IMAGE_COMPRESSION_QUALITY = 50;
    public static final int MESSAGE_OVERHEAD = 5000;

    private MessageUtils() {
    }

    public static String getMessageDetails(Context context, Cursor cursor, int size) {
        if (cursor == null) {
            return null;
        }
        if ("mms".equals(cursor.getString(0))) {
            int type = cursor.getInt(15);
            switch (type) {
                case 130: {
                    return MessageUtils.getNotificationIndDetails(context, cursor);
                }
                case 128: 
                case 132: {
                    return MessageUtils.getMultimediaMessageDetails(context, cursor, size);
                }
            }
            Log.w((String)TAG, (String)"No details could be retrieved.");
            return "";
        }
        return MessageUtils.getTextMessageDetails(context, cursor);
    }

    private static String getNotificationIndDetails(Context context, Cursor cursor) {
        NotificationInd nInd;
        StringBuilder details = new StringBuilder();
        Resources res = context.getResources();
        long id2 = cursor.getLong(1);
        Uri uri = ContentUris.withAppendedId((Uri)Telephony.Mms.CONTENT_URI, (long)id2);
        try {
            nInd = (NotificationInd)PduPersister.getPduPersister((Context)context).load(uri);
        }
        catch (MmsException e) {
            Log.e((String)TAG, (String)("Failed to load the message: " + uri), (Throwable)e);
            return context.getResources().getString(2131165353);
        }
        details.append(res.getString(2131165355));
        details.append(res.getString(2131165358));
        String from = MessageUtils.extractEncStr(context, nInd.getFrom());
        details.append('\n');
        details.append(res.getString(2131165359));
        details.append(!TextUtils.isEmpty((CharSequence)from) ? from : res.getString(2131165300));
        details.append('\n');
        details.append(res.getString(2131165209, new Object[]{MessageUtils.formatTimeStampString(context, nInd.getExpiry() * 1000L, true)}));
        details.append('\n');
        details.append(res.getString(2131165365));
        EncodedStringValue subject = nInd.getSubject();
        if (subject != null) {
            details.append(subject.getString());
        }
        details.append('\n');
        details.append(res.getString(2131165371));
        details.append(new String(nInd.getMessageClass()));
        details.append('\n');
        details.append(res.getString(2131165366));
        details.append(String.valueOf((nInd.getMessageSize() + 1023L) / 1024L));
        details.append(context.getString(2131165210));
        return details.toString();
    }

    private static String getMultimediaMessageDetails(Context context, Cursor cursor, int size) {
        EncodedStringValue[] values;
        MultimediaMessagePdu msg;
        int type = cursor.getInt(15);
        if (type == 130) {
            return MessageUtils.getNotificationIndDetails(context, cursor);
        }
        StringBuilder details = new StringBuilder();
        Resources res = context.getResources();
        long id2 = cursor.getLong(1);
        Uri uri = ContentUris.withAppendedId((Uri)Telephony.Mms.CONTENT_URI, (long)id2);
        try {
            msg = (MultimediaMessagePdu)PduPersister.getPduPersister((Context)context).load(uri);
        }
        catch (MmsException e) {
            Log.e((String)TAG, (String)("Failed to load the message: " + uri), (Throwable)e);
            return context.getResources().getString(2131165353);
        }
        details.append(res.getString(2131165355));
        details.append(res.getString(2131165357));
        if (msg instanceof RetrieveConf) {
            String from = MessageUtils.extractEncStr(context, ((RetrieveConf)msg).getFrom());
            details.append('\n');
            details.append(res.getString(2131165359));
            details.append(!TextUtils.isEmpty((CharSequence)from) ? from : res.getString(2131165300));
        }
        details.append('\n');
        details.append(res.getString(2131165360));
        EncodedStringValue[] to = msg.getTo();
        if (to != null) {
            details.append(EncodedStringValue.concat((EncodedStringValue[])to));
        } else {
            Log.w((String)TAG, (String)"recipient list is empty!");
        }
        if (msg instanceof SendReq && (values = ((SendReq)msg).getBcc()) != null && values.length > 0) {
            details.append('\n');
            details.append(res.getString(2131165361));
            details.append(EncodedStringValue.concat((EncodedStringValue[])values));
        }
        details.append('\n');
        int msgBox = cursor.getInt(16);
        if (msgBox == 3) {
            details.append(res.getString(2131165364));
        } else if (msgBox == 1) {
            details.append(res.getString(2131165363));
        } else {
            details.append(res.getString(2131165362));
        }
        details.append(MessageUtils.formatTimeStampString(context, msg.getDate() * 1000L, true));
        details.append('\n');
        details.append(res.getString(2131165365));
        EncodedStringValue subject = msg.getSubject();
        if (subject != null) {
            String subStr = subject.getString();
            size += subStr.length();
            details.append(subStr);
        }
        details.append('\n');
        details.append(res.getString(2131165367));
        details.append(MessageUtils.getPriorityDescription(context, msg.getPriority()));
        details.append('\n');
        details.append(res.getString(2131165366));
        details.append((size - 1) / 1000 + 1);
        details.append(" KB");
        return details.toString();
    }

    private static String getTextMessageDetails(Context context, Cursor cursor) {
        StringBuilder details = new StringBuilder();
        Resources res = context.getResources();
        details.append(res.getString(2131165355));
        details.append(res.getString(2131165356));
        details.append('\n');
        int smsType = cursor.getInt(7);
        if (Telephony.Sms.isOutgoingFolder((int)smsType)) {
            details.append(res.getString(2131165360));
        } else {
            details.append(res.getString(2131165359));
        }
        details.append(cursor.getString(3));
        details.append('\n');
        if (smsType == 3) {
            details.append(res.getString(2131165364));
        } else if (smsType == 1) {
            details.append(res.getString(2131165363));
        } else {
            details.append(res.getString(2131165362));
        }
        long date = cursor.getLong(5);
        details.append(MessageUtils.formatTimeStampString(context, date, true));
        int errorCode = cursor.getInt(10);
        if (errorCode != 0) {
            details.append('\n').append(res.getString(2131165372)).append(errorCode);
        }
        return details.toString();
    }

    private static String getPriorityDescription(Context context, int PriorityValue) {
        Resources res = context.getResources();
        switch (PriorityValue) {
            case 130: {
                return res.getString(2131165368);
            }
            case 128: {
                return res.getString(2131165370);
            }
        }
        return res.getString(2131165369);
    }

    public static int getAttachmentType(SlideshowModel model) {
        if (model == null) {
            return 0;
        }
        int numberOfSlides = model.size();
        if (numberOfSlides > 1) {
            return 4;
        }
        if (numberOfSlides == 1) {
            SlideModel slide = model.get(0);
            if (slide.hasVideo()) {
                return 2;
            }
            if (slide.hasAudio() && slide.hasImage()) {
                return 4;
            }
            if (slide.hasAudio()) {
                return 3;
            }
            if (slide.hasImage()) {
                return 1;
            }
            if (slide.hasText()) {
                return 0;
            }
        }
        return 0;
    }

    public static String formatTimeStampString(Context context, long when) {
        return MessageUtils.formatTimeStampString(context, when, false);
    }

    public static String formatTimeStampString(Context context, long when, boolean fullFormat) {
        Time then = new Time();
        then.set(when);
        Time now = new Time();
        now.setToNow();
        int format_flags = 527104;
        format_flags = then.year != now.year ? (format_flags |= 0x14) : (then.yearDay != now.yearDay ? (format_flags |= 0x10) : (format_flags |= 1));
        if (fullFormat) {
            format_flags |= 0x11;
        }
        return DateUtils.formatDateTime((Context)context, (long)when, (int)format_flags);
    }

    public static String getRecipientsByIds(Context context, String recipientIds, boolean allowQuery) {
        String value = sRecipientAddress.get(recipientIds);
        if (value != null) {
            return value;
        }
        if (!TextUtils.isEmpty((CharSequence)recipientIds)) {
            StringBuilder addressBuf = MessageUtils.extractIdsToAddresses(context, recipientIds, allowQuery);
            if (addressBuf == null) {
                return "";
            }
            value = addressBuf.toString();
        } else {
            value = "";
        }
        sRecipientAddress.put(recipientIds, value);
        return value;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static StringBuilder extractIdsToAddresses(Context context, String recipients, boolean allowQuery) {
        StringBuilder addressBuf = new StringBuilder();
        String[] recipientIds = recipients.split(" ");
        boolean firstItem = true;
        for (String recipientId : recipientIds) {
            String value = sRecipientAddress.get(recipientId);
            if (value == null) {
                if (!allowQuery) {
                    return null;
                }
                Uri uri = Uri.parse((String)("content://mms-sms/canonical-address/" + recipientId));
                Cursor c = SqliteWrapper.query((Context)context, (ContentResolver)context.getContentResolver(), (Uri)uri, null, null, null, null);
                if (c != null) {
                    try {
                        if (c.moveToFirst()) {
                            value = c.getString(0);
                            sRecipientAddress.put(recipientId, value);
                        }
                    }
                    finally {
                        c.close();
                    }
                }
            }
            if (value == null) continue;
            if (firstItem) {
                firstItem = false;
            } else {
                addressBuf.append(";");
            }
            addressBuf.append(value);
        }
        return addressBuf.length() == 0 ? null : addressBuf;
    }

    public static void selectAudio(Context context, int requestCode) {
        if (context instanceof Activity) {
            Intent intent = new Intent("android.intent.action.RINGTONE_PICKER");
            intent.putExtra("android.intent.extra.ringtone.SHOW_DEFAULT", false);
            intent.putExtra("android.intent.extra.ringtone.SHOW_SILENT", false);
            intent.putExtra("android.intent.extra.ringtone.INCLUDE_DRM", false);
            intent.putExtra("android.intent.extra.ringtone.TITLE", context.getString(2131165432));
            ((Activity)context).startActivityForResult(intent, requestCode);
        }
    }

    public static void recordSound(Context context, int requestCode) {
        if (context instanceof Activity) {
            Intent intent = new Intent("android.intent.action.GET_CONTENT");
            intent.setType("audio/amr");
            intent.setClassName("com.android.soundrecorder", "com.android.soundrecorder.SoundRecorder");
            ((Activity)context).startActivityForResult(intent, requestCode);
        }
    }

    public static void selectVideo(Context context, int requestCode) {
        MessageUtils.selectMediaByType(context, requestCode, "video/*");
    }

    public static void selectImage(Context context, int requestCode) {
        MessageUtils.selectMediaByType(context, requestCode, "image/*");
    }

    private static void selectMediaByType(Context context, int requestCode, String contentType) {
        if (context instanceof Activity) {
            Intent innerIntent = new Intent("android.intent.action.GET_CONTENT");
            innerIntent.setType(contentType);
            Intent wrapperIntent = Intent.createChooser((Intent)innerIntent, null);
            ((Activity)context).startActivityForResult(wrapperIntent, requestCode);
        }
    }

    public static void viewSimpleSlideshow(Context context, SlideshowModel slideshow) {
        if (!slideshow.isSimple()) {
            throw new IllegalArgumentException("viewSimpleSlideshow() called on a non-simple slideshow");
        }
        SlideModel slide = slideshow.get(0);
        RegionMediaModel mm = null;
        if (slide.hasImage()) {
            mm = slide.getImage();
        } else if (slide.hasVideo()) {
            mm = slide.getVideo();
        }
        Intent intent = new Intent("android.intent.action.VIEW");
        intent.addFlags(1);
        String contentType = mm.isDrmProtected() ? mm.getDrmObject().getContentType() : mm.getContentType();
        intent.setDataAndType(mm.getUri(), contentType);
        context.startActivity(intent);
    }

    public static void showErrorDialog(Context context, String title, String message) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setIcon(2130837579);
        builder.setTitle((CharSequence)title);
        builder.setMessage((CharSequence)message);
        builder.setPositiveButton(17039370, new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (which == -1) {
                    dialog.dismiss();
                }
            }
        });
        builder.show();
    }

    public static Uri saveBitmapAsPart(Context context, Uri messageUri, Bitmap bitmap) throws MmsException {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        bitmap.compress(Bitmap.CompressFormat.JPEG, 80, (OutputStream)os);
        PduPart part = new PduPart();
        part.setContentType("image/jpeg".getBytes());
        String contentId = "Image" + System.currentTimeMillis();
        part.setContentLocation((contentId + ".jpg").getBytes());
        part.setContentId(contentId.getBytes());
        part.setData(os.toByteArray());
        Uri retVal = PduPersister.getPduPersister((Context)context).persistPart(part, ContentUris.parseId((Uri)messageUri));
        if (Log.isLoggable((String)"Mms:app", (int)2)) {
            MessageUtils.log("saveBitmapAsPart: persisted part with uri=" + retVal);
        }
        return retVal;
    }

    public static void resizeImageAsync(final Context context, final Uri imageUri, final Handler handler, final ResizeImageResultCallback cb, final boolean append) {
        final Runnable showProgress = new Runnable(){

            public void run() {
                Toast.makeText((Context)context, (int)2131165255, (int)0).show();
            }
        };
        handler.postDelayed(showProgress, 1000L);
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            public void run() {
                PduPart part;
                try {
                    UriImage image = new UriImage(context, imageUri);
                    part = image.getResizedImageAsPart(MmsConfig.getMaxImageWidth(), MmsConfig.getMaxImageHeight(), MmsConfig.getMaxMessageSize() - 5000);
                }
                finally {
                    handler.removeCallbacks(showProgress);
                }
                handler.post(new Runnable(){

                    public void run() {
                        cb.onResizeResult(part, append);
                    }
                });
            }
        }).start();
    }

    public static void showDiscardDraftConfirmDialog(Context context, DialogInterface.OnClickListener listener) {
        new AlertDialog.Builder(context).setIcon(17301543).setTitle(2131165264).setMessage(2131165265).setPositiveButton(2131165301, listener).setNegativeButton(2131165302, null).show();
    }

    public static String getLocalNumber() {
        if (null == sLocalNumber) {
            sLocalNumber = MmsApp.getApplication().getTelephonyManager().getLine1Number();
        }
        return sLocalNumber;
    }

    public static boolean isLocalNumber(String number) {
        if (number == null) {
            return false;
        }
        if (number.indexOf(64) >= 0) {
            return false;
        }
        return PhoneNumberUtils.compare((String)number, (String)MessageUtils.getLocalNumber());
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void handleReadReport(final Context context, long threadId, final int status, final Runnable callback) {
        Cursor c;
        String selection = "m_type = 132 AND read = 0 AND rr = 128";
        if (threadId != -1L) {
            selection = selection + " AND " + "thread_id" + " = " + threadId;
        }
        if ((c = SqliteWrapper.query((Context)context, (ContentResolver)context.getContentResolver(), (Uri)Telephony.Mms.Inbox.CONTENT_URI, (String[])new String[]{"_id", "m_id"}, (String)selection, null, null)) == null) {
            return;
        }
        final HashMap<String, String> map = new HashMap<String, String>();
        try {
            if (c.getCount() == 0) {
                if (callback != null) {
                    callback.run();
                }
                return;
            }
            while (c.moveToNext()) {
                Uri uri = ContentUris.withAppendedId((Uri)Telephony.Mms.CONTENT_URI, (long)c.getLong(0));
                map.put(c.getString(1), AddressUtils.getFrom(context, uri));
            }
        }
        finally {
            c.close();
        }
        DialogInterface.OnClickListener positiveListener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                for (Map.Entry entry : map.entrySet()) {
                    MmsMessageSender.sendReadRec(context, (String)entry.getValue(), (String)entry.getKey(), status);
                }
                if (callback != null) {
                    callback.run();
                }
                dialog.dismiss();
            }
        };
        DialogInterface.OnClickListener negativeListener = new DialogInterface.OnClickListener(){

            public void onClick(DialogInterface dialog, int which) {
                if (callback != null) {
                    callback.run();
                }
                dialog.dismiss();
            }
        };
        DialogInterface.OnCancelListener cancelListener = new DialogInterface.OnCancelListener(){

            public void onCancel(DialogInterface dialog) {
                if (callback != null) {
                    callback.run();
                }
                dialog.dismiss();
            }
        };
        MessageUtils.confirmReadReportDialog(context, positiveListener, negativeListener, cancelListener);
    }

    private static void confirmReadReportDialog(Context context, DialogInterface.OnClickListener positiveListener, DialogInterface.OnClickListener negativeListener, DialogInterface.OnCancelListener cancelListener) {
        AlertDialog.Builder builder = new AlertDialog.Builder(context);
        builder.setCancelable(true);
        builder.setTitle(2131165418);
        builder.setMessage(2131165419);
        builder.setPositiveButton(2131165301, positiveListener);
        builder.setNegativeButton(2131165302, negativeListener);
        builder.setOnCancelListener(cancelListener);
        builder.show();
    }

    public static String extractEncStrFromCursor(Cursor cursor, int columnRawBytes, int columnCharset) {
        String rawBytes = cursor.getString(columnRawBytes);
        int charset = cursor.getInt(columnCharset);
        if (TextUtils.isEmpty((CharSequence)rawBytes)) {
            return "";
        }
        if (charset == 0) {
            return rawBytes;
        }
        return new EncodedStringValue(charset, PduPersister.getBytes((String)rawBytes)).getString();
    }

    private static String extractEncStr(Context context, EncodedStringValue value) {
        if (value != null) {
            return value.getString();
        }
        return "";
    }

    public static ArrayList<String> extractUris(URLSpan[] spans) {
        int size = spans.length;
        ArrayList<String> accumulator = new ArrayList<String>();
        for (int i = 0; i < size; ++i) {
            accumulator.add(spans[i].getURL());
        }
        return accumulator;
    }

    public static void viewMmsMessageAttachment(Context context, Uri msgUri, SlideshowModel slideshow) {
        boolean isSimple;
        boolean bl = isSimple = slideshow == null ? false : slideshow.isSimple();
        if (isSimple) {
            MessageUtils.viewSimpleSlideshow(context, slideshow);
        } else {
            if (slideshow != null) {
                PduPersister persister = PduPersister.getPduPersister((Context)context);
                try {
                    PduBody pb = slideshow.toPduBody();
                    persister.updateParts(msgUri, pb);
                    slideshow.sync(pb);
                }
                catch (MmsException e) {
                    Log.e((String)TAG, (String)"Unable to save message for preview");
                    return;
                }
            }
            Intent intent = new Intent(context, SlideshowActivity.class);
            intent.setData(msgUri);
            context.startActivity(intent);
        }
    }

    public static void viewMmsMessageAttachment(Context context, WorkingMessage msg) {
        SlideshowModel slideshow = msg.getSlideshow();
        if (slideshow == null) {
            throw new IllegalStateException("msg.getSlideshow() == null");
        }
        if (slideshow.isSimple()) {
            MessageUtils.viewSimpleSlideshow(context, slideshow);
        } else {
            Uri uri = msg.saveAsMms(false);
            MessageUtils.viewMmsMessageAttachment(context, uri, slideshow);
        }
    }

    public static void writeHprofDataToFile() {
        String filename = Environment.getExternalStorageDirectory() + "/mms_oom_hprof_data";
        try {
            Debug.dumpHprofData((String)filename);
            Log.i((String)TAG, (String)("##### written hprof data to " + filename));
        }
        catch (IOException ex) {
            Log.e((String)TAG, (String)("writeHprofDataToFile: caught " + ex));
        }
    }

    public static boolean isAlias(String string2) {
        if (!MmsConfig.isAliasEnabled()) {
            return false;
        }
        if (TextUtils.isEmpty((CharSequence)string2)) {
            return false;
        }
        if (Telephony.Mms.isPhoneNumber((String)string2)) {
            return false;
        }
        if (!MessageUtils.isAlphaNumeric(string2)) {
            return false;
        }
        int len = string2.length();
        return len >= MmsConfig.getAliasMinChars() && len <= MmsConfig.getAliasMaxChars();
    }

    public static boolean isAlphaNumeric(String s) {
        char[] chars = s.toCharArray();
        for (int x = 0; x < chars.length; ++x) {
            char c = chars[x];
            if (c >= 'a' && c <= 'z' || c >= 'A' && c <= 'Z' || c >= '0' && c <= '9') continue;
            return false;
        }
        return true;
    }

    private static String parsePhoneNumberForMms(String address) {
        StringBuilder builder = new StringBuilder();
        int len = address.length();
        for (int i = 0; i < len; ++i) {
            char c = address.charAt(i);
            if (c == '+' && builder.length() == 0) {
                builder.append(c);
                continue;
            }
            if (Character.isDigit(c)) {
                builder.append(c);
                continue;
            }
            if (numericSugarMap.get(Character.valueOf(c)) != null) continue;
            return null;
        }
        return builder.toString();
    }

    public static boolean isValidMmsAddress(String address) {
        String retVal = MessageUtils.parseMmsAddress(address);
        return retVal != null;
    }

    public static String parseMmsAddress(String address) {
        if (Telephony.Mms.isEmailAddress((String)address)) {
            return address;
        }
        String retVal = MessageUtils.parsePhoneNumberForMms(address);
        if (retVal != null) {
            return retVal;
        }
        if (MessageUtils.isAlias(address)) {
            return address;
        }
        return null;
    }

    private static void log(String msg) {
        Log.d((String)TAG, (String)("[MsgUtils] " + msg));
    }

    static {
        sRecipientAddress = new ConcurrentHashMap<String, String>(20);
        NUMERIC_CHARS_SUGAR = new char[]{'-', '.', ',', '(', ')', ' ', '/', '\\', '*', '#', '+'};
        numericSugarMap = new HashMap(NUMERIC_CHARS_SUGAR.length);
        for (int i = 0; i < NUMERIC_CHARS_SUGAR.length; ++i) {
            numericSugarMap.put(Character.valueOf(NUMERIC_CHARS_SUGAR[i]), Character.valueOf(NUMERIC_CHARS_SUGAR[i]));
        }
    }

    static interface ResizeImageResultCallback {
        public void onResizeResult(PduPart var1, boolean var2);
    }
}

