/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.app.AlertDialog;
import android.content.Context;
import android.content.DialogInterface;
import android.content.Intent;
import android.content.pm.PackageManager;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.Canvas;
import android.graphics.Paint;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.os.Message;
import android.provider.Telephony;
import android.telephony.PhoneNumberUtils;
import android.text.Html;
import android.text.Layout;
import android.text.SpannableStringBuilder;
import android.text.TextUtils;
import android.text.method.HideReturnsTransformationMethod;
import android.text.method.TransformationMethod;
import android.text.style.ForegroundColorSpan;
import android.text.style.LeadingMarginSpan;
import android.text.style.LineHeightSpan;
import android.text.style.StyleSpan;
import android.text.style.TextAppearanceSpan;
import android.text.style.URLSpan;
import android.util.AttributeSet;
import android.util.Log;
import android.view.View;
import android.view.ViewGroup;
import android.widget.ArrayAdapter;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.ImageView;
import android.widget.LinearLayout;
import android.widget.ListAdapter;
import android.widget.QuickContactBadge;
import android.widget.TextView;
import com.android.mms.MmsApp;
import com.android.mms.transaction.TransactionService;
import com.android.mms.ui.MessageItem;
import com.android.mms.ui.MessageListAdapter;
import com.android.mms.ui.MessageUtils;
import com.android.mms.ui.Presenter;
import com.android.mms.ui.PresenterFactory;
import com.android.mms.ui.SlideViewInterface;
import com.android.mms.ui.VideoAttachmentView;
import com.android.mms.util.DownloadManager;
import com.android.mms.util.SmileyParser;
import java.util.ArrayList;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MessageListItem
extends LinearLayout
implements SlideViewInterface,
View.OnClickListener {
    public static final String EXTRA_URLS = "com.android.mms.ExtraUrls";
    private static final String TAG = "MessageListItem";
    private static final StyleSpan STYLE_BOLD = new StyleSpan(1);
    static final int MSG_LIST_EDIT_MMS = 1;
    static final int MSG_LIST_EDIT_SMS = 2;
    private View mMsgListItem;
    private View mMmsView;
    private ImageView mImageView;
    private ImageView mLockedIndicator;
    private ImageView mDeliveredIndicator;
    private ImageView mDetailsIndicator;
    private ImageButton mSlideShowButton;
    private TextView mBodyTextView;
    private Button mDownloadButton;
    private TextView mDownloadingLabel;
    private QuickContactBadge mAvatar;
    private Handler mHandler;
    private MessageItem mMessageItem;
    private LeadingMarginSpan mLeadingMarginSpan;
    private LineHeightSpan mSpan = new LineHeightSpan(){

        public void chooseHeight(CharSequence text, int start, int end, int spanstartv, int v, Paint.FontMetricsInt fm) {
            fm.ascent -= 10;
        }
    };
    TextAppearanceSpan mTextSmallSpan = new TextAppearanceSpan(this.mContext, 16973894);
    ForegroundColorSpan mColorSpan = null;

    public MessageListItem(Context context) {
        super(context);
    }

    public MessageListItem(Context context, AttributeSet attrs) {
        super(context, attrs);
        int color2 = this.mContext.getResources().getColor(2131099648);
        this.mColorSpan = new ForegroundColorSpan(color2);
    }

    protected void onFinishInflate() {
        super.onFinishInflate();
        this.mMsgListItem = this.findViewById(2131361854);
        this.mBodyTextView = (TextView)this.findViewById(2131361857);
        this.mLockedIndicator = (ImageView)this.findViewById(2131361859);
        this.mDeliveredIndicator = (ImageView)this.findViewById(2131361860);
        this.mDetailsIndicator = (ImageView)this.findViewById(2131361861);
        this.mAvatar = (QuickContactBadge)this.findViewById(2131361822);
        ViewGroup.MarginLayoutParams badgeParams = (ViewGroup.MarginLayoutParams)this.mAvatar.getLayoutParams();
        final int badgeWidth = badgeParams.width + badgeParams.rightMargin + badgeParams.leftMargin;
        int lineHeight = this.mBodyTextView.getLineHeight();
        int effectiveBadgeHeight = badgeParams.height + badgeParams.topMargin - this.mBodyTextView.getPaddingTop();
        final int indentLineCount = (effectiveBadgeHeight - 1) / lineHeight + 1;
        this.mLeadingMarginSpan = new LeadingMarginSpan.LeadingMarginSpan2(){

            public void drawLeadingMargin(Canvas c, Paint p, int x, int dir, int top, int baseline, int bottom, CharSequence text, int start, int end, boolean first, Layout layout2) {
            }

            public int getLeadingMargin(boolean first) {
                return first ? badgeWidth : 0;
            }

            public int getLeadingMarginLineCount() {
                return indentLineCount;
            }
        };
    }

    public void bind(MessageListAdapter.AvatarCache avatarCache, MessageItem msgItem) {
        this.mMessageItem = msgItem;
        this.setLongClickable(false);
        switch (msgItem.mMessageType) {
            case 130: {
                this.bindNotifInd(msgItem);
                break;
            }
            default: {
                this.bindCommonMessage(avatarCache, msgItem);
            }
        }
    }

    public MessageItem getMessageItem() {
        return this.mMessageItem;
    }

    public void setMsgListItemHandler(Handler handler) {
        this.mHandler = handler;
    }

    private void bindNotifInd(final MessageItem msgItem) {
        this.hideMmsViewIfNeeded();
        String msgSizeText = this.mContext.getString(2131165366) + String.valueOf((msgItem.mMessageSize + 1023) / 1024) + this.mContext.getString(2131165210);
        this.mBodyTextView.setText(this.formatMessage(msgItem, msgItem.mContact, null, msgItem.mSubject, msgSizeText + "\n" + msgItem.mTimestamp, msgItem.mHighlight, msgItem.mTextContentType));
        int state = DownloadManager.getInstance().getState(msgItem.mMessageUri);
        switch (state) {
            case 129: {
                this.inflateDownloadControls();
                this.mDownloadingLabel.setVisibility(0);
                this.mDownloadButton.setVisibility(8);
                break;
            }
            default: {
                this.setLongClickable(true);
                this.inflateDownloadControls();
                this.mDownloadingLabel.setVisibility(8);
                this.mDownloadButton.setVisibility(0);
                this.mDownloadButton.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        MessageListItem.this.mDownloadingLabel.setVisibility(0);
                        MessageListItem.this.mDownloadButton.setVisibility(8);
                        Intent intent = new Intent(MessageListItem.this.mContext, TransactionService.class);
                        intent.putExtra("uri", msgItem.mMessageUri.toString());
                        intent.putExtra("type", 1);
                        MessageListItem.this.mContext.startService(intent);
                    }
                });
            }
        }
        this.mLockedIndicator.setVisibility(8);
        this.mDeliveredIndicator.setVisibility(8);
        this.mDetailsIndicator.setVisibility(8);
        this.drawLeftStatusIndicator(msgItem.mBoxId);
    }

    private void bindCommonMessage(MessageListAdapter.AvatarCache avatarCache, MessageItem msgItem) {
        if (this.mDownloadButton != null) {
            this.mDownloadButton.setVisibility(8);
            this.mDownloadingLabel.setVisibility(8);
        }
        this.mBodyTextView.setTransformationMethod((TransformationMethod)HideReturnsTransformationMethod.getInstance());
        String addr = null;
        addr = !Telephony.Sms.isOutgoingFolder((int)msgItem.mBoxId) ? msgItem.mAddress : MmsApp.getApplication().getTelephonyManager().getLine1Number();
        if (!TextUtils.isEmpty((CharSequence)addr)) {
            MessageListAdapter.AvatarCache.ContactData contactData = avatarCache.get(addr);
            this.mAvatar.setImageDrawable(contactData.getAvatar());
            Uri contactUri = contactData.getContactUri();
            if (contactUri != null) {
                this.mAvatar.assignContactUri(contactUri);
            } else {
                this.mAvatar.assignContactFromPhone(addr, true);
            }
        } else {
            this.mAvatar.setImageDrawable(null);
            this.mAvatar.assignContactUri(null);
        }
        CharSequence formattedMessage = msgItem.getCachedFormattedMessage();
        if (formattedMessage == null) {
            formattedMessage = this.formatMessage(msgItem, msgItem.mContact, msgItem.mBody, msgItem.mSubject, msgItem.mTimestamp, msgItem.mHighlight, msgItem.mTextContentType);
        }
        this.mBodyTextView.setText(formattedMessage);
        if (msgItem.isSms()) {
            this.hideMmsViewIfNeeded();
        } else {
            Presenter presenter = PresenterFactory.getPresenter("MmsThumbnailPresenter", this.mContext, this, msgItem.mSlideshow);
            presenter.present();
            if (msgItem.mAttachmentType != 0) {
                this.inflateMmsView();
                this.mMmsView.setVisibility(0);
                this.setOnClickListener(msgItem);
                this.drawPlaybackButton(msgItem);
            } else {
                this.hideMmsViewIfNeeded();
            }
        }
        this.drawLeftStatusIndicator(msgItem.mBoxId);
        this.drawRightStatusIndicator(msgItem);
        this.requestLayout();
    }

    private void hideMmsViewIfNeeded() {
        if (this.mMmsView != null) {
            this.mMmsView.setVisibility(8);
        }
    }

    @Override
    public void startAudio() {
    }

    @Override
    public void startVideo() {
    }

    @Override
    public void setAudio(Uri audio, String name, Map<String, ?> extras) {
    }

    @Override
    public void setImage(String name, Bitmap bitmap) {
        this.inflateMmsView();
        try {
            if (null == bitmap) {
                bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)2130837569);
            }
            this.mImageView.setImageBitmap(bitmap);
            this.mImageView.setVisibility(0);
        }
        catch (OutOfMemoryError e) {
            Log.e((String)TAG, (String)"setImage: out of memory: ", (Throwable)e);
        }
    }

    private void inflateMmsView() {
        if (this.mMmsView == null) {
            this.findViewById(2131361856).setVisibility(0);
            this.mMmsView = this.findViewById(2131361866);
            this.mImageView = (ImageView)this.findViewById(2131361867);
            this.mSlideShowButton = (ImageButton)this.findViewById(2131361868);
        }
    }

    private void inflateDownloadControls() {
        if (this.mDownloadButton == null) {
            this.findViewById(2131361862).setVisibility(0);
            this.mDownloadButton = (Button)this.findViewById(2131361864);
            this.mDownloadingLabel = (TextView)this.findViewById(2131361865);
        }
    }

    private CharSequence formatMessage(MessageItem msgItem, String contact, String body, String subject, String timestamp, Pattern highlight, String contentType) {
        boolean hasSubject;
        CharSequence template = this.mContext.getResources().getText(2131165218);
        SpannableStringBuilder buf = new SpannableStringBuilder(TextUtils.replace((CharSequence)template, (String[])new String[]{"%s"}, (CharSequence[])new CharSequence[]{contact}));
        boolean bl = hasSubject = !TextUtils.isEmpty((CharSequence)subject);
        if (hasSubject) {
            buf.append((CharSequence)this.mContext.getResources().getString(2131165219, new Object[]{subject}));
        }
        if (!TextUtils.isEmpty((CharSequence)body)) {
            if (contentType != null && "text/html".equals(contentType)) {
                buf.append((CharSequence)"\n");
                buf.append((CharSequence)Html.fromHtml((String)body));
            } else {
                if (hasSubject) {
                    buf.append((CharSequence)" - ");
                }
                SmileyParser parser = SmileyParser.getInstance();
                buf.append(parser.addSmileySpans(body));
            }
        }
        if (msgItem.isSending()) {
            timestamp = this.mContext.getResources().getString(2131165472);
        }
        buf.append((CharSequence)"\n");
        int startOffset = buf.length();
        startOffset = buf.length();
        buf.append((CharSequence)(TextUtils.isEmpty((CharSequence)timestamp) ? " " : timestamp));
        buf.setSpan((Object)this.mTextSmallSpan, startOffset, buf.length(), 33);
        buf.setSpan((Object)this.mSpan, startOffset + 1, buf.length(), 0);
        buf.setSpan((Object)this.mColorSpan, startOffset, buf.length(), 33);
        if (highlight != null) {
            Matcher m = highlight.matcher(buf.toString());
            while (m.find()) {
                buf.setSpan((Object)new StyleSpan(1), m.start(), m.end(), 0);
            }
        }
        buf.setSpan((Object)this.mLeadingMarginSpan, 0, buf.length(), 0);
        return buf;
    }

    private void drawPlaybackButton(MessageItem msgItem) {
        switch (msgItem.mAttachmentType) {
            case 2: 
            case 3: 
            case 4: {
                this.mSlideShowButton.setTag((Object)msgItem);
                this.mSlideShowButton.setOnClickListener((View.OnClickListener)this);
                this.mSlideShowButton.setVisibility(0);
                this.setLongClickable(true);
                this.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        MessageListItem.this.onMessageListItemClick();
                    }
                });
                break;
            }
            default: {
                this.mSlideShowButton.setVisibility(8);
            }
        }
    }

    public void onClick(View v) {
        MessageItem mi = (MessageItem)v.getTag();
        switch (mi.mAttachmentType) {
            case 2: 
            case 3: 
            case 4: {
                MessageUtils.viewMmsMessageAttachment(this.mContext, mi.mMessageUri, mi.mSlideshow);
            }
        }
    }

    public void onMessageListItemClick() {
        URLSpan[] spans = this.mBodyTextView.getUrls();
        if (spans.length != 0) {
            if (spans.length == 1) {
                Uri uri = Uri.parse((String)spans[0].getURL());
                Intent intent = new Intent("android.intent.action.VIEW", uri);
                intent.putExtra("com.android.browser.application_id", this.mContext.getPackageName());
                intent.setFlags(524288);
                this.mContext.startActivity(intent);
            } else {
                final ArrayList<String> urls = MessageUtils.extractUris(spans);
                ArrayAdapter<String> adapter = new ArrayAdapter<String>(this.mContext, 0x1090011, urls){

                    public View getView(int position, View convertView, ViewGroup parent) {
                        View v = super.getView(position, convertView, parent);
                        try {
                            String url = ((String)this.getItem(position)).toString();
                            TextView tv = (TextView)v;
                            Drawable d = MessageListItem.this.mContext.getPackageManager().getActivityIcon(new Intent("android.intent.action.VIEW", Uri.parse((String)url)));
                            if (d != null) {
                                d.setBounds(0, 0, d.getIntrinsicHeight(), d.getIntrinsicHeight());
                                tv.setCompoundDrawablePadding(10);
                                tv.setCompoundDrawables(d, null, null, null);
                            }
                            String telPrefix = "tel:";
                            if (url.startsWith("tel:")) {
                                url = PhoneNumberUtils.formatNumber((String)url.substring("tel:".length()));
                            }
                            tv.setText((CharSequence)url);
                        }
                        catch (PackageManager.NameNotFoundException ex) {
                            // empty catch block
                        }
                        return v;
                    }
                };
                AlertDialog.Builder b = new AlertDialog.Builder(this.mContext);
                DialogInterface.OnClickListener click = new DialogInterface.OnClickListener(){

                    public final void onClick(DialogInterface dialog, int which) {
                        if (which >= 0) {
                            Uri uri = Uri.parse((String)((String)urls.get(which)));
                            Intent intent = new Intent("android.intent.action.VIEW", uri);
                            intent.putExtra("com.android.browser.application_id", MessageListItem.this.mContext.getPackageName());
                            intent.setFlags(524288);
                            MessageListItem.this.mContext.startActivity(intent);
                        }
                        dialog.dismiss();
                    }
                };
                b.setTitle(2131165440);
                b.setCancelable(true);
                b.setAdapter((ListAdapter)adapter, click);
                b.setNegativeButton(0x1040000, new DialogInterface.OnClickListener(){

                    public final void onClick(DialogInterface dialog, int which) {
                        dialog.dismiss();
                    }
                });
                b.show();
            }
        }
    }

    private void setOnClickListener(final MessageItem msgItem) {
        switch (msgItem.mAttachmentType) {
            case 1: 
            case 2: {
                this.mImageView.setOnClickListener(new View.OnClickListener(){

                    public void onClick(View v) {
                        MessageUtils.viewMmsMessageAttachment(MessageListItem.this.mContext, null, msgItem.mSlideshow);
                    }
                });
                this.mImageView.setOnLongClickListener(new View.OnLongClickListener(){

                    public boolean onLongClick(View v) {
                        return v.showContextMenu();
                    }
                });
                break;
            }
            default: {
                this.mImageView.setOnClickListener(null);
            }
        }
    }

    private void drawLeftStatusIndicator(int msgBoxId) {
        switch (msgBoxId) {
            case 1: {
                this.mMsgListItem.setBackgroundResource(2130837583);
                break;
            }
            case 3: 
            case 4: 
            case 5: 
            case 6: {
                this.mMsgListItem.setBackgroundResource(2130837582);
                break;
            }
            default: {
                this.mMsgListItem.setBackgroundResource(2130837582);
            }
        }
    }

    private void setErrorIndicatorClickListener(final MessageItem msgItem) {
        String type = msgItem.mType;
        final int what = type.equals("sms") ? 2 : 1;
        this.mDeliveredIndicator.setOnClickListener(new View.OnClickListener(){

            public void onClick(View v) {
                if (null != MessageListItem.this.mHandler) {
                    Message msg = Message.obtain((Handler)MessageListItem.this.mHandler, (int)what);
                    msg.obj = new Long(msgItem.mMsgId);
                    msg.sendToTarget();
                }
            }
        });
    }

    private void drawRightStatusIndicator(MessageItem msgItem) {
        if (msgItem.mLocked) {
            this.mLockedIndicator.setImageResource(2130837548);
            this.mLockedIndicator.setVisibility(0);
        } else {
            this.mLockedIndicator.setVisibility(8);
        }
        if (msgItem.isOutgoingMessage() && msgItem.isFailedMessage()) {
            this.mDeliveredIndicator.setImageResource(2130837547);
            this.setErrorIndicatorClickListener(msgItem);
            this.mDeliveredIndicator.setVisibility(0);
        } else if (msgItem.mDeliveryStatus == MessageItem.DeliveryStatus.FAILED) {
            this.mDeliveredIndicator.setImageResource(2130837547);
            this.mDeliveredIndicator.setVisibility(0);
        } else if (msgItem.mDeliveryStatus == MessageItem.DeliveryStatus.RECEIVED) {
            this.mDeliveredIndicator.setImageResource(2130837577);
            this.mDeliveredIndicator.setVisibility(0);
        } else {
            this.mDeliveredIndicator.setVisibility(8);
        }
        if (msgItem.mDeliveryStatus == MessageItem.DeliveryStatus.INFO || msgItem.mReadReport) {
            this.mDetailsIndicator.setImageResource(2130837578);
            this.mDetailsIndicator.setVisibility(0);
        } else {
            this.mDetailsIndicator.setVisibility(8);
        }
    }

    @Override
    public void setImageRegionFit(String fit) {
    }

    @Override
    public void setImageVisibility(boolean visible) {
    }

    @Override
    public void setText(String name, String text) {
    }

    @Override
    public void setTextVisibility(boolean visible) {
    }

    @Override
    public void setVideo(String name, Uri video) {
        this.inflateMmsView();
        try {
            Bitmap bitmap = VideoAttachmentView.createVideoThumbnail(this.mContext, video);
            if (null == bitmap) {
                bitmap = BitmapFactory.decodeResource((Resources)this.getResources(), (int)2130837570);
            }
            this.mImageView.setImageBitmap(bitmap);
            this.mImageView.setVisibility(0);
        }
        catch (OutOfMemoryError e) {
            Log.e((String)TAG, (String)"setVideo: out of memory: ", (Throwable)e);
        }
    }

    @Override
    public void setVideoVisibility(boolean visible) {
    }

    @Override
    public void stopAudio() {
    }

    @Override
    public void stopVideo() {
    }

    @Override
    public void reset() {
        if (this.mImageView != null) {
            this.mImageView.setVisibility(8);
        }
    }

    @Override
    public void setVisibility(boolean visible) {
    }

    @Override
    public void pauseAudio() {
    }

    @Override
    public void pauseVideo() {
    }

    @Override
    public void seekAudio(int seekTo) {
    }

    @Override
    public void seekVideo(int seekTo) {
    }
}

