/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.content.AsyncQueryHandler;
import android.content.ContentUris;
import android.content.Context;
import android.content.res.Resources;
import android.database.Cursor;
import android.graphics.Bitmap;
import android.graphics.BitmapFactory;
import android.graphics.drawable.BitmapDrawable;
import android.graphics.drawable.Drawable;
import android.net.Uri;
import android.os.Handler;
import android.provider.ContactsContract;
import android.provider.Telephony;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.CursorAdapter;
import android.widget.ListView;
import com.android.mms.ui.MessageItem;
import com.android.mms.ui.MessageListItem;
import com.android.mms.ui.MessageUtils;
import com.google.android.mms.MmsException;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.regex.Pattern;

public class MessageListAdapter
extends CursorAdapter {
    private static final String TAG = "MessageListAdapter";
    private static final boolean DEBUG = false;
    private static final boolean LOCAL_LOGV = false;
    static final String[] PROJECTION = new String[]{"transport_type", "_id", "thread_id", "address", "body", "date", "read", "type", "status", "locked", "error_code", "sub", "sub_cs", "date", "read", "m_type", "msg_box", "d_rpt", "rr", "err_type", "locked"};
    static final int COLUMN_MSG_TYPE = 0;
    static final int COLUMN_ID = 1;
    static final int COLUMN_THREAD_ID = 2;
    static final int COLUMN_SMS_ADDRESS = 3;
    static final int COLUMN_SMS_BODY = 4;
    static final int COLUMN_SMS_DATE = 5;
    static final int COLUMN_SMS_READ = 6;
    static final int COLUMN_SMS_TYPE = 7;
    static final int COLUMN_SMS_STATUS = 8;
    static final int COLUMN_SMS_LOCKED = 9;
    static final int COLUMN_SMS_ERROR_CODE = 10;
    static final int COLUMN_MMS_SUBJECT = 11;
    static final int COLUMN_MMS_SUBJECT_CHARSET = 12;
    static final int COLUMN_MMS_DATE = 13;
    static final int COLUMN_MMS_READ = 14;
    static final int COLUMN_MMS_MESSAGE_TYPE = 15;
    static final int COLUMN_MMS_MESSAGE_BOX = 16;
    static final int COLUMN_MMS_DELIVERY_REPORT = 17;
    static final int COLUMN_MMS_READ_REPORT = 18;
    static final int COLUMN_MMS_ERROR_TYPE = 19;
    static final int COLUMN_MMS_LOCKED = 20;
    private static final int CACHE_SIZE = 50;
    protected LayoutInflater mInflater;
    private final ListView mListView;
    private final LinkedHashMap<Long, MessageItem> mMessageItemCache;
    private final ColumnsMap mColumnsMap;
    private OnDataSetChangedListener mOnDataSetChangedListener;
    private Handler mMsgListItemHandler;
    private Pattern mHighlight;
    private Context mContext;
    private HashMap<String, HashSet<MessageListItem>> mAddressToMessageListItems = new HashMap();
    private AvatarCache mAvatarCache;

    public MessageListAdapter(Context context, Cursor c, ListView listView, boolean useDefaultColumnsMap, Pattern highlight) {
        super(context, c, false);
        this.mContext = context;
        this.mHighlight = highlight;
        this.mInflater = (LayoutInflater)context.getSystemService("layout_inflater");
        this.mListView = listView;
        this.mMessageItemCache = new LinkedHashMap<Long, MessageItem>(10, 1.0f, true){

            @Override
            protected boolean removeEldestEntry(Map.Entry eldest) {
                return this.size() > 50;
            }
        };
        this.mColumnsMap = useDefaultColumnsMap ? new ColumnsMap() : new ColumnsMap(c);
        this.mAvatarCache = new AvatarCache();
    }

    public void bindView(View view, Context context, Cursor cursor) {
        long msgId;
        String type;
        MessageItem msgItem;
        if (view instanceof MessageListItem && (msgItem = this.getCachedMessageItem(type = cursor.getString(this.mColumnsMap.mColumnMsgType), msgId = cursor.getLong(this.mColumnsMap.mColumnMsgId), cursor)) != null) {
            HashSet<MessageListItem> set;
            String oldAddress;
            MessageListItem mli = (MessageListItem)view;
            MessageItem oldMessageItem = mli.getMessageItem();
            if (oldMessageItem != null && (oldAddress = oldMessageItem.mAddress) != null && (set = this.mAddressToMessageListItems.get(oldAddress)) != null) {
                set.remove(mli);
            }
            mli.bind(this.mAvatarCache, msgItem);
            mli.setMsgListItemHandler(this.mMsgListItemHandler);
            String addr = !Telephony.Sms.isOutgoingFolder((int)msgItem.mBoxId) ? msgItem.mAddress : MessageUtils.getLocalNumber();
            set = this.mAddressToMessageListItems.get(addr);
            if (set == null) {
                set = new HashSet();
                this.mAddressToMessageListItems.put(addr, set);
            }
            set.add(mli);
        }
    }

    public void setOnDataSetChangedListener(OnDataSetChangedListener l) {
        this.mOnDataSetChangedListener = l;
    }

    public void setMsgListItemHandler(Handler handler) {
        this.mMsgListItemHandler = handler;
    }

    public void notifyImageLoaded(String address) {
        HashSet<MessageListItem> set = this.mAddressToMessageListItems.get(address);
        if (set != null) {
            for (MessageListItem mli : set) {
                mli.bind(this.mAvatarCache, mli.getMessageItem());
            }
        }
    }

    public void notifyDataSetChanged() {
        super.notifyDataSetChanged();
        this.mListView.setSelection(this.mListView.getCount());
        this.mMessageItemCache.clear();
        if (this.mOnDataSetChangedListener != null) {
            this.mOnDataSetChangedListener.onDataSetChanged(this);
        }
    }

    protected void onContentChanged() {
        if (this.getCursor() != null && !this.getCursor().isClosed() && this.mOnDataSetChangedListener != null) {
            this.mOnDataSetChangedListener.onContentChanged(this);
        }
    }

    public View newView(Context context, Cursor cursor, ViewGroup parent) {
        return this.mInflater.inflate(2130903055, parent, false);
    }

    public MessageItem getCachedMessageItem(String type, long msgId, Cursor c) {
        MessageItem item = this.mMessageItemCache.get(MessageListAdapter.getKey(type, msgId));
        if (item == null && c != null && this.isCursorValid(c)) {
            try {
                item = new MessageItem(this.mContext, type, c, this.mColumnsMap, this.mHighlight);
                this.mMessageItemCache.put(MessageListAdapter.getKey(item.mType, item.mMsgId), item);
            }
            catch (MmsException e) {
                Log.e((String)TAG, (String)"getCachedMessageItem: ", (Throwable)e);
            }
        }
        return item;
    }

    private boolean isCursorValid(Cursor cursor) {
        return !cursor.isClosed() && !cursor.isBeforeFirst() && !cursor.isAfterLast();
    }

    private static long getKey(String type, long id2) {
        if (type.equals("mms")) {
            return -id2;
        }
        return id2;
    }

    class AvatarCache {
        private static final int TOKEN_PHONE_LOOKUP = 101;
        private static final int TOKEN_EMAIL_LOOKUP = 102;
        private static final int TOKEN_CONTACT_INFO = 201;
        private static final int TOKEN_PHOTO_DATA = 301;
        private final String[] COLUMNS = new String[]{"_id", "photo_id"};
        private final int PHOTO_ID = 1;
        private final String[] PHONE_LOOKUP_PROJECTION = new String[]{"_id", "lookup"};
        private static final int PHONE_LOOKUP_CONTACT_ID_COLUMN_INDEX = 0;
        private static final int PHONE_LOOKUP_CONTACT_LOOKUP_KEY_COLUMN_INDEX = 1;
        private final String[] EMAIL_LOOKUP_PROJECTION = new String[]{"contact_id", "lookup"};
        private static final int EMAIL_LOOKUP_CONTACT_ID_COLUMN_INDEX = 0;
        private static final int EMAIL_LOOKUP_CONTACT_LOOKUP_KEY_COLUMN_INDEX = 1;
        HashMap<String, ContactData> mImageCache = new HashMap();
        Drawable mDefaultAvatarDrawable = null;
        AsyncQueryHandler mQueryHandler = new AsyncQueryHandler(MessageListAdapter.access$200(MessageListAdapter.this).getContentResolver()){

            protected void onQueryComplete(int token, Object cookieObject, Cursor cursor) {
                super.onQueryComplete(token, cookieObject, cursor);
                ContactData cookie = (ContactData)cookieObject;
                switch (token) {
                    case 101: {
                        if (cookie.onContactIdLoaded(cursor, 0, 1)) break;
                        cookie.loadDefaultAvatar();
                        break;
                    }
                    case 102: {
                        if (cookie.onContactIdLoaded(cursor, 0, 1)) break;
                        cookie.loadDefaultAvatar();
                        break;
                    }
                    case 201: {
                        if (cookie.onContactInfoLoaded(cursor)) break;
                        cookie.loadDefaultAvatar();
                        break;
                    }
                    case 301: {
                        if (!cookie.onPhotoDataLoaded(cursor)) {
                            cookie.loadDefaultAvatar();
                            break;
                        }
                        MessageListAdapter.this.notifyImageLoaded(cookie.mAddress);
                        break;
                    }
                }
            }
        };

        public ContactData get(String address) {
            if (this.mImageCache.containsKey(address)) {
                return this.mImageCache.get(address);
            }
            ContactData cookie = new ContactData(address);
            this.mImageCache.put(address, cookie);
            cookie.startInitialQuery();
            cookie.loadDefaultAvatar();
            return cookie;
        }

        public class ContactData {
            private String mAddress;
            private long mContactId;
            private Uri mContactUri;
            private Drawable mPhoto;

            ContactData(String address) {
                this.mAddress = address;
            }

            public Drawable getAvatar() {
                return this.mPhoto;
            }

            public Uri getContactUri() {
                return this.mContactUri;
            }

            private boolean startInitialQuery() {
                if (Telephony.Mms.isPhoneNumber((String)this.mAddress)) {
                    AvatarCache.this.mQueryHandler.startQuery(101, (Object)this, Uri.withAppendedPath((Uri)ContactsContract.PhoneLookup.CONTENT_FILTER_URI, (String)Uri.encode((String)this.mAddress)), AvatarCache.this.PHONE_LOOKUP_PROJECTION, null, null, null);
                    return true;
                }
                if (Telephony.Mms.isEmailAddress((String)this.mAddress)) {
                    AvatarCache.this.mQueryHandler.startQuery(102, (Object)this, Uri.withAppendedPath((Uri)ContactsContract.CommonDataKinds.Email.CONTENT_LOOKUP_URI, (String)Uri.encode((String)this.mAddress)), AvatarCache.this.EMAIL_LOOKUP_PROJECTION, null, null, null);
                    return true;
                }
                return false;
            }

            private boolean onPhotoDataLoaded(Cursor c) {
                if (c == null || !c.moveToFirst()) {
                    return false;
                }
                try {
                    byte[] photoData = c.getBlob(0);
                    Bitmap b = BitmapFactory.decodeByteArray((byte[])photoData, (int)0, (int)photoData.length, null);
                    this.mPhoto = new BitmapDrawable(MessageListAdapter.this.mContext.getResources(), b);
                    return true;
                }
                catch (Exception ex) {
                    return false;
                }
            }

            private boolean onContactInfoLoaded(Cursor c) {
                if (c == null || !c.moveToFirst()) {
                    return false;
                }
                long photoId = c.getLong(1);
                Uri contactUri = ContentUris.withAppendedId((Uri)ContactsContract.Data.CONTENT_URI, (long)photoId);
                AvatarCache.this.mQueryHandler.startQuery(301, (Object)this, contactUri, new String[]{"data15"}, null, null, null);
                return true;
            }

            private boolean onContactIdLoaded(Cursor c, int contactIdColumn, int lookupKeyColumn) {
                if (c == null || !c.moveToFirst()) {
                    return false;
                }
                this.mContactId = c.getLong(contactIdColumn);
                String lookupKey = c.getString(lookupKeyColumn);
                this.mContactUri = ContactsContract.Contacts.getLookupUri((long)this.mContactId, (String)lookupKey);
                AvatarCache.this.mQueryHandler.startQuery(201, (Object)this, this.mContactUri, AvatarCache.this.COLUMNS, null, null, null);
                return true;
            }

            private void loadDefaultAvatar() {
                try {
                    if (AvatarCache.this.mDefaultAvatarDrawable == null) {
                        Bitmap b = BitmapFactory.decodeResource((Resources)MessageListAdapter.this.mContext.getResources(), (int)2130837532);
                        AvatarCache.this.mDefaultAvatarDrawable = new BitmapDrawable(MessageListAdapter.this.mContext.getResources(), b);
                    }
                    this.mPhoto = AvatarCache.this.mDefaultAvatarDrawable;
                }
                catch (OutOfMemoryError e) {
                    Log.e((String)MessageListAdapter.TAG, (String)"loadDefaultAvatar: out of memory: ", (Throwable)e);
                }
            }
        }
    }

    public static class ColumnsMap {
        public int mColumnMsgType;
        public int mColumnMsgId;
        public int mColumnSmsAddress;
        public int mColumnSmsBody;
        public int mColumnSmsDate;
        public int mColumnSmsRead;
        public int mColumnSmsType;
        public int mColumnSmsStatus;
        public int mColumnSmsLocked;
        public int mColumnSmsErrorCode;
        public int mColumnMmsSubject;
        public int mColumnMmsSubjectCharset;
        public int mColumnMmsDate;
        public int mColumnMmsRead;
        public int mColumnMmsMessageType;
        public int mColumnMmsMessageBox;
        public int mColumnMmsDeliveryReport;
        public int mColumnMmsReadReport;
        public int mColumnMmsErrorType;
        public int mColumnMmsLocked;

        public ColumnsMap() {
            this.mColumnMsgType = 0;
            this.mColumnMsgId = 1;
            this.mColumnSmsAddress = 3;
            this.mColumnSmsBody = 4;
            this.mColumnSmsDate = 5;
            this.mColumnSmsType = 7;
            this.mColumnSmsStatus = 8;
            this.mColumnSmsLocked = 9;
            this.mColumnSmsErrorCode = 10;
            this.mColumnMmsSubject = 11;
            this.mColumnMmsSubjectCharset = 12;
            this.mColumnMmsMessageType = 15;
            this.mColumnMmsMessageBox = 16;
            this.mColumnMmsDeliveryReport = 17;
            this.mColumnMmsReadReport = 18;
            this.mColumnMmsErrorType = 19;
            this.mColumnMmsLocked = 20;
        }

        public ColumnsMap(Cursor cursor) {
            try {
                this.mColumnMsgType = cursor.getColumnIndexOrThrow("transport_type");
            }
            catch (IllegalArgumentException e) {
                Log.w((String)"colsMap", (String)e.getMessage());
            }
            try {
                this.mColumnMsgId = cursor.getColumnIndexOrThrow("_id");
            }
            catch (IllegalArgumentException e) {
                Log.w((String)"colsMap", (String)e.getMessage());
            }
            try {
                this.mColumnSmsAddress = cursor.getColumnIndexOrThrow("address");
            }
            catch (IllegalArgumentException e) {
                Log.w((String)"colsMap", (String)e.getMessage());
            }
            try {
                this.mColumnSmsBody = cursor.getColumnIndexOrThrow("body");
            }
            catch (IllegalArgumentException e) {
                Log.w((String)"colsMap", (String)e.getMessage());
            }
            try {
                this.mColumnSmsDate = cursor.getColumnIndexOrThrow("date");
            }
            catch (IllegalArgumentException e) {
                Log.w((String)"colsMap", (String)e.getMessage());
            }
            try {
                this.mColumnSmsType = cursor.getColumnIndexOrThrow("type");
            }
            catch (IllegalArgumentException e) {
                Log.w((String)"colsMap", (String)e.getMessage());
            }
            try {
                this.mColumnSmsStatus = cursor.getColumnIndexOrThrow("status");
            }
            catch (IllegalArgumentException e) {
                Log.w((String)"colsMap", (String)e.getMessage());
            }
            try {
                this.mColumnSmsLocked = cursor.getColumnIndexOrThrow("locked");
            }
            catch (IllegalArgumentException e) {
                Log.w((String)"colsMap", (String)e.getMessage());
            }
            try {
                this.mColumnSmsErrorCode = cursor.getColumnIndexOrThrow("error_code");
            }
            catch (IllegalArgumentException e) {
                Log.w((String)"colsMap", (String)e.getMessage());
            }
            try {
                this.mColumnMmsSubject = cursor.getColumnIndexOrThrow("sub");
            }
            catch (IllegalArgumentException e) {
                Log.w((String)"colsMap", (String)e.getMessage());
            }
            try {
                this.mColumnMmsSubjectCharset = cursor.getColumnIndexOrThrow("sub_cs");
            }
            catch (IllegalArgumentException e) {
                Log.w((String)"colsMap", (String)e.getMessage());
            }
            try {
                this.mColumnMmsMessageType = cursor.getColumnIndexOrThrow("m_type");
            }
            catch (IllegalArgumentException e) {
                Log.w((String)"colsMap", (String)e.getMessage());
            }
            try {
                this.mColumnMmsMessageBox = cursor.getColumnIndexOrThrow("msg_box");
            }
            catch (IllegalArgumentException e) {
                Log.w((String)"colsMap", (String)e.getMessage());
            }
            try {
                this.mColumnMmsDeliveryReport = cursor.getColumnIndexOrThrow("d_rpt");
            }
            catch (IllegalArgumentException e) {
                Log.w((String)"colsMap", (String)e.getMessage());
            }
            try {
                this.mColumnMmsReadReport = cursor.getColumnIndexOrThrow("rr");
            }
            catch (IllegalArgumentException e) {
                Log.w((String)"colsMap", (String)e.getMessage());
            }
            try {
                this.mColumnMmsErrorType = cursor.getColumnIndexOrThrow("err_type");
            }
            catch (IllegalArgumentException e) {
                Log.w((String)"colsMap", (String)e.getMessage());
            }
            try {
                this.mColumnMmsLocked = cursor.getColumnIndexOrThrow("locked");
            }
            catch (IllegalArgumentException e) {
                Log.w((String)"colsMap", (String)e.getMessage());
            }
        }
    }

    public static interface OnDataSetChangedListener {
        public void onDataSetChanged(MessageListAdapter var1);

        public void onContentChanged(MessageListAdapter var1);
    }
}

