/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.content.ContentUris;
import android.content.Context;
import android.database.Cursor;
import android.net.Uri;
import android.provider.Telephony;
import android.text.TextUtils;
import android.util.Log;
import com.android.mms.data.Contact;
import com.android.mms.model.SlideModel;
import com.android.mms.model.SlideshowModel;
import com.android.mms.model.TextModel;
import com.android.mms.ui.MessageListAdapter;
import com.android.mms.ui.MessageUtils;
import com.android.mms.util.AddressUtils;
import com.google.android.mms.MmsException;
import com.google.android.mms.pdu.EncodedStringValue;
import com.google.android.mms.pdu.MultimediaMessagePdu;
import com.google.android.mms.pdu.NotificationInd;
import com.google.android.mms.pdu.PduPersister;
import com.google.android.mms.pdu.RetrieveConf;
import com.google.android.mms.pdu.SendReq;
import java.util.regex.Pattern;

public class MessageItem {
    private static String TAG = "MessageItem";
    final Context mContext;
    final String mType;
    final long mMsgId;
    final int mBoxId;
    DeliveryStatus mDeliveryStatus;
    boolean mReadReport;
    boolean mLocked;
    String mTimestamp;
    String mAddress;
    String mContact;
    String mBody;
    String mTextContentType;
    Pattern mHighlight;
    CharSequence mCachedFormattedMessage;
    boolean mLastSendingState;
    Uri mMessageUri;
    int mMessageType;
    int mAttachmentType;
    String mSubject;
    SlideshowModel mSlideshow;
    int mMessageSize;
    int mErrorType;
    int mErrorCode;

    MessageItem(Context context, String type, Cursor cursor, MessageListAdapter.ColumnsMap columnsMap, Pattern highlight) throws MmsException {
        this.mContext = context;
        this.mMsgId = cursor.getLong(columnsMap.mColumnMsgId);
        this.mHighlight = highlight;
        this.mType = type;
        if ("sms".equals(type)) {
            String meString;
            this.mReadReport = false;
            long status = cursor.getLong(columnsMap.mColumnSmsStatus);
            this.mDeliveryStatus = status == -1L ? DeliveryStatus.NONE : (status >= 64L ? DeliveryStatus.FAILED : (status >= 32L ? DeliveryStatus.PENDING : DeliveryStatus.RECEIVED));
            this.mMessageUri = ContentUris.withAppendedId((Uri)Telephony.Sms.CONTENT_URI, (long)this.mMsgId);
            this.mBoxId = cursor.getInt(columnsMap.mColumnSmsType);
            this.mAddress = cursor.getString(columnsMap.mColumnSmsAddress);
            this.mContact = Telephony.Sms.isOutgoingFolder((int)this.mBoxId) ? (meString = context.getString(2131165202)) : Contact.get(this.mAddress, false).getName();
            this.mBody = cursor.getString(columnsMap.mColumnSmsBody);
            if (!this.isOutgoingMessage()) {
                long date = cursor.getLong(columnsMap.mColumnSmsDate);
                this.mTimestamp = String.format(context.getString(2131165208), MessageUtils.formatTimeStampString(context, date));
            }
            this.mLocked = cursor.getInt(columnsMap.mColumnSmsLocked) != 0;
            this.mErrorCode = cursor.getInt(columnsMap.mColumnSmsErrorCode);
        } else if ("mms".equals(type)) {
            this.mMessageUri = ContentUris.withAppendedId((Uri)Telephony.Mms.CONTENT_URI, (long)this.mMsgId);
            this.mBoxId = cursor.getInt(columnsMap.mColumnMmsMessageBox);
            this.mMessageType = cursor.getInt(columnsMap.mColumnMmsMessageType);
            this.mErrorType = cursor.getInt(columnsMap.mColumnMmsErrorType);
            String subject = cursor.getString(columnsMap.mColumnMmsSubject);
            if (!TextUtils.isEmpty((CharSequence)subject)) {
                EncodedStringValue v = new EncodedStringValue(cursor.getInt(columnsMap.mColumnMmsSubjectCharset), PduPersister.getBytes((String)subject));
                this.mSubject = v.getString();
            }
            this.mLocked = cursor.getInt(columnsMap.mColumnMmsLocked) != 0;
            long timestamp = 0L;
            PduPersister p = PduPersister.getPduPersister((Context)this.mContext);
            if (130 == this.mMessageType) {
                this.mDeliveryStatus = DeliveryStatus.NONE;
                NotificationInd notifInd = (NotificationInd)p.load(this.mMessageUri);
                this.interpretFrom(notifInd.getFrom(), this.mMessageUri);
                this.mBody = new String(notifInd.getContentLocation());
                this.mMessageSize = (int)notifInd.getMessageSize();
                timestamp = notifInd.getExpiry() * 1000L;
            } else {
                int reportInt;
                MultimediaMessagePdu msg = (MultimediaMessagePdu)p.load(this.mMessageUri);
                this.mSlideshow = SlideshowModel.createFromPduBody(context, msg.getBody());
                this.mAttachmentType = MessageUtils.getAttachmentType(this.mSlideshow);
                if (this.mMessageType == 132) {
                    RetrieveConf retrieveConf = (RetrieveConf)msg;
                    this.interpretFrom(retrieveConf.getFrom(), this.mMessageUri);
                    timestamp = retrieveConf.getDate() * 1000L;
                } else {
                    this.mContact = this.mAddress = context.getString(2131165202);
                    timestamp = ((SendReq)msg).getDate() * 1000L;
                }
                String report = cursor.getString(columnsMap.mColumnMmsDeliveryReport);
                if (report == null || !this.mAddress.equals(context.getString(2131165202))) {
                    this.mDeliveryStatus = DeliveryStatus.NONE;
                } else {
                    try {
                        reportInt = Integer.parseInt(report);
                        this.mDeliveryStatus = reportInt == 128 ? DeliveryStatus.RECEIVED : DeliveryStatus.NONE;
                    }
                    catch (NumberFormatException nfe) {
                        Log.e((String)TAG, (String)"Value for delivery report was invalid.");
                        this.mDeliveryStatus = DeliveryStatus.NONE;
                    }
                }
                report = cursor.getString(columnsMap.mColumnMmsReadReport);
                if (report == null || !this.mAddress.equals(context.getString(2131165202))) {
                    this.mReadReport = false;
                } else {
                    try {
                        reportInt = Integer.parseInt(report);
                        this.mReadReport = reportInt == 128;
                    }
                    catch (NumberFormatException nfe) {
                        Log.e((String)TAG, (String)"Value for read report was invalid.");
                        this.mReadReport = false;
                    }
                }
                SlideModel slide = this.mSlideshow.get(0);
                if (slide != null && slide.hasText()) {
                    TextModel tm = slide.getText();
                    this.mBody = tm.isDrmProtected() ? this.mContext.getString(2131165220) : tm.getText();
                    this.mTextContentType = tm.getContentType();
                }
                this.mMessageSize = this.mSlideshow.getCurrentMessageSize();
            }
            if (!this.isOutgoingMessage()) {
                this.mTimestamp = context.getString(this.getTimestampStrId(), new Object[]{MessageUtils.formatTimeStampString(context, timestamp)});
            }
        } else {
            throw new MmsException("Unknown type of the message: " + type);
        }
    }

    private void interpretFrom(EncodedStringValue from, Uri messageUri) {
        this.mAddress = from != null ? from.getString() : AddressUtils.getFrom(this.mContext, messageUri);
        this.mContact = TextUtils.isEmpty((CharSequence)this.mAddress) ? "" : Contact.get(this.mAddress, false).getName();
    }

    private int getTimestampStrId() {
        if (130 == this.mMessageType) {
            return 2131165209;
        }
        return 2131165208;
    }

    public boolean isMms() {
        return this.mType.equals("mms");
    }

    public boolean isSms() {
        return this.mType.equals("sms");
    }

    public boolean isDownloaded() {
        return this.mMessageType != 130;
    }

    public boolean isOutgoingMessage() {
        boolean isOutgoingMms = this.isMms() && this.mBoxId == 4;
        boolean isOutgoingSms = this.isSms() && (this.mBoxId == 5 || this.mBoxId == 4 || this.mBoxId == 6);
        return isOutgoingMms || isOutgoingSms;
    }

    public boolean isSending() {
        return !this.isFailedMessage() && this.isOutgoingMessage();
    }

    public boolean isFailedMessage() {
        boolean isFailedMms = this.isMms() && this.mErrorType >= 10;
        boolean isFailedSms = this.isSms() && this.mBoxId == 5;
        return isFailedMms || isFailedSms;
    }

    public void setCachedFormattedMessage(CharSequence formattedMessage) {
        this.mCachedFormattedMessage = formattedMessage;
    }

    public CharSequence getCachedFormattedMessage() {
        boolean isSending = this.isSending();
        if (isSending != this.mLastSendingState) {
            this.mLastSendingState = isSending;
            this.mCachedFormattedMessage = null;
        }
        return this.mCachedFormattedMessage;
    }

    public int getBoxId() {
        return this.mBoxId;
    }

    public String toString() {
        return "type: " + this.mType + " box: " + this.mBoxId + " uri: " + this.mMessageUri + " address: " + this.mAddress + " contact: " + this.mContact + " read: " + this.mReadReport + " delivery status: " + (Object)((Object)this.mDeliveryStatus);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static enum DeliveryStatus {
        NONE,
        INFO,
        FAILED,
        PENDING,
        RECEIVED;

    }
}

