/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.content.Context;
import android.database.Cursor;
import android.util.Log;
import android.view.LayoutInflater;
import android.view.View;
import android.view.ViewGroup;
import android.widget.AbsListView;
import android.widget.CursorAdapter;
import com.android.mms.data.Conversation;
import com.android.mms.ui.ConversationListItem;
import com.android.mms.ui.ConversationListItemData;

public class ConversationListAdapter
extends CursorAdapter
implements AbsListView.RecyclerListener {
    private static final String TAG = "ConversationListAdapter";
    private static final boolean LOCAL_LOGV = false;
    private final LayoutInflater mFactory;
    private OnContentChangedListener mOnContentChangedListener;

    public ConversationListAdapter(Context context, Cursor cursor) {
        super(context, cursor, false);
        this.mFactory = LayoutInflater.from((Context)context);
    }

    public void bindView(View view, Context context, Cursor cursor) {
        if (!(view instanceof ConversationListItem)) {
            Log.e((String)TAG, (String)("Unexpected bound view: " + view));
            return;
        }
        ConversationListItem headerView = (ConversationListItem)view;
        Conversation conv = Conversation.from(context, cursor);
        ConversationListItemData ch = new ConversationListItemData(context, conv);
        headerView.bind(context, ch);
    }

    public void onMovedToScrapHeap(View view) {
        ConversationListItem headerView = (ConversationListItem)view;
        headerView.unbind();
    }

    public View newView(Context context, Cursor cursor, ViewGroup parent) {
        return this.mFactory.inflate(2130903044, parent, false);
    }

    public void setOnContentChangedListener(OnContentChangedListener l) {
        this.mOnContentChangedListener = l;
    }

    protected void onContentChanged() {
        if (this.mCursor != null && !this.mCursor.isClosed() && this.mOnContentChangedListener != null) {
            this.mOnContentChangedListener.onContentChanged(this);
        }
    }

    public static interface OnContentChangedListener {
        public void onContentChanged(ConversationListAdapter var1);
    }
}

