/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.content.Context;
import android.content.res.Resources;
import android.graphics.Bitmap;
import android.media.MediaPlayer;
import android.net.Uri;
import android.util.AttributeSet;
import android.util.Log;
import android.widget.LinearLayout;
import android.widget.TextView;
import com.android.mms.ui.SlideViewInterface;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class AudioAttachmentView
extends LinearLayout
implements SlideViewInterface {
    private static final String TAG = "AudioAttachmentView";
    private final Resources mRes;
    private TextView mNameView;
    private TextView mAlbumView;
    private TextView mArtistView;
    private TextView mErrorMsgView;
    private Uri mAudioUri;
    private MediaPlayer mMediaPlayer;
    private boolean mIsPlaying;

    public AudioAttachmentView(Context context) {
        super(context);
        this.mRes = context.getResources();
    }

    public AudioAttachmentView(Context context, AttributeSet attrs) {
        super(context, attrs);
        this.mRes = context.getResources();
    }

    protected void onFinishInflate() {
        this.mNameView = (TextView)this.findViewById(2131361793);
        this.mAlbumView = (TextView)this.findViewById(2131361794);
        this.mArtistView = (TextView)this.findViewById(2131361795);
        this.mErrorMsgView = (TextView)this.findViewById(2131361796);
    }

    private void onPlaybackError() {
        Log.e((String)TAG, (String)"Error occurred while playing audio.");
        this.showErrorMessage(this.mRes.getString(2131165285));
        this.stopAudio();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void cleanupMediaPlayer() {
        if (this.mMediaPlayer != null) {
            try {
                this.mMediaPlayer.stop();
                this.mMediaPlayer.release();
            }
            finally {
                this.mMediaPlayer = null;
            }
        }
    }

    @Override
    public synchronized void startAudio() {
        if (!this.mIsPlaying && this.mAudioUri != null) {
            this.mMediaPlayer = MediaPlayer.create((Context)this.mContext, (Uri)this.mAudioUri);
            if (this.mMediaPlayer != null) {
                this.mMediaPlayer.setAudioStreamType(3);
                this.mMediaPlayer.setOnCompletionListener(new MediaPlayer.OnCompletionListener(){

                    public void onCompletion(MediaPlayer mp) {
                        AudioAttachmentView.this.stopAudio();
                    }
                });
                this.mMediaPlayer.setOnErrorListener(new MediaPlayer.OnErrorListener(){

                    public boolean onError(MediaPlayer mp, int what, int extra) {
                        AudioAttachmentView.this.onPlaybackError();
                        return true;
                    }
                });
                this.mIsPlaying = true;
                this.mMediaPlayer.start();
            }
        }
    }

    @Override
    public void startVideo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void setAudio(Uri audio, String name, Map<String, ?> extras) {
        AudioAttachmentView audioAttachmentView = this;
        synchronized (audioAttachmentView) {
            this.mAudioUri = audio;
        }
        this.mNameView.setText((CharSequence)name);
        this.mAlbumView.setText((CharSequence)((String)extras.get("album")));
        this.mArtistView.setText((CharSequence)((String)extras.get("artist")));
    }

    @Override
    public void setImage(String name, Bitmap bitmap) {
    }

    @Override
    public void setImageRegionFit(String fit) {
    }

    @Override
    public void setImageVisibility(boolean visible) {
    }

    @Override
    public void setText(String name, String text) {
    }

    @Override
    public void setTextVisibility(boolean visible) {
    }

    @Override
    public void setVideo(String name, Uri video) {
    }

    @Override
    public void setVideoVisibility(boolean visible) {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public synchronized void stopAudio() {
        try {
            this.cleanupMediaPlayer();
        }
        finally {
            this.mIsPlaying = false;
        }
    }

    @Override
    public void stopVideo() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void reset() {
        AudioAttachmentView audioAttachmentView = this;
        synchronized (audioAttachmentView) {
            if (this.mIsPlaying) {
                this.stopAudio();
            }
        }
        this.mErrorMsgView.setVisibility(8);
    }

    @Override
    public void setVisibility(boolean visible) {
    }

    private void showErrorMessage(String msg) {
        this.mErrorMsgView.setText((CharSequence)msg);
        this.mErrorMsgView.setVisibility(0);
    }

    @Override
    public void pauseAudio() {
    }

    @Override
    public void pauseVideo() {
    }

    @Override
    public void seekAudio(int seekTo) {
    }

    @Override
    public void seekVideo(int seekTo) {
    }
}

