/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.ui;

import android.content.Context;
import android.content.res.Configuration;
import android.os.Handler;
import android.os.Message;
import android.util.AttributeSet;
import android.view.View;
import android.view.ViewStub;
import android.widget.Button;
import android.widget.ImageButton;
import android.widget.LinearLayout;
import com.android.mms.data.WorkingMessage;
import com.android.mms.model.SlideModel;
import com.android.mms.model.SlideshowModel;
import com.android.mms.ui.Presenter;
import com.android.mms.ui.PresenterFactory;
import com.android.mms.ui.SlideViewInterface;

public class AttachmentEditor
extends LinearLayout {
    private static final String TAG = "AttachmentEditor";
    static final int MSG_EDIT_SLIDESHOW = 1;
    static final int MSG_SEND_SLIDESHOW = 2;
    static final int MSG_PLAY_SLIDESHOW = 3;
    static final int MSG_REPLACE_IMAGE = 4;
    static final int MSG_REPLACE_VIDEO = 5;
    static final int MSG_REPLACE_AUDIO = 6;
    static final int MSG_PLAY_VIDEO = 7;
    static final int MSG_PLAY_AUDIO = 8;
    static final int MSG_VIEW_IMAGE = 9;
    static final int MSG_REMOVE_ATTACHMENT = 10;
    private final Context mContext;
    private Handler mHandler;
    private SlideViewInterface mView;
    private SlideshowModel mSlideshow;
    private Presenter mPresenter;
    private boolean mCanSend;
    private Button mSendButton;

    public AttachmentEditor(Context context, AttributeSet attr2) {
        super(context, attr2);
        this.mContext = context;
    }

    public void update(WorkingMessage msg) {
        this.hideView();
        this.mView = null;
        if (!msg.hasAttachment()) {
            return;
        }
        this.mSlideshow = msg.getSlideshow();
        this.mView = this.createView();
        if (this.mPresenter == null || !this.mSlideshow.equals(this.mPresenter.getModel())) {
            this.mPresenter = PresenterFactory.getPresenter("MmsThumbnailPresenter", this.mContext, this.mView, this.mSlideshow);
        } else {
            this.mPresenter.setView(this.mView);
        }
        this.mPresenter.present();
    }

    public void setHandler(Handler handler) {
        this.mHandler = handler;
    }

    public void setCanSend(boolean enable) {
        if (this.mCanSend != enable) {
            this.mCanSend = enable;
            this.updateSendButton();
        }
    }

    private void updateSendButton() {
        if (null != this.mSendButton) {
            this.mSendButton.setEnabled(this.mCanSend);
            this.mSendButton.setFocusable(this.mCanSend);
        }
    }

    public void hideView() {
        if (this.mView != null) {
            ((View)this.mView).setVisibility(8);
        }
    }

    private View getStubView(int stubId, int viewId) {
        View view = this.findViewById(viewId);
        if (view == null) {
            ViewStub stub = (ViewStub)this.findViewById(stubId);
            view = stub.inflate();
        }
        return view;
    }

    private SlideViewInterface createView() {
        boolean inPortrait = this.inPortraitMode();
        if (this.mSlideshow.size() > 1) {
            return this.createSlideshowView(inPortrait);
        }
        SlideModel slide = this.mSlideshow.get(0);
        if (slide.hasImage()) {
            return this.createMediaView(inPortrait ? 2131361806 : 2131361810, inPortrait ? 2131361853 : 2131361849, 2131361851, 2131361841, 2131361852, 9, 4, 10);
        }
        if (slide.hasVideo()) {
            return this.createMediaView(inPortrait ? 2131361807 : 2131361811, inPortrait ? 2131361908 : 2131361903, 2131361905, 2131361906, 2131361907, 7, 5, 10);
        }
        if (slide.hasAudio()) {
            return this.createMediaView(inPortrait ? 2131361808 : 2131361812, inPortrait ? 2131361800 : 2131361792, 2131361797, 2131361798, 2131361799, 8, 6, 10);
        }
        throw new IllegalArgumentException();
    }

    private boolean inPortraitMode() {
        Configuration configuration = this.mContext.getResources().getConfiguration();
        return configuration.orientation == 1;
    }

    private SlideViewInterface createMediaView(int stub_view_id, int real_view_id, int view_button_id, int replace_button_id, int remove_button_id, int view_message, int replace_message, int remove_message) {
        LinearLayout view = (LinearLayout)this.getStubView(stub_view_id, real_view_id);
        view.setVisibility(0);
        Button viewButton = (Button)view.findViewById(view_button_id);
        Button replaceButton = (Button)view.findViewById(replace_button_id);
        Button removeButton = (Button)view.findViewById(remove_button_id);
        viewButton.setOnClickListener((View.OnClickListener)new MessageOnClick(view_message));
        replaceButton.setOnClickListener((View.OnClickListener)new MessageOnClick(replace_message));
        removeButton.setOnClickListener((View.OnClickListener)new MessageOnClick(remove_message));
        return (SlideViewInterface)view;
    }

    private SlideViewInterface createSlideshowView(boolean inPortrait) {
        LinearLayout view = (LinearLayout)this.getStubView(inPortrait ? 2131361809 : 2131361813, inPortrait ? 2131361890 : 2131361885);
        view.setVisibility(0);
        Button editBtn = (Button)view.findViewById(2131361888);
        this.mSendButton = (Button)view.findViewById(2131361889);
        this.updateSendButton();
        ImageButton playBtn = (ImageButton)view.findViewById(2131361868);
        editBtn.setOnClickListener((View.OnClickListener)new MessageOnClick(1));
        this.mSendButton.setOnClickListener((View.OnClickListener)new MessageOnClick(2));
        playBtn.setOnClickListener((View.OnClickListener)new MessageOnClick(3));
        return (SlideViewInterface)view;
    }

    private class MessageOnClick
    implements View.OnClickListener {
        private int mWhat;

        public MessageOnClick(int what) {
            this.mWhat = what;
        }

        public void onClick(View v) {
            Message msg = Message.obtain((Handler)AttachmentEditor.this.mHandler, (int)this.mWhat);
            msg.sendToTarget();
        }
    }
}

