/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.content.Context;
import android.net.ConnectivityManager;
import android.net.Uri;
import com.android.mms.transaction.HttpUtils;
import com.android.mms.transaction.Observable;
import com.android.mms.transaction.TransactionSettings;
import com.android.mms.transaction.TransactionState;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;

public abstract class Transaction
extends Observable {
    private final int mServiceId;
    protected Context mContext;
    protected String mId;
    protected TransactionState mTransactionState;
    protected TransactionSettings mTransactionSettings;
    public static final int NOTIFICATION_TRANSACTION = 0;
    public static final int RETRIEVE_TRANSACTION = 1;
    public static final int SEND_TRANSACTION = 2;
    public static final int READREC_TRANSACTION = 3;

    public Transaction(Context context, int serviceId, TransactionSettings settings) {
        this.mContext = context;
        this.mTransactionState = new TransactionState();
        this.mServiceId = serviceId;
        this.mTransactionSettings = settings;
    }

    public TransactionState getState() {
        return this.mTransactionState;
    }

    public abstract void process();

    public boolean isEquivalent(Transaction transaction) {
        return this.getClass().equals(transaction.getClass()) && this.mId.equals(transaction.mId);
    }

    public int getServiceId() {
        return this.mServiceId;
    }

    public TransactionSettings getConnectionSettings() {
        return this.mTransactionSettings;
    }

    public void setConnectionSettings(TransactionSettings settings) {
        this.mTransactionSettings = settings;
    }

    protected byte[] sendPdu(byte[] pdu) throws IOException {
        return this.sendPdu(-1L, pdu, this.mTransactionSettings.getMmscUrl());
    }

    protected byte[] sendPdu(byte[] pdu, String mmscUrl) throws IOException {
        return this.sendPdu(-1L, pdu, mmscUrl);
    }

    protected byte[] sendPdu(long token, byte[] pdu) throws IOException {
        return this.sendPdu(token, pdu, this.mTransactionSettings.getMmscUrl());
    }

    protected byte[] sendPdu(long token, byte[] pdu, String mmscUrl) throws IOException {
        this.ensureRouteToHost(mmscUrl, this.mTransactionSettings);
        return HttpUtils.httpConnection(this.mContext, token, mmscUrl, pdu, 1, this.mTransactionSettings.isProxySet(), this.mTransactionSettings.getProxyAddress(), this.mTransactionSettings.getProxyPort());
    }

    protected byte[] getPdu(String url) throws IOException {
        this.ensureRouteToHost(url, this.mTransactionSettings);
        return HttpUtils.httpConnection(this.mContext, -1L, url, null, 2, this.mTransactionSettings.isProxySet(), this.mTransactionSettings.getProxyAddress(), this.mTransactionSettings.getProxyPort());
    }

    private void ensureRouteToHost(String url, TransactionSettings settings) throws IOException {
        ConnectivityManager connMgr = (ConnectivityManager)this.mContext.getSystemService("connectivity");
        if (settings.isProxySet()) {
            String proxyAddr = settings.getProxyAddress();
            int inetAddr = Transaction.lookupHost(proxyAddr);
            if (inetAddr == -1) {
                throw new IOException("Cannot establish route for " + url + ": Unknown host");
            }
            if (!connMgr.requestRouteToHost(2, inetAddr)) {
                throw new IOException("Cannot establish route to proxy " + inetAddr);
            }
        } else {
            Uri uri = Uri.parse((String)url);
            int inetAddr = Transaction.lookupHost(uri.getHost());
            if (inetAddr == -1) {
                throw new IOException("Cannot establish route for " + url + ": Unknown host");
            }
            if (!connMgr.requestRouteToHost(2, inetAddr)) {
                throw new IOException("Cannot establish route to " + inetAddr + " for " + url);
            }
        }
    }

    public static int lookupHost(String hostname) {
        InetAddress inetAddress;
        try {
            inetAddress = InetAddress.getByName(hostname);
        }
        catch (UnknownHostException e) {
            return -1;
        }
        byte[] addrBytes = inetAddress.getAddress();
        int addr = (addrBytes[3] & 0xFF) << 24 | (addrBytes[2] & 0xFF) << 16 | (addrBytes[1] & 0xFF) << 8 | addrBytes[0] & 0xFF;
        return addr;
    }

    public String toString() {
        return this.getClass().getName() + ": serviceId=" + this.mServiceId;
    }

    public abstract int getType();
}

