/*
 * Decompiled with CFR 0.152.
 */
package com.android.mms.transaction;

import android.app.PendingIntent;
import android.content.Context;
import android.content.Intent;
import android.net.Uri;
import android.provider.Telephony;
import android.telephony.SmsManager;
import android.util.Log;
import com.android.mms.MmsConfig;
import com.android.mms.transaction.MessageStatusReceiver;
import com.android.mms.transaction.SmsMessageSender;
import com.android.mms.transaction.SmsReceiver;
import com.android.mms.ui.MessageUtils;
import com.google.android.mms.MmsException;
import java.util.ArrayList;

public class SmsSingleRecipientSender
extends SmsMessageSender {
    private final boolean mRequestDeliveryReport;
    private String mDest;
    private Uri mUri;

    public SmsSingleRecipientSender(Context context, String dest, String msgText, long threadId, boolean requestDeliveryReport, Uri uri) {
        super(context, null, msgText, threadId);
        this.mRequestDeliveryReport = requestDeliveryReport;
        this.mDest = dest;
        this.mUri = uri;
    }

    public boolean sendMessage(long token) throws MmsException {
        if (this.mMessageText == null) {
            throw new MmsException("Null message body or have multiple destinations.");
        }
        SmsManager smsManager = SmsManager.getDefault();
        ArrayList messages = null;
        if (MmsConfig.getEmailGateway() != null && (Telephony.Mms.isEmailAddress((String)this.mDest) || MessageUtils.isAlias(this.mDest))) {
            String msgText = this.mDest + " " + this.mMessageText;
            this.mDest = MmsConfig.getEmailGateway();
            messages = smsManager.divideMessage(msgText);
        } else {
            messages = smsManager.divideMessage(this.mMessageText);
            this.mDest = this.mDest.replaceAll(" ", "");
        }
        int messageCount = messages.size();
        if (messageCount == 0) {
            throw new MmsException("SmsMessageSender.sendMessage: divideMessage returned empty messages. Original message is \"" + this.mMessageText + "\"");
        }
        boolean moved = Telephony.Sms.moveMessageToFolder((Context)this.mContext, (Uri)this.mUri, (int)4, (int)0);
        if (!moved) {
            throw new MmsException("SmsMessageSender.sendMessage: couldn't move message to outbox: " + this.mUri);
        }
        ArrayList<PendingIntent> deliveryIntents = new ArrayList<PendingIntent>(messageCount);
        ArrayList<PendingIntent> sentIntents = new ArrayList<PendingIntent>(messageCount);
        for (int i = 0; i < messageCount; ++i) {
            if (this.mRequestDeliveryReport) {
                deliveryIntents.add(PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)new Intent("com.android.mms.transaction.MessageStatusReceiver.MESSAGE_STATUS_RECEIVED", this.mUri, this.mContext, MessageStatusReceiver.class), (int)0));
            }
            Intent intent = new Intent("com.android.mms.transaction.MESSAGE_SENT", this.mUri, this.mContext, SmsReceiver.class);
            if (i == messageCount - 1) {
                intent.putExtra("SendNextMsg", true);
            }
            sentIntents.add(PendingIntent.getBroadcast((Context)this.mContext, (int)0, (Intent)intent, (int)0));
        }
        try {
            smsManager.sendMultipartTextMessage(this.mDest, this.mServiceCenter, messages, sentIntents, deliveryIntents);
        }
        catch (Exception ex) {
            throw new MmsException("SmsMessageSender.sendMessage: caught " + ex + " from SmsManager.sendTextMessage()");
        }
        if (Log.isLoggable((String)"Mms:transaction", (int)2)) {
            this.log("sendMessage: address=" + this.mDest + ", threadId=" + this.mThreadId + ", uri=" + this.mUri + ", msgs.count=" + messageCount);
        }
        return false;
    }

    private void log(String msg) {
        Log.d((String)"Mms", (String)("[SmsSingleRecipientSender] " + msg));
    }
}

